/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocalVariableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class Local
extends AbstractVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    LocalVariable local;
    JPDAThread thread;
    int depth;
    String className;
    String genericSignature;

    Local(JPDADebuggerImpl jPDADebuggerImpl, PrimitiveValue primitiveValue, String string, LocalVariable localVariable, CallStackFrameImpl callStackFrameImpl) {
        super(jPDADebuggerImpl, primitiveValue, Local.getID(localVariable, primitiveValue));
        this.local = localVariable;
        if (callStackFrameImpl != null) {
            this.thread = callStackFrameImpl.getThread();
            this.depth = callStackFrameImpl.getFrameDepth();
        }
        this.className = string;
    }

    private static String getID(LocalVariable localVariable, PrimitiveValue primitiveValue) {
        try {
            return LocalVariableWrapper.name(localVariable) + LocalVariableWrapper.hashCode(localVariable) + (primitiveValue instanceof ObjectReference ? "^" : "");
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    public String getName() {
        try {
            return LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String string) {
        this.className = string;
    }

    public String getDeclaredType() {
        try {
            return LocalVariableWrapper.typeName(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }

    @Override
    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            StackFrame stackFrame = ((CallStackFrameImpl)this.thread.getCallStack(this.depth, this.depth + 1)[0]).getStackFrame();
            stackFrame.setValue(this.local, value);
            this.setInnerValue(value);
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InvalidExpressionException((Throwable)absentInformationException);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameException);
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameExceptionWrapper);
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            // empty catch block
        }
    }

    final void setFrame(CallStackFrameImpl callStackFrameImpl) {
        this.thread = callStackFrameImpl.getThread();
        this.depth = callStackFrameImpl.getFrameDepth();
    }

    @Override
    public Local clone() {
        Local local = new Local(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.className, this.local, null);
        local.depth = this.depth;
        local.thread = this.thread;
        return local;
    }

    @Override
    public String toString() {
        try {
            return "LocalVariable " + LocalVariableWrapper.name(this.local);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return "LocalVariable " + internalExceptionWrapper.getLocalizedMessage();
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return vMDisconnectedExceptionWrapper.getLocalizedMessage();
        }
    }
}

