/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.util.ConfigHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final Log log = LogFactory.getLog((Class)DTDEntityResolver.class);
    private static final String HIBERNATE_NAMESPACE = "http://hibernate.sourceforge.net/";
    private static final String USER_NAMESPACE = "classpath://";

    /*
     * Enabled aggressive block sorting
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId == null) return null;
        log.debug((Object)("trying to resolve system-id [" + systemId + "]"));
        if (systemId.startsWith(HIBERNATE_NAMESPACE)) {
            log.debug((Object)"recognized hibernate namespace; attempting to resolve on classpath under org/hibernate/");
            String path = "org/hibernate/" + systemId.substring(HIBERNATE_NAMESPACE.length());
            InputStream dtdStream = this.resolveInHibernateNamespace(path);
            if (dtdStream == null) {
                log.debug((Object)("unable to locate [" + systemId + "] on classpath"));
                if (systemId.substring(HIBERNATE_NAMESPACE.length()).indexOf("2.0") <= -1) return null;
                log.error((Object)"Don't use old DTDs, read the Hibernate 3.x Migration Guide!");
                return null;
            }
            log.debug((Object)("located [" + systemId + "] in classpath"));
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        if (!systemId.startsWith(USER_NAMESPACE)) return null;
        log.debug((Object)"recognized local namespace; attempting to resolve on classpath");
        String path = systemId.substring(USER_NAMESPACE.length());
        InputStream stream = this.resolveInLocalNamespace(path);
        if (stream == null) {
            log.debug((Object)("unable to locate [" + systemId + "] on classpath"));
            return null;
        }
        log.debug((Object)("located [" + systemId + "] in classpath"));
        InputSource source = new InputSource(stream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    protected InputStream resolveInHibernateNamespace(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    protected InputStream resolveInLocalNamespace(String path) {
        try {
            return ConfigHelper.getUserResourceAsStream(path);
        }
        catch (Throwable t) {
            return null;
        }
    }
}

