/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactory;
import org.netbeans.modules.cnd.testrunner.spi.TestRecognizerHandler;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.openide.util.NbBundle;

public class CndUnitHandlerFactory
implements TestHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(CndUnitHandlerFactory.class.getName());
    private static String CPP_UNIT = "Cpp Unit Test";
    private static final Pattern STRING_COMPARISON = Pattern.compile("(Expected (.+) but got (.+))|((.+) != (.+))", 32);

    @Override
    public boolean printSummary() {
        return true;
    }

    @Override
    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> result = new ArrayList<TestRecognizerHandler>();
        result.add(new SimpleSuiteStartingHandler());
        result.add(new SimpleSuiteStartedHandler());
        result.add(new SimpleSuiteFinishedHandler());
        result.add(new SimpleSuiteErrorOutputHandler());
        result.add(new SimpleTestStartedHandler());
        result.add(new SimpleTestFailedHandler());
        result.add(new SimpleTestErrorHandler());
        result.add(new SimpleTestFinishedHandler());
        result.add(new SimpleTestLoggerHandler());
        result.add(new SimpleTestMiscHandler());
        result.add(new SimpleSuiteMiscHandler());
        return result;
    }

    private static String errorMsg(long failureCount) {
        return NbBundle.getMessage(CndUnitHandlerFactory.class, (String)"MSG_Error", (Object)failureCount);
    }

    private static String failureMsg(long failureCount) {
        return NbBundle.getMessage(CndUnitHandlerFactory.class, (String)"MSG_Failure", (Object)failureCount);
    }

    static String[] getStackTrace(String message, String stackTrace) {
        ArrayList<String> stackTraceList = new ArrayList<String>();
        stackTraceList.add(message);
        for (String location : stackTrace.split("%BR%")) {
        }
        return stackTraceList.toArray(new String[stackTraceList.size()]);
    }

    static Trouble.ComparisonFailure getComparisonFailure(String msg) {
        String actual;
        Matcher comparisonMatcher = STRING_COMPARISON.matcher(msg);
        if (!comparisonMatcher.matches()) {
            return null;
        }
        boolean isDocTest = false;
        String expected = comparisonMatcher.group(2);
        if (expected == null) {
            expected = comparisonMatcher.group(5);
            actual = comparisonMatcher.group(6);
        } else {
            isDocTest = true;
            actual = comparisonMatcher.group(3);
        }
        expected = expected.replace("\\n", "\n");
        actual = actual.replace("\\n", "\n");
        return new Trouble.ComparisonFailure(expected, actual);
    }

    static class SimpleTestLoggerHandler
    extends TestRecognizerHandler {
        public SimpleTestLoggerHandler() {
            super("%TEST_LOGGER%\\slevel=(.+)\\smsg=(.*)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            Level level = Level.parse(this.matcher.group(1));
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, this.matcher.group(2));
            }
        }
    }

    static class SimpleSuiteMiscHandler
    extends TestRecognizerHandler {
        public SimpleSuiteMiscHandler() {
            super("%SUITE_.*");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SimpleSuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SimpleSuiteStartingHandler() {
            super("%SUITE_STARTING%\\s+(.+)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(session);
            }
            String suiteName = this.matcher.group(1);
            session.addSuite(new TestSuite(suiteName));
            manager.displaySuiteRunning(session, suiteName);
        }
    }

    static class SimpleSuiteErrorOutputHandler
    extends TestRecognizerHandler {
        public SimpleSuiteErrorOutputHandler() {
            super("%SUITE_ERROR_OUTPUT%\\serror=(.*)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            manager.displayOutput(session, this.matcher.group(1), true);
            manager.displayOutput(session, "", false);
        }

        @Override
        public List<String> getRecognizedOutput() {
            return Collections.singletonList(this.matcher.group(1));
        }
    }

    static class SimpleSuiteStartedHandler
    extends TestRecognizerHandler {
        public SimpleSuiteStartedHandler() {
            super("%SUITE_STARTED%\\s.*");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SimpleSuiteFinishedHandler
    extends TestRecognizerHandler {
        public SimpleSuiteFinishedHandler() {
            super("%SUITE_FINISHED%\\s+time=(.+)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            manager.displayReport(session, session.getReport((long)SimpleSuiteFinishedHandler.toMillis(this.matcher.group(1))));
            manager.sessionFinished(session);
        }
    }

    static class SimpleTestMiscHandler
    extends TestRecognizerHandler {
        public SimpleTestMiscHandler() {
            super("%TEST_.*");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SimpleTestFinishedHandler
    extends TestRecognizerHandler {
        public SimpleTestFinishedHandler(String regex) {
            super(regex);
        }

        public SimpleTestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\s+(.+) \\((.+)\\)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), CPP_UNIT, session);
            testcase.setTimeMillis((long)SimpleTestFinishedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            session.addTestCase(testcase);
        }
    }

    static class SimpleTestStartedHandler
    extends TestRecognizerHandler {
        public SimpleTestStartedHandler() {
            super("%TEST_STARTED%\\s*(.+) \\((.+)\\)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SimpleTestErrorHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public SimpleTestErrorHandler() {
            super("%TEST_ERROR%\\stime=(.+)\\stestname=(.+) \\((.+)\\)\\smessage=(.*)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), CPP_UNIT, session);
            testcase.setTimeMillis((long)SimpleTestErrorHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(true));
            testcase.getTrouble().setStackTrace(CndUnitHandlerFactory.getStackTrace(this.matcher.group(4).replace("%BR%", "\n"), ""));
            session.addTestCase(testcase);
            String errorMsg = CndUnitHandlerFactory.errorMsg(session.incrementFailuresCount());
            String testCase = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(errorMsg);
            this.output.add(testCase);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(session, "", false);
            manager.displayOutput(session, errorMsg, false);
            manager.displayOutput(session, testCase, false);
            for (String line : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(session, line, true);
            }
            manager.displayOutput(session, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        public List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }

    static class SimpleTestFailedHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public SimpleTestFailedHandler(String regex) {
            super(regex);
        }

        public SimpleTestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=(.+) \\((.+)\\)\\smessage=(.*)");
        }

        @Override
        public void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), CPP_UNIT, session);
            testcase.setTimeMillis((long)SimpleTestFailedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(false));
            String message = this.matcher.group(4).replace("%BR%", "\n");
            testcase.getTrouble().setStackTrace(CndUnitHandlerFactory.getStackTrace(message, ""));
            testcase.getTrouble().setComparisonFailure(CndUnitHandlerFactory.getComparisonFailure(message));
            session.addTestCase(testcase);
            String failureMsg = CndUnitHandlerFactory.failureMsg(session.incrementFailuresCount());
            String testCase = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(failureMsg);
            this.output.add(testCase);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(session, "", false);
            manager.displayOutput(session, failureMsg, false);
            manager.displayOutput(session, testCase, false);
            for (String line : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(session, line, false);
            }
            manager.displayOutput(session, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        public List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }
}

