/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.security.EnterPasswordPanel;
import org.netbeans.modules.mobility.project.ui.security.ExportPanel;
import org.netbeans.modules.mobility.project.ui.security.KeyAliasCellRenderer;
import org.netbeans.modules.mobility.project.ui.security.KeystoreCellRenderer;
import org.netbeans.modules.mobility.project.ui.security.SecurityManagerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class CustomizerSign
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ChangeListener,
ItemListener {
    static final String[] PROPERTY_GROUP = new String[]{"sign.enabled", "sign.keystore", "sign.alias"};
    private VisualPropertySupport vps;
    private boolean useDefault;
    private Map<String, Object> props;
    private String configuration;
    private JButton bAliasUnlock;
    private JButton bExport;
    private JButton bKeyStoreUnlock;
    private JButton bOpenSecurityManager;
    private JComboBox cAlias;
    private JCheckBox cDefault;
    private JCheckBox cEnabled;
    private JComboBox cKeystore;
    private JPanel jPanel1;
    private JLabel lAlias;
    private JLabel lDetails;
    private JLabel lKeystore;
    private JPanel pDetails;
    private ErrorPanel pError;

    public CustomizerSign() {
        this.initComponents();
        this.initAccessibility();
        this.cKeystore.setRenderer(new KeystoreCellRenderer());
        this.cAlias.setRenderer(new KeyAliasCellRenderer());
        this.cEnabled.addChangeListener(this);
        this.cKeystore.addItemListener(this);
        this.cAlias.addItemListener(this);
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.cEnabled = new JCheckBox();
        this.bOpenSecurityManager = new JButton();
        this.lKeystore = new JLabel();
        this.cKeystore = new JComboBox();
        this.bKeyStoreUnlock = new JButton();
        this.lAlias = new JLabel();
        this.cAlias = new JComboBox();
        this.bAliasUnlock = new JButton();
        this.pDetails = new JPanel();
        this.lDetails = new JLabel();
        this.bExport = new JButton();
        this.pError = new ErrorPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cDefault, gridBagConstraints);
        this.cDefault.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_UseDefault"));
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cEnabled, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_Enabled"));
        this.cEnabled.setMargin(new Insets(0, 0, 0, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 12, 0);
        this.jPanel1.add((Component)this.cEnabled, gridBagConstraints);
        this.cEnabled.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_Sign"));
        Mnemonics.setLocalizedText((AbstractButton)this.bOpenSecurityManager, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_OpenSecurityManager"));
        this.bOpenSecurityManager.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSign.this.bOpenSecurityManagerActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 12, 0);
        this.jPanel1.add((Component)this.bOpenSecurityManager, gridBagConstraints);
        this.bOpenSecurityManager.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_OpenManager"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.lKeystore.setLabelFor(this.cKeystore);
        Mnemonics.setLocalizedText((JLabel)this.lKeystore, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_Keystore"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.lKeystore, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.cKeystore, gridBagConstraints);
        this.cKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_Keystore"));
        Mnemonics.setLocalizedText((AbstractButton)this.bKeyStoreUnlock, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_UnlockKeyStore"));
        this.bKeyStoreUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSign.this.bKeyStoreUnlockActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.bKeyStoreUnlock, gridBagConstraints);
        this.bKeyStoreUnlock.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_UnlockKeystore"));
        this.lAlias.setLabelFor(this.cAlias);
        Mnemonics.setLocalizedText((JLabel)this.lAlias, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_Alias"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.lAlias, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.cAlias, gridBagConstraints);
        this.cAlias.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_Alias"));
        Mnemonics.setLocalizedText((AbstractButton)this.bAliasUnlock, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_UnlockAlias"));
        this.bAliasUnlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSign.this.bAliasUnlockActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.bAliasUnlock, gridBagConstraints);
        this.bAliasUnlock.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_UnlockAlias"));
        this.pDetails.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_Details")));
        this.pDetails.setEnabled(false);
        this.pDetails.setLayout(new GridBagLayout());
        this.lDetails.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pDetails.add((Component)this.lDetails, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(CustomizerSign.class, (String)"LBL_Sign_Export"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerSign.this.bExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.pDetails.add((Component)this.bExport, gridBagConstraints);
        this.bExport.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_CustSign_Export"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.pDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerSign.class, (String)"ACSN_Sign"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSign.class, (String)"ACSD_Sign"));
    }

    private void bExportActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        ExportPanel.showExportKeyIntoPlatform(bean, alias, null, null);
    }

    private void bAliasUnlockActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias;
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        if (EnterPasswordPanel.getAliasPassword(bean, alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem()) != null) {
            this.loadAliasUnlock();
            this.loadDetails();
        }
    }

    private void bKeyStoreUnlockActionPerformed(ActionEvent evt) {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        if (EnterPasswordPanel.getKeystorePassword(bean) != null) {
            this.loadKeystoreUnlock();
            this.loadAliasses();
        }
    }

    private void bOpenSecurityManagerActionPerformed(ActionEvent evt) {
        SecurityManagerPanel.showSecurityManager((KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem(), (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem());
        this.loadKeystores();
    }

    @Override
    public void initValues(ProjectProperties props, String configuration) {
        this.props = props;
        String keystorePath = (String)props.get("sign.keystore");
        if (keystorePath.startsWith("${") && keystorePath.endsWith("}")) {
            String propName = keystorePath.substring(2, keystorePath.length() - 1);
            keystorePath = System.getProperty(propName);
            props.put("sign.keystore", keystorePath);
        }
        this.configuration = configuration;
        this.vps = VisualPropertySupport.getDefault(props);
        this.vps.register(this.cDefault, configuration, this);
    }

    @Override
    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    @Override
    public void initGroupValues(boolean useDefault) {
        this.useDefault = useDefault;
        this.vps.register(this.cEnabled, "sign.enabled", useDefault);
        this.cEnabled.setEnabled(!useDefault);
        this.bOpenSecurityManager.setEnabled(!useDefault);
        this.loadKeystores();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.loadKeystores();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.cKeystore) {
            KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "sign.keystore", this.useDefault), bean != null ? bean.getKeyStorePath() : null);
            this.loadKeystoreUnlock();
            this.loadAliasses();
        } else if (e.getSource() == this.cAlias) {
            KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, "sign.alias", this.useDefault), alias != null ? alias.getAlias() : null);
            this.loadAliasUnlock();
            this.loadDetails();
        }
    }

    private boolean isEditEnabled() {
        return this.cEnabled.isEnabled() && this.cEnabled.isSelected();
    }

    private void loadKeystores() {
        boolean editEnabled = this.isEditEnabled();
        this.cKeystore.setEnabled(editEnabled);
        this.lKeystore.setEnabled(editEnabled);
        this.lAlias.setEnabled(editEnabled);
        this.registerKeystore();
        this.loadKeystoreUnlock();
        this.loadAliasses();
    }

    private void loadAliasses() {
        this.cAlias.setEnabled(this.isEditEnabled());
        this.registerAlias();
        this.loadAliasUnlock();
        this.loadDetails();
    }

    private void loadKeystoreUnlock() {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        this.bKeyStoreUnlock.setEnabled(bean != null ? this.isEditEnabled() && bean.isValid() && !bean.isOpened() : false);
    }

    private void loadAliasUnlock() {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        this.bAliasUnlock.setEnabled(alias != null ? this.isEditEnabled() && alias.isValid() && !alias.isOpened() : false);
        this.bExport.setEnabled(alias != null ? this.isEditEnabled() && alias.isValid() && alias.isOpened() : false);
    }

    private void loadDetails() {
        KeyStoreRepository.KeyStoreBean.KeyAliasBean alias = (KeyStoreRepository.KeyStoreBean.KeyAliasBean)this.cAlias.getSelectedItem();
        this.lDetails.setText(alias != null ? KeyAliasCellRenderer.getHtmlFormattedText(alias) : "");
        Color color = UIManager.getDefaults().getColor(this.isEditEnabled() ? "Label.foreground" : "Label.disabledForeground");
        this.lDetails.setForeground(color);
        Border b = this.pDetails.getBorder();
        if (b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleColor(color);
        }
    }

    public void registerKeystore() {
        List<KeyStoreRepository.KeyStoreBean> list = KeyStoreRepository.getDefault().getKeyStores();
        this.register(this.cKeystore, list != null ? list.toArray() : null, "sign.keystore");
    }

    public void registerAlias() {
        KeyStoreRepository.KeyStoreBean bean = (KeyStoreRepository.KeyStoreBean)this.cKeystore.getSelectedItem();
        if (!(bean == null || bean.isValid() && bean.isOpened())) {
            bean = null;
        }
        this.register(this.cAlias, bean != null ? bean.aliasses().toArray() : null, "sign.alias");
    }

    private void register(JComboBox component, Object[] items, String propertyName) {
        this.cKeystore.removeItemListener(this);
        this.cAlias.removeItemListener(this);
        Object value = this.props.get(VisualPropertySupport.translatePropertyName(this.configuration, propertyName, this.useDefault));
        component.removeAllItems();
        boolean selected = false;
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                Object o = items[i];
                component.addItem(o);
                if (o == null || !o.equals(value)) continue;
                selected = true;
                component.setSelectedIndex(i);
            }
        }
        if (!selected && items != null && items.length > 0) {
            Object o = items[0];
            if (o != null) {
                if (o instanceof KeyStoreRepository.KeyStoreBean) {
                    o = ((KeyStoreRepository.KeyStoreBean)o).getKeyStorePath();
                } else if (o instanceof KeyStoreRepository.KeyStoreBean.KeyAliasBean) {
                    o = ((KeyStoreRepository.KeyStoreBean.KeyAliasBean)o).getAlias();
                }
            }
            component.setSelectedIndex(0);
            this.props.put(VisualPropertySupport.translatePropertyName(this.configuration, propertyName, this.useDefault), o);
        }
        this.cKeystore.addItemListener(this);
        this.cAlias.addItemListener(this);
    }
}

