/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.CyclicDependencyWarningPanel;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    protected J2MEProject project;
    protected final AntProjectHelper helper;
    protected final Set<Thread> threads;

    public JavadocForBinaryQueryImpl(J2MEProject project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
        this.threads = Collections.synchronizedSet(new HashSet());
    }

    public JavadocForBinaryQuery.Result findJavadoc(final URL binaryRoot) {
        class R
        implements JavadocForBinaryQuery.Result,
        AntProjectListener {
            ArrayList<ChangeListener> listeners = new ArrayList();
            private URL[] cache = null;
            private final AntProjectListener antProjectListener;
            private final transient Object lock = new Object();

            public R(AntProjectHelper helper) {
                this.antProjectListener = (AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)((Object)this), (Object)helper);
                helper.addAntProjectListener(this.antProjectListener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public URL[] getRoots() {
                URL[] urls = this.cache;
                if (urls == null) {
                    urls = this.createRoots();
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.cache != null) {
                            this.cache = urls;
                        }
                    }
                }
                return urls;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private URL[] createRoots() {
                ArrayList<URL> roots;
                block15: {
                    roots = new ArrayList<URL>();
                    try {
                        URL projectRoot = URLMapper.findURL((FileObject)JavadocForBinaryQueryImpl.this.helper.getProjectDirectory(), (int)1);
                        URL distRoot = JavadocForBinaryQueryImpl.this.helper.resolveFile("dist").toURI().toURL();
                        URL buildRoot = JavadocForBinaryQueryImpl.this.helper.resolveFile("build").toURI().toURL();
                        if (!J2MEProjectUtils.isParentOf(distRoot, binaryRoot) && !J2MEProjectUtils.isParentOf(buildRoot, binaryRoot)) break block15;
                        String cfg = J2MEProjectUtils.detectConfiguration(projectRoot, binaryRoot);
                        if (cfg != null) {
                            try {
                                roots.add(J2MEProjectUtils.wrapJar(JavadocForBinaryQueryImpl.this.helper.resolveFile("dist/" + cfg + "/doc").toURI().toURL()));
                            }
                            catch (MalformedURLException mue) {
                                // empty catch block
                            }
                        }
                        try {
                            roots.add(J2MEProjectUtils.wrapJar(JavadocForBinaryQueryImpl.this.helper.resolveFile("dist/doc").toURI().toURL()));
                        }
                        catch (MalformedURLException mue) {
                            // empty catch block
                        }
                        String path = J2MEProjectUtils.evaluateProperty(JavadocForBinaryQueryImpl.this.helper, "libs.classpath", cfg);
                        if (path != null) {
                            path = JavadocForBinaryQueryImpl.this.helper.resolvePath(path);
                        }
                        if (path == null) break block15;
                        String[] p = PropertyUtils.tokenizePath((String)path);
                        for (int i = 0; i < p.length; ++i) {
                            try {
                                URL url = J2MEProjectUtils.wrapJar(new File(p[i]).toURI().toURL());
                                if (url == null || J2MEProjectUtils.isParentOf(projectRoot, url)) continue;
                                if (JavadocForBinaryQueryImpl.this.threads.contains(Thread.currentThread())) {
                                    CyclicDependencyWarningPanel.showWarning(ProjectUtils.getInformation((Project)JavadocForBinaryQueryImpl.this.project).getDisplayName());
                                    return new URL[0];
                                }
                                try {
                                    JavadocForBinaryQueryImpl.this.threads.add(Thread.currentThread());
                                    roots.addAll(Arrays.asList(JavadocForBinaryQuery.findJavadoc((URL)url).getRoots()));
                                    continue;
                                }
                                finally {
                                    JavadocForBinaryQueryImpl.this.threads.remove(Thread.currentThread());
                                }
                            }
                            catch (MalformedURLException mue) {
                                // empty catch block
                            }
                        }
                    }
                    catch (MalformedURLException mue) {
                        ErrorManager.getDefault().notify((Throwable)mue);
                    }
                }
                return roots.toArray(new URL[roots.size()]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addChangeListener(ChangeListener l) {
                ArrayList<ChangeListener> arrayList = this.listeners;
                synchronized (arrayList) {
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeChangeListener(ChangeListener l) {
                ArrayList<ChangeListener> arrayList = this.listeners;
                synchronized (arrayList) {
                    this.listeners.remove(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fireChanged() {
                ArrayList<ChangeListener> arrayList = this.listeners;
                synchronized (arrayList) {
                    ChangeEvent event = new ChangeEvent(this);
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        ChangeListener changeListener = this.listeners.get(i);
                        changeListener.stateChanged(event);
                    }
                }
            }

            public void configurationXmlChanged(AntProjectEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertiesChanged(AntProjectEvent event) {
                Object object = this.lock;
                synchronized (object) {
                    this.cache = null;
                }
                this.fireChanged();
            }
        }
        return new R(this.helper);
    }
}

