/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.spi.utils.FileSystemsProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class CndFileUtils {
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static final FileChangeListener FSL;
    private static final Lock maRefLock;
    private static final Lock mapNormalizedRefLock;
    private static Reference<ConcurrentMap<String, Flags>> mapRef;
    private static Reference<Map<String, String>> normalizedRef;
    private static final boolean TRACE_EXTERNAL_CHANGES;

    private CndFileUtils() {
    }

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    public static boolean areFilenamesEqual(String firstFile, String secondFile) {
        return CndFileUtils.isSystemCaseSensitive() ? firstFile.equals(secondFile) : firstFile.equalsIgnoreCase(secondFile);
    }

    public static void clearFileExistenceCache() {
        mapRef.clear();
    }

    public static File normalizeFile(File file) {
        String normPath;
        String path;
        if (CndUtils.isDebugMode() && !file.isAbsolute()) {
            CndUtils.assertTrueInConsole(false, "Is it OK to normalize not absolute file? [" + file + "] during this session it is [" + file.getAbsolutePath() + "] but will be different if start IDE from another folder");
        }
        return (path = file.getPath()).equals(normPath = CndFileUtils.normalizeAbsolutePath(file.getAbsolutePath())) ? file : new File(normPath);
    }

    public static String normalizeAbsolutePath(String path) {
        Map<String, String> normalizedPaths;
        String normalized;
        if (CndUtils.isDebugMode() && !new File(path).isAbsolute()) {
            CndUtils.assertTrueInConsole(false, "path for normalization must be absolute " + path);
        }
        if ((normalized = (normalizedPaths = CndFileUtils.getNormalizedFilesMap()).get(path)) == null) {
            boolean caseSensitive = CndFileUtils.isSystemCaseSensitive();
            if (!caseSensitive) {
                path = FileSystemsProvider.getCaseInsensitivePath(path);
            }
            normalized = !caseSensitive || path.endsWith("/.") || path.endsWith("\\.") || path.contains("..") || path.contains("./") || path.contains(".\\") ? FileUtil.normalizeFile((File)new File(path)).getAbsolutePath() : path;
            normalizedPaths.put(path, normalized);
        }
        return normalized;
    }

    public static boolean exists(File file) {
        return CndFileUtils.getFlags(file, null, true).exist;
    }

    public static boolean isExistingFile(File file) {
        return CndFileUtils.isExistingFile(file, null);
    }

    public static boolean isExistingFile(String filePath) {
        return CndFileUtils.isExistingFile(null, filePath);
    }

    public static boolean isExistingFile(File file, String filePath) {
        Flags flags = CndFileUtils.getFlags(file, filePath, true);
        return flags.exist && !flags.directory;
    }

    public static boolean isExistingDirectory(File file) {
        return CndFileUtils.isExistingDirectory(file, null);
    }

    public static boolean isExistingDirectory(String filePath) {
        return CndFileUtils.isExistingDirectory(null, filePath);
    }

    public static boolean isExistingDirectory(File file, String filePath) {
        Flags flags = CndFileUtils.getFlags(file, filePath, false);
        return flags.exist && flags.directory;
    }

    public static InputStream getInputStream(CharSequence filePath) throws IOException {
        FileSystemsProvider.Data data = FileSystemsProvider.get(filePath);
        if (data == null) {
            File file = new File(((Object)filePath).toString());
            FileObject fo = FileUtil.toFileObject((File)file);
            InputStream is = fo != null ? fo.getInputStream() : new FileInputStream(file);
            return is;
        }
        FileObject fo = data.fileSystem.getRoot().getFileObject(data.path);
        if (fo == null) {
            throw new FileNotFoundException(((Object)filePath).toString());
        }
        return fo.getInputStream();
    }

    private static Flags getFlags(File file, String absolutePath, boolean indexParentFolder) {
        assert (file != null || absolutePath != null);
        absolutePath = absolutePath == null ? file.getAbsolutePath() : absolutePath;
        absolutePath = CndFileUtils.changeStringCaseIfNeeded(absolutePath);
        ConcurrentMap<String, Flags> files = CndFileUtils.getFilesMap();
        Flags exists = (Flags)files.get(absolutePath);
        if (exists == null) {
            String parent = CndFileUtils.changeStringCaseIfNeeded((file = file == null ? new File(absolutePath) : file).getParent());
            if (parent != null) {
                Flags parentDirFlags = (Flags)files.get(parent);
                if (parentDirFlags == null || parentDirFlags == Flags.DIRECTORY) {
                    File parentFile = file.getParentFile();
                    if (parentDirFlags == null) {
                        parentDirFlags = Flags.get(parentFile);
                        files.put(parent, parentDirFlags);
                    }
                    if (parentDirFlags == Flags.NOT_FOUND || parentDirFlags == Flags.FILE) {
                        exists = Flags.NOT_FOUND;
                    } else if (indexParentFolder) {
                        assert (parentDirFlags == Flags.DIRECTORY) : "must be DIRECTORY but was " + parentDirFlags;
                        CndFileUtils.index(parentFile, parent, files);
                        exists = (Flags)files.get(absolutePath);
                    }
                } else {
                    exists = Flags.NOT_FOUND;
                }
            }
            if (exists == null) {
                exists = Flags.get(file);
                files.put(absolutePath, exists);
            }
            if (exists == Flags.DIRECTORY) {
                CndFileUtils.index(file, absolutePath, files);
            }
        }
        return exists;
    }

    private static void index(File file, String path, ConcurrentMap<String, Flags> files) {
        if (file.canRead()) {
            File[] listFiles = CndFileUtils.listFilesImpl(file);
            for (int i = 0; i < listFiles.length; ++i) {
                File curFile = listFiles[i];
                String absPath = CndFileUtils.changeStringCaseIfNeeded(curFile.getAbsolutePath());
                if (curFile.isDirectory()) {
                    files.putIfAbsent(absPath, Flags.DIRECTORY);
                    continue;
                }
                files.put(absPath, Flags.FILE);
            }
        }
        assert (CndFileUtils.changeStringCaseIfNeeded(path).equals(path));
        files.put(path, Flags.INDEXED_DIRECTORY);
    }

    private static String changeStringCaseIfNeeded(String path) {
        return ((Object)FileSystemsProvider.lowerPathCaseIfNeeded(path)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConcurrentMap<String, Flags> getFilesMap() {
        ConcurrentMap<String, Flags> map = mapRef.get();
        if (map == null) {
            try {
                maRefLock.lock();
                map = mapRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, Flags>();
                    mapRef = new SoftReference<ConcurrentMap<String, Flags>>(map);
                }
            }
            finally {
                maRefLock.unlock();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getNormalizedFilesMap() {
        Map<String, String> map = normalizedRef.get();
        if (map == null) {
            try {
                mapNormalizedRefLock.lock();
                map = normalizedRef.get();
                if (map == null) {
                    map = new ConcurrentHashMap<String, String>();
                    normalizedRef = new SoftReference<Map<String, String>>(map);
                }
            }
            finally {
                mapNormalizedRefLock.unlock();
            }
        }
        return map;
    }

    private static boolean existsImpl(File file) {
        FileSystemsProvider.Data data = FileSystemsProvider.get(file);
        if (data == null) {
            return file.exists();
        }
        FileObject fo = data.fileSystem.getRoot().getFileObject(data.path);
        if (fo == null) {
            return false;
        }
        return !fo.isVirtual();
    }

    private static File[] listFilesImpl(File file) {
        FileSystemsProvider.Data data = FileSystemsProvider.get(file);
        if (data == null) {
            return file.listFiles();
        }
        FileObject fo = data.fileSystem.getRoot().getFileObject(data.path);
        fo.getFileObject("dummy");
        return file.listFiles();
    }

    static {
        boolean caseSenstive;
        FSL = new FSListener();
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
            FileUtil.addFileChangeListener((FileChangeListener)FSL);
        }
        catch (IOException ex) {
            caseSenstive = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
        maRefLock = new ReentrantLock();
        mapNormalizedRefLock = new ReentrantLock();
        mapRef = new SoftReference(new ConcurrentHashMap());
        normalizedRef = new SoftReference(new ConcurrentHashMap());
        TRACE_EXTERNAL_CHANGES = Boolean.getBoolean("cnd.modelimpl.trace.external.changes");
    }

    private static final class FSListener
    implements FileChangeListener {
        private FSListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileDataCreated(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileDeleted(FileEvent fe) {
            this.clearCachesAboutFile(fe);
        }

        public void fileRenamed(FileRenameEvent fe) {
            File parent = this.clearCachesAboutFile((FileEvent)fe);
            if (parent != null) {
                String ext = fe.getExt();
                String oldName = ext.length() == 0 ? fe.getName() : fe.getName() + "." + ext;
                this.clearCachesAboutFile(new File(parent, oldName), false);
            }
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        private File clearCachesAboutFile(FileEvent fe) {
            return this.clearCachesAboutFile(FileUtil.toFile((FileObject)fe.getFile()), true);
        }

        private File clearCachesAboutFile(File f, boolean withParent) {
            this.cleanCachesImpl(f.getAbsolutePath());
            if (withParent) {
                File parent = f.getParentFile();
                if (parent != null) {
                    this.cleanCachesImpl(parent.getAbsolutePath());
                }
                return parent;
            }
            return null;
        }

        private void cleanCachesImpl(String file) {
            if (TRACE_EXTERNAL_CHANGES) {
                System.err.println("clean cache for " + file);
            }
            CndFileUtils.getFilesMap().remove(file);
        }
    }

    private static final class Flags {
        private final boolean exist;
        private final boolean directory;
        private static final Flags FILE = new Flags(true, false);
        private static final Flags DIRECTORY = new Flags(true, true);
        private static final Flags INDEXED_DIRECTORY = new Flags(true, true);
        private static final Flags NOT_FOUND = new Flags(false, true);
        private static final Flags NOT_FOUND_INDEXED_DIRECTORY = new Flags(false, true);

        private Flags(boolean exist, boolean directory) {
            this.exist = exist;
            this.directory = directory;
        }

        private static Flags get(File file) {
            if (CndFileUtils.existsImpl(file)) {
                if (file.isDirectory()) {
                    return DIRECTORY;
                }
                return FILE;
            }
            return NOT_FOUND;
        }

        public String toString() {
            if (this == NOT_FOUND) {
                return "NOT_FOUND";
            }
            if (this == NOT_FOUND_INDEXED_DIRECTORY) {
                return "NOT_FOUND_INDEXED_DIRECTORY";
            }
            if (this == INDEXED_DIRECTORY) {
                return "INDEXED_DIRECTORY";
            }
            if (this == DIRECTORY) {
                return "DIRECTORY";
            }
            if (this == FILE) {
                return "FILE";
            }
            return "UNKNOWN";
        }
    }
}

