/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class J2SELogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor RP = new RequestProcessor(J2SELogicalViewProvider.class);
    private final J2SEProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4 = J2SELogicalViewProvider.this.broken;
            if (bl4 != (bl3 = J2SELogicalViewProvider.this.hasBrokenLinks())) {
                J2SELogicalViewProvider.this.setBroken(bl3);
            }
            if ((bl4 = J2SELogicalViewProvider.this.illegalState) != (bl2 = J2SELogicalViewProvider.this.hasInvalidJdkVersion())) {
                J2SELogicalViewProvider.this.setIllegalState(bl2);
            }
            if ((bl4 = J2SELogicalViewProvider.this.compileOnSaveDisabled) != (bl = J2SELogicalViewProvider.this.isCompileOnSaveDisabled())) {
                J2SELogicalViewProvider.this.setCompileOnSaveDisabled(bl);
            }
        }
    });
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "endorsed.classpath", "javac.test.classpath"};
    private static Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/brokenProjectBadge.gif", (boolean)true);
    private static final String COMPILE_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/java/j2seproject/ui/resources/compileOnSaveDisabledBadge.gif";
    private static final Image compileOnSaveDisabledBadge;
    private boolean broken;
    private boolean illegalState;
    private boolean compileOnSaveDisabled;

    public J2SELogicalViewProvider(J2SEProject j2SEProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = j2SEProject;
        assert (j2SEProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
        assert (referenceHelper != null);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                J2SELogicalViewProvider.this.testBroken();
            }
        };
        propertyEvaluator.addPropertyChangeListener(this.pcl);
        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)JavaPlatformManager.getDefault()));
    }

    public Node createLogicalView() {
        return new J2SELogicalViewRootNode();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            for (Node node2 : node.getChildren().getNodes(true)) {
                Node node3 = PackageView.findPath((Node)node2, (Object)object);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void testBroken() {
        this.task.schedule(100);
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private boolean hasInvalidJdkVersion() {
        String string = this.evaluator.getProperty("javac.source");
        String string2 = this.evaluator.getProperty("javac.target");
        if (string == null && string2 == null) {
            return false;
        }
        String string3 = this.evaluator.getProperty("platform.active");
        JavaPlatform javaPlatform = J2SEProjectUtil.getActivePlatform(string3);
        if (javaPlatform == null) {
            return true;
        }
        SpecificationVersion specificationVersion = javaPlatform.getSpecification().getVersion();
        try {
            return string != null && new SpecificationVersion(string).compareTo((Object)specificationVersion) > 0 || string2 != null && new SpecificationVersion(string2).compareTo((Object)specificationVersion) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            ErrorManager.getDefault().log("Invalid javac.source: " + string + " or javac.target: " + string2 + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private boolean isCompileOnSaveDisabled() {
        return !J2SEProjectUtil.isCompileOnSaveEnabled(this.project) && J2SEProjectUtil.isCompileOnSaveSupported(this.project);
    }

    private String[] getBreakableProperties() {
        SourceRoots sourceRoots = this.project.getSourceRoots();
        String[] stringArray = sourceRoots.getRootProperties();
        sourceRoots = this.project.getTestSourceRoots();
        String[] stringArray2 = sourceRoots.getRootProperties();
        String[] stringArray3 = new String[BREAKABLE_PROPERTIES.length + stringArray.length + stringArray2.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, stringArray3, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(stringArray, 0, stringArray3, BREAKABLE_PROPERTIES.length, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, BREAKABLE_PROPERTIES.length + stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private void setBroken(boolean bl) {
        this.broken = bl;
        this.changeSupport.fireChange();
    }

    private void setIllegalState(boolean bl) {
        this.illegalState = bl;
        this.changeSupport.fireChange();
    }

    private void setCompileOnSaveDisabled(boolean bl) {
        this.compileOnSaveDisabled = bl;
        this.changeSupport.fireChange();
    }

    static {
        URL uRL = J2SELogicalViewProvider.class.getClassLoader().getResource(COMPILE_ON_SAVE_DISABLED_BADGE_PATH);
        String string = "<img src=\"" + uRL + "\">&nbsp;" + NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"TP_CompileOnSaveDisabled");
        compileOnSaveDisabledBadge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)COMPILE_ON_SAVE_DISABLED_BADGE_PATH), (String)string);
    }

    private class BrokenLinksAction
    extends AbstractAction {
        public BrokenLinksAction() {
            this.putValue("Name", NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(J2SELogicalViewProvider.this.broken);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                J2SELogicalViewProvider.this.helper.requestUpdate();
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2SELogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)J2SELogicalViewProvider.this.resolver, (String[])J2SELogicalViewProvider.this.getBreakableProperties(), (String[])new String[]{"platform.active"});
                J2SELogicalViewProvider.this.testBroken();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    public static final class BrokenLinksActionFactory
    extends AbstractAction
    implements ContextAwareAction {
        public BrokenLinksActionFactory() {
            this.putValue("Name", NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup lookup) {
            Collection collection = lookup.lookupAll(Project.class);
            if (collection.size() != 1) {
                return this;
            }
            J2SELogicalViewProvider j2SELogicalViewProvider = (J2SELogicalViewProvider)((Project)collection.iterator().next()).getLookup().lookup(J2SELogicalViewProvider.class);
            if (j2SELogicalViewProvider == null) {
                return this;
            }
            return j2SELogicalViewProvider.new BrokenLinksAction();
        }
    }

    private final class J2SELogicalViewRootNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener {
        private final ProjectInformation info;

        public J2SELogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)J2SELogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-java-j2seproject/Nodes"), Lookups.singleton((Object)J2SELogicalViewProvider.this.project));
            this.info = ProjectUtils.getInformation((Project)J2SELogicalViewProvider.this.project);
            this.setIconBaseWithExtension("org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png");
            if (J2SELogicalViewProvider.this.hasBrokenLinks()) {
                J2SELogicalViewProvider.this.broken = true;
            } else if (J2SELogicalViewProvider.this.hasInvalidJdkVersion()) {
                J2SELogicalViewProvider.this.illegalState = true;
            }
            J2SELogicalViewProvider.this.compileOnSaveDisabled = J2SELogicalViewProvider.this.isCompileOnSaveDisabled();
            J2SELogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)J2SELogicalViewProvider.this));
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getShortDescription() {
            String string = FileUtil.getFileDisplayName((FileObject)J2SELogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"HINT_project_root_node", (Object)string);
        }

        public String getHtmlDisplayName() {
            String string = super.getDisplayName();
            try {
                string = XMLUtil.toElementContent((String)string);
            }
            catch (CharConversionException charConversionException) {
                return string;
            }
            return J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState ? "<font color=\"#A40000\">" + string + "</font>" : null;
        }

        public Image getIcon(int n) {
            Image image = super.getIcon(n);
            if (J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState) {
                return ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            return J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)image, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : image;
        }

        public Image getOpenedIcon(int n) {
            Image image = super.getOpenedIcon(n);
            if (J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState) {
                return ImageUtilities.mergeImages((Image)image, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            return J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)image, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : image;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    J2SELogicalViewRootNode.this.fireNameChange(null, null);
                    J2SELogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            });
        }

        public Action[] getActions(boolean bl) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-java-j2seproject");
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2SELogicalViewProvider.this.project, (String)string);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2SELogicalViewRootNode.class);
        }
    }
}

