/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.ui.PropertiesDialog;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectManager {
    private static final ConnectManager DEFAULT = new ConnectManager();
    private final PropertyChangeListener listener = new ReconnectPropertyChangeListener();
    private static final Logger LOGGER = Logger.getLogger(ConnectManager.class.getName());
    private boolean reconnecting = false;
    private static final RequestProcessor RP = new RequestProcessor(ConnectManager.class);

    private ConnectManager() {
    }

    public static ConnectManager getDefault() {
        return DEFAULT;
    }

    public PropertyChangeListener getReconnectListener() {
        return this.listener;
    }

    public void reconnect(final DatabaseServer server) {
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConnectManager connectManager = ConnectManager.this;
                    synchronized (connectManager) {
                        block13: {
                            if (!ConnectManager.this.reconnecting) break block13;
                            LOGGER.log(Level.FINE, "Already reconnecting to the server");
                            return;
                        }
                        ConnectManager.this.reconnecting = true;
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ConnectManager.class, (String)"MSG_ReconnectingToMySQL"));
                    server.reconnect();
                }
                catch (DatabaseException dbe) {
                    LOGGER.log(Level.INFO, dbe.getMessage(), dbe);
                    boolean displayProperties = Utils.displayYesNoDialog(NbBundle.getMessage(ConnectManager.class, (String)"MSG_ReconnectFailed", (Object)dbe.getMessage()));
                    if (displayProperties) {
                        Mutex.EVENT.postReadRequest(new Runnable(){

                            @Override
                            public void run() {
                                PropertiesDialog dialog = new PropertiesDialog(server);
                                boolean ok = dialog.displayDialog();
                                if (ok) {
                                    ConnectManager.getDefault().reconnect(server);
                                }
                            }
                        });
                    }
                }
                catch (TimeoutException te) {
                    LOGGER.log(Level.INFO, te.getMessage(), te);
                    Utils.displayErrorMessage(te.getMessage());
                }
                finally {
                    ConnectManager.this.setReconnecting(false);
                }
            }
        });
    }

    private synchronized void setReconnecting(boolean isReconnecting) {
        this.reconnecting = isReconnecting;
    }

    private class ReconnectPropertyChangeListener
    implements PropertyChangeListener {
        private ReconnectPropertyChangeListener() {
        }

        private boolean propertyChangeNeedsReconnect(PropertyChangeEvent evt) {
            String property = evt.getPropertyName();
            return property.equals("adminuser") || property.equals("adminpwd") || property.equals("host") || property.equals("port");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DatabaseServer server = (DatabaseServer)evt.getSource();
            if (this.propertyChangeNeedsReconnect(evt)) {
                ConnectManager.this.reconnect(server);
            }
        }
    }
}

