/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemAction;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.GemPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RubyPlatformCustomizer
extends JPanel {
    private static final String LAST_PLATFORM_DIRECTORY = "lastPlatformDirectory";
    private static final String UPDATE_GEM_NAME = "rubygems-update";
    private static String lastSelectedPlatformID;
    private JButton addButton;
    private JButton addGemPath;
    private JButton autoDetectButton;
    private JLabel autoDetectLabel;
    private JProgressBar autoDetectProgress;
    private JButton browseGemHome;
    private JPanel configPanel;
    private JPanel debuggerPanel;
    private JLabel engineLabel;
    private JLabel engineType;
    private JLabel gemHome;
    private JTextField gemHomeValue;
    private JButton gemManagerButton;
    private JLabel gemPath;
    private JList gemPathList;
    private JScrollPane gemPathSP;
    private JLabel gemTool;
    private JTextField gemToolValue;
    private JButton installFastDebugger;
    private JLabel platformsLabel;
    private JList platformsList;
    private JScrollPane platformsListSP;
    private JLabel plfInterpreter;
    private JTextField plfInterpreterValue;
    private JLabel plfName;
    private JTextField plfNameValue;
    private JPanel progressPanel;
    private JButton removeButton;
    private JButton removeGemPath;
    private JLabel rubyDebuggerLabel;
    private JSeparator upperSep;

    public static void manage(JComboBox platforms) {
        RubyPlatformCustomizer.manage(platforms, true);
    }

    public static void manage(JComboBox platforms, boolean canManageGems) {
        RubyPlatformCustomizer.showCustomizer(canManageGems);
        RubyPlatform origPlatform = (RubyPlatform)platforms.getSelectedItem();
        platforms.setModel(new PlatformComponentFactory.RubyPlatformListModel());
        platforms.setSelectedItem(origPlatform);
        platforms.requestFocus();
    }

    public static void showCustomizer() {
        RubyPlatformCustomizer.showCustomizer(true);
    }

    public static void showCustomizer(boolean canManageGems) {
        RubyPlatformCustomizer customizer = new RubyPlatformCustomizer(canManageGems);
        JButton closeButton = new JButton();
        closeButton.getAccessibleContext().setAccessibleDescription(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.closeButton.AccessibleContext.accessibleName"));
        Mnemonics.setLocalizedText((AbstractButton)closeButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"CTL_Close"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)customizer, RubyPlatformCustomizer.getMessage("CTL_RubyPlatformManager_Title"), true, new Object[]{closeButton}, (Object)closeButton, 0, new HelpCtx(RubyPlatformCustomizer.class), null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public RubyPlatformCustomizer() {
    }

    public RubyPlatformCustomizer(boolean canManageGems) {
        this.initComponents();
        if (!canManageGems) {
            this.gemManagerButton.setVisible(false);
        }
        this.getAccessibleContext().setAccessibleName(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.AccessibleContext.accessibleDescription"));
        this.refreshPlatformList();
        this.gemPathList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RubyPlatformCustomizer.this.removeGemPath.setEnabled(RubyPlatformCustomizer.this.gemPathList.getSelectedValue() != null);
            }
        });
        this.platformsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RubyPlatformCustomizer.this.refreshPlatform();
            }
        });
        if (RubyPreferences.isFirstPlatformTouch()) {
            this.performPlatformDetection();
        } else {
            this.setAutoDetecting(false);
        }
    }

    private RubyPlatform getSelectedPlatform() {
        Object value = this.platformsList.getSelectedValue();
        return value instanceof RubyPlatform ? (RubyPlatform)value : null;
    }

    private void refreshPlatformList() {
        if (this.platformsList.getModel().getSize() > 0) {
            RubyPlatform lastPlaf;
            this.platformsList.setSelectedIndex(0);
            if (lastSelectedPlatformID != null && (lastPlaf = RubyPlatformManager.getPlatformByID(lastSelectedPlatformID)) != null) {
                this.platformsList.setSelectedValue(lastPlaf, true);
            }
        }
        this.refreshPlatform();
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(RubyPlatformCustomizer.class, (String)key);
    }

    private void performPlatformDetection() {
        this.setAutoDetecting(true);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                RubyPlatformManager.performPlatformDetection();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RubyPlatformCustomizer.this.platformsList.setModel(new PlatformComponentFactory.RubyPlatformListModel());
                        RubyPlatformCustomizer.this.refreshPlatformList();
                        RubyPlatformCustomizer.this.setAutoDetecting(false);
                    }
                });
            }
        });
    }

    private void setAutoDetecting(boolean autoDetecting) {
        this.autoDetectButton.setEnabled(!autoDetecting);
        this.addButton.setEnabled(!autoDetecting);
        this.autoDetectProgress.setVisible(autoDetecting);
        this.autoDetectLabel.setVisible(autoDetecting);
    }

    private void refreshPlatform() {
        Color color;
        RubyPlatform plaf = this.getSelectedPlatform();
        if (plaf == null) {
            this.setEnabledGUI(false);
            return;
        }
        this.setEnabledGUI(true);
        lastSelectedPlatformID = plaf.getID();
        this.plfNameValue.setText(plaf.getInfo().getLongDescription());
        this.plfInterpreterValue.setText(plaf.getInterpreter());
        boolean gemsInstalled = plaf.hasRubyGemsInstalled();
        if (gemsInstalled) {
            this.gemHomeValue.setText(plaf.getGemManager().getGemHome());
            this.gemPathList.setModel(this.createGemPathsModel(plaf));
            this.refreshGemToolVersion();
            this.gemToolValue.setText(plaf.getGemTool() + " (" + plaf.getInfo().getGemVersion() + ')');
            color = UIManager.getColor("Label.foreground");
        } else {
            color = PlatformComponentFactory.INVALID_PLAF_COLOR;
            String notInstalledMsg = GemManager.getNotInstalledMessage();
            this.gemHomeValue.setText(notInstalledMsg);
            this.gemToolValue.setText(notInstalledMsg);
        }
        this.browseGemHome.setEnabled(gemsInstalled);
        this.gemHomeValue.setForeground(color);
        this.gemToolValue.setForeground(color);
        this.removeGemPath.setEnabled(this.gemPathList.getSelectedValue() != null);
        this.refreshDebugger();
    }

    private void setEnabledGUI(boolean enabled) {
        JComponent[] controls;
        for (JComponent comp : controls = new JComponent[]{this.removeButton, this.browseGemHome, this.addGemPath, this.removeGemPath, this.installFastDebugger, this.gemManagerButton}) {
            comp.setEnabled(enabled);
        }
        if (!enabled) {
            this.plfInterpreterValue.setText(null);
            this.plfNameValue.setText(null);
            this.gemHomeValue.setText(null);
            this.gemToolValue.setText(null);
            this.gemPathList.setModel(new DefaultListModel());
        }
    }

    private ListModel createGemPathsModel(RubyPlatform plaf) {
        return new GemPathsListModel(plaf);
    }

    private GemPathsListModel getGemPathListModel() {
        return (GemPathsListModel)this.gemPathList.getModel();
    }

    private void initComponents() {
        this.platformsLabel = new JLabel();
        this.platformsListSP = new JScrollPane();
        this.platformsList = PlatformComponentFactory.getRubyPlatformsList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.gemManagerButton = new JButton();
        this.autoDetectButton = new JButton();
        this.configPanel = new JPanel();
        this.gemTool = new JLabel();
        this.gemToolValue = new JTextField();
        this.gemHome = new JLabel();
        this.gemHomeValue = new JTextField();
        this.browseGemHome = new JButton();
        this.gemPath = new JLabel();
        this.plfInterpreter = new JLabel();
        this.plfInterpreterValue = new JTextField();
        this.plfName = new JLabel();
        this.plfNameValue = new JTextField();
        this.gemPathSP = new JScrollPane();
        this.gemPathList = new JList();
        this.addGemPath = new JButton();
        this.removeGemPath = new JButton();
        this.progressPanel = new JPanel();
        this.autoDetectLabel = new JLabel();
        this.autoDetectProgress = new JProgressBar();
        this.debuggerPanel = new JPanel();
        this.rubyDebuggerLabel = new JLabel();
        this.upperSep = new JSeparator();
        this.engineLabel = new JLabel();
        this.engineType = new JLabel();
        this.installFastDebugger = new JButton();
        this.platformsLabel.setLabelFor(this.platformsList);
        Mnemonics.setLocalizedText((JLabel)this.platformsLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsLabel.text"));
        this.platformsList.setSelectionMode(0);
        this.platformsListSP.setViewportView(this.platformsList);
        this.platformsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsList.AccessibleContext.accessibleName"));
        this.platformsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.platformsList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.addButtonaddPlatform(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.removeButtonremovePlatform(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.gemManagerButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemManagerButton.text"));
        this.gemManagerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.gemManagerButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.autoDetectButton, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectButton.text"));
        this.autoDetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.autoDetectButtonremovePlatform(evt);
            }
        });
        this.gemTool.setLabelFor(this.gemToolValue);
        Mnemonics.setLocalizedText((JLabel)this.gemTool, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemTool.text"));
        this.gemToolValue.setEditable(false);
        this.gemHome.setLabelFor(this.gemHomeValue);
        Mnemonics.setLocalizedText((JLabel)this.gemHome, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemHome.text"));
        this.gemHomeValue.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseGemHome, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.browseGemHome.text"));
        this.browseGemHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.browseGemHomeActionPerformed(evt);
            }
        });
        this.gemPath.setLabelFor(this.gemPathList);
        Mnemonics.setLocalizedText((JLabel)this.gemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPath.text"));
        this.plfInterpreter.setLabelFor(this.plfInterpreterValue);
        Mnemonics.setLocalizedText((JLabel)this.plfInterpreter, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfInterpreter.text"));
        this.plfInterpreterValue.setEditable(false);
        this.plfName.setLabelFor(this.plfNameValue);
        Mnemonics.setLocalizedText((JLabel)this.plfName, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfName.text"));
        this.plfNameValue.setEditable(false);
        this.gemPathSP.setViewportView(this.gemPathList);
        this.gemPathList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPathList.AccessibleContext.accessibleName"));
        this.gemPathList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemPathList.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.addGemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addGemPath.text"));
        this.addGemPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.addGemPathActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeGemPath, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeGemPath.text"));
        this.removeGemPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.removeGemPathActionPerformed(evt);
            }
        });
        GroupLayout configPanelLayout = new GroupLayout((Container)this.configPanel);
        this.configPanel.setLayout((LayoutManager)configPanelLayout);
        configPanelLayout.setHorizontalGroup((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configPanelLayout.createSequentialGroup().add((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((Component)this.plfInterpreter).add((Component)this.plfName).add((Component)this.gemHome).add((Component)this.gemPath).add((Component)this.gemTool)).addPreferredGap(0).add((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configPanelLayout.createSequentialGroup().add((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((Component)this.gemHomeValue, -1, 396, Short.MAX_VALUE).add((Component)this.gemPathSP, -1, 396, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)configPanelLayout.createParallelGroup(2).add((Component)this.removeGemPath).add((Component)this.addGemPath).add((Component)this.browseGemHome))).add((Component)this.plfInterpreterValue, -1, 491, Short.MAX_VALUE).add((Component)this.plfNameValue, -1, 491, Short.MAX_VALUE).add((Component)this.gemToolValue, -1, 491, Short.MAX_VALUE))));
        configPanelLayout.linkSize(new Component[]{this.gemHome, this.gemTool, this.plfInterpreter, this.plfName}, 1);
        configPanelLayout.linkSize(new Component[]{this.addGemPath, this.browseGemHome, this.removeGemPath}, 1);
        configPanelLayout.setVerticalGroup((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((GroupLayout.Group)configPanelLayout.createSequentialGroup().add((GroupLayout.Group)configPanelLayout.createParallelGroup(3).add((Component)this.plfName).add((Component)this.plfNameValue, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)configPanelLayout.createParallelGroup(3).add((Component)this.plfInterpreter).add((Component)this.plfInterpreterValue, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)configPanelLayout.createParallelGroup(3).add((Component)this.gemHome).add((Component)this.gemHomeValue, -2, -1, -2).add((Component)this.browseGemHome)).addPreferredGap(0).add((GroupLayout.Group)configPanelLayout.createParallelGroup(1).add((Component)this.gemPath).add((Component)this.gemPathSP, -2, 68, -2).add((GroupLayout.Group)configPanelLayout.createSequentialGroup().add((Component)this.addGemPath).addPreferredGap(0).add((Component)this.removeGemPath))).addPreferredGap(0).add((GroupLayout.Group)configPanelLayout.createParallelGroup(3).add((Component)this.gemTool).add((Component)this.gemToolValue, -2, -1, -2))));
        this.gemToolValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemToolValue.AccessibleContext.accessibleDescription"));
        this.gemHomeValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.gemHomeValue.AccessibleContext.accessibleDescription"));
        this.browseGemHome.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.browseGemHome.AccessibleContext.accessibleDescription"));
        this.plfInterpreterValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfInterpreterValue.AccessibleContext.accessibleDescription"));
        this.plfNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.plfNameValue.AccessibleContext.accessibleDescription"));
        this.addGemPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addGemPath.AccessibleContext.accessibleDescription"));
        this.removeGemPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeGemPath.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((JLabel)this.autoDetectLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectLabel.text"));
        this.progressPanel.add(this.autoDetectLabel);
        this.autoDetectProgress.setIndeterminate(true);
        this.progressPanel.add(this.autoDetectProgress);
        Mnemonics.setLocalizedText((JLabel)this.rubyDebuggerLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.rubyDebuggerLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.engineLabel, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.engineLabel.text"));
        this.engineType.setFont(this.engineType.getFont().deriveFont(this.engineType.getFont().getStyle() | 2));
        Mnemonics.setLocalizedText((JLabel)this.engineType, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.classicDebuggerEngine.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.installFastDebugger, (String)NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.installFastDebugger.text"));
        this.installFastDebugger.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RubyPlatformCustomizer.this.installFastDebuggerActionPerformed(evt);
            }
        });
        GroupLayout debuggerPanelLayout = new GroupLayout((Container)this.debuggerPanel);
        this.debuggerPanel.setLayout((LayoutManager)debuggerPanelLayout);
        debuggerPanelLayout.setHorizontalGroup((GroupLayout.Group)debuggerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)debuggerPanelLayout.createSequentialGroup().add((GroupLayout.Group)debuggerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)debuggerPanelLayout.createSequentialGroup().add((Component)this.rubyDebuggerLabel).addPreferredGap(0).add((Component)this.upperSep, -1, 478, Short.MAX_VALUE)).add((GroupLayout.Group)debuggerPanelLayout.createSequentialGroup().add((Component)this.engineLabel).addPreferredGap(0).add((Component)this.engineType).addPreferredGap(0).add((Component)this.installFastDebugger))).addContainerGap()));
        debuggerPanelLayout.setVerticalGroup((GroupLayout.Group)debuggerPanelLayout.createParallelGroup(1).add((GroupLayout.Group)debuggerPanelLayout.createSequentialGroup().add((GroupLayout.Group)debuggerPanelLayout.createParallelGroup(4).add((Component)this.rubyDebuggerLabel).add((Component)this.upperSep, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)debuggerPanelLayout.createParallelGroup(3).add((Component)this.engineLabel).add((Component)this.engineType).add((Component)this.installFastDebugger)).addContainerGap(-1, Short.MAX_VALUE)));
        this.installFastDebugger.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.installFastDebugger.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.platformsLabel).add((Component)this.platformsListSP, -2, 235, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.debuggerPanel, -1, -1, Short.MAX_VALUE).add((Component)this.configPanel, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton).add(6, 6, 6).add((Component)this.gemManagerButton).addPreferredGap(0).add((Component)this.autoDetectButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.progressPanel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.platformsLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.platformsListSP, -1, 312, Short.MAX_VALUE).add(6, 6, 6)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.configPanel, -2, -1, -2).add(18, 18, 18).add((Component)this.debuggerPanel, -2, -1, -2).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.gemManagerButton).add((Component)this.autoDetectButton)).add((Component)this.progressPanel, -2, 25, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.addButton, this.autoDetectButton, this.progressPanel, this.removeButton}, 2);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.addButton.AccessibleContext.accessibleDescription"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.removeButton.AccessibleContext.accessibleDescription"));
        this.autoDetectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RubyPlatformCustomizer.class, (String)"RubyPlatformCustomizer.autoDetectButton.AccessibleContext.accessibleDescription"));
    }

    private void gemManagerButtonActionPerformed(ActionEvent evt) {
        GemAction.showGemManager(this.getSelectedPlatform(), false);
    }

    private PlatformComponentFactory.RubyPlatformListModel getPlafListModel() {
        return (PlatformComponentFactory.RubyPlatformListModel)this.platformsList.getModel();
    }

    private void addButtonaddPlatform(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(RubyPreferences.getPreferences().get(LAST_PLATFORM_DIRECTORY, ""));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileHidingEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || RubyPlatformCustomizer.this.isRuby(f);
            }

            @Override
            public String getDescription() {
                return RubyPlatformCustomizer.getMessage("RubyPlatformCustomizer.rubyPlatform");
            }
        });
        int ret = chooser.showOpenDialog(this);
        if (ret == 0) {
            final File intepreter = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            RubyPreferences.getPreferences().put(LAST_PLATFORM_DIRECTORY, intepreter.getParentFile().getAbsolutePath());
            this.setAutoDetecting(true);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    final RubyPlatform platform = RubyPlatformCustomizer.this.getPlafListModel().addPlatform(intepreter);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (platform == null) {
                                Util.notifyLocalized(RubyPlatformCustomizer.class, "RubyPlatformCustomizer.invalid.platform.added", intepreter.getAbsolutePath());
                            } else {
                                RubyPlatformCustomizer.this.refreshPlatform();
                            }
                            RubyPlatformCustomizer.this.setAutoDetecting(false);
                        }
                    });
                }
            });
        }
    }

    private boolean isRuby(File f) {
        String fName = f.getName().toLowerCase(Locale.US);
        return f.isFile() && (fName.contains("ruby") || fName.contains("rubinius"));
    }

    private void removeButtonremovePlatform(ActionEvent evt) {
        RubyPlatform plaf = this.getSelectedPlatform();
        if (plaf != null) {
            this.getPlafListModel().removePlatform(plaf);
            this.platformsList.setSelectedValue(RubyPlatformManager.getDefaultPlatform(), true);
            this.refreshPlatform();
            this.platformsList.requestFocusInWindow();
        }
    }

    private void autoDetectButtonremovePlatform(ActionEvent evt) {
        this.performPlatformDetection();
        this.platformsList.requestFocusInWindow();
    }

    private void installFastDebuggerActionPerformed(ActionEvent evt) {
        if (this.getSelectedPlatform().isJRuby()) {
            Util.notifyLocalized(RubyPlatformCustomizer.class, "RubyPlatformCustomizer.instructionsToInstallJRubyDebugger", this.getSelectedPlatform().getFastDebuggerProblemsInHTML());
        } else if (this.getSelectedPlatform().installFastDebugger()) {
            this.refreshDebugger();
        }
    }

    private void browseGemHomeActionPerformed(ActionEvent evt) {
        boolean changed = GemPanel.chooseAndSetGemHome(this, this.getSelectedPlatform());
        if (changed) {
            this.refreshPlatform();
        }
    }

    private void addGemPathActionPerformed(ActionEvent evt) {
        File repo = GemPanel.chooseGemRepository(this);
        if (repo != null) {
            String absPath = repo.getAbsolutePath();
            if (!this.getGemPathListModel().getPaths().contains(absPath)) {
                this.getGemPathListModel().addPath(repo);
                this.refreshPlatform();
                this.gemPathList.requestFocus();
                this.gemPathList.setSelectedValue(absPath, true);
            }
        }
    }

    private void removeGemPathActionPerformed(ActionEvent evt) {
        this.getGemPathListModel().removePath((File)this.gemPathList.getSelectedValue());
        this.refreshPlatform();
        if (this.getGemPathListModel().getSize() > 0) {
            this.gemPathList.setSelectedIndex(0);
        }
        this.gemPathList.requestFocus();
    }

    private void refreshDebugger() {
        RubyPlatform platform = this.getSelectedPlatform();
        boolean supportFastDebuggerInstallation = !platform.isRubinius();
        boolean fdInstalled = platform.hasFastDebuggerInstalled();
        this.installFastDebugger.setEnabled(supportFastDebuggerInstallation && platform.hasRubyGemsInstalled());
        this.installFastDebugger.setVisible(supportFastDebuggerInstallation && !fdInstalled);
        String key = platform.isRubinius() ? "RubyPlatformCustomizer.noFastDebuggerForRubiniusYet.text" : (platform.hasFastDebuggerInstalled() ? "RubyPlatformCustomizer.rubyDebugEngine.text" : "RubyPlatformCustomizer.classicDebuggerEngine.text");
        this.engineType.setText(RubyPlatformCustomizer.getMessage(key));
    }

    private boolean refreshGemToolVersion() {
        boolean wasUpdated = false;
        RubyPlatform plaf = this.getSelectedPlatform();
        String old = plaf.getInfo().getGemVersion();
        plaf.getGemManager().resetLocal();
        String updated = plaf.getGemManager().getLatestVersion(UPDATE_GEM_NAME);
        if (updated != null && !updated.equals(old)) {
            plaf.getInfo().setGemVersion(updated);
            wasUpdated = true;
        }
        return wasUpdated;
    }

    private static final class GemPathsListModel
    extends AbstractListModel {
        private final RubyPlatform platform;

        GemPathsListModel(RubyPlatform platform) {
            this.platform = platform;
        }

        @Override
        public Object getElementAt(int index) {
            return index >= this.getSize() ? null : this.getPaths().toArray()[index];
        }

        @Override
        public int getSize() {
            return this.getPaths().size();
        }

        void addPath(File repo) {
            this.platform.getGemManager().addGemPath(repo);
            super.fireIntervalAdded(this, 0, this.getSize());
        }

        void removePath(File path) {
            this.platform.getGemManager().removeGemPath(path);
            super.fireIntervalRemoved(this, 0, this.getSize());
        }

        private Set<File> getPaths() {
            return this.platform.getGemManager().getGemPath();
        }
    }
}

