/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RubyPlatformProvider {
    private static final Logger LOGGER = Logger.getLogger(RubyPlatformProvider.class.getName());
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor(ExecutionUtils.namedThreadFactory("Ruby Platform AutoDetection"));
    private final PropertyEvaluator evaluator;
    private static final Map<String, Boolean> LOGGED_WARNINGS = new HashMap<String, Boolean>();

    public RubyPlatformProvider(PropertyEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public RubyPlatform getPlatform() {
        String id = this.evaluator.getProperty("platform.active");
        return RubyPlatformProvider.getPlatform(id);
    }

    public static RubyPlatform getPlatform(String id) {
        RubyPlatform platform;
        RubyPlatformProvider.ensurePlatformsReady();
        RubyPlatform rubyPlatform = platform = id == null ? RubyPlatformManager.getDefaultPlatform() : RubyPlatformManager.getPlatformByID(id);
        if (platform == null) {
            platform = RubyPlatformManager.getDefaultPlatform();
            if (LOGGED_WARNINGS.get(id) == null) {
                LOGGER.info("Platform with id '" + id + "' does not exist. Using default platform.");
                LOGGED_WARNINGS.put(id, Boolean.TRUE);
            }
        }
        return platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensurePlatformsReady() {
        if (!RubyPreferences.isFirstPlatformTouch()) {
            return;
        }
        String handleMessage = NbBundle.getMessage(RubyPlatformProvider.class, (String)"RubyPlatformProvider.RubyPlatformAutoDetection");
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)handleMessage);
        ph.start();
        Future<?> result = EXECUTOR.submit(new Runnable(){

            @Override
            public void run() {
                RubyPlatformManager.performPlatformDetection();
            }
        });
        try {
            result.get(30L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TimeoutException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            ph.finish();
        }
    }

    static {
        RubyPlatformManager.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("platforms".equals(evt.getPropertyName())) {
                    LOGGED_WARNINGS.clear();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTOR.shutdown();
            }
        });
    }
}

