/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.navigator.NavigatorController;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class NavigatorTC
extends TopComponent {
    private static NavigatorTC instance;
    private NavigatorPanel selectedPanel;
    private List<NavigatorPanel> panels;
    private NavigatorController controller;
    private final JLabel notAvailLbl = new JLabel(NbBundle.getMessage(NavigatorTC.class, (String)"MSG_NotAvailable"));
    private Lookup navTCLookup;
    private JPanel contentArea;
    private JPanel holderPanel;
    private JComboBox panelSelector;

    private NavigatorTC() {
        this.initComponents();
        this.setName(NbBundle.getMessage(NavigatorTC.class, (String)"LBL_Navigator"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/navigator/resources/navigator.png"));
        this.setFocusable(true);
        this.putClientProperty("SlidingName", this.getName());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NavigatorTC.class, (String)"ACC_DESC_NavigatorTC"));
        this.notAvailLbl.setHorizontalAlignment(0);
        this.notAvailLbl.setEnabled(false);
        Color usualWindowBkg = UIManager.getColor("window");
        this.notAvailLbl.setBackground(usualWindowBkg != null ? usualWindowBkg : Color.white);
        this.notAvailLbl.setOpaque(true);
        this.holderPanel.setOpaque(false);
        this.getController().installActions();
        this.setToEmpty();
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color backColor = UIManager.getColor("NbExplorerView.background");
            this.setBackground(backColor);
            this.notAvailLbl.setBackground(backColor);
            this.setOpaque(true);
            this.holderPanel.setOpaque(true);
            this.holderPanel.setBackground(backColor);
            this.holderPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("NbSplitPane.background")));
        }
    }

    public static final NavigatorTC getInstance() {
        NavigatorTC navTC = (NavigatorTC)WindowManager.getDefault().findTopComponent("navigatorTC");
        if (navTC == null) {
            navTC = NavigatorTC.privateGetInstance();
            Logger.getAnonymousLogger().warning("Could not locate the navigator component via its winsys id");
        }
        return navTC;
    }

    public static final NavigatorTC privateGetInstance() {
        if (instance == null) {
            instance = new NavigatorTC();
        }
        return instance;
    }

    public void setSelectedPanel(NavigatorPanel panel) {
        int panelIdx = this.panels.indexOf(panel);
        assert (panelIdx != -1) : "Panel to select is not available";
        if (panel.equals(this.selectedPanel)) {
            return;
        }
        this.selectedPanel = panel;
        assert (SwingUtilities.isEventDispatchThread()) : "Called in AWT queue.";
        JComponent comp = this.selectedPanel.getComponent();
        if (comp == null) {
            NullPointerException npe = new NullPointerException("Method " + this.selectedPanel.getClass().getName() + ".getComponent() must not return null under any condition!");
            ErrorManager.getDefault().notify(4096, (Throwable)npe);
        } else {
            this.contentArea.removeAll();
            this.contentArea.add((Component)panel.getComponent(), "Center");
            this.revalidate();
            this.repaint();
        }
        this.panelSelector.setSelectedIndex(panelIdx);
    }

    public NavigatorPanel getSelectedPanel() {
        return this.selectedPanel;
    }

    public List<NavigatorPanel> getPanels() {
        return this.panels;
    }

    public void setPanels(List<NavigatorPanel> panels, NavigatorPanel select) {
        this.panels = panels;
        int panelsCount = panels == null ? -1 : panels.size();
        this.selectedPanel = null;
        if (panelsCount <= 0) {
            this.setToEmpty();
        } else {
            this.contentArea.removeAll();
            this.panelSelector.removeAllItems();
            this.holderPanel.setVisible(panelsCount != 1);
            int i = 0;
            boolean selectFound = false;
            for (NavigatorPanel curPanel : panels) {
                this.panelSelector.addItem(curPanel.getDisplayName());
                if (curPanel == select) {
                    selectFound = true;
                }
                ++i;
            }
            if (selectFound) {
                this.setSelectedPanel(select);
            } else {
                this.selectedPanel = panels.get(0);
            }
            this.resetFromEmpty();
        }
    }

    public JComboBox getPanelSelector() {
        return this.panelSelector;
    }

    public String preferredID() {
        return "navigatorTC";
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        if (this.selectedPanel != null) {
            return this.selectedPanel.getComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void requestFocus() {
        if (this.selectedPanel != null) {
            this.selectedPanel.getComponent().requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("navigator.java");
    }

    public void componentOpened() {
        this.getController().navigatorTCOpened();
    }

    public void componentClosed() {
        this.getController().navigatorTCClosed();
    }

    public Lookup getLookup() {
        if (this.navTCLookup == null) {
            Lookup defaultLookup = super.getLookup();
            Lookup clientLookup = this.getController().getPanelLookup();
            this.navTCLookup = new ProxyLookup(new Lookup[]{defaultLookup, clientLookup});
        }
        return this.navTCLookup;
    }

    public UndoRedo getUndoRedo() {
        return this.getController().getUndoRedo();
    }

    public NavigatorController getController() {
        if (this.controller == null) {
            this.controller = new NavigatorController(this);
        }
        return this.controller;
    }

    private void setToEmpty() {
        if (this.notAvailLbl.isShowing()) {
            return;
        }
        this.remove(this.holderPanel);
        this.holderPanel.setVisible(false);
        this.remove(this.contentArea);
        this.add(this.notAvailLbl, "Center");
        this.revalidate();
        this.repaint();
    }

    private void resetFromEmpty() {
        if (this.contentArea.isShowing()) {
            // empty if block
        }
        this.remove(this.notAvailLbl);
        this.add(this.holderPanel, "North");
        this.add(this.contentArea, "Center");
        this.revalidate();
        this.repaint();
    }

    private void initComponents() {
        this.holderPanel = new JPanel();
        this.panelSelector = new JComboBox();
        this.contentArea = new JPanel();
        this.setLayout(new BorderLayout());
        this.holderPanel.setLayout(new BorderLayout());
        this.holderPanel.add((Component)this.panelSelector, "Center");
        this.add(this.holderPanel, "North");
        this.contentArea.setLayout(new BorderLayout());
        this.add(this.contentArea, "Center");
    }
}

