/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby.ui.tree;

import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FolderTreeElement
implements TreeElement {
    private FileObject fo;

    FolderTreeElement(FileObject fo) {
        this.fo = fo;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            SourceGroup sg = FolderTreeElement.getSourceGroup(this.fo);
            if (sg != null) {
                return TreeElementFactory.getTreeElement((Object)sg);
            }
            return null;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)this.fo);
        if (p != null) {
            return TreeElementFactory.getTreeElement((Object)p);
        }
        return null;
    }

    public Icon getIcon() {
        return UiUtils.getElementIcon((ElementKind)ElementKind.MODULE, null);
    }

    public String getText(boolean isLogical) {
        ClassPath cp = ClassPath.getClassPath((FileObject)this.fo, (String)"classpath/source");
        if (cp == null) {
            return this.fo.getPath();
        }
        if (FolderTreeElement.getRubySourceGroup(this.fo) != null) {
            String name = cp.getResourceName(this.fo).replace('/', '.');
            if ("".equals(name)) {
                return NbBundle.getMessage(UiUtils.class, (String)"LBL_DefaultPackage_PDU");
            }
            return name;
        }
        return this.fo.getPath();
    }

    static SourceGroup getSourceGroup(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] rubygroups = src.getSourceGroups("ruby");
        SourceGroup[] xmlgroups = src.getSourceGroups("xml");
        if (rubygroups.length == 0 && xmlgroups.length == 0) {
            return null;
        }
        SourceGroup[] allgroups = new SourceGroup[rubygroups.length + xmlgroups.length];
        System.arraycopy(rubygroups, 0, allgroups, 0, rubygroups.length);
        System.arraycopy(xmlgroups, 0, allgroups, allgroups.length - 1, xmlgroups.length);
        for (int i = 0; i < allgroups.length; ++i) {
            if (!allgroups[i].getRootFolder().equals(file) && !FileUtil.isParentOf((FileObject)allgroups[i].getRootFolder(), (FileObject)file)) continue;
            return allgroups[i];
        }
        return null;
    }

    private static SourceGroup getRubySourceGroup(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] rubygroups = src.getSourceGroups("ruby");
        for (int i = 0; i < rubygroups.length; ++i) {
            if (!rubygroups[i].getRootFolder().equals(file) && !FileUtil.isParentOf((FileObject)rubygroups[i].getRootFolder(), (FileObject)file)) continue;
            return rubygroups[i];
        }
        return null;
    }

    public Object getUserObject() {
        return this.fo;
    }
}

