/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.modules.search.CopyTextAction;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.NodeSelector;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

final class NodeListener
implements MouseListener,
KeyListener,
TreeWillExpandListener,
TreeExpansionListener {
    private static final boolean COLLAPSE_FILE_ON_SELECTION = false;
    private static final boolean COLLAPSE_FILE_ON_UNSELECTION = true;
    private boolean selectionChangeEnabled = true;

    NodeListener() {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTree tree = (JTree)e.getSource();
        int clickCount = e.getClickCount();
        if (clickCount != 1 && clickCount != 2) {
            return;
        }
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(tree);
        boolean insideCheckBox = this.isInsideCheckBox(tree, path, resultModel, e);
        int modifiers = e.getModifiersEx();
        if (modifiers == 0 || modifiers == 16 || modifiers == 1024) {
            if (clickCount == 1 && insideCheckBox) {
                assert (path != null);
                this.toggleSelection(tree, path);
            }
            if (clickCount == 2 && !insideCheckBox) {
                if (path.getPathCount() == 1) {
                    this.toggleExpansionState(tree, path);
                } else {
                    Node nbNode = NodeListener.getNbNode(path, resultModel);
                    this.callDefaultAction(nbNode, e.getSource(), e.getID(), "double-click");
                }
            }
        }
    }

    private static boolean checkPathCounts(TreePath[] paths, int expLength) {
        for (TreePath path : paths) {
            if (path.getPathCount() == expLength) continue;
            return false;
        }
        return true;
    }

    private void popupTriggerEventFired(MouseEvent e) {
        int selCount;
        JTree tree = (JTree)e.getSource();
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return;
        }
        if (!NodeListener.isPathSelected(path, tree)) {
            tree.setSelectionPath(path);
        }
        if ((selCount = tree.getSelectionCount()) >= 1) {
            ResultModel resultModel = this.getResultModel(tree);
            if (selCount > 1) {
                this.showPopup(tree, null, resultModel, e);
            } else if (!this.isInsideCheckBox(tree, path, resultModel, e)) {
                this.showPopup(tree, path, resultModel, e);
            }
        }
    }

    private static boolean isPathSelected(TreePath path, JTree tree) {
        int selCount = tree.getSelectionCount();
        if (selCount == 0) {
            return false;
        }
        if (selCount == 1) {
            return tree.getSelectionPath().equals(path);
        }
        for (TreePath tp : tree.getSelectionPaths()) {
            if (!tp.equals(path)) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideCheckBox(JTree tree, TreePath path, ResultModel resultModel, MouseEvent mouseEvent) {
        if (resultModel == null || !resultModel.searchAndReplace) {
            return false;
        }
        Rectangle rowRect = tree.getPathBounds(path);
        Rectangle chRect = NodeRenderer.getCheckBoxRectangle();
        chRect.setLocation(rowRect.x + chRect.x, rowRect.y + chRect.y);
        return chRect.contains(mouseEvent.getPoint());
    }

    private void showPopup(JTree tree, TreePath path, ResultModel resultModel, MouseEvent e) {
        int pathCount;
        TreePath[] paths;
        if (path != null) {
            paths = null;
            pathCount = path.getPathCount();
        } else {
            paths = tree.getSelectionPaths();
            assert (paths.length > 1);
            if (NodeListener.checkPathCounts(paths, 2)) {
                pathCount = 2;
            } else {
                return;
            }
        }
        if (pathCount != 1) {
            if (pathCount == 2) {
                JPopupMenu popup = null;
                if (tree.getSelectionCount() > 1) {
                    StringBuilder wholeNameBuf = new StringBuilder(30);
                    HashSet<String> labels = new HashSet<String>();
                    final ArrayList<Node> nbNodes = new ArrayList<Node>(paths.length);
                    for (TreePath tp : paths) {
                        String partName;
                        Node nbNode = NodeListener.getNbNode(tp, resultModel);
                        if (nbNode == null) continue;
                        nbNodes.add(nbNode);
                        Action action = this.getDefaultAction(nbNode);
                        if (action == null || (partName = NodeListener.getMenuItemLabel(action)).length() == 0 || !labels.add(partName)) continue;
                        wholeNameBuf.append('/').append(partName);
                    }
                    if (labels.isEmpty()) {
                        return;
                    }
                    JMenuItem menuItem = new JMenuItem(wholeNameBuf.toString().substring(1));
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            NodeListener.this.callResultNodesDefaultActions(nbNodes, e);
                        }
                    });
                    popup = new JPopupMenu();
                    popup.add(menuItem);
                } else {
                    popup = this.createFileNodePopupMenu(path, resultModel);
                }
                if (popup != null) {
                    Point location = NodeListener.getPopupMenuLocation(tree, path, e);
                    popup.show(tree, location.x, location.y);
                }
            } else if (pathCount == 3) {
                Node nbNode;
                if (tree.getSelectionCount() == 1 && (nbNode = NodeListener.getNbNode(path, resultModel)) != null) {
                    Point location = NodeListener.getPopupMenuLocation(tree, path, e);
                    nbNode.getContextMenu().show(tree, location.x, location.y);
                }
            } else assert (false);
        }
    }

    private void callResultNodesDefaultActions(Collection<Node> nbNodes, ActionEvent e) {
        assert (nbNodes != null && !nbNodes.isEmpty());
        Object eSource = e.getSource();
        int eID = e.getID();
        for (Node nbNode : nbNodes) {
            this.callDefaultAction(nbNode, eSource, eID, "click");
        }
    }

    private static Point getPopupMenuLocation(JTree tree, TreePath path, MouseEvent e) {
        if (e != null) {
            return new Point(e.getX(), e.getY());
        }
        if (path != null) {
            return tree.getPathBounds(path).getLocation();
        }
        Point pos = tree.getMousePosition();
        if (pos == null) {
            Rectangle r = tree.getVisibleRect();
            pos = new Point(r.x + r.width / 2, r.y + r.height / 2);
        }
        return pos;
    }

    private boolean autocollapseFileNodeIfNeeded(JTree tree, TreePath treePath, MatchingObject matchingObj, boolean selected) {
        boolean isCollapsed;
        boolean autocollapse;
        assert (treePath.getPathCount() == 2 && treePath.getLastPathComponent() == matchingObj);
        boolean bl = autocollapse = !selected;
        if (autocollapse) {
            if (matchingObj.isExpanded()) {
                tree.collapsePath(treePath);
            }
            isCollapsed = true;
        } else {
            isCollapsed = !tree.isExpanded(treePath);
        }
        return isCollapsed;
    }

    private void toggleRootNodeSelection(JTree tree, TreePath path) {
        boolean autocollapse;
        ResultTreeModel resultTreeModel = this.getResultTreeModel(path);
        ResultModel resultModel = resultTreeModel.resultModel;
        boolean isSelected = resultTreeModel.isSelected();
        boolean willBeSelected = !isSelected;
        boolean bl = autocollapse = !willBeSelected;
        if (resultModel == null) {
            return;
        }
        List<MatchingObject> matchingObjects = resultModel.getMatchingObjects();
        int[] toggledIndices = null;
        MatchingObject[] toggledObjects = null;
        ArrayList<MatchingObject> expandedToggled = null;
        int toggledCount = 0;
        int i = 0;
        for (MatchingObject matchingObj : matchingObjects) {
            boolean collapsed;
            boolean bl2 = collapsed = !matchingObj.isExpanded();
            if (autocollapse && !collapsed) {
                tree.collapsePath(path.pathByAddingChild(matchingObj));
                collapsed = true;
            }
            if (matchingObj.isSelected() == willBeSelected) continue;
            matchingObj.setSelected(willBeSelected);
            if (toggledCount == 0) {
                int arrayLength = matchingObjects.size() - i;
                toggledIndices = new int[arrayLength];
                toggledObjects = new MatchingObject[arrayLength];
            }
            toggledIndices[toggledCount] = i;
            toggledObjects[toggledCount] = matchingObj;
            ++toggledCount;
            if (collapsed) {
                matchingObj.markChildrenSelectionDirty();
            } else {
                if (expandedToggled == null) {
                    expandedToggled = new ArrayList<MatchingObject>(6);
                }
                expandedToggled.add(matchingObj);
            }
            ++i;
        }
        if (toggledCount != 0 && toggledCount != matchingObjects.size()) {
            int[] newToggledIndices = new int[toggledCount];
            System.arraycopy(toggledIndices, 0, newToggledIndices, 0, toggledCount);
            toggledIndices = newToggledIndices;
            MatchingObject[] newToggledObjects = new MatchingObject[toggledCount];
            System.arraycopy(toggledObjects, 0, newToggledObjects, 0, toggledCount);
            toggledObjects = newToggledObjects;
        }
        resultTreeModel.setRootNodeSelected(willBeSelected);
        if (toggledCount != 0) {
            assert (toggledIndices.length == toggledCount);
            assert (toggledObjects.length == toggledCount);
            resultTreeModel.fireFileNodesSelectionChanged(toggledIndices, toggledObjects);
        }
        if (expandedToggled != null) {
            for (MatchingObject obj : expandedToggled) {
                resultTreeModel.fireFileNodeChildrenSelectionChanged(obj);
            }
        }
    }

    private void setFileNodeSelected(JTree tree, TreePath treePath, MatchingObject mo, boolean selected) {
        assert (treePath.getPathCount() == 2);
        this.autocollapseFileNodeIfNeeded(tree, treePath, mo, selected);
        mo.setSelected(selected);
        this.getResultTreeModel(treePath).fileNodeSelectionChanged(mo, true);
    }

    private void toggleDetailNodeSelection(JTree tree, ResultModel resultModel, MatchingObject mo, int index) {
        boolean propagateUp = mo.toggleSubnodeSelection(resultModel, index);
        ResultTreeModel resultTreeModel = this.getResultTreeModel(tree);
        resultTreeModel.fireDetailNodeSelectionChanged(mo, index);
        if (propagateUp) {
            resultTreeModel.fileNodeSelectionChanged(mo, false);
        }
    }

    private ResultTreeModel getResultTreeModel(TreePath path) {
        return (ResultTreeModel)path.getPathComponent(0);
    }

    private ResultTreeModel getResultTreeModel(JTree tree) {
        return (ResultTreeModel)tree.getPathForRow(0).getPathComponent(0);
    }

    private ResultModel getResultModel(JTree tree) {
        return ((ResultTreeModel)tree.getPathForRow((int)0).getPathComponent((int)0)).resultModel;
    }

    private static Node getNbNode(TreePath path, ResultModel resultModel) {
        Node node;
        boolean isFileNode;
        MatchingObject mo;
        Object obj = path.getLastPathComponent();
        if (obj.getClass() == MatchingObject.class) {
            mo = (MatchingObject)obj;
            isFileNode = true;
        } else {
            Object parentObj = path.getParentPath().getLastPathComponent();
            assert (parentObj.getClass() == MatchingObject.class);
            mo = (MatchingObject)parentObj;
            isFileNode = false;
        }
        if (!mo.isObjectValid()) {
            return null;
        }
        if (isFileNode) {
            node = resultModel == null ? null : resultModel.getSearchGroup().getNodeForFoundObject(mo.object);
        } else {
            assert (obj instanceof Node);
            node = (Node)obj;
        }
        return node;
    }

    private static MatchingObject getMatchingObject(TreePath path) {
        Object obj = path.getLastPathComponent();
        return obj instanceof MatchingObject ? (MatchingObject)obj : null;
    }

    private JPopupMenu createFileNodePopupMenu(TreePath path, ResultModel resultModel) {
        Node fileNode = NodeListener.getNbNode(path, resultModel);
        if (fileNode == null) {
            return null;
        }
        Action action = this.getDefaultAction(fileNode);
        if (action == null) {
            return null;
        }
        assert (action.isEnabled());
        JMenuItem menuItem = NodeListener.getJMenuItem(action);
        JPopupMenu popupMenu = new JPopupMenu();
        if (menuItem != null) {
            popupMenu.add(menuItem);
        } else {
            popupMenu.add(action);
        }
        CopyTextAction cta = this.newCopyTextAction(path);
        if (cta != null) {
            popupMenu.add(cta);
        }
        return popupMenu;
    }

    private CopyTextAction newCopyTextAction(TreePath path) {
        try {
            MatchingObject mo = NodeListener.getMatchingObject(path);
            String filePath = mo.getFile().getCanonicalPath();
            String ctaName = NbBundle.getBundle(this.getClass()).getString("LBL_CopyFilePathAction");
            CopyTextAction cta = new CopyTextAction(ctaName);
            cta.setTextCopy(filePath);
            return cta;
        }
        catch (IOException ex) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static String getMenuItemLabel(Action action) {
        JMenuItem menuItem = NodeListener.getJMenuItem(action);
        return menuItem != null ? menuItem.getText() : (String)action.getValue("Name");
    }

    private static JMenuItem getJMenuItem(Action action) {
        return action instanceof Presenter.Popup ? ((Presenter.Popup)action).getPopupPresenter() : null;
    }

    private Action getDefaultAction(Node node) {
        Action action;
        EditAction editAction = (EditAction)SharedClassObject.findObject(EditAction.class, (boolean)true);
        if (editAction != null && (action = editAction.createContextAwareInstance(Lookups.singleton((Object)node))).isEnabled()) {
            return action;
        }
        Action preferredAction = node.getPreferredAction();
        if (preferredAction == null) {
            return null;
        }
        action = preferredAction;
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        return action != null && action.isEnabled() ? action : null;
    }

    private void callDefaultAction(Node node, Object eventSource, int eventId, String command) {
        if (node == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        EditCookie editCookie = (EditCookie)node.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return;
        }
        Action action = node.getPreferredAction();
        if (action == null) {
            return;
        }
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(eventSource, eventId, command));
        }
    }

    private void toggleExpansionState(JTree tree, TreePath path) {
        if (tree.isCollapsed(path)) {
            tree.expandPath(path);
        } else {
            tree.collapsePath(path);
        }
    }

    private void toggleSelection(JTree tree, TreePath path) {
        assert (EventQueue.isDispatchThread());
        if (!this.selectionChangeEnabled) {
            return;
        }
        int pathCount = path.getPathCount();
        if (pathCount == 1) {
            this.toggleRootNodeSelection(tree, path);
        } else if (pathCount == 2) {
            MatchingObject matchingObj;
            this.setFileNodeSelected(tree, path, matchingObj, !(matchingObj = (MatchingObject)path.getPathComponent(1)).isSelected());
        } else {
            assert (pathCount == 3);
            MatchingObject matchingObj = (MatchingObject)path.getPathComponent(1);
            int parentPathRow = tree.getRowForPath(path.getParentPath());
            int row = tree.getRowForPath(path);
            int index = row - parentPathRow - 1;
            this.toggleDetailNodeSelection(tree, this.getResultModel(tree), matchingObj, index);
        }
    }

    void setSelectionChangeEnabled(boolean enabled) {
        assert (EventQueue.isDispatchThread());
        this.selectionChangeEnabled = enabled;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupTriggerEventFired(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popupTriggerEventFired(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        JTree tree = (JTree)e.getSource();
        ResultModel resultModel = this.getResultModel(tree);
        if (e.getKeyChar() == ' ') {
            TreePath path = tree.getSelectionPath();
            if (path != null) {
                if (resultModel.searchAndReplace) {
                    this.toggleSelection(tree, path);
                } else if (tree.isCollapsed(path)) {
                    tree.expandPath(path);
                } else {
                    tree.collapsePath(path);
                }
            }
        } else if (e.getKeyCode() == 10 && e.getModifiersEx() == 0) {
            List<TreePath> mainNodes;
            TreeSelectionModel selectionModel = tree.getSelectionModel();
            if (selectionModel.getSelectionCount() == 0) {
                return;
            }
            if (selectionModel.getSelectionCount() == 1) {
                TreePath selectedPath = selectionModel.getLeadSelectionPath();
                if (selectedPath == null || selectedPath.getParentPath() == null) {
                    return;
                }
                mainNodes = Collections.singletonList(selectedPath);
            } else {
                TreePath[] selectedPaths = selectionModel.getSelectionPaths();
                if (selectedPaths == null || selectedPaths.length < 2) {
                    assert (false);
                    return;
                }
                mainNodes = NodeSelector.selectMainNodes(selectedPaths, resultModel.canHaveDetails());
            }
            for (TreePath mainNode : mainNodes) {
                Node nbNode = NodeListener.getNbNode(mainNode, resultModel);
                this.callDefaultAction(nbNode, e.getSource(), e.getID(), "enter");
            }
        } else if (e.getKeyCode() == 525 && e.getModifiersEx() == 0) {
            e.consume();
            int selCount = tree.getSelectionCount();
            if (selCount >= 1) {
                if (selCount > 1) {
                    this.showPopup(tree, null, resultModel, null);
                } else {
                    TreePath path = tree.getSelectionPath();
                    this.showPopup(tree, path, resultModel, null);
                }
            }
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        MatchingObject matchingObj;
        TreePath path = event.getPath();
        if (path.getPathCount() == 2 && (matchingObj = (MatchingObject)path.getLastPathComponent()).isChildrenSelectionDirty()) {
            this.getResultTreeModel(path).fireFileNodeChildrenSelectionChanged(matchingObj);
            matchingObj.markChildrenSelectionClean();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() == 2) {
            ((MatchingObject)path.getLastPathComponent()).markExpanded(true);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        if (path.getPathCount() == 2) {
            ((MatchingObject)path.getLastPathComponent()).markExpanded(false);
        }
    }
}

