/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.Utils;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

final class MatchingObject
implements Comparable<MatchingObject>,
PropertyChangeListener {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private final ResultModel resultModel;
    private final File file;
    private final long timestamp;
    final Object object;
    private final Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private boolean[] matchesSelection;
    private int selectedMatchesCount;
    private boolean childrenSelectionDirty;
    private boolean valid = true;
    private StringBuilder text;
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, Object object, Charset charset) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (object == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.resultModel = resultModel;
        this.object = object;
        this.charset = charset;
        FileObject fileObject = this.getFileObject();
        this.file = FileUtil.toFile((FileObject)fileObject);
        this.timestamp = this.file != null ? this.file.lastModified() : 0L;
        this.valid = this.timestamp != 0L;
        this.setUpDataObjValidityChecking();
    }

    private void setUpDataObjValidityChecking() {
        DataObject dataObj = (DataObject)this.object;
        if (dataObj.isValid()) {
            dataObj.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    void cleanup() {
        DataObject dataObj = (DataObject)this.object;
        dataObj.removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("valid".equals(e.getPropertyName()) && Boolean.FALSE.equals(e.getNewValue())) {
            assert (e.getSource() == (DataObject)this.object);
            DataObject dataObj = (DataObject)this.object;
            dataObj.removePropertyChangeListener((PropertyChangeListener)this);
            this.resultModel.objectBecameInvalid(this);
        }
    }

    boolean isObjectValid() {
        return ((DataObject)this.object).isValid();
    }

    private FileObject getFileObject() {
        return ((DataObject)this.object).getPrimaryFile();
    }

    void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.matchesSelection = null;
    }

    boolean isSelected() {
        return this.selected;
    }

    boolean isUniformSelection() {
        return this.matchesSelection == null;
    }

    Boolean checkSubnodesSelection() {
        if (this.matchesSelection == null) {
            return this.selected;
        }
        boolean firstMatchSelection = this.matchesSelection[0];
        for (int i = 1; i < this.matchesSelection.length; ++i) {
            if (this.matchesSelection[i] == firstMatchSelection) continue;
            return null;
        }
        return firstMatchSelection;
    }

    boolean toggleSubnodeSelection(ResultModel resultModel, int index) {
        if (this.matchesSelection == null) {
            int detailsCount = resultModel.getDetailsCount(this);
            if (detailsCount == 1) {
                this.selected = !this.selected;
                return true;
            }
            this.matchesSelection = new boolean[detailsCount];
            Arrays.fill(this.matchesSelection, this.selected);
            this.matchesSelection[index] = !this.selected;
            boolean wasSelected = this.selected;
            this.selectedMatchesCount = wasSelected ? detailsCount - 1 : 1;
            this.selected = true;
            return this.selected != wasSelected;
        }
        assert (this.selected);
        assert (this.selectedMatchesCount > 0 && this.selectedMatchesCount < this.matchesSelection.length);
        boolean wasSubnodeSelected = this.matchesSelection[index];
        if (wasSubnodeSelected) {
            if (--this.selectedMatchesCount == 0) {
                this.matchesSelection = null;
                this.selected = false;
                return true;
            }
        } else if (++this.selectedMatchesCount == this.matchesSelection.length) {
            this.matchesSelection = null;
            return false;
        }
        this.matchesSelection[index] = !wasSubnodeSelected;
        return false;
    }

    boolean isSubnodeSelected(int index) {
        assert (this.matchesSelection == null || index >= 0 && index < this.matchesSelection.length) : "Illegal index=" + index + "in the case matchesSelection" + (this.matchesSelection == null ? "=null" : ".length=" + this.matchesSelection.length);
        return this.matchesSelection == null ? this.selected : this.matchesSelection[index];
    }

    void markChildrenSelectionDirty() {
        this.childrenSelectionDirty = true;
    }

    void markChildrenSelectionClean() {
        this.childrenSelectionDirty = false;
    }

    boolean isChildrenSelectionDirty() {
        return this.childrenSelectionDirty;
    }

    void markExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    File getFile() {
        return this.file;
    }

    String getName() {
        return this.getFile().getName();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFile().getParent();
    }

    String getText() throws IOException {
        StringBuilder txt = this.text();
        if (txt != null) {
            return txt.toString();
        }
        return null;
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    private StringBuilder text() throws IOException {
        return this.text(false);
    }

    private StringBuilder text(boolean refreshCache) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (refreshCache || this.text == null) {
            this.text = new StringBuilder(Utils.getCharSequence(new FileInputStream(this.getFile()), this.charset));
        }
        return this.text == null ? new StringBuilder() : this.text;
    }

    @Override
    public int compareTo(MatchingObject o) {
        if (o == null) {
            return Integer.MAX_VALUE;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus status = this.getInvalidityStatus();
        if (status != null) {
            this.valid = false;
        }
        return status;
    }

    String getInvalidityDescription() {
        InvalidityStatus status = this.getInvalidityStatus();
        String descr = status != null ? status.getDescription(this.getFile().getPath()) : null;
        return descr;
    }

    private InvalidityStatus getInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        File f = this.getFile();
        if (!f.exists()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (f.isDirectory()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long stamp = f.lastModified();
        if (stamp > this.resultModel.getCreationTime()) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (this.LOG.isLoggable(Level.FINEST)) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(stamp);
                this.log(Level.FINEST, " - file stamp:           " + stamp + " (" + cal.getTime() + ')');
                cal.setTimeInMillis(this.resultModel.getCreationTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getCreationTime() + " (" + cal.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (f.length() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!f.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public InvalidityStatus replace() throws IOException {
        boolean shouldReplaceNone;
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        Boolean uniformSelection = this.checkSubnodesSelection();
        boolean bl = shouldReplaceNone = uniformSelection == Boolean.FALSE;
        if (shouldReplaceNone) {
            return null;
        }
        StringBuilder content = this.text(true);
        List<TextDetail> textMatches = this.resultModel.basicCriteria.getTextDetails(this.object);
        int offsetShift = 0;
        for (int i = 0; i < textMatches.size(); ++i) {
            if (this.matchesSelection != null && !this.matchesSelection[i]) continue;
            TextDetail textDetail = textMatches.get(i);
            String matchedSubstring = content.substring(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift);
            if (!matchedSubstring.equals(textDetail.getMatchedText())) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (this.LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getMatchedText() + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + matchedSubstring + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            String replacedString = this.resultModel.basicCriteria.getReplaceExpr();
            if (this.resultModel.basicCriteria.isRegexp()) {
                Matcher m = this.resultModel.basicCriteria.getTextPattern().matcher(matchedSubstring);
                replacedString = m.replaceFirst(this.resultModel.basicCriteria.getReplaceString());
            }
            content.replace(textDetail.getStartOffset() + offsetShift, textDetail.getEndOffset() + offsetShift, replacedString);
            offsetShift += replacedString.length() - matchedSubstring.length();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        FileObject fileObject = this.getFileObject();
        Writer writer = null;
        try {
            writer = new OutputStreamWriter(fileObject.getOutputStream(fileLock), this.charset);
            writer.write(this.makeStringToWrite());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text);
    }

    static String makeStringToWrite(StringBuilder text) {
        return text.toString();
    }

    private void log(Level logLevel, String msg) {
        String id;
        String string = id = this.object instanceof DataObject ? ((DataObject)this.object).getName() : this.object.toString();
        if (this.LOG.isLoggable(logLevel)) {
            this.LOG.log(logLevel, id + ": " + msg);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean fatal, String descrBundleKey) {
            this.fatal = fatal;
            this.descrBundleKey = descrBundleKey;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String path) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)path);
        }
    }
}

