/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTask;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;

public class FindInFilesAction
extends CallableSystemAction
implements ContextAwareAction,
ChangeListener {
    static final long serialVersionUID = 4554342565076372611L;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.search.FindAction_state");
    private static final String VAR_FIRST_ISENABLED = "first call of isEnabled()";
    private static final String VAR_TOOLBAR_COMP_REF = "toolbar presenter ref";
    private static final String VAR_LISTENING = "listening";
    protected static final String REPLACING = "replacing";
    private static final String VAR_LAST_SEARCH_SCOPE_TYPE = "lastScopeType";
    private final String shortClassName;

    public FindInFilesAction() {
        String clsName = this.getClass().getName();
        int lastDot = clsName.lastIndexOf(46);
        this.shortClassName = lastDot != -1 ? clsName.substring(lastDot + 1) : clsName;
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.putProperty(VAR_FIRST_ISENABLED, Boolean.TRUE);
        this.putProperty(REPLACING, Boolean.FALSE, false);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        if (this.shouldLog(LOG)) {
            this.log("createContextAwareInstance(lookup)");
        }
        return new LookupSensitive(this, lookup);
    }

    public Action createContextAwareInstance(Lookup lookup, boolean searchSelection) {
        if (this.shouldLog(LOG)) {
            this.log("createContextAwareInstance(lookup, " + searchSelection + ')');
        }
        LookupSensitive result = new LookupSensitive(this, lookup, searchSelection);
        if (this.shouldLog(LOG)) {
            this.log(" -> " + result);
        }
        return result;
    }

    public Component getToolbarPresenter() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getMenuPresenter()");
        }
        Component presenter = this.getStoredToolbarPresenter();
        if (this.putProperty(VAR_LISTENING, Boolean.TRUE) == null) {
            SearchScopeRegistry.getDefault().addChangeListener(this);
            this.putProperty(VAR_FIRST_ISENABLED, null);
            this.updateState();
        }
        return presenter;
    }

    private Component getStoredToolbarPresenter() {
        Reference ref;
        Object presenterObj;
        Object refObj;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("getStoredToolbarPresenter()");
        }
        if ((refObj = this.getProperty(VAR_TOOLBAR_COMP_REF)) != null && (presenterObj = (ref = (Reference)refObj).get()) != null) {
            return (Component)presenterObj;
        }
        Component presenter = super.getToolbarPresenter();
        this.putProperty(VAR_TOOLBAR_COMP_REF, new WeakReference<Component>(presenter));
        return presenter;
    }

    private boolean checkToolbarPresenterExists() {
        Object refObj;
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("checkToolbarPresenterExists()");
        }
        if ((refObj = this.getProperty(VAR_TOOLBAR_COMP_REF)) == null) {
            return false;
        }
        return ((Reference)refObj).get() != null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.shouldLog(LOG)) {
            this.log("stateChanged()");
        }
        if (this.getProperty(VAR_LISTENING) == null) {
            return;
        }
        if (this.checkToolbarPresenterExists()) {
            this.updateState();
        } else {
            SearchScopeRegistry.getDefault().removeChangeListener(this);
            this.putProperty(VAR_LISTENING, null);
            this.putProperty(VAR_TOOLBAR_COMP_REF, null);
        }
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("isEnabled()");
        }
        if (this.getProperty(VAR_LISTENING) != null) {
            this.log(" - isListening");
            return super.isEnabled();
        }
        if (this.getProperty(VAR_FIRST_ISENABLED) == null) {
            this.log(" - checking registry");
            return SearchScopeRegistry.getDefault().hasApplicableSearchScope();
        }
        this.log(" - first \"isEnabled()\"");
        this.putProperty(VAR_FIRST_ISENABLED, null);
        return false;
    }

    private void updateState() {
        assert (EventQueue.isDispatchThread());
        if (this.shouldLog(LOG)) {
            this.log("updateState()");
        }
        final boolean enabled = SearchScopeRegistry.getDefault().hasApplicableSearchScope();
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                FindInFilesAction.this.setEnabled(enabled);
            }
        });
    }

    protected String iconResource() {
        return "org/openide/resources/actions/find.gif";
    }

    public String getName() {
        String key = SearchScopeRegistry.getDefault().hasProjectSearchScopes() ? "LBL_Action_FindInProjects" : "LBL_Action_FindInFiles";
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FindInFilesAction.class);
    }

    public void performAction() {
        this.performAction(SearchScopeRegistry.getDefault().getSearchScopes(), this.getLastSearchScope());
    }

    private void performAction(Map<SearchScope, Boolean> searchScopes, String preferredSearchScopeType) {
        assert (EventQueue.isDispatchThread());
        String msg = Manager.getInstance().mayStartSearching();
        if (msg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 1));
            return;
        }
        if (!FindInFilesAction.isSomeEnabled(searchScopes)) {
            return;
        }
        boolean replacing = Boolean.TRUE.equals(this.getProperty(REPLACING));
        SearchPanel searchPanel = new SearchPanel(searchScopes, preferredSearchScopeType, replacing);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        SearchScope searchScope = searchPanel.getSearchScope();
        this.storeLastSearchScope(searchScope.getTypeId());
        BasicSearchCriteria basicSearchCriteria = searchPanel.getBasicSearchCriteria();
        ResultView resultView = ResultView.getInstance();
        resultView.open();
        resultView.requestActive();
        Manager.getInstance().scheduleSearchTask(new SearchTask(searchScope, basicSearchCriteria, searchPanel.getCustomizedSearchTypes()));
    }

    private String getLastSearchScope() {
        Object o = this.getProperty(VAR_LAST_SEARCH_SCOPE_TYPE);
        return o instanceof String ? (String)o : null;
    }

    private void storeLastSearchScope(String typeId) {
        this.putProperty(VAR_LAST_SEARCH_SCOPE_TYPE, typeId, false);
    }

    private static boolean isSomeEnabled(Map<SearchScope, Boolean> searchScopes) {
        for (Boolean b : searchScopes.values()) {
            if (!b.booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    private boolean shouldLog(Logger logger) {
        return logger.isLoggable(Level.FINER) && this.shortClassName.equals("FindInFilesAction");
    }

    private void log(String msg) {
        LOG.finer(this.shortClassName + ": " + msg);
    }

    static final class LookupSensitive
    implements Action,
    ChangeListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar {
        private static int counter = 0;
        private final FindInFilesAction delegate;
        private final SearchScopeRegistry searchScopeRegistry;
        private final boolean searchSelection;
        private final int id = ++counter;
        private PropertyChangeSupport support;
        private boolean enabled;
        private final String shortClassName;

        LookupSensitive(FindInFilesAction delegate, Lookup lookup) {
            this(delegate, lookup, false);
        }

        LookupSensitive(FindInFilesAction delegate, Lookup lookup, boolean searchSelection) {
            String clsName = this.getClass().getName();
            int lastDot = clsName.lastIndexOf(46);
            this.shortClassName = (lastDot != -1 ? clsName.substring(lastDot + 1) : clsName).replace('$', '.');
            this.delegate = delegate;
            this.searchScopeRegistry = SearchScopeRegistry.getInstance(lookup, this.id);
            this.searchSelection = searchSelection;
            this.log("<init>");
        }

        private Object getLock() {
            return this;
        }

        @Override
        public Object getValue(String key) {
            if (this.shouldLog(LOG)) {
                this.log("getValue(\"" + key + "\")");
            }
            return this.delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (EventQueue.isDispatchThread());
            if (this.shouldLog(LOG)) {
                this.log("actionPerformed(...)");
            }
            this.delegate.performAction(this.searchScopeRegistry.getSearchScopes(), this.searchSelection ? this.searchScopeRegistry.getNodeSelectionSearchScope().getTypeId() : this.delegate.getLastSearchScope());
        }

        @Override
        public void setEnabled(boolean b) {
            if (this.shouldLog(LOG)) {
                this.log("setEnabled(" + b + ')');
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnabled() {
            assert (EventQueue.isDispatchThread());
            if (this.shouldLog(LOG)) {
                this.log("isEnabled(...)");
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support != null) {
                    return this.enabled;
                }
            }
            return this.searchScopeRegistry.hasApplicableSearchScope();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.shouldLog(LOG)) {
                this.log("addPropertyChangeListener(...)");
            }
            if (listener == null) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support == null) {
                    this.support = new PropertyChangeSupport(this);
                    this.searchScopeRegistry.addChangeListener(this);
                    this.enabled = this.searchScopeRegistry.hasApplicableSearchScope();
                }
                this.support.addPropertyChangeListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this.shouldLog(LOG)) {
                this.log("removePropertyChangeListener(...)");
            }
            if (listener == null) {
                return;
            }
            Object object = this.getLock();
            synchronized (object) {
                boolean lastListener;
                if (this.support == null) {
                    return;
                }
                this.support.removePropertyChangeListener(listener);
                boolean bl = lastListener = !this.support.hasListeners(null);
                if (lastListener) {
                    this.searchScopeRegistry.removeChangeListener(this);
                    this.support = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.shouldLog(LOG)) {
                this.log("stateChanged(...)");
            }
            Object object = this.getLock();
            synchronized (object) {
                if (this.support != null) {
                    boolean wasEnabled = this.enabled;
                    this.enabled = this.searchScopeRegistry.hasApplicableSearchScope();
                    final PropertyChangeEvent newEvent = new PropertyChangeEvent(this, "enabled", wasEnabled, this.enabled);
                    final PropertyChangeListener[] listeners = this.support.getPropertyChangeListeners();
                    Mutex.EVENT.writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            for (PropertyChangeListener l : listeners) {
                                l.propertyChange(newEvent);
                            }
                        }
                    });
                }
            }
        }

        public JMenuItem getMenuPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getMenuPresenter(...)");
            }
            return this.delegate.getMenuPresenter();
        }

        public JMenuItem getPopupPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getPopupPresenter(...)");
            }
            return this.delegate.getPopupPresenter();
        }

        public Component getToolbarPresenter() {
            if (this.shouldLog(LOG)) {
                this.log("getToolbarPresenter(...)");
            }
            return this.delegate.getToolbarPresenter();
        }

        public String toString() {
            return this.shortClassName + " #" + this.id;
        }

        private boolean shouldLog(Logger logger) {
            return logger.isLoggable(Level.FINER) && this.shortClassName.startsWith("FindInFilesAction");
        }

        private void log(String msg) {
            LOG.finer(this + ": " + msg);
        }
    }
}

