/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import org.netbeans.modules.search.FindInFilesAction;
import org.netbeans.modules.search.SearchScopeNodeSelection;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Mutex;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

final class FindActionManager
implements PropertyChangeListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(FindActionManager.class.getName());
    private static final String MAPPED_FIND_ACTION = FindActionManager.class.getName() + " - FindActionImpl";
    private static FindActionManager instance;
    private final FindInFilesAction findAction;
    private final Set<TopComponent> activatedOnWindows = new WeakSet(8);
    private Object findActionMapKey;
    private Class<SearchScopeNodeSelection.LookupSensitive> ssnslsClass;
    private Class<FindInFilesAction.LookupSensitive> fifalsClass;

    private FindActionManager() {
        this.findAction = (FindInFilesAction)SharedClassObject.findObject(FindInFilesAction.class, (boolean)true);
    }

    static FindActionManager getInstance() {
        LOG.finer("getInstance()");
        if (instance == null) {
            instance = new FindActionManager();
        }
        return instance;
    }

    void init() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.writeAccess((Runnable)this);
        this.ssnslsClass = SearchScopeNodeSelection.LookupSensitive.class;
        this.fifalsClass = FindInFilesAction.LookupSensitive.class;
    }

    void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Object>(){

            public Object run() {
                FindActionManager.this.cleanupWindowRegistry();
                return null;
            }
        });
        this.ssnslsClass = null;
        this.fifalsClass = null;
    }

    @Override
    public void run() {
        this.someoneActivated();
    }

    private void cleanupWindowRegistry() {
        Object findActionKey = this.getFindActionMapKey();
        for (TopComponent tc : this.activatedOnWindows) {
            Object origFindActionObj;
            Action origFindAction = null;
            Action currFindAction = null;
            Object origFindActionRef = tc.getClientProperty((Object)MAPPED_FIND_ACTION);
            if (origFindActionRef instanceof Reference && (origFindActionObj = ((Reference)origFindActionRef).get()) instanceof Action) {
                origFindAction = (Action)origFindActionObj;
            }
            if (origFindAction != null) {
                currFindAction = tc.getActionMap().get(findActionKey);
            }
            if (currFindAction != null && currFindAction == origFindAction) {
                tc.getActionMap().put(findActionKey, null);
            } else {
                ErrorManager.getDefault().log(16, "ActionMap mapping of FindAction changed for window " + tc.getName());
            }
            if (origFindActionRef == null) continue;
            tc.putClientProperty((Object)MAPPED_FIND_ACTION, null);
        }
        this.activatedOnWindows.clear();
    }

    private void someoneActivated() {
        TopComponent window = TopComponent.getRegistry().getActivated();
        if (LOG.isLoggable(Level.FINER)) {
            String windowId;
            if (window == null) {
                windowId = "<null>";
            } else {
                String windowName = window.getDisplayName();
                if (windowName == null) {
                    windowName = window.getHtmlDisplayName();
                }
                if (windowName == null) {
                    windowName = window.getName();
                }
                windowName = windowName != null ? '\"' + windowName + '\"' : "<noname>";
                windowId = windowName + '(' + window.getClass().getName() + ')';
            }
            LOG.finer("someoneActivated (" + windowId + ')');
        }
        if (window == null || window instanceof CloneableEditorSupport.Pane) {
            return;
        }
        Object key = this.getFindActionMapKey();
        ActionMap actionMap = window.getActionMap();
        if (actionMap.get(key) == null && this.activatedOnWindows.add(window)) {
            Action a = this.findAction.createContextAwareInstance(window.getLookup(), true);
            actionMap.put(key, a);
            window.putClientProperty((Object)MAPPED_FIND_ACTION, new WeakReference<Action>(a));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("activated".equals(evt.getPropertyName())) {
            this.someoneActivated();
        }
    }

    private Object getFindActionMapKey() {
        if (this.findActionMapKey == null) {
            FindAction systemFindAction = (FindAction)SharedClassObject.findObject(FindAction.class, (boolean)true);
            assert (systemFindAction != null);
            this.findActionMapKey = systemFindAction.getActionMapKey();
        }
        return this.findActionMapKey;
    }
}

