/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ButtonWithExtraInfo;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ListComboBoxModel;
import org.netbeans.modules.search.SearchScope;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openidex.search.SearchHistory;
import org.openidex.search.SearchPattern;

final class BasicSearchForm
extends JPanel
implements ChangeListener,
ItemListener {
    private final BasicSearchCriteria searchCriteria;
    private final Map<SearchScope, Boolean> searchScopes;
    private final String preferredSearchScopeType;
    private SearchScope selectedSearchScope;
    private ChangeListener usabilityChangeListener;
    private ButtonGroup radioBtnGroup;
    private JComboBox cboxTextToFind;
    private JComboBox cboxReplacement;
    private JComboBox cboxFileNamePattern;
    private JCheckBox chkWholeWords;
    private JCheckBox chkCaseSensitive;
    private JCheckBox chkRegexp;
    private JTextComponent textToFindEditor;
    private JTextComponent fileNamePatternEditor;
    private JTextComponent replacementPatternEditor;
    private JLabel lblHintTextToFind;
    private Color errorTextColor;
    private Color defaultTextColor;
    private boolean invalidTextPattern = false;
    private boolean invalidReplacePattern = false;
    private boolean ignoreFileNamePatternChanges = false;

    BasicSearchForm(Map<SearchScope, Boolean> searchScopes, String preferredSearchScopeType, BasicSearchCriteria criteria, boolean searchAndReplace, boolean usePreviousValues) {
        this.searchCriteria = criteria != null ? criteria : new BasicSearchCriteria();
        this.searchScopes = searchScopes;
        this.preferredSearchScopeType = preferredSearchScopeType;
        this.initComponents(searchAndReplace);
        this.initAccessibility();
        this.initHistory();
        this.initInteraction();
        if (searchAndReplace && this.searchCriteria.getReplaceExpr() == null) {
            this.searchCriteria.setReplaceExpr("");
        }
        if (usePreviousValues) {
            this.initPreviousValues();
        } else {
            this.initValuesFromHistory();
        }
        this.updateTextPatternColor();
        if (searchAndReplace) {
            this.updateReplacePatternColor();
        }
    }

    private void initComponents(boolean searchAndReplace) {
        JLabel lblReplacement;
        JLabel lblTextToFind = new JLabel();
        this.cboxTextToFind = new JComboBox();
        lblTextToFind.setLabelFor(this.cboxTextToFind);
        this.lblHintTextToFind = new JLabel();
        this.lblHintTextToFind.setMinimumSize(new Dimension(0, 0));
        if (searchAndReplace) {
            lblReplacement = new JLabel();
            this.cboxReplacement = new JComboBox();
            this.cboxReplacement.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.cbox.Replacement.AccessibleDescription"));
            lblReplacement.setLabelFor(this.cboxReplacement);
        } else {
            lblReplacement = null;
            this.cboxReplacement = null;
        }
        JLabel lblFileNamePattern = new JLabel();
        this.cboxFileNamePattern = new JComboBox();
        lblFileNamePattern.setLabelFor(this.cboxFileNamePattern);
        JLabel lblHintFileNamePattern = new JLabel();
        this.chkWholeWords = new JCheckBox();
        this.chkCaseSensitive = new JCheckBox();
        this.chkRegexp = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)lblTextToFind, (String)this.getText("BasicSearchForm.lblTextToFind.text"));
        this.lblHintTextToFind.setText(this.getText("BasicSearchForm.lblHintTextToFind.text"));
        this.lblHintTextToFind.setForeground(SystemColor.textInactiveText);
        this.cboxTextToFind.setEditable(true);
        if (searchAndReplace) {
            Mnemonics.setLocalizedText((JLabel)lblReplacement, (String)this.getText("BasicSearchForm.lblReplacement.text"));
            this.cboxReplacement.setEditable(true);
        }
        Mnemonics.setLocalizedText((JLabel)lblFileNamePattern, (String)this.getText("BasicSearchForm.lblFileNamePattern.text"));
        lblHintFileNamePattern.setText(this.getText("BasicSearchForm.lblHintFileNamePattern.text"));
        lblHintFileNamePattern.setForeground(SystemColor.textInactiveText);
        this.cboxFileNamePattern.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkWholeWords, (String)this.getText("BasicSearchForm.chkWholeWords.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkCaseSensitive, (String)this.getText("BasicSearchForm.chkCaseSensitive.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.chkRegexp, (String)this.getText("BasicSearchForm.chkRegexp.text"));
        JComponent optionsPanel = this.createButtonsPanel("LBL_OptionsPanelTitle", this.chkWholeWords, this.chkCaseSensitive, this.chkRegexp);
        JComponent scopePanel = this.createButtonsPanel("LBL_ScopePanelTitle", this.createSearchScopeButtons());
        GridLayout lowerPanelLayout = new GridLayout(1, 0);
        JPanel lowerPanel = new JPanel(lowerPanelLayout);
        lowerPanel.add(optionsPanel);
        lowerPanel.add(scopePanel);
        lowerPanelLayout.setHgap(LayoutStyle.getInstance().getPreferredGap(optionsPanel, scopePanel, LayoutStyle.ComponentPlacement.UNRELATED, 3, null));
        GroupLayout criteriaPanelLayout = new GroupLayout(this);
        this.setLayout(criteriaPanelLayout);
        criteriaPanelLayout.setHonorsVisibility(false);
        criteriaPanelLayout.setHorizontalGroup(criteriaPanelLayout.createSequentialGroup().addContainerGap().addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(criteriaPanelLayout.createSequentialGroup().addGroup(BasicSearchForm.createParallelGroup(criteriaPanelLayout, GroupLayout.Alignment.LEADING, lblTextToFind, lblReplacement, lblFileNamePattern)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(BasicSearchForm.createParallelGroup(criteriaPanelLayout, GroupLayout.Alignment.LEADING, lblHintFileNamePattern, this.lblHintTextToFind, this.cboxTextToFind, this.cboxReplacement, this.cboxFileNamePattern))).addComponent(lowerPanel)).addContainerGap());
        GroupLayout.SequentialGroup seqGroup = criteriaPanelLayout.createSequentialGroup();
        seqGroup.addContainerGap().addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblTextToFind).addComponent(this.cboxTextToFind, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHintTextToFind);
        if (this.cboxReplacement != null) {
            seqGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblReplacement).addComponent(this.cboxReplacement, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        }
        seqGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(criteriaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(lblFileNamePattern).addComponent(this.cboxFileNamePattern, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblHintFileNamePattern).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(lowerPanel, -2, -1, -2).addContainerGap();
        criteriaPanelLayout.setVerticalGroup(seqGroup);
        Component cboxEditorComp = this.cboxTextToFind.getEditor().getEditorComponent();
        this.textToFindEditor = (JTextComponent)cboxEditorComp;
        cboxEditorComp = this.cboxFileNamePattern.getEditor().getEditorComponent();
        this.fileNamePatternEditor = (JTextComponent)cboxEditorComp;
        if (this.cboxReplacement != null) {
            cboxEditorComp = this.cboxReplacement.getEditor().getEditorComponent();
            this.replacementPatternEditor = (JTextComponent)cboxEditorComp;
        }
    }

    private static GroupLayout.ParallelGroup createParallelGroup(GroupLayout groupLayout, GroupLayout.Alignment alignment, Component ... components) {
        GroupLayout.ParallelGroup group = groupLayout.createParallelGroup(alignment);
        for (Component c : components) {
            if (c == null) continue;
            if (c.getClass() == JComboBox.class) {
                group.addComponent(c, 0, 300, Short.MAX_VALUE);
                continue;
            }
            group.addComponent(c);
        }
        return group;
    }

    private void initAccessibility() {
        this.chkCaseSensitive.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkCaseSensitive.AccessibleDescription"));
        this.chkRegexp.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkRegexp.AccessibleDescription"));
        this.chkWholeWords.getAccessibleContext().setAccessibleDescription(this.getText("BasicSearchForm.chkWholeWords.AccessibleDescription"));
    }

    private void initPreviousValues() {
        this.cboxTextToFind.setSelectedItem(this.searchCriteria.getTextPatternExpr());
        this.cboxFileNamePattern.setSelectedItem(this.searchCriteria.getFileNamePatternExpr());
        if (this.cboxReplacement != null) {
            this.cboxReplacement.setSelectedItem(this.searchCriteria.getReplaceExpr());
        }
        this.chkWholeWords.setSelected(this.searchCriteria.isWholeWords());
        this.chkCaseSensitive.setSelected(this.searchCriteria.isCaseSensitive());
        this.chkRegexp.setSelected(this.searchCriteria.isRegexp());
    }

    private void initInteraction() {
        TextFieldFocusListener focusListener = new TextFieldFocusListener();
        this.textToFindEditor.addFocusListener(focusListener);
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.addFocusListener(focusListener);
        }
        FileNamePatternWatcher watcher = new FileNamePatternWatcher(this.fileNamePatternEditor);
        this.fileNamePatternEditor.addFocusListener(watcher);
        this.fileNamePatternEditor.addHierarchyListener(watcher);
        class PatternChangeListener
        implements DocumentListener {
            private final JComboBox sourceComboBox;

            PatternChangeListener(JComboBox srcCBox) {
                this.sourceComboBox = srcCBox;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update(e);
            }

            private void update(DocumentEvent e) {
                String text;
                if (this.sourceComboBox == BasicSearchForm.this.cboxFileNamePattern && BasicSearchForm.this.ignoreFileNamePatternChanges) {
                    return;
                }
                Document doc = e.getDocument();
                try {
                    text = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException ex) {
                    assert (false);
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                    text = "";
                }
                if (this.sourceComboBox == BasicSearchForm.this.cboxTextToFind) {
                    BasicSearchForm.this.searchCriteria.setTextPattern(text);
                    BasicSearchForm.this.updateTextPatternColor();
                    if (BasicSearchForm.this.cboxReplacement != null) {
                        BasicSearchForm.this.updateReplacePatternColor();
                    }
                } else if (this.sourceComboBox == BasicSearchForm.this.cboxFileNamePattern) {
                    BasicSearchForm.this.searchCriteria.setFileNamePattern(text);
                } else {
                    assert (this.sourceComboBox == BasicSearchForm.this.cboxReplacement);
                    BasicSearchForm.this.searchCriteria.setReplaceExpr(text);
                    if (BasicSearchForm.this.cboxReplacement != null) {
                        BasicSearchForm.this.updateReplacePatternColor();
                    }
                }
            }
        }
        this.textToFindEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxTextToFind));
        this.fileNamePatternEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxFileNamePattern));
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.getDocument().addDocumentListener(new PatternChangeListener(this.cboxReplacement));
        }
        this.chkRegexp.addItemListener(this);
        this.chkCaseSensitive.addItemListener(this);
        this.chkWholeWords.addItemListener(this);
        boolean regexp = this.chkRegexp.isSelected();
        this.chkWholeWords.setEnabled(!regexp);
        this.searchCriteria.setUsabilityChangeListener(this);
    }

    private void initHistory() {
        FindDialogMemory memory;
        List<String> entries;
        List patterns = SearchHistory.getDefault().getSearchPatterns();
        if (!patterns.isEmpty()) {
            ArrayList<String> itemsList = new ArrayList<String>(patterns.size());
            for (SearchPattern pattern : patterns) {
                String searchExpression = pattern.getSearchExpression();
                if (itemsList.contains(searchExpression)) continue;
                itemsList.add(searchExpression);
            }
            this.cboxTextToFind.setModel(new ListComboBoxModel(itemsList));
        }
        if (!(entries = (memory = FindDialogMemory.getDefault()).getFileNamePatterns()).isEmpty()) {
            this.cboxFileNamePattern.setModel(new ListComboBoxModel(entries, true));
        }
        if (this.cboxReplacement != null && !(entries = memory.getReplacementExpressions()).isEmpty()) {
            this.cboxReplacement.setModel(new ListComboBoxModel(entries, true));
        }
    }

    private void initValuesFromHistory() {
        FindDialogMemory memory = FindDialogMemory.getDefault();
        if (memory.isTextPatternSpecified() && this.cboxTextToFind.getItemCount() != 0) {
            this.cboxTextToFind.setSelectedIndex(0);
        }
        if (memory.isFileNamePatternSpecified() && this.cboxFileNamePattern.getItemCount() != 0) {
            this.cboxFileNamePattern.setSelectedIndex(0);
        }
        if (this.cboxReplacement != null && this.cboxReplacement.getItemCount() != 0) {
            this.cboxReplacement.setSelectedIndex(0);
        }
        this.chkWholeWords.setSelected(memory.isWholeWords());
        this.chkCaseSensitive.setSelected(memory.isCaseSensitive());
        this.chkRegexp.setSelected(memory.isRegularExpression());
    }

    @Override
    public boolean requestFocusInWindow() {
        assert (this.textToFindEditor != null);
        if (this.textToFindEditor.isFocusOwner()) {
            return true;
        }
        int textLength = this.textToFindEditor.getText().length();
        if (textLength > 0) {
            this.textToFindEditor.setCaretPosition(0);
            this.textToFindEditor.moveCaretPosition(textLength);
        }
        return this.textToFindEditor.requestFocusInWindow();
    }

    private void updateTextPatternColor() {
        boolean wasInvalid = this.invalidTextPattern;
        this.invalidTextPattern = this.searchCriteria.isTextPatternInvalid();
        if (this.invalidTextPattern != wasInvalid) {
            if (this.defaultTextColor == null) {
                assert (!wasInvalid);
                this.defaultTextColor = this.textToFindEditor.getForeground();
            }
            this.textToFindEditor.setForeground(this.invalidTextPattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private void updateReplacePatternColor() {
        boolean wasInvalid = this.invalidReplacePattern;
        this.invalidReplacePattern = this.searchCriteria.isReplacePatternInvalid();
        if (this.invalidReplacePattern != wasInvalid) {
            if (this.defaultTextColor == null) {
                assert (!wasInvalid);
                this.defaultTextColor = this.textToFindEditor.getForeground();
            }
            this.replacementPatternEditor.setForeground(this.invalidReplacePattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private static boolean isBackrefSyntaxUsed(String text) {
        int index;
        int len = text.length();
        if (len < 2) {
            return false;
        }
        String textToSearch = text.substring(0, len - 1);
        int startIndex = 0;
        while ((index = textToSearch.indexOf(92, startIndex)) != -1) {
            char c = text.charAt(index + 1);
            if (c == '\\') {
                startIndex = index + 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                return true;
            }
            startIndex = index + 2;
        }
        return false;
    }

    private Color getErrorTextColor() {
        if (this.errorTextColor == null) {
            this.errorTextColor = UIManager.getDefaults().getColor("TextField.errorForeground");
            if (this.errorTextColor == null) {
                this.errorTextColor = Color.RED;
            }
        }
        return this.errorTextColor;
    }

    void setUsabilityChangeListener(ChangeListener l) {
        this.usabilityChangeListener = l;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean selected;
        ItemSelectable toggle = e.getItemSelectable();
        boolean bl = selected = e.getStateChange() == 1;
        if (toggle == this.chkRegexp) {
            this.searchCriteria.setRegexp(selected);
            this.updateTextPatternColor();
            if (this.cboxReplacement != null) {
                this.updateReplacePatternColor();
            }
            this.chkWholeWords.setEnabled(!selected);
            this.lblHintTextToFind.setVisible(!selected);
        } else if (toggle == this.chkCaseSensitive) {
            this.searchCriteria.setCaseSensitive(selected);
        } else if (toggle == this.chkWholeWords) {
            this.searchCriteria.setWholeWords(selected);
        } else assert (false);
    }

    private AbstractButton[] createSearchScopeButtons() {
        this.radioBtnGroup = new ButtonGroup();
        ItemListener buttonStateListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AbstractButton selectedButton = (AbstractButton)e.getSource();
                    Object storedObject = selectedButton.getClientProperty("searchScope");
                    BasicSearchForm.this.selectedSearchScope = (SearchScope)storedObject;
                }
            }
        };
        AbstractButton[] result = new AbstractButton[this.searchScopes.size()];
        int index = 0;
        boolean preferredScopeSelected = false;
        int firstEnabled = -1;
        for (Map.Entry<SearchScope, Boolean> entry : this.orderSearchScopes()) {
            SearchScope searchScope = entry.getKey();
            boolean enabled = entry.getValue();
            String searchScopeInfo = enabled ? searchScope.getAdditionalInfo() : null;
            JRadioButton button = searchScopeInfo == null ? new JRadioButton() : new ButtonWithExtraInfo(searchScopeInfo);
            Mnemonics.setLocalizedText((AbstractButton)button, (String)searchScope.getDisplayName());
            ((Component)button).getAccessibleContext().setAccessibleDescription(searchScope.getDisplayName());
            button.putClientProperty("searchScope", searchScope);
            button.addItemListener(buttonStateListener);
            button.setEnabled(enabled);
            if (enabled) {
                if (searchScope.getTypeId().equals(this.preferredSearchScopeType)) {
                    button.setSelected(true);
                    preferredScopeSelected = true;
                } else if (firstEnabled == -1) {
                    firstEnabled = index;
                }
            }
            result[index++] = button;
            this.radioBtnGroup.add(button);
        }
        if (!preferredScopeSelected && firstEnabled != -1) {
            result[firstEnabled].setSelected(true);
        }
        return result;
    }

    private Collection<Map.Entry<SearchScope, Boolean>> orderSearchScopes() {
        Set<Map.Entry<SearchScope, Boolean>> currentCollection = this.searchScopes.entrySet();
        if (currentCollection.isEmpty() || currentCollection.size() == 1) {
            return currentCollection;
        }
        ArrayList<Map.Entry<SearchScope, Boolean>> newCollection = new ArrayList<Map.Entry<SearchScope, Boolean>>(currentCollection.size());
        Map.Entry firstEntry = null;
        for (Map.Entry entry : currentCollection) {
            if (firstEntry == null) {
                firstEntry = entry;
                continue;
            }
            newCollection.add(entry);
        }
        newCollection.add(firstEntry);
        return newCollection;
    }

    private JComponent createButtonsPanel(String borderTitleBundleKey, AbstractButton ... buttons) {
        JPanel buttonsPanel = new JPanel();
        GroupLayout buttonsPanelLayout = new GroupLayout(buttonsPanel);
        buttonsPanel.setLayout(buttonsPanelLayout);
        GroupLayout.ParallelGroup parallelGroup = buttonsPanelLayout.createParallelGroup();
        for (AbstractButton button : buttons) {
            if (button instanceof ButtonWithExtraInfo) {
                parallelGroup.addComponent(button, -1, -2, Short.MAX_VALUE);
                continue;
            }
            parallelGroup.addComponent(button);
        }
        buttonsPanelLayout.setHorizontalGroup(parallelGroup);
        GroupLayout.SequentialGroup sequentialGroup = buttonsPanelLayout.createSequentialGroup();
        boolean first = true;
        for (AbstractButton button : buttons) {
            if (!first) {
                sequentialGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
            }
            sequentialGroup.addComponent(button);
            first = false;
        }
        buttonsPanelLayout.setVerticalGroup(sequentialGroup);
        buttonsPanelLayout.linkSize(buttons);
        buttonsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.getText(borderTitleBundleKey)), BorderFactory.createEmptyBorder(3, 5, 5, 5)));
        return buttonsPanel;
    }

    void onOk() {
        this.searchCriteria.onOk();
        FindDialogMemory memory = FindDialogMemory.getDefault();
        if (this.searchCriteria.isTextPatternUsable()) {
            SearchHistory.getDefault().add(this.getCurrentSearchPattern());
            memory.setTextPatternSpecified(true);
        } else {
            memory.setTextPatternSpecified(false);
        }
        if (this.searchCriteria.isFileNamePatternUsable()) {
            memory.storeFileNamePattern(this.fileNamePatternEditor.getText());
            memory.setFileNamePatternSpecified(true);
        } else {
            memory.setFileNamePatternSpecified(false);
        }
        if (this.replacementPatternEditor != null) {
            memory.storeReplacementExpression(this.replacementPatternEditor.getText());
        }
        memory.setWholeWords(this.chkWholeWords.isSelected());
        memory.setCaseSensitive(this.chkCaseSensitive.isSelected());
        memory.setRegularExpression(this.chkRegexp.isSelected());
    }

    private SearchPattern getCurrentSearchPattern() {
        return SearchPattern.create((String)this.textToFindEditor.getText(), (boolean)this.chkWholeWords.isSelected(), (boolean)this.chkCaseSensitive.isSelected(), (boolean)this.chkRegexp.isSelected());
    }

    SearchScope getSelectedSearchScope() {
        assert (this.selectedSearchScope != null);
        return this.selectedSearchScope;
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        return this.searchCriteria;
    }

    boolean isUsable() {
        return this.selectedSearchScope != null && this.searchCriteria.isUsable();
    }

    private String getText(String bundleKey) {
        return NbBundle.getMessage(this.getClass(), (String)bundleKey);
    }

    private final class FileNamePatternWatcher
    extends TextFieldFocusListener
    implements HierarchyListener {
        private final Logger watcherLogger;
        private final JTextComponent txtComp;
        private final Document doc;
        private Color foregroundColor;
        private String infoText;
        private boolean infoDisplayed;

        private FileNamePatternWatcher(JTextComponent txtComp) {
            this.watcherLogger = Logger.getLogger("org.netbeans.modules.search.BasicSearchForm.FileNamePatternWatcher");
            this.txtComp = txtComp;
            this.doc = txtComp.getDocument();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (e.getComponent() != this.txtComp || (e.getChangeFlags() & 2L) == 0L || !this.txtComp.isDisplayable()) {
                return;
            }
            this.watcherLogger.finer("componentShown()");
            if (this.foregroundColor == null) {
                this.foregroundColor = this.txtComp.getForeground();
            }
            if (this.doc.getLength() == 0 && !this.txtComp.isFocusOwner()) {
                this.displayInfo();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.infoDisplayed) {
                this.hideInfo();
            }
            super.focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            if (this.isEmptyText()) {
                this.displayInfo();
            }
        }

        private boolean isEmptyText() {
            String text;
            int length = this.doc.getLength();
            if (length == 0) {
                return true;
            }
            try {
                text = this.doc.getText(0, length);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                text = null;
            }
            return text != null && text.trim().length() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayInfo() {
            assert (this.doc.getLength() == 0 && !this.txtComp.isFocusOwner());
            this.watcherLogger.finer("displayInfo()");
            try {
                this.txtComp.setForeground(this.txtComp.getDisabledTextColor());
                BasicSearchForm.this.ignoreFileNamePatternChanges = true;
                this.doc.insertString(0, this.getInfoText(), null);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                BasicSearchForm.this.ignoreFileNamePatternChanges = false;
                this.infoDisplayed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hideInfo() {
            this.watcherLogger.finer("hideInfo()");
            this.txtComp.setEnabled(true);
            try {
                BasicSearchForm.this.ignoreFileNamePatternChanges = true;
                this.doc.remove(0, this.doc.getLength());
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                BasicSearchForm.this.ignoreFileNamePatternChanges = false;
                this.txtComp.setForeground(this.foregroundColor);
                this.infoDisplayed = false;
            }
        }

        private String getInfoText() {
            if (this.infoText == null) {
                this.infoText = NbBundle.getMessage(this.getClass(), (String)"BasicSearchForm.cboxFileNamePattern.allFiles");
            }
            return this.infoText;
        }
    }

    private static class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextComponent textComp;
            if (!e.isTemporary() && (textComp = (JTextComponent)e.getSource()).getText().length() != 0) {
                textComp.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

