/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee.sunas;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.profiler.attach.providers.IDESettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.SettingsPersistor;
import org.netbeans.modules.profiler.attach.providers.ValidationResult;
import org.netbeans.modules.profiler.attach.providers.scripted.AbstractScriptIntegrationProvider;
import org.netbeans.modules.profiler.attach.providers.scripted.ProfilerScriptModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.ScriptModificationException;
import org.netbeans.modules.profiler.attach.providers.scripted.TextScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.providers.scripted.XmlScriptHeaderModifier;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.netbeans.modules.profiler.attach.spi.ModificationException;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.SimpleWizardStep;
import org.netbeans.modules.profiler.j2ee.sunas.SunASIntegrationPanel;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class SunASAutoIntegrationProvider
extends AbstractScriptIntegrationProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.modules.profiler.j2ee.sunas.Bundle");
    private static final String PATH_TO_JVM_DIR_TEXT = messages.getString("SunAS8IntegrationProvider_PathToJvmDirText");
    private static final String MANUAL_REMOTE_STEP3_MSG = messages.getString("SunAS8IntegrationProvider_ManualRemoteStep3Msg");
    private static final String MANUAL_REMOTE_STEP4_50_MSG = messages.getString("SunAS8IntegrationProvider_ManualRemoteStep450Msg");
    private static final String MANUAL_REMOTE_STEP5_MSG = messages.getString("SunAS8IntegrationProvider_ManualRemoteStep5Msg");
    private static final String MANUAL_REMOTE_STEP6_MSG = messages.getString("SunAS8IntegrationProvider_ManualRemoteStep6Msg");
    private static final String MANUAL_REMOTE_STEP7_MSG = messages.getString("SunAS8IntegrationProvider_ManualRemoteStep7Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP1_MSG = messages.getString("SunAS8IntegrationProvider_ManualDirectDynamicStep1Msg");
    private static final String MANUAL_DIRECT_DYNAMIC_STEP2_50_MSG = messages.getString("SunAS8IntegrationProvider_ManualDirectDynamicStep250Msg");
    private static final String MANUAL_DIRECT_STEP3_MSG = messages.getString("SunAS8IntegrationProvider_ManualDirectStep3Msg");
    private static final String MANUAL_DIRECT_STEP4_MSG = messages.getString("SunAS8IntegrationProvider_ManualDirectStep4Msg");
    private static final String MANUAL_DIRECT_STEP5_MSG = messages.getString("SunAS8IntegrationProvider_ManualDirectStep5Msg");
    private static final String MANUAL_DYNAMIC_STEP3_MSG = messages.getString("SunAS8IntegrationProvider_ManualDynamicStep3Msg");
    private static final String INTEGR_REVIEW_STEP1_MSG = messages.getString("SunAS8IntegrationProvider_IntegrReviewStep1Msg");
    private static final String INTEGR_REVIEW_STEP2_MSG = messages.getString("SunAS8IntegrationProvider_IntegrReviewStep2Msg");
    private static final String INTEGR_REVIEW_STEP3_DIRECT_MSG = messages.getString("SunAS8IntegrationProvider_IntegrReviewStep3DirectMsg");
    private static final String INTEGR_REVIEW_STEP3_DYNAMIC_MSG = messages.getString("SunAS8IntegrationProvider_IntegrReviewStep3DynamicMsg");
    private static final String RESTORE_SETTINGS_WARNING_MSG = messages.getString("SunAS8IntegrationProvider_RestoreSettingsWarningMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DIRECT_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsStep1DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsStep1DynamicMsg");
    private static final String ADDITIONAL_STEPS_STEP2_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsStep2Msg");
    private static final String ADDITIONAL_STEPS_STEP3_DIRECT_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsStep3DirectMsg");
    private static final String ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsStep3DynamicPidMsg");
    private static final String ADDITIONAL_STEPS_AUTO_START_MSG = messages.getString("SunAS8IntegrationProvider_AdditionalStepsAutoStartMsg");
    private static final String ENTER_INSTALL_DIR_MSG = messages.getString("SunAS8IntegrationProvider_EnterInstallDirMsg");
    private static final String INVALID_INSTALL_DIR_MSG = messages.getString("SunAS8IntegrationProvider_InvalidInstallDirMsg");
    private static final String DYNAMIC_WARNING_MESSAGE = messages.getString("SunASIntegrationProvider_DynamicWarningMessage");
    private static final String SUNAS_INSTALL_VAR_STRING = "AS_INSTALL";
    private static final String SUNAS_HOME_VAR_STRING = "AS_HOME";
    private static final String SUNAS_8PE_BINDIR_NAME = "bin";
    private static final String SUNAS_8PE_ASADMINSCRIPT_NAME = "asadmin";
    private static final String SUNAS_8PE_CONFIGDIR_NAME = "config";
    private static final String SUNAS_8PE_ASENVSCRIPT_NAME = "asenv";
    private static final String SUNAS_8PE_DOMAINSDIR_NAME = "domains";
    private static final String SUNAS_8PE_DOMAINCONFIGDIR_NAME = "config";
    private static final String SUNAS_8PE_DOMAINSCRIPT_NAME = "domain.xml";
    private static final String ASENV_INSERTION_POINT_WIN_0_STRING = "set AS_JAVA";
    private static final String ASENV_INSERTION_POINT_NOWIN_0_STRING = "AS_JAVA";
    private SettingsPersistor persistor;
    private String appserverDomain = "";
    private String scriptPublicId = "";
    private String scriptSystemId = "";

    public SunASAutoIntegrationProvider() {
        this.attachedWizard = new SimpleWizardStep(NbBundle.getMessage(SunASAutoIntegrationProvider.class, (String)"AttachWizard_LocateRequiredFilesString"), (WizardScreen)new SunASIntegrationPanel());
        this.persistor = new IDESettingsPersistor(){

            protected String getSettingsFileName() {
                return "SunAS8IntegrationProvider.properties";
            }

            protected void parsePersistableSettings(Properties settings) {
                SunASAutoIntegrationProvider.this.setTargetJava(settings.getProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", ""));
                SunASAutoIntegrationProvider.this.setInstallationPath(settings.getProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_InstallDir", ""));
                SunASAutoIntegrationProvider.this.setDomain(settings.getProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_DomainName", ""));
                if (SunASAutoIntegrationProvider.this.getInstallationPath() == null || SunASAutoIntegrationProvider.this.getInstallationPath().length() == 0) {
                    SunASAutoIntegrationProvider.this.setInstallationPath(SunASAutoIntegrationProvider.this.getDefaultInstallationPath());
                }
            }

            protected Properties preparePersistableSettings() {
                Properties settings = new Properties();
                settings.setProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_JavaPlatform", SunASAutoIntegrationProvider.this.getTargetJava());
                settings.setProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_InstallDir", SunASAutoIntegrationProvider.this.getInstallationPath());
                settings.setProperty("SunAS8IntegrationProvider_" + SunASAutoIntegrationProvider.this.getMagicNumber() + "_DomainName", SunASAutoIntegrationProvider.this.getDomain());
                return settings;
            }
        };
    }

    public IntegrationProvider.IntegrationHints getAfterInstallationHints(AttachSettings attachSettings, boolean automation) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        if (attachSettings.isDirect()) {
            instructions.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DIRECT_MSG, this.getAsAdminScriptFilePath(targetOS) + " start-domain --domaindir " + this.getInstallationPath() + IntegrationUtils.getDirectorySeparator((String)targetOS) + SUNAS_8PE_DOMAINSDIR_NAME + " " + this.getDomain()));
        } else {
            instructions.addStep(MessageFormat.format(ADDITIONAL_STEPS_STEP1_DYNAMIC_MSG, this.getAsAdminScriptFilePath(targetOS) + " start-domain --domaindir " + this.getInstallationPath() + IntegrationUtils.getDirectorySeparator((String)targetOS) + SUNAS_8PE_DOMAINSDIR_NAME + " " + this.getDomain(), ""));
        }
        instructions.addStep(ADDITIONAL_STEPS_STEP2_MSG);
        if (attachSettings.isDirect()) {
            instructions.addStep(ADDITIONAL_STEPS_STEP3_DIRECT_MSG);
        } else {
            instructions.addStep(ADDITIONAL_STEPS_STEP3_DYNAMIC_PID_MSG);
            instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        }
        instructions.addWarning(MessageFormat.format(RESTORE_SETTINGS_WARNING_MSG, this.getAsEnvScriptFileName(targetOS), SUNAS_8PE_DOMAINSCRIPT_NAME));
        instructions.addHint(ADDITIONAL_STEPS_AUTO_START_MSG);
        return instructions;
    }

    public final Collection getAvailableDomains(String installPath) {
        File[] domains;
        String separator = System.getProperty("file.separator");
        StringBuffer path = new StringBuffer();
        Vector<String> availableDomains = new Vector<String>();
        path.append(installPath);
        if (!installPath.endsWith(separator)) {
            path.append(separator);
        }
        path.append(SUNAS_8PE_DOMAINSDIR_NAME);
        File domainsDir = new File(path.toString());
        if (domainsDir.exists() && (domains = domainsDir.listFiles()) != null && domains.length != 0) {
            for (int i = 0; i < domains.length; ++i) {
                StringBuffer configPath = new StringBuffer(domains[i].getAbsolutePath());
                configPath.append(separator).append("config").append(separator).append(SUNAS_8PE_DOMAINSCRIPT_NAME);
                if (!domains[i].isDirectory() || !new File(configPath.toString()).exists()) continue;
                availableDomains.add(domains[i].getName());
            }
        }
        return availableDomains;
    }

    public void setDomain(String domain) {
        this.appserverDomain = domain;
    }

    public String getDomain() {
        return this.appserverDomain;
    }

    public String getDomainScriptDirPath(AttachSettings attachSettings) {
        String targetOS = attachSettings.getHostOS();
        return this.getDomainScriptDirPath(targetOS);
    }

    public IntegrationProvider.IntegrationHints getIntegrationReview(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        String targetOS = attachSettings.getHostOS();
        instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP1_MSG, this.getAsEnvScriptFilePath(targetOS), this.getDomainScriptFilePath(targetOS), this.getAsEnvScriptFileName(targetOS), SUNAS_8PE_DOMAINSCRIPT_NAME));
        instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP2_MSG, this.getAsEnvScriptFileName(targetOS), (IntegrationUtils.isWindowsPlatform((String)targetOS) ? ASENV_INSERTION_POINT_WIN_0_STRING : ASENV_INSERTION_POINT_NOWIN_0_STRING) + "=\"" + this.getTargetJavaHome() + "\""));
        if (attachSettings.isDirect()) {
            instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP3_DIRECT_MSG, SUNAS_8PE_DOMAINSCRIPT_NAME, "", this.getProfilerAgentCommandLineArgsForDomainScript(targetOS, attachSettings.isRemote(), attachSettings.getPort())));
        } else {
            instructions.addStep(MessageFormat.format(INTEGR_REVIEW_STEP3_DYNAMIC_MSG, SUNAS_8PE_DOMAINSCRIPT_NAME));
        }
        instructions.addWarning(MessageFormat.format(RESTORE_SETTINGS_WARNING_MSG, this.getAsEnvScriptFileName(targetOS), SUNAS_8PE_DOMAINSCRIPT_NAME));
        return instructions;
    }

    public IntegrationProvider.IntegrationHints getModificationHints(AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints hints = null;
        hints = attachSettings.isRemote() ? this.getManualRemoteIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings) : (attachSettings.isDirect() ? this.getManualLocalDirectIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings) : this.getManualLocalDynamicIntegrationStepsInstructions(attachSettings.getHostOS(), attachSettings));
        return hints;
    }

    public SettingsPersistor getSettingsPersistor() {
        return this.persistor;
    }

    public void modify(AttachSettings attachSettings) throws ModificationException {
        String targetOS = attachSettings.getHostOS();
        try {
            this.modifyAsEnvScriptFile(targetOS, attachSettings);
            super.modify(attachSettings);
        }
        catch (ScriptModificationException e) {
            throw new ModificationException((Throwable)e);
        }
    }

    public ValidationResult validateInstallation(String targetOS, String path) {
        if (path == null || path.length() == 0 || !new File(path).exists()) {
            return new ValidationResult(false, MessageFormat.format(ENTER_INSTALL_DIR_MSG, this.getTitle()));
        }
        String asenv = SunASAutoIntegrationProvider.getAsScriptFilePath(path, "config", this.getAsEnvScriptFileName(targetOS), targetOS);
        if (!new File(asenv).exists()) {
            return new ValidationResult(false, MessageFormat.format(INVALID_INSTALL_DIR_MSG, this.getTitle(), this.getAsEnvScriptFileName(targetOS)));
        }
        return new ValidationResult(true);
    }

    protected boolean isBackupRequired() {
        return true;
    }

    protected String getDefaultScriptEncoding() {
        return "UTF-8";
    }

    protected ScriptHeaderModifier getHeaderModifier(String targetOS) {
        XmlScriptHeaderModifier modifier = new XmlScriptHeaderModifier(){
            private static final String PROFILER_LINE = "<profiler enabled=\"true\" name=\"NetBeansProfiler\">";
            private boolean needsProfilerLine = true;

            public void lineRead(StringBuffer line) {
                super.lineRead(line);
                if (this.needsProfilerLine && line.indexOf(PROFILER_LINE) != -1) {
                    this.needsProfilerLine = false;
                }
            }

            protected boolean needsWritingHeaders() {
                return super.needsWritingHeaders() || this.needsProfilerLine;
            }
        };
        modifier.setOptionalHeaders(new String[]{IntegrationUtils.ORIGINAL_BACKUP_LOCATION_STRING, ""});
        return modifier;
    }

    protected abstract int getMagicNumber();

    protected IntegrationProvider.IntegrationHints getManualLocalDirectIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, this.getAsEnvScriptFileName(targetOS), IntegrationUtils.getEnvVariableReference((String)SUNAS_INSTALL_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP2_50_MSG, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), this.getAsEnvScriptFileName(targetOS), IntegrationUtils.isWindowsPlatform((String)targetOS) ? IntegrationUtils.getExportCommandString((String)targetOS) + " AS_JAVA=" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) : "AS_JAVA=\"" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) + "\"", this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)SUNAS_INSTALL_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS)));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP4_MSG, "", this.getProfilerAgentCommandLineArgsForDomainScript(targetOS, attachSettings.isRemote(), attachSettings.getPort())));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_STEP5_MSG, IntegrationUtils.getEnvVariableReference((String)SUNAS_INSTALL_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS)));
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualLocalDynamicIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP1_MSG, this.getAsEnvScriptFileName(targetOS), IntegrationUtils.getEnvVariableReference((String)SUNAS_INSTALL_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_DIRECT_DYNAMIC_STEP2_50_MSG, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), this.getAsEnvScriptFileName(targetOS), IntegrationUtils.isWindowsPlatform((String)targetOS) ? IntegrationUtils.getExportCommandString((String)targetOS) + " AS_JAVA=" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) : "AS_JAVA=\"" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) + "\"", this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_DYNAMIC_STEP3_MSG, IntegrationUtils.getEnvVariableReference((String)SUNAS_INSTALL_VAR_STRING, (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS)));
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        instructions.addWarning(MessageFormat.format(DYNAMIC_WARNING_MESSAGE, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), IntegrationUtils.getProfilerAgentCommandLineArgs((String)targetOS, (String)this.getTargetJava(), (boolean)attachSettings.isRemote(), (int)attachSettings.getPort())));
        return instructions;
    }

    protected IntegrationProvider.IntegrationHints getManualRemoteIntegrationStepsInstructions(String targetOS, AttachSettings attachSettings) {
        IntegrationProvider.IntegrationHints instructions = new IntegrationProvider.IntegrationHints();
        instructions.addStep(this.getManualRemoteStep1(targetOS));
        instructions.addStep(this.getManualRemoteStep2(targetOS));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP3_MSG, this.getAsEnvScriptFileName(targetOS), IntegrationUtils.getEnvVariableReference((String)"REMOTE_AS_INSTALL", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS), this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP4_50_MSG, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava()), this.getAsEnvScriptFileName(targetOS), IntegrationUtils.isWindowsPlatform((String)targetOS) ? IntegrationUtils.getExportCommandString((String)targetOS) + " AS_JAVA=" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) : "AS_JAVA=\"" + MessageFormat.format(PATH_TO_JVM_DIR_TEXT, IntegrationUtils.getJavaPlatformName((String)this.getTargetJava())) + "\"", this.getTitle()));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP5_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_AS_INSTALL", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS)));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP6_MSG, "", this.getProfilerAgentCommandLineArgsForDomainScript(targetOS, attachSettings.isRemote(), attachSettings.getPort()), IntegrationUtils.getRemoteAbsolutePathHint()));
        instructions.addStep(MessageFormat.format(MANUAL_REMOTE_STEP7_MSG, IntegrationUtils.getEnvVariableReference((String)"REMOTE_AS_INSTALL", (String)targetOS), IntegrationUtils.getDirectorySeparator((String)targetOS)));
        instructions.addHint(this.REDUCE_OVERHEAD_MSG);
        return instructions;
    }

    protected String getModifiedScriptPath(String targetOS, boolean quoted) {
        return this.getScriptPath(targetOS, quoted);
    }

    protected String getScriptPath(String targetOS, boolean quoted) {
        StringBuffer path = new StringBuffer();
        path.append(this.getDomainScriptFilePath(targetOS));
        if (quoted) {
            path.insert(0, "\"");
            path.append("\"");
        }
        return path.toString();
    }

    protected abstract String getWinSpecificCommandLineArgs(String var1, boolean var2, int var3);

    protected void generateCommands(String targetOS, Collection commandsArray) {
        String asadminScript = this.getAsAdminScriptFilePath(targetOS);
        String domainsDir = this.getInstallationPath() + IntegrationUtils.getDirectorySeparator((String)targetOS) + SUNAS_8PE_DOMAINSDIR_NAME;
        String domainName = this.getDomain();
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            commandsArray.add("call");
            commandsArray.add(asadminScript);
            commandsArray.add("start-domain");
            commandsArray.add("--verbose");
            commandsArray.add("--domaindir");
            commandsArray.add(domainsDir);
            commandsArray.add(domainName);
        } else {
            commandsArray.add(asadminScript);
            commandsArray.add("start-domain");
            commandsArray.add("--verbose");
            commandsArray.add("--domaindir");
            commandsArray.add(domainsDir);
            commandsArray.add(domainName);
        }
    }

    protected void modifyScriptFileForDirectAttach(String targetOS, int commPort, boolean isReplaceFile, StringBuffer buffer) {
        Document domainScriptDocument = this.loadDomainScriptFile(buffer);
        if (domainScriptDocument == null) {
            return;
        }
        NodeList profilerElementNodeList = domainScriptDocument.getElementsByTagName("profiler");
        if (profilerElementNodeList != null && profilerElementNodeList.getLength() > 0) {
            while (profilerElementNodeList.getLength() > 0) {
                profilerElementNodeList.item(0).getParentNode().removeChild(profilerElementNodeList.item(0));
            }
        }
        Element profilerElement = domainScriptDocument.createElement("profiler");
        profilerElement.setAttribute("enabled", "true");
        profilerElement.setAttribute("name", "NetBeansProfiler");
        Element jvmOptionsElement = domainScriptDocument.createElement("jvm-options");
        String jvmOptionsElementTextContent = this.getProfilerAgentCommandLineArgsForDomainScript(targetOS, false, commPort);
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            jvmOptionsElementTextContent = jvmOptionsElementTextContent + " -Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true";
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            jvmOptionsElementTextContent = jvmOptionsElementTextContent + " -Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true";
        }
        jvmOptionsElement.setTextContent(jvmOptionsElementTextContent);
        profilerElement.appendChild(jvmOptionsElement);
        NodeList javaConfigNodeList = domainScriptDocument.getElementsByTagName("java-config");
        if (javaConfigNodeList == null || javaConfigNodeList.getLength() == 0) {
            return;
        }
        Node javaConfigNode = javaConfigNodeList.item(0);
        if (javaConfigNode.getFirstChild() != null) {
            javaConfigNode.insertBefore(profilerElement, javaConfigNode.getFirstChild());
        } else {
            javaConfigNode.appendChild(profilerElement);
        }
        this.saveDomainScriptFile(domainScriptDocument, buffer);
    }

    protected void modifyScriptFileForDynamicAttach(String hostOS, int port, boolean isReplaceFile, StringBuffer buffer) {
        Document domainScriptDocument = this.loadDomainScriptFile(buffer);
        if (domainScriptDocument == null) {
            return;
        }
        NodeList profilerElementNodeList = domainScriptDocument.getElementsByTagName("profiler");
        if (profilerElementNodeList != null && profilerElementNodeList.getLength() > 0) {
            while (profilerElementNodeList.getLength() > 0) {
                profilerElementNodeList.item(0).getParentNode().removeChild(profilerElementNodeList.item(0));
            }
        }
        this.saveDomainScriptFile(domainScriptDocument, buffer);
    }

    private static String getAsScriptFilePath(String installDir, String specDir, String scriptName, String targetOS) {
        String separator = System.getProperty("file.separator");
        StringBuffer path = new StringBuffer();
        path.append(installDir);
        if (!installDir.endsWith(separator)) {
            path.append(separator);
        }
        path.append(specDir).append(separator).append(scriptName);
        return path.toString();
    }

    private String getAsAdminScriptFileName(String targetOS) {
        return this.getAsScriptFile(SUNAS_8PE_ASADMINSCRIPT_NAME, targetOS);
    }

    private String getAsAdminScriptFilePath(String targetOS) {
        return this.getAsScriptFilePath(SUNAS_8PE_BINDIR_NAME, this.getAsAdminScriptFileName(targetOS), targetOS);
    }

    private String getAsEnvScriptFileName(String targetOS) {
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            return "asenv.bat";
        }
        return "asenv.conf";
    }

    private String getAsEnvScriptFilePath(String targetOS) {
        return this.getAsScriptFilePath("config", this.getAsEnvScriptFileName(targetOS), targetOS);
    }

    private String getAsScriptFile(String scriptName, String targetOS) {
        if (IntegrationUtils.isWindowsPlatform((String)targetOS)) {
            return scriptName + ".bat";
        }
        return scriptName + "";
    }

    private String getAsScriptFilePath(String specDir, String scriptName, String targetOS) {
        return SunASAutoIntegrationProvider.getAsScriptFilePath(this.getInstallationPath(), specDir, scriptName, targetOS);
    }

    private String getDefaultInstallationPath() {
        String home = "";
        try {
            String homeEnv = System.getenv(SUNAS_INSTALL_VAR_STRING);
            if (homeEnv != null && homeEnv.length() > 1) {
                File homeDir = new File(homeEnv);
                if (homeDir.exists() && homeDir.isDirectory()) {
                    home = homeEnv;
                }
            } else {
                File homeDir;
                homeEnv = System.getenv(SUNAS_HOME_VAR_STRING);
                if (homeEnv != null && homeEnv.length() > 1 && (homeDir = new File(homeEnv)).exists() && homeDir.isDirectory()) {
                    home = homeEnv;
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return home;
    }

    private String getDomainScriptDirPath(String targetOS) {
        String separator = IntegrationUtils.getDirectorySeparator((String)targetOS);
        StringBuffer path = new StringBuffer();
        path.append(this.getInstallationPath());
        if (!this.getInstallationPath().endsWith(separator)) {
            path.append(separator);
        }
        path.append(SUNAS_8PE_DOMAINSDIR_NAME).append(separator).append(this.getDomain());
        path.append(separator).append("config");
        return path.toString();
    }

    private String getDomainScriptFilePath(String targetOS) {
        String separator = System.getProperty("file.separator");
        StringBuffer path = new StringBuffer();
        path.append(this.getDomainScriptDirPath(targetOS)).append(separator).append(SUNAS_8PE_DOMAINSCRIPT_NAME);
        return path.toString();
    }

    private String getProfilerAgentCommandLineArgsForDomainScript(String targetOS, boolean isRemote, int portNumber) {
        if (!IntegrationUtils.isWindowsPlatform((String)targetOS) || IntegrationUtils.getNativeLibrariesPath((String)targetOS, (String)this.getTargetJava(), (boolean)isRemote).indexOf(32) == -1) {
            return IntegrationUtils.getProfilerAgentCommandLineArgsWithoutQuotes((String)targetOS, (String)this.getTargetJava(), (boolean)isRemote, (int)portNumber);
        }
        return this.getWinSpecificCommandLineArgs(targetOS, isRemote, portNumber);
    }

    private Document loadDomainScriptFile(StringBuffer scriptBuffer) {
        Document document = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    StringReader reader = new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    InputSource source = new InputSource(reader);
                    SunASAutoIntegrationProvider.this.scriptPublicId = publicId;
                    SunASAutoIntegrationProvider.this.scriptSystemId = systemId;
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
            });
            StringReader scriptReader = new StringReader(scriptBuffer.toString());
            InputSource scriptSource = new InputSource(scriptReader);
            document = dBuilder.parse(scriptSource);
            return document;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void modifyAsEnvScriptFile(String targetOS, AttachSettings attachSettings) throws ScriptModificationException {
        final String asJavaString = IntegrationUtils.isWindowsPlatform((String)targetOS) ? ASENV_INSERTION_POINT_WIN_0_STRING : ASENV_INSERTION_POINT_NOWIN_0_STRING;
        this.modifyScript(this.getAsEnvScriptFilePath(targetOS), new ProfilerScriptModifier((ScriptHeaderModifier)new TextScriptHeaderModifier(IntegrationUtils.getSilentScriptCommentSign((String)targetOS))){
            boolean insertionFound;
            int insertionIndex;
            {
                super(x0);
                this.insertionFound = false;
                this.insertionIndex = -1;
            }

            public void onModification(AttachSettings attachSettings, String lineBreak, StringBuffer scriptBuffer) throws ScriptModificationException {
            }

            public void onLineRead(StringBuffer line) throws ScriptModificationException {
                if (line.toString().trim().startsWith(asJavaString)) {
                    line.delete(0, line.length());
                    line.append(asJavaString).append("=").append(SunASAutoIntegrationProvider.this.getTargetJavaHome());
                }
            }
        }, attachSettings);
    }

    private void saveDomainScriptFile(Document domainScriptDocument, StringBuffer scriptBuffer) {
        try {
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("doctype-public", this.scriptPublicId);
            transformer.setOutputProperty("doctype-system", this.scriptSystemId);
            transformer.setOutputProperty("omit-xml-declaration", "no");
            DOMSource domSource = new DOMSource(domainScriptDocument);
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(domSource, streamResult);
            if (stringWriter.getBuffer().length() > 0) {
                scriptBuffer.delete(0, scriptBuffer.length());
                scriptBuffer.append(stringWriter.getBuffer());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

