/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.javascript.debugger.ant;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.client.tools.api.JSToNbJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.LocationMappersFactory;
import org.netbeans.modules.web.client.tools.api.NbJSToJSLocationMapper;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class NbJsDebugStart
extends Task {
    private String webUrl;
    private String urlPart;

    public String getUrlPart() {
        return this.urlPart;
    }

    public void setUrlPart(String urlPart) {
        this.urlPart = urlPart;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public void execute() throws BuildException {
        if (this.webUrl == null) {
            throw new BuildException("The weburl attribute must be set to the client URL");
        }
        try {
            FileObject projectDir = FileUtil.toFileObject((File)this.getProject().getBaseDir());
            projectDir.refresh();
            Project nbProject = FileOwnerQuery.getOwner((FileObject)projectDir);
            WebModule wm = WebModule.getWebModule((FileObject)projectDir);
            FileObject projectDocBase = wm.getDocumentBase();
            WebApp app = DDProvider.getDefault().getDDRoot(wm.getDeploymentDescriptor());
            WelcomeFileList list = app.getSingleWelcomeFileList();
            String[] welcomeFiles = list != null ? list.getWelcomeFile() : null;
            String welcomeFile = null;
            if (welcomeFiles != null && welcomeFiles.length > 0) {
                welcomeFile = welcomeFiles[0];
            }
            String serverPrefix = this.getWebBaseUrl();
            LocationMappersFactory mapperFactory = (LocationMappersFactory)Lookup.getDefault().lookup(LocationMappersFactory.class);
            Lookup debuggerLookup = null;
            if (mapperFactory != null) {
                URI appContext = new URI(serverPrefix);
                HashMap<String, String> extendedInfo = null;
                if (welcomeFile != null) {
                    extendedInfo = new HashMap<String, String>();
                    extendedInfo.put("welcome-file", welcomeFile);
                }
                JSToNbJSLocationMapper forwardMapper = mapperFactory.getJSToNbJSLocationMapper(projectDocBase, appContext, extendedInfo);
                NbJSToJSLocationMapper reverseMapper = mapperFactory.getNbJSToJSLocationMapper(projectDocBase, appContext, extendedInfo);
                debuggerLookup = Lookups.fixed((Object[])new Object[]{forwardMapper, reverseMapper, nbProject});
            } else {
                debuggerLookup = Lookups.fixed((Object[])new Object[]{nbProject});
            }
            this.log("Project document base: " + FileUtil.getFileDisplayName((FileObject)projectDocBase));
            this.log("Server document base: " + this.getWebBaseUrl());
            this.log("Client URL: " + this.webUrl);
            URI clientUrl = new URI(this.webUrl);
            HtmlBrowser.Factory browser = null;
            browser = WebClientToolsProjectUtils.isInternetExplorer((Project)nbProject) ? WebClientToolsProjectUtils.getInternetExplorerBrowser() : WebClientToolsProjectUtils.getFirefoxBrowser();
            if (browser == null) {
                throw new BuildException("The configured debugging browser could not be found");
            }
            WebClientToolsSessionStarterService.startSession((URI)clientUrl, (HtmlBrowser.Factory)browser, (Lookup)debuggerLookup);
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private String getWebBaseUrl() {
        int partition;
        String clientBaseUrl = this.urlPart != null && this.urlPart.length() > 0 ? ((partition = this.webUrl.lastIndexOf(this.urlPart)) > 0 ? this.webUrl.substring(0, partition + 1) : this.webUrl) : this.webUrl;
        return clientBaseUrl;
    }
}

