/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.widget.Widget;

public class TableLayout
implements Layout {
    private int columnCount;
    private int hgap;
    private int vgap;
    private int minColumnWidth;

    public TableLayout(int columnCount, int hgap, int vgap, int minColumnWidth) {
        this.minColumnWidth = minColumnWidth;
        this.columnCount = columnCount;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public void layout(Widget widget) {
        List children = widget.getChildren();
        int width = (this.minColumnWidth + this.hgap) * this.columnCount - this.hgap;
        int y = 0;
        for (int i = 0; i < children.size(); i += this.columnCount) {
            int rowHeight = 0;
            for (int j = 0; j < this.columnCount; ++j) {
                Widget w = (Widget)children.get(i + j);
                Rectangle b = w.getPreferredBounds();
                rowHeight = Math.max(rowHeight, b.height);
            }
            int x = 0;
            for (int j = 0; j < this.columnCount; ++j) {
                Widget w = (Widget)children.get(i + j);
                Rectangle b = w.getPreferredBounds();
                b.height = rowHeight;
                b.width = this.minColumnWidth;
                w.resolveBounds(new Point(x - b.x, y - b.y), b);
                x += this.minColumnWidth + this.hgap;
            }
            y += rowHeight + this.vgap;
        }
    }

    public boolean requiresJustification(Widget widget) {
        return true;
    }

    public void justify(Widget widget) {
        Rectangle bounds = widget.getClientArea();
        int y0 = bounds.y;
        List children = widget.getChildren();
        for (int i = 0; i < children.size(); i += this.columnCount) {
            int rowHeight = 0;
            for (int j = 0; j < this.columnCount; ++j) {
                Widget w = (Widget)children.get(i + j);
                Rectangle b = w.getBounds();
                rowHeight = Math.max(rowHeight, b.height);
            }
            int x0 = bounds.x;
            int width = bounds.width;
            for (int j = 0; j < this.columnCount; ++j) {
                int columnWidth;
                Widget w = (Widget)children.get(i + j);
                Rectangle b = w.getBounds();
                b.width = columnWidth = (width - this.hgap * (this.columnCount - 1 - j)) / (this.columnCount - j);
                b.height = rowHeight;
                w.resolveBounds(new Point(x0 - b.x, y0 - b.y), b);
                width -= columnWidth + this.hgap;
                x0 += columnWidth + this.hgap;
            }
            y0 += rowHeight + this.vgap;
        }
    }
}

