/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepositoryManager
implements IRepositoryManager {
    public static final String OLD_REPOSITORIES_FILE = "repositories.xml";
    public static final String DEFAULT_REPOSITORIES_FILE = "repositories.xml.zip";
    public static final String PREF_REPOSITORIES = "org.eclipse.mylyn.tasklist.repositories.";
    private final Map<String, AbstractRepositoryConnector> repositoryConnectors = new HashMap<String, AbstractRepositoryConnector>();
    private final Map<String, Set<TaskRepository>> repositoryMap = new HashMap<String, Set<TaskRepository>>();
    private final Set<IRepositoryListener> listeners = new CopyOnWriteArraySet<IRepositoryListener>();
    private final Set<TaskRepository> orphanedRepositories = new HashSet<TaskRepository>();
    public static final String MESSAGE_NO_REPOSITORY = Messages.TaskRepositoryManager_No_repository_available;
    public static final String PREFIX_LOCAL = "local-";
    private final PropertyChangeListener PROPERTY_CHANGE_LISTENER = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            TaskRepositoryManager.this.notifyRepositorySettingsChanged((TaskRepository)((Object)evt.getSource()), new TaskRepositoryDelta(TaskRepositoryDelta.Type.PROPERTY, evt.getPropertyName()));
        }
    };
    private final TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();

    @Override
    public Collection<AbstractRepositoryConnector> getRepositoryConnectors() {
        return Collections.unmodifiableCollection(this.repositoryConnectors.values());
    }

    @Override
    public AbstractRepositoryConnector getRepositoryConnector(String connectorKind) {
        return this.repositoryConnectors.get(connectorKind);
    }

    public AbstractRepositoryConnector removeRepositoryConnector(String connectorKind) {
        return this.repositoryConnectors.remove(connectorKind);
    }

    public void addRepositoryConnector(AbstractRepositoryConnector repositoryConnector) {
        if (!this.repositoryConnectors.values().contains(repositoryConnector)) {
            this.repositoryConnectors.put(repositoryConnector.getConnectorKind(), repositoryConnector);
        }
    }

    public boolean hasUserManagedRepositoryConnectors() {
        for (AbstractRepositoryConnector connector : this.repositoryConnectors.values()) {
            if (!connector.isUserManaged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addRepository(final TaskRepository repository) {
        Set<Object> repositories;
        if (!this.repositoryMap.containsKey(repository.getConnectorKind())) {
            repositories = new HashSet();
            this.repositoryMap.put(repository.getConnectorKind(), repositories);
        } else {
            repositories = this.repositoryMap.get(repository.getConnectorKind());
        }
        repositories.add((Object)repository);
        repository.addChangeListener(this.PROPERTY_CHANGE_LISTENER);
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    listener.repositoryAdded(repository);
                }
            });
        }
    }

    @Deprecated
    public void removeRepository(TaskRepository repository, String repositoryFilePath) {
        this.removeRepository(repository);
    }

    public void removeRepository(final TaskRepository repository) {
        Set<TaskRepository> repositories = this.repositoryMap.get(repository.getConnectorKind());
        if (repositories != null) {
            repository.flushAuthenticationCredentials();
            repositories.remove((Object)repository);
        }
        repository.removeChangeListener(this.PROPERTY_CHANGE_LISTENER);
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    listener.repositoryRemoved(repository);
                }
            });
        }
    }

    @Override
    public void addListener(IRepositoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public static String stripSlashes(String url) {
        Assert.isNotNull((Object)url);
        StringBuilder sb = new StringBuilder(url.trim());
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public TaskRepository getRepository(String kind, String urlString) {
        Assert.isNotNull((Object)kind);
        Assert.isNotNull((Object)urlString);
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        if (this.repositoryMap.containsKey(kind)) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!TaskRepositoryManager.stripSlashes(repository.getRepositoryUrl()).equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public TaskRepository getRepository(String urlString) {
        Assert.isNotNull((Object)urlString);
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        for (String kind : this.repositoryMap.keySet()) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!TaskRepositoryManager.stripSlashes(repository.getRepositoryUrl()).equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public AbstractRepositoryConnector getConnectorForRepositoryTaskUrl(String url) {
        Assert.isNotNull((Object)url);
        for (AbstractRepositoryConnector connector : this.getRepositoryConnectors()) {
            if (connector.getRepositoryUrlFromTaskUrl(url) == null) continue;
            for (TaskRepository repository : this.getRepositories(connector.getConnectorKind())) {
                if (!url.startsWith(repository.getRepositoryUrl())) continue;
                return connector;
            }
        }
        return null;
    }

    @Override
    public Set<TaskRepository> getRepositories(String kind) {
        Assert.isNotNull((Object)kind);
        if (this.repositoryMap.containsKey(kind)) {
            return this.repositoryMap.get(kind);
        }
        return Collections.emptySet();
    }

    @Override
    public List<TaskRepository> getAllRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
            if (!this.repositoryMap.containsKey(repositoryConnector.getConnectorKind())) continue;
            repositories.addAll((Collection<TaskRepository>)this.repositoryMap.get(repositoryConnector.getConnectorKind()));
        }
        return repositories;
    }

    public TaskRepository getDefaultRepository(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            Iterator<TaskRepository> iterator = this.repositoryMap.get(kind).iterator();
            if (iterator.hasNext()) {
                TaskRepository repository = iterator.next();
                return repository;
            }
        } else {
            Collection<Set<TaskRepository>> values = this.repositoryMap.values();
            if (!values.isEmpty()) {
                Set<TaskRepository> repoistorySet = values.iterator().next();
                return repoistorySet.iterator().next();
            }
        }
        return null;
    }

    Map<String, Set<TaskRepository>> readRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.loadRepositories(repositoriesFilePath);
        return this.repositoryMap;
    }

    private void loadRepositories(String repositoriesFilePath) {
        boolean migration = false;
        File repositoriesFile = new File(repositoriesFilePath);
        for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
            this.repositoryMap.put(repositoryConnector.getConnectorKind(), new HashSet());
        }
        if (repositoriesFile.exists()) {
            Set<TaskRepository> repositories = this.externalizer.readRepositoriesFromXML(repositoriesFile);
            if (repositories != null && repositories.size() > 0) {
                for (TaskRepository repository : repositories) {
                    if (this.removeHttpAuthMigration(repository)) {
                        migration = true;
                    }
                    if (this.repositoryMap.containsKey(repository.getConnectorKind())) {
                        this.repositoryMap.get(repository.getConnectorKind()).add(repository);
                        repository.addChangeListener(this.PROPERTY_CHANGE_LISTENER);
                        continue;
                    }
                    this.orphanedRepositories.add(repository);
                }
            }
            if (migration) {
                this.saveRepositories(repositoriesFilePath);
            }
        }
    }

    private boolean removeHttpAuthMigration(TaskRepository repository) {
        String httpusername = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
        String httppassword = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
        if (httpusername != null && httppassword != null) {
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
            if (httpusername.length() > 0 && httppassword.length() > 0) {
                repository.setHttpAuthenticationCredentials(httpusername, httppassword);
            }
            return true;
        }
        return false;
    }

    protected synchronized boolean saveRepositories(String destinationPath) {
        HashSet<TaskRepository> repositoriesToWrite = new HashSet<TaskRepository>(this.getAllRepositories());
        for (TaskRepository repository : this.orphanedRepositories) {
            if (repositoriesToWrite.contains((Object)repository)) continue;
            repositoriesToWrite.add(repository);
        }
        try {
            File repositoriesFile = new File(destinationPath);
            this.externalizer.writeRepositoriesToXML(repositoriesToWrite, repositoriesFile);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not save repositories", t));
            return false;
        }
        return true;
    }

    @Deprecated
    public void clearRepositories(String repositoriesFilePath) {
        this.clearRepositories();
    }

    public void clearRepositories() {
        List<TaskRepository> repositories = this.getAllRepositories();
        for (TaskRepository repository : repositories) {
            this.removeRepository(repository);
        }
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
    }

    public void notifyRepositorySettingsChanged(TaskRepository repository) {
        this.notifyRepositorySettingsChanged(repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.ALL));
    }

    public void notifyRepositorySettingsChanged(final TaskRepository repository, TaskRepositoryDelta delta) {
        final TaskRepositoryChangeEvent event = new TaskRepositoryChangeEvent(this, repository, delta);
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    if (listener instanceof IRepositoryChangeListener) {
                        ((IRepositoryChangeListener)((Object)listener)).repositoryChanged(event);
                    }
                    listener.repositorySettingsChanged(repository);
                }
            });
        }
    }

    public void insertRepositories(Set<TaskRepository> repositories, String repositoryFilePath) {
        for (TaskRepository repository : repositories) {
            if (this.getRepository(repository.getConnectorKind(), repository.getRepositoryUrl()) != null) continue;
            this.addRepository(repository);
        }
    }

    public boolean isOwnedByUser(ITask task) {
        if (task instanceof LocalTask) {
            return true;
        }
        ITask repositoryTask = task;
        TaskRepository repository = this.getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        if (repository != null && repositoryTask.getOwner() != null) {
            return repositoryTask.getOwner().equals(repository.getUserName());
        }
        return false;
    }

    public void notifyRepositoryUrlChanged(final TaskRepository repository, final String oldUrl) {
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + listener.getClass(), e));
                }

                public void run() throws Exception {
                    listener.repositoryUrlChanged(repository, oldUrl);
                }
            });
        }
    }
}

