/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rhtml.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.html.dtd.Registry;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.csl.api.DeleteToNextCamelCasePosition;
import org.netbeans.modules.csl.api.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.csl.api.InstantRenameAction;
import org.netbeans.modules.csl.api.NextCamelCasePosition;
import org.netbeans.modules.csl.api.PreviousCamelCasePosition;
import org.netbeans.modules.csl.api.SelectCodeElementAction;
import org.netbeans.modules.csl.api.SelectNextCamelCasePosition;
import org.netbeans.modules.csl.api.SelectPreviousCamelCasePosition;
import org.netbeans.modules.html.editor.api.HtmlKit;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.rhtml.RhtmlDocument;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;
import org.netbeans.modules.ruby.rhtml.spi.DtdResolver;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class RhtmlKit
extends HtmlKit {
    static final long serialVersionUID = -1381945567613910297L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RhtmlKit.class);
    }

    public RhtmlKit() {
        super("application/x-httpd-eruby");
    }

    public String getContentType() {
        return "application/x-httpd-eruby";
    }

    public Document createDefaultDocument() {
        return new RhtmlDocument(this.getContentType());
    }

    public Syntax createSyntax(Document doc) {
        String fallbackDtd;
        Syntax result = super.createSyntax(doc);
        DtdResolver resolver = (DtdResolver)Lookup.getDefault().lookup(DtdResolver.class);
        if (resolver != null && (fallbackDtd = resolver.getIdentifier(doc)) != null) {
            doc.putProperty("fallbackDTD", Registry.getDTD((String)fallbackDtd, null));
        }
        return result;
    }

    protected BaseKit.DeleteCharAction createDeletePrevAction() {
        return new RhtmlDeleteCharAction("delete-previous", false, super.createDeletePrevAction());
    }

    protected ExtKit.ExtDefaultKeyTypedAction createDefaultKeyTypedAction() {
        return new RhtmlDefaultKeyTypedAction(super.createDefaultKeyTypedAction());
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        return TextAction.augmentList(superActions, new Action[]{new RhtmlToggleCommentAction(), new SelectCodeElementAction("select-element-next", true), new SelectCodeElementAction("select-element-previous", false), new NextCamelCasePosition(RhtmlKit.findAction(superActions, "caret-next-word")), new PreviousCamelCasePosition(RhtmlKit.findAction(superActions, "caret-previous-word")), new SelectNextCamelCasePosition(RhtmlKit.findAction(superActions, "selection-next-word")), new SelectPreviousCamelCasePosition(RhtmlKit.findAction(superActions, "selection-previous-word")), new DeleteToNextCamelCasePosition(RhtmlKit.findAction(superActions, "remove-word-next")), new DeleteToPreviousCamelCasePosition(RhtmlKit.findAction(superActions, "remove-word-previous")), new InstantRenameAction()});
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    private boolean handleDeletion(BaseDocument doc, int dotPos) {
        if (dotPos > 0) {
            try {
                char ch = doc.getText(dotPos - 1, 1).charAt(0);
                if (ch == '%') {
                    Token token;
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    TokenSequence ts = th.tokenSequence();
                    ts.move(dotPos);
                    if (ts.movePrevious() && (token = ts.token()).id() == RhtmlTokenId.DELIMITER && ts.offset() + token.length() == dotPos && ts.moveNext() && (token = ts.token()).id() == RhtmlTokenId.DELIMITER && ts.offset() == dotPos) {
                        doc.remove(dotPos - 1, 1 + token.length());
                        return true;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean handleInsertion(BaseDocument doc, Caret caret, char c) {
        int dotPos = caret.getDot();
        if (c == ' ' && dotPos >= 2) {
            try {
                String s = doc.getText(dotPos - 2, 2);
                if ("%=".equals(s) && dotPos >= 3) {
                    s = doc.getText(dotPos - 3, 3);
                }
                if ("<%".equals(s) || "<%=".equals(s)) {
                    doc.insertString(dotPos, "  ", null);
                    caret.setDot(dotPos + 1);
                    return true;
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
            return false;
        }
        if (dotPos > 0 && (c == '%' || c == '>')) {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = th.tokenSequence();
            ts.move(dotPos);
            try {
                if (ts.moveNext() || ts.movePrevious()) {
                    String s;
                    Token token = ts.token();
                    if (token.id() == RhtmlTokenId.HTML && doc.getText(dotPos - 1, 1).charAt(0) == '<') {
                        int first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos));
                        if (first == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if (token.id() == RhtmlTokenId.DELIMITER) {
                        int first;
                        String tokenText = ((Object)token.text()).toString();
                        if (tokenText.endsWith("%>")) {
                            int tokenPos = c == '%' ? dotPos : dotPos - 1;
                            CharSequence suffix = DocumentUtilities.getText((Document)doc, (int)tokenPos, (int)2);
                            if (CharSequenceUtilities.textEquals((CharSequence)suffix, (CharSequence)"%>")) {
                                caret.setDot(dotPos + 1);
                                return true;
                            }
                        } else if (tokenText.endsWith("<") && (first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)Utilities.getRowEnd((BaseDocument)doc, (int)dotPos))) == -1) {
                            doc.insertString(dotPos, "%%>", null);
                            caret.setDot(dotPos + 1);
                            return true;
                        }
                    } else if ((token.id() == RhtmlTokenId.RUBY || token.id() == RhtmlTokenId.RUBY_EXPR) && dotPos >= 1 && dotPos <= doc.getLength() - 3 && "% %>".equals(s = doc.getText(dotPos - 1, 4))) {
                        doc.remove(dotPos - 1, 2);
                        caret.setDot(dotPos + 1);
                        return true;
                    }
                }
            }
            catch (BadLocationException ble) {
                // empty catch block
            }
        }
        return false;
    }

    public Object clone() {
        return new RhtmlKit();
    }

    private static Token<?> getToken(BaseDocument doc, int offset, boolean checkEmbedded) {
        TokenSequence es;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (checkEmbedded && (es = ts.embedded()) != null) {
            es.move(offset);
            if (es.moveNext() || es.movePrevious()) {
                return es.token();
            }
        }
        return ts.token();
    }

    public static class RhtmlToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        static final long serialVersionUID = -1L;
        private static final String ERB_PREFIX = "<%";
        private static final String ERB_COMMENT = "<%#";
        private static final String ERB_TEXT = "<%#*";
        private static final String ERB_SUFFIX = "%>";
        private static final int ERB_PREFIX_LEN = "<%".length();
        private static final int ERB_SUFFIX_LEN = "%>".length();
        private static final int ERB_COMMENT_LEN = "<%#".length();
        private static final int ERB_TEXT_LEN = "<%#*".length();

        public RhtmlToggleCommentAction() {
            super(ERB_COMMENT);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            this.commentUncomment(evt, target, null);
        }

        private static boolean isLineCommented(BaseDocument doc, int textBegin) throws BadLocationException {
            assert (textBegin != -1);
            Token token = RhtmlKit.getToken(doc, textBegin, false);
            if (token != null) {
                TokenId id = token.id();
                if (id == RhtmlTokenId.DELIMITER) {
                    if (((Object)token.text()).toString().endsWith("#")) {
                        return true;
                    }
                    int first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(textBegin + token.length()), (int)Utilities.getRowEnd((BaseDocument)doc, (int)textBegin));
                    if (first == -1) {
                        return false;
                    }
                    char c = DocumentUtilities.getText((Document)doc, (int)first, (int)1).charAt(0);
                    return c == '#';
                }
                if (id == RhtmlTokenId.RUBY || id == RhtmlTokenId.RUBY_EXPR) {
                    token = RhtmlKit.getToken(doc, textBegin, true);
                    return token.id() == RubyTokenId.LINE_COMMENT;
                }
                return id == RhtmlTokenId.RUBYCOMMENT;
            }
            int textEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)textBegin) + 1;
            if (textEnd - textBegin < ERB_COMMENT_LEN) {
                return false;
            }
            CharSequence maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)ERB_COMMENT_LEN);
            return CharSequenceUtilities.textEquals((CharSequence)maybeLineComment, (CharSequence)ERB_COMMENT);
        }

        private void commentUncomment(ActionEvent evt, final JTextComponent target, final Boolean forceComment) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean comment;
                            int endPos;
                            int startPos;
                            Caret caret = target.getCaret();
                            if (caret.isSelectionVisible()) {
                                startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                                endPos = target.getSelectionEnd();
                                if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos && endPos > startPos) {
                                    --endPos;
                                }
                                endPos = Utilities.getRowEnd((BaseDocument)doc, (int)endPos);
                            } else {
                                startPos = Utilities.getRowStart((BaseDocument)doc, (int)caret.getDot());
                                endPos = Utilities.getRowEnd((BaseDocument)doc, (int)caret.getDot());
                            }
                            int lineCount = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos);
                            boolean bl = forceComment != null ? forceComment : (comment = !RhtmlToggleCommentAction.this.allComments(doc, startPos, lineCount));
                            if (comment) {
                                RhtmlToggleCommentAction.this.comment(doc, startPos, lineCount);
                            } else {
                                RhtmlToggleCommentAction.this.uncomment(doc, startPos, lineCount);
                            }
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                    }
                });
            }
        }

        private boolean allComments(BaseDocument doc, int startOffset, int lineCount) throws BadLocationException {
            int offset = startOffset;
            while (lineCount > 0) {
                int firstNonWhitePos = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                if (firstNonWhitePos != -1 && !RhtmlToggleCommentAction.isLineCommented(doc, firstNonWhitePos)) {
                    return false;
                }
                offset = Utilities.getRowStart((BaseDocument)doc, (int)offset, (int)1);
                --lineCount;
            }
            return true;
        }

        private void comment(BaseDocument doc, int startOffset, int lineCount) throws BadLocationException {
            int offset = startOffset;
            while (lineCount > 0) {
                if (!Utilities.isRowEmpty((BaseDocument)doc, (int)offset) && !Utilities.isRowWhite((BaseDocument)doc, (int)offset)) {
                    int textBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                    Token token = RhtmlKit.getToken(doc, textBegin, false);
                    if (token != null) {
                        TokenId id = token.id();
                        if (id == RhtmlTokenId.DELIMITER) {
                            if (!((Object)token.text()).toString().endsWith("#")) {
                                doc.insertString(textBegin + ERB_PREFIX_LEN, "#", null);
                            }
                        } else if (id == RhtmlTokenId.RUBY || id == RhtmlTokenId.RUBY_EXPR) {
                            token = RhtmlKit.getToken(doc, textBegin, true);
                            doc.insertString(textBegin, "#", null);
                        } else if (id != RhtmlTokenId.RUBYCOMMENT) {
                            doc.insertString(textBegin, ERB_TEXT, null);
                            doc.insertString(Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset) + 1, ERB_SUFFIX, null);
                        }
                    } else {
                        CharSequence maybeLineComment;
                        int textEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
                        if (textEnd - offset >= ERB_PREFIX_LEN && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)ERB_PREFIX_LEN)), (CharSequence)ERB_PREFIX)) {
                            doc.insertString(textBegin + ERB_PREFIX_LEN, "#", null);
                        } else {
                            doc.insertString(textBegin, ERB_TEXT, null);
                            doc.insertString(Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset) + 1, ERB_SUFFIX, null);
                        }
                    }
                }
                --lineCount;
                offset = Utilities.getRowStart((BaseDocument)doc, (int)offset, (int)1);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void uncomment(BaseDocument doc, int startOffset, int lineCount) throws BadLocationException {
            offset = startOffset;
            while (lineCount > 0) {
                block11: {
                    block12: {
                        block13: {
                            block14: {
                                if (Utilities.isRowEmpty((BaseDocument)doc, (int)offset) || Utilities.isRowWhite((BaseDocument)doc, (int)offset)) break block11;
                                textBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                                token = RhtmlKit.access$200(doc, textBegin, false);
                                if (token == null) break block12;
                                id = token.id();
                                if (id != RhtmlTokenId.DELIMITER) break block13;
                                if (!token.text().toString().endsWith("#")) break block14;
                                textEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)textBegin) + 1;
                                if (textEnd - textBegin < RhtmlToggleCommentAction.ERB_TEXT_LEN) ** GOTO lbl-1000
                                maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)RhtmlToggleCommentAction.ERB_TEXT_LEN);
                                maybeLineEnd = DocumentUtilities.getText((Document)doc, (int)(textEnd - RhtmlToggleCommentAction.ERB_SUFFIX_LEN), (int)RhtmlToggleCommentAction.ERB_SUFFIX_LEN).toString();
                                if (CharSequenceUtilities.textEquals((CharSequence)maybeLineComment, (CharSequence)"<%#*")) {
                                    doc.remove(textBegin, RhtmlToggleCommentAction.ERB_TEXT_LEN);
                                    if (CharSequenceUtilities.textEquals((CharSequence)maybeLineEnd, (CharSequence)"%>")) {
                                        doc.remove(textEnd - RhtmlToggleCommentAction.ERB_SUFFIX_LEN - RhtmlToggleCommentAction.ERB_TEXT_LEN, RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                                    }
                                } else if (textEnd - textBegin >= RhtmlToggleCommentAction.ERB_COMMENT_LEN && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)RhtmlToggleCommentAction.ERB_COMMENT_LEN)), (CharSequence)"<%#")) {
                                    doc.remove(textBegin + 2, 1);
                                }
                                break block11;
                            }
                            first = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)(textBegin + token.length()), (int)Utilities.getRowEnd((BaseDocument)doc, (int)textBegin));
                            if (first != -1 && (c = DocumentUtilities.getText((Document)doc, (int)first, (int)1).charAt(0)) == '#') {
                                doc.remove(first, 1);
                            }
                            break block11;
                        }
                        if ((id == RhtmlTokenId.RUBY || id == RhtmlTokenId.RUBY_EXPR) && (token = RhtmlKit.access$200(doc, textBegin, true)).id() == RubyTokenId.LINE_COMMENT) {
                            doc.remove(textBegin, 1);
                        }
                        break block11;
                    }
                    textEnd = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)textBegin) + 1;
                    if (textEnd - textBegin < RhtmlToggleCommentAction.ERB_TEXT_LEN) ** GOTO lbl-1000
                    maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)RhtmlToggleCommentAction.ERB_TEXT_LEN);
                    maybeLineEnd = DocumentUtilities.getText((Document)doc, (int)(textEnd - RhtmlToggleCommentAction.ERB_SUFFIX_LEN), (int)RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                    if (CharSequenceUtilities.textEquals((CharSequence)maybeLineComment, (CharSequence)"<%#*")) {
                        doc.remove(textBegin, RhtmlToggleCommentAction.ERB_TEXT_LEN);
                        if (CharSequenceUtilities.textEquals((CharSequence)maybeLineEnd, (CharSequence)"%>")) {
                            doc.remove(textEnd - RhtmlToggleCommentAction.ERB_SUFFIX_LEN - RhtmlToggleCommentAction.ERB_TEXT_LEN, RhtmlToggleCommentAction.ERB_SUFFIX_LEN);
                        }
                    } else if (textEnd - textBegin >= RhtmlToggleCommentAction.ERB_COMMENT_LEN && CharSequenceUtilities.textEquals((CharSequence)(maybeLineComment = DocumentUtilities.getText((Document)doc, (int)textBegin, (int)RhtmlToggleCommentAction.ERB_COMMENT_LEN)), (CharSequence)"<%#")) {
                        doc.remove(textBegin + 2, 1);
                    }
                }
                --lineCount;
                offset = Utilities.getRowStart((BaseDocument)doc, (int)offset, (int)1);
            }
        }
    }

    private class RhtmlDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        private BaseKit.DeleteCharAction htmlAction;

        public RhtmlDeleteCharAction(String nm, boolean nextChar, BaseKit.DeleteCharAction htmlAction) {
            super(nm, nextChar);
            this.htmlAction = htmlAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            target.putClientProperty(ExtKit.ExtDeleteCharAction.class, (Object)this);
            try {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                int dotPos = caret.getDot();
                if (RhtmlKit.this.handleDeletion(doc, dotPos)) {
                    return;
                }
                this.htmlAction.actionPerformed(evt, target);
            }
            finally {
                target.putClientProperty(ExtKit.ExtDeleteCharAction.class, null);
            }
        }

        public boolean getNextChar() {
            return this.nextChar;
        }
    }

    private class RhtmlDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private ExtKit.ExtDefaultKeyTypedAction htmlAction;

        RhtmlDefaultKeyTypedAction(ExtKit.ExtDefaultKeyTypedAction htmlAction) {
            this.htmlAction = htmlAction;
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            char c;
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            String cmd = evt.getActionCommand();
            if (cmd.length() > 0 && RhtmlKit.this.handleInsertion(doc, caret, c = cmd.charAt(0))) {
                return;
            }
            this.htmlAction.actionPerformed(evt, target);
        }
    }
}

