/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.DeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class DeclarationContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private final TreeMap<CharSequence, Object> declarations;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private final Map<CharSequence, Set<CsmUID<? extends CsmFriend>>> friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<? extends CsmFriend>>>();
    private static final DeclarationContainer EMPTY = new DeclarationContainer(){

        @Override
        public void put() {
        }

        @Override
        public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        }
    };

    public DeclarationContainer(ProjectBase projectBase) {
        super(new DeclarationContainerKey(((Object)projectBase.getUniqueName()).toString()), false);
        this.declarations = new TreeMap(CharSequences.comparator());
        this.put();
    }

    public DeclarationContainer(CsmNamespace csmNamespace) {
        super(new NamespaceDeclarationContainerKey(csmNamespace), false);
        this.declarations = new TreeMap(CharSequences.comparator());
        this.put();
    }

    public DeclarationContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        this.declarations = UIDObjectFactory.getDefaultFactory().readStringToArrayUIDMap(dataInput, UniqueNameCache.getManager());
    }

    private DeclarationContainer() {
        super(null, false);
        this.declarations = new TreeMap(CharSequences.comparator());
    }

    public static DeclarationContainer empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CharSequence charSequence = CharSequences.create((CharSequence)csmOffsetableDeclaration.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> csmUID = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
        Object object = null;
        try {
            this.declarationsLock.writeLock().lock();
            object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                int n = csmUIDArray.length;
                CsmUID csmUID2 = null;
                int n2 = n;
                for (int i = 0; i < n; ++i) {
                    CsmUID csmUID3 = csmUIDArray[i];
                    if (UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID3, csmUID)) {
                        csmUIDArray[i] = null;
                        --n2;
                        continue;
                    }
                    csmUID2 = csmUID3;
                }
                if (n2 == 0) {
                    this.declarations.remove(charSequence);
                } else if (n2 == 1) {
                    this.declarations.put(charSequence, csmUID2);
                } else {
                    CsmUID[] csmUIDArray2 = new CsmUID[n2];
                    n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        CsmUID csmUID4 = csmUIDArray[i];
                        if (csmUID4 == null) continue;
                        csmUIDArray2[n2] = csmUID4;
                        ++n2;
                    }
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (object instanceof CsmUID) {
                this.declarations.remove(charSequence);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.removeFriend(csmOffsetableDeclaration);
        this.put();
    }

    private void removeFriend(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmFriendFunction csmFriendFunction;
        CharSequence charSequence;
        Set<CsmUID<? extends CsmFriend>> set;
        if (CsmKindUtilities.isFriendClass((CsmObject)csmOffsetableDeclaration)) {
            CsmFriendClass csmFriendClass = (CsmFriendClass)csmOffsetableDeclaration;
            CharSequence charSequence2 = CharSequences.create((CharSequence)csmFriendClass.getName());
            Set<CsmUID<? extends CsmFriend>> set2 = this.friends.get(charSequence2);
            if (set2 != null) {
                set2.remove(UIDs.get((Object)csmFriendClass));
                if (set2.isEmpty()) {
                    this.friends.remove(charSequence2);
                }
            }
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmOffsetableDeclaration) && (set = this.friends.get(charSequence = CharSequences.create((CharSequence)(csmFriendFunction = (CsmFriendFunction)csmOffsetableDeclaration).getSignature()))) != null) {
            set.remove(UIDs.get((Object)csmFriendFunction));
            if (set.isEmpty()) {
                this.friends.remove(charSequence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CharSequence charSequence = UniqueNameCache.getManager().getString(csmOffsetableDeclaration.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> csmUID = RepositoryUtils.put(csmOffsetableDeclaration);
        assert (csmUID != null);
        if (!(csmUID instanceof SelfPersistent)) {
            object = " [" + csmOffsetableDeclaration.getStartPosition().getLine() + ":" + csmOffsetableDeclaration.getStartPosition().getColumn() + "-" + csmOffsetableDeclaration.getEndPosition().getLine() + ":" + csmOffsetableDeclaration.getEndPosition().getColumn() + "]";
            new Exception("attempt to put local declaration " + csmOffsetableDeclaration + (String)object).printStackTrace();
        }
        try {
            this.declarationsLock.writeLock().lock();
            object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                boolean bl = false;
                for (int i = 0; i < csmUIDArray.length; ++i) {
                    if (!UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUIDArray[i], csmUID)) continue;
                    csmUIDArray[i] = csmUID;
                    bl = true;
                    break;
                }
                if (!bl) {
                    CsmUID[] csmUIDArray2 = new CsmUID[csmUIDArray.length + 1];
                    csmUIDArray2[0] = csmUID;
                    for (int i = 0; i < csmUIDArray.length; ++i) {
                        csmUIDArray2[i + 1] = csmUIDArray[i];
                    }
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (object instanceof CsmUID) {
                CsmUID csmUID2 = (CsmUID)object;
                if (UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID2, csmUID)) {
                    this.declarations.put(charSequence, csmUID);
                } else {
                    CsmUID[] csmUIDArray = new CsmUID[]{csmUID, csmUID2};
                    this.declarations.put(charSequence, csmUIDArray);
                }
            } else {
                this.declarations.put(charSequence, csmUID);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.putFriend((CsmDeclaration)csmOffsetableDeclaration);
        this.put();
    }

    private void putFriend(CsmDeclaration csmDeclaration) {
        if (CsmKindUtilities.isFriendClass((CsmObject)csmDeclaration)) {
            CsmFriendClass csmFriendClass = (CsmFriendClass)csmDeclaration;
            CharSequence charSequence = CharSequences.create((CharSequence)csmFriendClass.getName());
            Set<CsmUID<? extends CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<? extends CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<? extends CsmFriend>)UIDs.get((Object)csmFriendClass));
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmDeclaration)) {
            CsmFriendFunction csmFriendFunction = (CsmFriendFunction)csmDeclaration;
            CharSequence charSequence = CharSequences.create((CharSequence)csmFriendFunction.getSignature());
            Set<CsmUID<? extends CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<? extends CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<? extends CsmFriend>)UIDs.get((Object)csmFriendFunction));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsRange(CharSequence charSequence, CharSequence charSequence2) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        charSequence = CharSequences.create((CharSequence)charSequence);
        charSequence2 = CharSequences.create((CharSequence)charSequence2);
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(charSequence, charSequence2).entrySet()) {
                DeclarationContainer.addAll(arrayList, entry.getValue());
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsFQN(CharSequence charSequence, CsmDeclaration.Kind[] kindArray) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        char c = '\u00ff';
        for (CsmDeclaration.Kind kind : kindArray) {
            String string = Utils.getCsmDeclarationKindkey(kind) + ':' + charSequence;
            CharSequence charSequence2 = CharSequences.create((CharSequence)string);
            CharSequence charSequence3 = CharSequences.create((CharSequence)(string + c));
            try {
                this.declarationsLock.readLock().lock();
                for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(charSequence2, charSequence3).entrySet()) {
                    DeclarationContainer.addAll(arrayList, entry.getValue());
                }
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedMap<CharSequence, Object> testDeclarations() {
        try {
            this.declarationsLock.readLock().lock();
            TreeMap<CharSequence, Object> treeMap = new TreeMap<CharSequence, Object>((SortedMap<CharSequence, Object>)this.declarations);
            return treeMap;
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    SortedMap<CharSequence, Set<CsmUID<? extends CsmFriend>>> testFriends() {
        return new TreeMap<CharSequence, Set<CsmUID<? extends CsmFriend>>>(this.friends);
    }

    private static void addAll(Collection<CsmUID<CsmOffsetableDeclaration>> collection, Object object) {
        if (object instanceof CsmUID[]) {
            CsmUID[] csmUIDArray = (CsmUID[])object;
            collection.addAll(Arrays.asList(csmUIDArray));
        } else if (object instanceof CsmUID) {
            CsmUID csmUID = (CsmUID)object;
            collection.add((CsmUID<CsmOffsetableDeclaration>)csmUID);
        }
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CharSequence charSequence2) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsRange(charSequence, charSequence2));
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CsmDeclaration.Kind[] kindArray) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsFQN(charSequence, kindArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarationsUIDs() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        try {
            this.declarationsLock.readLock().lock();
            for (Object object : this.declarations.values()) {
                DeclarationContainer.addAll(arrayList, object);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> findFriends(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CharSequence charSequence = null;
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmClass)csmOffsetableDeclaration;
            charSequence = object.getName();
        } else if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmFunction)csmOffsetableDeclaration;
            charSequence = object.getSignature();
        }
        if (charSequence != null) {
            Collection<Object> collection;
            charSequence = CharSequences.create((CharSequence)charSequence);
            object = new ArrayList();
            try {
                this.declarationsLock.readLock().lock();
                collection = this.friends.get(charSequence);
                if (collection != null) {
                    object.addAll(collection);
                }
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
            if (object.size() > 0) {
                collection = new ArrayList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CsmFriendClass csmFriendClass;
                    CsmUID csmUID = (CsmUID)iterator.next();
                    CsmFriend csmFriend = (CsmFriend)csmUID.getObject();
                    if (CsmKindUtilities.isFriendClass((CsmObject)csmFriend)) {
                        csmFriendClass = (CsmFriendClass)csmFriend;
                        if (!csmOffsetableDeclaration.equals(csmFriendClass.getReferencedClass())) continue;
                        collection.add((CsmUID<? extends CsmFriend>)csmFriendClass);
                        continue;
                    }
                    if (!CsmKindUtilities.isFriendMethod((CsmObject)csmFriend) || !csmOffsetableDeclaration.equals((csmFriendClass = (CsmFriendFunction)csmFriend).getReferencedFunction())) continue;
                    collection.add(csmFriendClass);
                }
                return collection;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        ArrayList arrayList = new ArrayList();
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            DeclarationContainer.addAll(arrayList, this.declarations.get(charSequence));
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmDeclaration getDeclaration(CharSequence charSequence) {
        CsmUID csmUID = null;
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            Object object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                csmUID = csmUIDArray[0];
            } else if (object instanceof CsmUID) {
                CsmUID csmUID2;
                csmUID = csmUID2 = (CsmUID)object;
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        Object t = UIDCsmConverter.UIDtoDeclaration(csmUID);
        if (csmUID != null && t == null) {
            DiagnosticExceptoins.register(new IllegalStateException("no declaration for UID " + csmUID));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeclarations() {
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.clear();
            this.put();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToArrayUIDMap(this.declarations, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

