/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.common;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;

public class Utilities {
    public static AnnotationMirror findAnnotation(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!string.equals(annotationMirror.getAnnotationType().toString())) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String string) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(element, string);
        return annotationMirror != null;
    }

    public static AnnotationValue getAnnotationAttrValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!string.equals(executableElement.getSimpleName().toString())) continue;
                return annotationMirror.getElementValues().get(executableElement);
            }
        }
        return null;
    }

    public static TextSpan getUnderlineSpan(CompilationInfo compilationInfo, Tree tree) {
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        int n = (int)sourcePositions.getStartPosition(compilationInfo.getCompilationUnit(), tree);
        int n2 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree);
        Tree tree2 = null;
        if (tree.getKind() == Tree.Kind.CLASS) {
            tree2 = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            tree2 = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            tree2 = ((VariableTree)tree).getType();
        }
        if (tree2 != null) {
            int n3 = (int)sourcePositions.getEndPosition(compilationInfo.getCompilationUnit(), tree2);
            TokenSequence tokenSequence = compilationInfo.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean bl = false;
                tokenSequence.move(n3);
                do {
                    boolean bl2 = bl = !tokenSequence.moveNext();
                } while (!bl && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!bl) {
                    Token token = tokenSequence.token();
                    n = token.offset(compilationInfo.getTokenHierarchy());
                    n2 = n + token.length();
                }
            }
        }
        return new TextSpan(n, n2);
    }

    public static String getShortClassName(String string) {
        return string.substring(string.lastIndexOf(".") + 1);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

