/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.modules.cnd.lexer.CndLexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public class CppLexer
extends CndLexer {
    private final Filter<CppTokenId> lexerFilter;

    public CppLexer(Filter<CppTokenId> defaultFilter, LexerRestartInfo<CppTokenId> info) {
        super(info);
        Filter<CppTokenId> filter = (Filter<CppTokenId>)info.getAttributeValue((Object)"lexer-filter");
        this.lexerFilter = filter != null ? filter : defaultFilter;
    }

    @Override
    protected Token<CppTokenId> finishSharp() {
        while (true) {
            block0 : switch (this.read(true)) {
                case 34: {
                    this.skipLiteral(true);
                    break;
                }
                case 39: {
                    this.skipLiteral(false);
                    break;
                }
                case 47: {
                    switch (this.read(true)) {
                        case 47: {
                            this.skipLineComment();
                            break block0;
                        }
                        case 42: {
                            this.skipBlockComment();
                            break block0;
                        }
                        case 13: {
                            this.consumeNewline();
                        }
                        case -1: 
                        case 10: {
                            return this.token(CppTokenId.PREPROCESSOR_DIRECTIVE);
                        }
                    }
                    break;
                }
                case 13: {
                    this.consumeNewline();
                }
                case -1: 
                case 10: {
                    return this.token(CppTokenId.PREPROCESSOR_DIRECTIVE);
                }
            }
        }
    }

    private void skipBlockComment() {
        super.finishBlockComment(false);
    }

    private void skipLineComment() {
        super.finishLineComment(false);
    }

    private void skipLiteral(boolean endDblQuote) {
        while (true) {
            switch (this.read(true)) {
                case 34: {
                    if (!endDblQuote) break;
                    return;
                }
                case 39: {
                    if (endDblQuote) break;
                    return;
                }
                case 92: {
                    this.read(false);
                    break;
                }
                case 10: 
                case 13: {
                    this.backup(1);
                }
                case -1: {
                    return;
                }
            }
        }
    }

    @Override
    protected CppTokenId getKeywordOrIdentifierID(CharSequence text) {
        CppTokenId id = this.lexerFilter.check(text);
        return id != null ? id : CppTokenId.IDENTIFIER;
    }
}

