/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.editors.CustomIconEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IconEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
FormAwareEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    private static final String[] DEFAULT_DIRS = new String[]{"resources", "resource", "images"};
    private String currentPackage;
    private String[] currentFiles;
    private FileObject sourceFile;
    private boolean externalIconsAllowed = true;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";

    @Override
    public void setValue(Object object) {
        if (IconEditor.sameValue(object, this.getValue())) {
            return;
        }
        if (object instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)object;
            if (nbImageIcon.getType() == 3) {
                this.setCurrentPackage(this.getResourcePackage(nbImageIcon.getName()));
            }
        } else {
            Object var2_3 = null;
            if (object == null && this.currentPackage == null) {
                this.setCurrentPackage(this.getDefaultResourcePackage());
            }
        }
        super.setValue(object);
        this.currentFiles = null;
    }

    private static boolean sameValue(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object instanceof NbImageIcon && object2 instanceof NbImageIcon) {
            return IconEditor.sameIcon((NbImageIcon)object, (NbImageIcon)object2);
        }
        return false;
    }

    private static boolean sameIcon(NbImageIcon nbImageIcon, NbImageIcon nbImageIcon2) {
        return nbImageIcon.getType() == nbImageIcon2.getType() && nbImageIcon.getName().equals(nbImageIcon2.getName());
    }

    @Override
    public String getAsText() {
        Object object = this.getValue();
        if (object instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)object;
            if (nbImageIcon.getType() == 3) {
                String string = nbImageIcon.getName();
                if (this.currentPackage != null && string.startsWith(this.currentPackage)) {
                    return string.substring(this.currentPackage.length() + 1);
                }
                return string;
            }
            return nbImageIcon.getName();
        }
        return "";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.createIconFromText(string));
    }

    @Override
    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)this.getValue();
            switch (nbImageIcon.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(nbImageIcon.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "*/\n\\1NOI18N*/\n\\0new javax.swing.ImageIcon(\"" + IconEditor.convert(nbImageIcon.name) + "\")";
                }
                case 3: {
                    return "*/\n\\1NOI18N*/\n\\0new javax.swing.ImageIcon(getClass().getResource(\"/" + nbImageIcon.name + "\"))";
                }
            }
        }
        return "null";
    }

    private static String convert(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        StringBuilder stringBuilder = new StringBuilder();
        if (stringTokenizer.hasMoreElements()) {
            stringBuilder.append(stringTokenizer.nextElement());
            while (stringTokenizer.hasMoreElements()) {
                stringBuilder.append("\\\\").append(stringTokenizer.nextElement());
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] getTags() {
        if (this.currentFiles == null) {
            this.currentFiles = this.getAvailableFileNames();
        }
        return this.currentFiles;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        CustomIconEditor customIconEditor = new CustomIconEditor(this);
        Object object = this.getValue();
        if (!(object instanceof NbImageIcon)) {
            object = null;
        }
        customIconEditor.setValue((NbImageIcon)object);
        this.currentFiles = null;
        return customIconEditor;
    }

    @Override
    public void setContext(FormModel formModel, FormProperty formProperty) {
        if (formModel != null) {
            this.sourceFile = FormEditor.getFormDataObject(formModel).getPrimaryFile();
        }
        if (formProperty != null) {
            formProperty.setValue("canEditAsText", true);
        }
        if (this.currentPackage == null && this.sourceFile != null) {
            this.setCurrentPackage(this.getDefaultResourcePackage());
        }
    }

    @Override
    public void updateFormVersionLevel() {
    }

    FileObject getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(FileObject fileObject) {
        this.sourceFile = fileObject;
    }

    public void setExternalIconsAllowed(boolean bl) {
        this.externalIconsAllowed = bl;
    }

    public boolean isExternalIconsAllowed() {
        return this.externalIconsAllowed;
    }

    public FileObject getCurrentFolder() {
        if (this.currentPackage != null) {
            FileObject fileObject = this.getSourceFile();
            FileObject fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findResource(this.currentPackage);
            if (fileObject2 == null) {
                fileObject2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute").findResource(this.currentPackage);
            }
            return fileObject2;
        }
        return null;
    }

    public void setCurrentFolder(FileObject fileObject) {
        if (fileObject != null) {
            FileObject fileObject2 = this.getSourceFile();
            FileObject fileObject3 = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source").findOwnerRoot(fileObject);
            if (fileObject3 == null) {
                fileObject3 = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/execute").findOwnerRoot(fileObject);
            }
            if (fileObject3 != null) {
                this.setCurrentPackage(FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject));
            }
        } else {
            this.setCurrentPackage(null);
        }
    }

    private void setCurrentPackage(String string) {
        this.currentPackage = string;
        this.currentFiles = null;
    }

    private String getResourcePackage(String string) {
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return null;
        }
        return string.substring(0, n);
    }

    FileObject getDefaultResourceFolder() {
        FileObject fileObject = this.getSourceFile();
        for (String string : DEFAULT_DIRS) {
            FileObject fileObject2 = fileObject.getParent().getFileObject(string);
            if (fileObject2 == null) continue;
            return fileObject2;
        }
        return fileObject.getParent();
    }

    private String getDefaultResourcePackage() {
        FileObject fileObject = this.getDefaultResourceFolder();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        return FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
    }

    private String[] getAvailableFileNames() {
        FileObject fileObject = this.getCurrentFolder();
        if (fileObject != null) {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!IconEditor.isImageFile(fileObject2)) continue;
                linkedList.add(fileObject2.getNameExt());
            }
            Object[] objectArray = new String[linkedList.size()];
            linkedList.toArray(objectArray);
            Arrays.sort(objectArray);
            return objectArray;
        }
        return null;
    }

    static boolean isImageFile(FileObject fileObject) {
        return fileObject.isFolder() ? false : IconEditor.isImageFileName(fileObject.getNameExt());
    }

    static boolean isImageFileName(String string) {
        return (string = string.toLowerCase()).endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png") || string.endsWith(".jpeg") || string.endsWith(".jpe");
    }

    private NbImageIcon createIconFromText(String string) {
        Object object;
        if (string == null || "".equals(string.trim())) {
            return null;
        }
        if (!(string.contains("/") || string.contains("\\") || string.contains(":"))) {
            object = this.currentPackage != null ? this.currentPackage : this.getDefaultResourcePackage();
            string = (String)object + "/" + string;
        }
        if ((object = this.iconFromResourceName(string)) != null) {
            return object;
        }
        object = this.iconFromURL(string, true);
        if (object != null) {
            return object;
        }
        return this.iconFromFileName(string);
    }

    private NbImageIcon iconFromResourceName(String string) {
        return IconEditor.iconFromResourceName(string, this.getSourceFile());
    }

    private static NbImageIcon iconFromResourceName(String string, FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        FileObject fileObject2 = classPath.findResource(string);
        if (fileObject2 == null) {
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
            fileObject2 = classPath.findResource(string);
        }
        if (fileObject2 != null) {
            try {
                try {
                    BufferedImage bufferedImage = ImageIO.read(fileObject2.getURL());
                    if (bufferedImage != null) {
                        return new NbImageIcon(3, string, new ImageIcon(bufferedImage));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, illegalArgumentException);
                    return new NbImageIcon(3, string, new ImageIcon(fileObject2.getURL()));
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(IconEditor.class.getName()).log(Level.WARNING, null, iOException);
            }
        }
        return null;
    }

    private NbImageIcon iconFromURL(String string, boolean bl) {
        block15: {
            try {
                Object object;
                Serializable serializable;
                URL uRL = new URL(string);
                if (!bl) {
                    try {
                        serializable = new File(uRL.toURI());
                        if (serializable.exists()) {
                            object = serializable.getAbsolutePath();
                            try {
                                BufferedImage bufferedImage = ImageIO.read(new File((String)object));
                                if (bufferedImage != null) {
                                    return new NbImageIcon(2, (String)object, new ImageIcon(bufferedImage));
                                }
                                return null;
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(IconEditor.class.getName()).log(Level.WARNING, null, iOException);
                            }
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (uRL == null) break block15;
                serializable = null;
                try {
                    try {
                        object = ImageIO.read(uRL);
                        if (object != null) {
                            serializable = new ImageIcon((Image)object);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, illegalArgumentException);
                        serializable = new ImageIcon(uRL);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new NbImageIcon(1, string, (Icon)((Object)serializable));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private NbImageIcon iconFromFileName(String string) {
        File file = new File(string);
        if (file.exists()) {
            try {
                try {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    if (bufferedImage != null) {
                        return new NbImageIcon(2, string, new ImageIcon(bufferedImage));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, illegalArgumentException);
                    return new NbImageIcon(2, string, new ImageIcon(string));
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, iOException);
            }
        }
        return null;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_IMAGE.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            int n = Integer.parseInt(namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue());
            String string = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
            switch (n) {
                case 0: {
                    this.setValue(null);
                    break;
                }
                case 1: {
                    this.setValue(this.iconFromURL(string, false));
                    break;
                }
                case 2: {
                    this.setValue(this.iconFromFileName(string));
                    break;
                }
                case 3: {
                    NbImageIcon nbImageIcon;
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    if ((nbImageIcon = this.iconFromResourceName(string)) == null && string.contains("/")) {
                        nbImageIcon = new NbImageIcon(3, string, null);
                    }
                    this.setValue(nbImageIcon);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)nullPointerException);
            throw iOException;
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_IMAGE);
        Object object = this.getValue();
        if (object instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)object;
            String string = nbImageIcon.getName();
            if (nbImageIcon.getType() == 3 && !string.startsWith("/")) {
                string = "/" + string;
            }
            element.setAttribute(ATTR_TYPE, Integer.toString(nbImageIcon.type));
            element.setAttribute(ATTR_NAME, string);
        } else {
            element.setAttribute(ATTR_TYPE, "0");
            element.setAttribute(ATTR_NAME, "null");
        }
        return element;
    }

    public static class NbImageIcon
    extends FormDesignValueAdapter {
        private int type;
        private String name;
        private Icon icon;

        public NbImageIcon(int n, String string, Icon icon) {
            this.type = n;
            if (n == 3 && string.startsWith("/")) {
                string = string.substring(1);
            }
            this.name = string;
            this.icon = icon;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Object getDesignValue() {
            return this.icon;
        }

        @Override
        public String getDescription() {
            return this.name;
        }

        @Override
        public FormDesignValue copy(FormProperty formProperty) {
            FormModel formModel;
            if (this.type == 3 && (formModel = formProperty.getPropertyContext().getFormModel()) != null) {
                FileObject fileObject = FormEditor.getFormDataObject(formModel).getPrimaryFile();
                return IconEditor.iconFromResourceName(this.name, fileObject);
            }
            return new NbImageIcon(this.type, this.name, this.icon);
        }
    }
}

