/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MethodPicker;
import org.netbeans.modules.form.PropertyPicker;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;

public class ParametersPicker
extends JPanel {
    static final long serialVersionUID = 1116033799965380000L;
    private boolean previousValue = false;
    private JRadioButton beanButton;
    private JComboBox beanCombo;
    private JEditorPane codeArea;
    private JRadioButton codeButton;
    private JScrollPane codeScrollPane;
    private JRadioButton methodButton;
    private JButton methodDetailsButton;
    private JTextField methodLabel;
    private JLabel paramLabel;
    private JRadioButton propertyButton;
    private JButton propertyDetailsButton;
    private JTextField propertyLabel;
    private JRadioButton valueButton;
    private JTextField valueField;
    private FormModel formModel;
    private Class<?> requiredType;
    private PropertyPicker propertyPicker;
    private List<ChangeListener> listeners;
    private RADComponent selectedComponent;
    private PropertyDescriptor selectedProperty;
    private MethodDescriptor selectedMethod;
    private List<RADComponent> beansList;

    public ParametersPicker(FormModel formModel, Class clazz) {
        this.formModel = formModel;
        this.requiredType = clazz;
        this.initComponents();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.valueButton);
        buttonGroup.add(this.beanButton);
        buttonGroup.add(this.propertyButton);
        buttonGroup.add(this.methodButton);
        buttonGroup.add(this.codeButton);
        if (!clazz.isPrimitive() && !clazz.equals(String.class)) {
            this.valueButton.setEnabled(false);
            this.propertyButton.setSelected(true);
        }
        this.paramLabel.setLabelFor(this);
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        Mnemonics.setLocalizedText((AbstractButton)this.valueButton, (String)FormUtils.getBundleString("CTL_CW_Value"));
        Mnemonics.setLocalizedText((AbstractButton)this.beanButton, (String)FormUtils.getBundleString("CTL_CW_Bean"));
        Mnemonics.setLocalizedText((AbstractButton)this.propertyButton, (String)FormUtils.getBundleString("CTL_CW_Property"));
        Mnemonics.setLocalizedText((AbstractButton)this.methodButton, (String)FormUtils.getBundleString("CTL_CW_Method"));
        Mnemonics.setLocalizedText((AbstractButton)this.codeButton, (String)FormUtils.getBundleString("CTL_CW_UserCode"));
        this.beansList = new ArrayList<RADComponent>();
        for (RADComponent rADComponent : formModel.getAllComponents()) {
            if (!this.requiredType.isAssignableFrom(rADComponent.getBeanClass())) continue;
            this.beansList.add(rADComponent);
        }
        if (this.beansList.size() > 0) {
            Collections.sort(this.beansList, new ComponentComparator());
            this.beanCombo.addItem(FormUtils.getBundleString("CTL_CW_SelectBean"));
            for (RADComponent rADComponent : this.beansList) {
                if (rADComponent == formModel.getTopRADComponent()) {
                    this.beanCombo.addItem(FormUtils.getBundleString("CTL_FormTopContainerName"));
                    continue;
                }
                this.beanCombo.addItem(rADComponent.getName());
            }
            this.beanCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = ParametersPicker.this.beanCombo.getSelectedIndex();
                    if (n == 0) {
                        ParametersPicker.this.selectedComponent = null;
                    } else {
                        ParametersPicker.this.selectedComponent = (RADComponent)ParametersPicker.this.beansList.get(n - 1);
                    }
                    ParametersPicker.this.fireStateChange();
                }
            });
        } else {
            this.beanButton.setEnabled(false);
        }
        this.updateParameterTypes();
        HelpCtx.setHelpIDString((JComponent)this, (String)"gui.source.modifying.property");
        this.valueButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Value"));
        this.beanButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Bean"));
        this.propertyButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Property"));
        this.methodButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_Method"));
        this.codeButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCode"));
        this.valueField.getAccessibleContext().setAccessibleName(this.valueButton.getText());
        this.valueField.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_ValueField"));
        this.beanCombo.getAccessibleContext().setAccessibleName(this.beanButton.getText());
        this.beanCombo.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_BeanCombo"));
        this.propertyLabel.getAccessibleContext().setAccessibleName(this.propertyButton.getText());
        this.propertyLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyLabel"));
        this.methodLabel.getAccessibleContext().setAccessibleName(this.methodButton.getText());
        this.methodLabel.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodLabel"));
        this.codeArea.getAccessibleContext().setAccessibleName(this.codeButton.getText());
        this.codeArea.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_UserCodeArea"));
        this.propertyDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_PropertyButton"));
        this.methodDetailsButton.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_CTL_CW_MethodButton"));
        this.getAccessibleContext().setAccessibleDescription(FormUtils.getBundleString("ACSD_ParametersPicker"));
    }

    public void setPropertyValue(RADConnectionPropertyEditor.RADConnectionDesignValue rADConnectionDesignValue, Object object) {
        if (rADConnectionDesignValue == null) {
            this.previousValue = object != null;
            return;
        }
        this.previousValue = true;
        switch (rADConnectionDesignValue.type) {
            case 3: {
                this.valueButton.setSelected(true);
                this.valueField.setText(rADConnectionDesignValue.value);
                break;
            }
            case 4: {
                this.beanButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                int n = this.beansList.indexOf(this.selectedComponent);
                if (n <= -1) break;
                this.beanCombo.setSelectedIndex(n + 1);
                break;
            }
            case 0: {
                this.propertyButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedProperty = rADConnectionDesignValue.getProperty();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.propertyLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.propertyLabel.setText(this.selectedProperty.getName());
                } else {
                    this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
                }
                this.propertyLabel.selectAll();
                break;
            }
            case 1: {
                this.methodButton.setSelected(true);
                this.selectedComponent = rADConnectionDesignValue.getRADComponent();
                this.selectedMethod = rADConnectionDesignValue.getMethod();
                if (this.selectedComponent.getCodeExpression() == null) {
                    this.methodLabel.setText(FormUtils.getBundleString("CTL_CONNECTION_INVALID"));
                } else if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                    this.methodLabel.setText(this.selectedMethod.getName());
                } else {
                    this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
                }
                this.methodLabel.selectAll();
                break;
            }
            default: {
                this.codeButton.setSelected(true);
                this.codeArea.setText(rADConnectionDesignValue.userCode);
            }
        }
        this.updateParameterTypes();
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.valueButton.isSelected() && !"".equals(this.valueField.getText())) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.requiredType, this.valueField.getText());
        }
        if (this.beanButton.isSelected() && this.selectedComponent != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent);
        }
        if (this.codeButton.isSelected() && !"".equals(this.codeArea.getText())) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.codeArea.getText());
        }
        if (this.propertyButton.isSelected() && this.selectedProperty != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedProperty);
        }
        if (this.methodButton.isSelected() && this.selectedMethod != null) {
            return new RADConnectionPropertyEditor.RADConnectionDesignValue(this.selectedComponent, this.selectedMethod);
        }
        if (!this.previousValue) {
            return BeanSupport.NO_VALUE;
        }
        IllegalStateException illegalStateException = new IllegalStateException();
        ErrorManager.getDefault().annotate((Throwable)illegalStateException, 256, null, FormUtils.getBundleString("ERR_NothingEntered"), null, null);
        throw illegalStateException;
    }

    public String getPreviewText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.codeButton.isSelected()) {
            return FormUtils.getBundleString("CTL_CW_Code");
        }
        return this.getText();
    }

    public String getText() {
        if (!this.isFilled()) {
            return FormUtils.getBundleString("CTL_CW_NotSet");
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                String string = this.valueField.getText();
                string = string.replace("\\", "\\\\");
                string = string.replace("\"", "\\\"");
                return "\"" + string + "\"";
            }
            return this.valueField.getText() != null ? this.valueField.getText() : "";
        }
        if (this.codeButton.isSelected()) {
            return this.codeArea.getText();
        }
        if (this.beanButton.isSelected()) {
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                return "this";
            }
            return this.selectedComponent.getName();
        }
        if (this.propertyButton.isSelected()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                stringBuilder.append(this.selectedComponent.getName());
                stringBuilder.append(".");
            }
            if (this.selectedProperty != null) {
                stringBuilder.append(this.selectedProperty.getReadMethod().getName());
                stringBuilder.append("()");
            } else {
                stringBuilder.append("???");
            }
            return stringBuilder.toString();
        }
        if (this.methodButton.isSelected()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.selectedComponent != this.formModel.getTopRADComponent()) {
                stringBuilder.append(this.selectedComponent.getName());
                stringBuilder.append(".");
            }
            stringBuilder.append(this.selectedMethod.getName());
            stringBuilder.append("()");
            return stringBuilder.toString();
        }
        return "";
    }

    public boolean isFilled() {
        if (this.codeButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                return true;
            }
            return !"".equals(this.codeArea.getText());
        }
        if (this.beanButton.isSelected()) {
            return this.selectedComponent != null;
        }
        if (this.propertyButton.isSelected()) {
            return this.selectedProperty != null;
        }
        if (this.valueButton.isSelected()) {
            if (this.requiredType.equals(String.class)) {
                return true;
            }
            return !"".equals(this.valueField.getText());
        }
        if (this.methodButton.isSelected()) {
            return this.selectedMethod != null;
        }
        return false;
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ChangeListener>();
        }
        this.listeners.add(changeListener);
    }

    public synchronized void removeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(changeListener);
    }

    private synchronized void fireStateChange() {
        if (this.listeners == null) {
            return;
        }
        ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(this.listeners);
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(changeEvent);
        }
    }

    private void initComponents() {
        this.valueButton = new JRadioButton();
        this.valueField = new JTextField();
        this.beanButton = new JRadioButton();
        this.beanCombo = new JComboBox();
        this.propertyButton = new JRadioButton();
        this.propertyLabel = new JTextField();
        this.propertyDetailsButton = new JButton();
        this.methodButton = new JRadioButton();
        this.methodLabel = new JTextField();
        this.methodDetailsButton = new JButton();
        this.codeButton = new JRadioButton();
        this.codeScrollPane = new JScrollPane();
        this.codeArea = FormEditor.createCodeEditorPane(this.formModel);
        this.paramLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.valueButton.setText("Value:");
        this.valueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.valueButton, gridBagConstraints);
        this.valueField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                ParametersPicker.this.updateState(caretEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.valueField, gridBagConstraints);
        this.beanButton.setText("Bean:");
        this.beanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.beanButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.beanCombo, gridBagConstraints);
        this.propertyButton.setText("Property:");
        this.propertyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.propertyButton, gridBagConstraints);
        this.propertyLabel.setEditable(false);
        this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.propertyLabel, gridBagConstraints);
        this.propertyDetailsButton.setText("...");
        this.propertyDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.propertyDetailsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.propertyDetailsButton, gridBagConstraints);
        this.methodButton.setText("Method Call:");
        this.methodButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.methodButton, gridBagConstraints);
        this.methodLabel.setEditable(false);
        this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.methodLabel, gridBagConstraints);
        this.methodDetailsButton.setText("...");
        this.methodDetailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.methodDetailsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.methodDetailsButton, gridBagConstraints);
        this.codeButton.setText("User Code:");
        this.codeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPicker.this.typeButtonPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.codeButton, gridBagConstraints);
        this.codeArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ParametersPicker.this.codeAreaMouseClicked(mouseEvent);
            }
        });
        this.codeArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                ParametersPicker.this.updateState(caretEvent);
            }
        });
        this.codeScrollPane.setViewportView(this.codeArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.codeScrollPane, gridBagConstraints);
        this.paramLabel.setText(FormUtils.getBundleString("CTL_CW_GetParametersFrom"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
    }

    private void codeAreaMouseClicked(MouseEvent mouseEvent) {
        if (!this.codeButton.isSelected()) {
            this.codeButton.doClick();
        }
    }

    private void methodDetailsButtonActionPerformed(ActionEvent actionEvent) {
        MethodPicker methodPicker = new MethodPicker(this.formModel, null, this.requiredType);
        methodPicker.setSelectedComponent(this.selectedComponent);
        methodPicker.setSelectedMethod(this.selectedMethod);
        String string = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectMethod", new Object[]{Utilities.getShortClassName(this.requiredType)});
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)methodPicker, string);
        dialogDescriptor.setValid(methodPicker.isPickerValid());
        methodPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = methodPicker.getSelectedComponent();
            MethodPicker.MethodPickerItem methodPickerItem = methodPicker.getSelectedMethod();
            this.selectedMethod = methodPickerItem.getMethodDescriptor();
            if (this.selectedMethod == null) {
                this.switchToCodeArea(methodPickerItem.getMethodName());
                return;
            }
            this.methodLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.methodLabel.setText(this.selectedMethod.getName());
            } else {
                this.methodLabel.setText(this.selectedComponent.getName() + "." + this.selectedMethod.getName());
            }
            this.methodLabel.repaint();
            this.fireStateChange();
        }
    }

    private void updateState(CaretEvent caretEvent) {
        this.fireStateChange();
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
    }

    private void propertyDetailsButtonActionPerformed(ActionEvent actionEvent) {
        if (this.propertyPicker == null) {
            this.propertyPicker = new PropertyPicker(this.formModel, null, this.requiredType);
        }
        this.propertyPicker.setSelectedComponent(this.selectedComponent);
        this.propertyPicker.setSelectedProperty(this.selectedProperty);
        String string = FormUtils.getFormattedBundleString("CTL_FMT_CW_SelectProperty", new Object[]{Utilities.getShortClassName(this.requiredType)});
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.propertyPicker, string);
        dialogDescriptor.setValid(this.propertyPicker.isPickerValid());
        this.propertyPicker.addPropertyChangeListener("pickerValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                dialogDescriptor.setValid(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.selectedComponent = this.propertyPicker.getSelectedComponent();
            PropertyPicker.PropertyPickerItem propertyPickerItem = this.propertyPicker.getSelectedProperty();
            this.selectedProperty = propertyPickerItem.getPropertyDescriptor();
            if (this.selectedProperty == null) {
                this.switchToCodeArea(propertyPickerItem.getReadMethodName());
                return;
            }
            this.propertyLabel.setEnabled(true);
            if (this.selectedComponent == this.formModel.getTopRADComponent()) {
                this.propertyLabel.setText(this.selectedProperty.getName());
            } else {
                this.propertyLabel.setText(this.selectedComponent.getName() + "." + this.selectedProperty.getName());
            }
            this.propertyLabel.repaint();
            this.fireStateChange();
        }
    }

    private void switchToCodeArea(String string) {
        this.codeArea.setText(string);
        this.codeButton.setSelected(true);
        this.updateParameterTypes();
    }

    private void typeButtonPressed(ActionEvent actionEvent) {
        this.updateParameterTypes();
        if (this.beanButton.isSelected()) {
            this.beanCombo.requestFocus();
        } else if (this.codeButton.isSelected()) {
            this.codeArea.requestFocus();
        } else if (this.propertyButton.isSelected()) {
            this.propertyDetailsButton.requestFocus();
        } else if (this.methodButton.isSelected()) {
            this.methodDetailsButton.requestFocus();
        } else if (this.valueButton.isSelected()) {
            this.valueField.requestFocus();
        }
    }

    private void updateParameterTypes() {
        this.valueField.setEnabled(this.valueButton.isSelected());
        this.beanCombo.setEnabled(this.beanButton.isSelected());
        if (!this.propertyButton.isSelected()) {
            this.propertyLabel.setText(FormUtils.getBundleString("CTL_CW_NoProperty"));
        }
        this.propertyLabel.setEnabled(this.propertyButton.isSelected());
        this.propertyLabel.repaint();
        this.propertyDetailsButton.setEnabled(this.propertyButton.isSelected());
        if (!this.methodButton.isSelected()) {
            this.methodLabel.setText(FormUtils.getBundleString("CTL_CW_NoMethod"));
        }
        this.methodLabel.setEnabled(this.methodButton.isSelected());
        this.methodLabel.repaint();
        this.methodDetailsButton.setEnabled(this.methodButton.isSelected());
        this.codeArea.setEnabled(this.codeButton.isSelected());
        this.codeArea.getCaret().setVisible(this.codeButton.isSelected() && this.codeArea.hasFocus());
        this.fireStateChange();
    }

    static class ComponentComparator
    implements Comparator<RADComponent> {
        ComponentComparator() {
        }

        @Override
        public int compare(RADComponent rADComponent, RADComponent rADComponent2) {
            if (rADComponent == rADComponent2) {
                return 0;
            }
            RADComponent rADComponent3 = rADComponent.getFormModel().getTopRADComponent();
            if (rADComponent == rADComponent3) {
                return -1;
            }
            if (rADComponent2 == rADComponent3) {
                return 1;
            }
            return rADComponent.getName().compareTo(rADComponent2.getName());
        }
    }
}

