/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.fakepeer.FakePeerContainer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

class ComponentLayer
extends JPanel {
    private static final int HORIZONTAL_MARGIN = 12;
    private static final int VERTICAL_MARGIN = 12;
    private Container componentContainer = new FakePeerContainer();
    private DesignerPanel designerPanel;

    ComponentLayer(FormModel formModel) {
        this.componentContainer.setLayout(new BorderLayout());
        this.componentContainer.setBackground(Color.white);
        this.componentContainer.setFont(FakePeerSupport.getDefaultAWTFont());
        this.designerPanel = new DesignerPanel(formModel);
        this.designerPanel.setLayout(new BorderLayout());
        this.designerPanel.add((Component)this.componentContainer, "Center");
        this.setLayout(new FlowLayout(0, 12, 12));
        this.add(this.designerPanel);
        this.updateBackground();
    }

    Container getComponentContainer() {
        return this.componentContainer;
    }

    Rectangle getDesignerInnerBounds() {
        Rectangle r = new Rectangle(this.designerPanel.getDesignerSize());
        Insets i = this.designerPanel.getInsets();
        r.x = 12 + i.left;
        r.y = 12 + i.top;
        return r;
    }

    Rectangle getDesignerOuterBounds() {
        return this.designerPanel.getBounds();
    }

    Insets getDesignerOutsets() {
        return this.designerPanel.getInsets();
    }

    Dimension getDesignerSize() {
        return this.designerPanel.getDesignerSize();
    }

    Dimension setDesignerSize(Dimension size) {
        if (size == null) {
            size = this.componentContainer.getComponent(0).getPreferredSize();
        }
        if (!size.equals(this.designerPanel.getDesignerSize())) {
            this.designerPanel.setDesignerSize(size);
        }
        return size;
    }

    void setTopDesignComponent(Component component) {
        if (this.componentContainer.getComponentCount() > 0) {
            this.componentContainer.removeAll();
        }
        this.componentContainer.add(component, "Center");
    }

    void updateVisualSettings() {
        this.updateBackground();
        this.designerPanel.updateBorder();
    }

    private void updateBackground() {
        this.setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
    }

    private static class DesignerPanel
    extends JPanel {
        private static int BORDER_THICKNESS = 4;
        private Dimension designerSize = new Dimension(400, 300);
        private FormModel formModel;

        DesignerPanel(FormModel formModel) {
            this.formModel = formModel;
            this.updateBorder();
        }

        void updateBorder() {
            this.setBorder(new LineBorder(FormLoaderSettings.getInstance().getFormDesignerBorderColor(), BORDER_THICKNESS));
        }

        Dimension getDesignerSize() {
            return this.designerSize;
        }

        void setDesignerSize(Dimension size) {
            this.designerSize = size;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = new Dimension(this.designerSize);
            Insets insets = this.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            try {
                FormLAF.setUseDesignerDefaults(this.formModel);
                super.paint(g);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                String msg = NbBundle.getMessage(ComponentLayer.class, (String)"MSG_Paiting_Exception");
                msg = "<html><b>" + msg + "</b><br><br>";
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                msg = msg + sw.toString().replaceAll("\n", "<br>");
                Insets insets = this.getInsets();
                JLabel label = new JLabel(msg);
                label.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
                label.setOpaque(true);
                label.setVerticalAlignment(1);
                label.setSize(this.getWidth() - (insets.left + insets.top), this.getHeight() - (insets.top + insets.bottom));
                Shape oldClip = g.getClip();
                Rectangle newClip = new Rectangle(insets.left, insets.top, label.getWidth(), label.getHeight());
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    newClip = newClip.intersection(clipBounds);
                }
                g.setClip(newClip);
                g.translate(insets.left, insets.top);
                label.paint(g);
                g.translate(-insets.left, -insets.top);
                g.setClip(oldClip);
            }
            finally {
                FormLAF.setUseDesignerDefaults(null);
            }
        }
    }
}

