/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import java.awt.Component;
import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.WebXMLRefactoringSupport;
import org.netbeans.modules.javacard.templates.ServletDeploymentVisualPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ServletDeploymentWizardPanel
implements WizardDescriptor.Panel {
    WizardDescriptor wizard;
    Collection<String> allServletNames;
    private ServletDeploymentVisualPanel component;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public ServletDeploymentWizardPanel(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project p = Templates.getProject((WizardDescriptor)wizard);
        final JCProject jcProject = (JCProject)p.getLookup().lookup(JCProject.class);
        if (jcProject != null) {
            ProjectManager.mutex().readAccess(new Runnable(){

                @Override
                public void run() {
                    FileObject webObj = jcProject.getProjectDirectory().getFileObject("WEB-INF/web.xml");
                    WebXMLRefactoringSupport web = WebXMLRefactoringSupport.fromFile(FileUtil.toFile((FileObject)webObj));
                    ServletDeploymentWizardPanel.this.allServletNames = web.getAllServletNames();
                }
            });
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ServletDeploymentVisualPanel(this);
        }
        return this.component;
    }

    public void setClassName(String className) {
        this.component.setClassName(className);
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        String servletName = this.component.getServletName();
        if (servletName.equals("")) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletDeploymentWizardPanel.class, (String)"LBL_servlet_name_empty"));
            return false;
        }
        if (this.allServletNames != null && this.allServletNames.contains(servletName)) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletDeploymentWizardPanel.class, (String)"LBL_servlet_name_exists"));
            return false;
        }
        if (!this.component.getUrlPattern().startsWith("/")) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ServletDeploymentWizardPanel.class, (String)"LBL_url_pattern_invalid"));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.component.setClassName(Templates.getTargetName((WizardDescriptor)wiz));
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        if (this.component.isAddInfoSelected()) {
            wiz.putProperty("urlPattern", (Object)this.component.getUrlPattern());
            wiz.putProperty("servletName", (Object)this.component.getServletName());
        }
    }
}

