/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectActionProvider;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class JCProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private JCProject project;

    public JCProjectOperations(JCProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        JCProjectOperations.addFile(projectDirectory, "nbproject", files);
        JCProjectOperations.addFile(projectDirectory, "build.xml", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        files.addAll(Arrays.asList(this.project.getRoots().getRoots()));
        JCProjectOperations.addFile(this.project.getProjectDirectory(), "META-INF", files);
        JCProjectOperations.addFile(this.project.getProjectDirectory(), this.project.kind() == ProjectKind.WEB ? "WEB-INF" : "APPLET-INF", files);
        return files;
    }

    public void notifyDeleting() throws IOException {
        JCProjectActionProvider ap = (JCProjectActionProvider)this.project.getLookup().lookup(JCProjectActionProvider.class);
        assert (ap != null);
        Properties p = new Properties();
        String[] targetNames = ((JCProjectActionProvider)this.project.getLookup().lookup(JCProjectActionProvider.class)).getTargetNames("clean", Lookup.EMPTY, new Properties());
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, String newName) {
        this.project.setName(newName);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, String nueName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        this.project.setName(nueName);
    }
}

