/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor;

import java.awt.Image;
import java.util.EventListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.editor.pub.J2MEDataObject;
import org.netbeans.modules.mobility.project.MIDletsCacheHelper;
import org.netbeans.modules.mobility.project.MIDletsCacheListener;
import org.openide.filesystems.FileObject;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;

public class J2MENode
extends FilterNode
implements MIDletsCacheListener {
    public static final Image entryPointImage = ImageUtilities.loadImage((String)"org/netbeans/modules/mobility/editor/resources/entrypoint.gif", (boolean)true);
    private final J2MEDataObject dao;
    private final Node node;
    private MIDletsCacheListener listener;

    public J2MENode(J2MEDataObject j2MEDataObject, Node node) {
        super(node);
        this.node = node;
        this.dao = j2MEDataObject;
    }

    public Image createIcon(int n) {
        ClassPath classPath;
        Image image = this.node.getIcon(n);
        Project project = FileOwnerQuery.getOwner((FileObject)this.dao.getPrimaryFile());
        if (project == null) {
            return image;
        }
        MIDletsCacheHelper mIDletsCacheHelper = (MIDletsCacheHelper)project.getLookup().lookup(MIDletsCacheHelper.class);
        if (mIDletsCacheHelper == null) {
            return image;
        }
        FileObject fileObject = this.dao.getPrimaryFile();
        if (fileObject == null) {
            return image;
        }
        if (this.listener == null) {
            this.listener = (MIDletsCacheListener)WeakListeners.create(MIDletsCacheListener.class, (EventListener)((Object)this), (Object)mIDletsCacheHelper);
            mIDletsCacheHelper.addMIDletsCacheListener(this.listener);
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            return image;
        }
        String string = classPath.getResourceName(fileObject, '.', false);
        if (mIDletsCacheHelper.contains(string) && image != null && entryPointImage != null) {
            image = ImageUtilities.mergeImages((Image)image, (Image)entryPointImage, (int)0, (int)0);
        }
        return image;
    }

    public Image getIcon(int n) {
        return this.createIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public void cacheChanged() {
        this.fireIconChange();
        this.fireOpenedIconChange();
    }
}

