/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.hyperlink;

import java.awt.Toolkit;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class ManifestHyperlinkProvider
implements HyperlinkProviderExt {
    public Set<HyperlinkType> getSupportedHyperlinkTypes() {
        return EnumSet.of(HyperlinkType.GO_TO_DECLARATION);
    }

    public boolean isHyperlinkPoint(Document doc, int offset, HyperlinkType type) {
        return this.getHyperlinkSpan(doc, offset, type) != null;
    }

    public int[] getHyperlinkSpan(Document doc, int offset, HyperlinkType type) {
        return ManifestHyperlinkProvider.getIdentifierSpan(doc, offset, null);
    }

    public void performClickAction(Document doc, int offset, HyperlinkType type) {
        EditCookie ec = this.getEditorCookie(doc, offset);
        if (ec != null) {
            ec.edit();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public String getTooltipText(Document doc, int offset, HyperlinkType type) {
        return null;
    }

    private EditCookie getEditorCookie(Document doc, int offset) {
        String name;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(Language.find((String)"text/x-manifest"));
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        FileObject fo = ManifestHyperlinkProvider.getFileObject(doc);
        FileObject props = ManifestHyperlinkProvider.findFile(fo, name = t.toString());
        if (props != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)props);
                return (EditCookie)dobj.getLookup().lookup(EditCookie.class);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static FileObject findFile(FileObject manifest, String path) {
        Project prj = FileOwnerQuery.getOwner((FileObject)manifest);
        if (prj == null) {
            return null;
        }
        Sources srcs = (Sources)prj.getLookup().lookup(Sources.class);
        SourceGroup[] grps = srcs.getSourceGroups("java");
        if (grps.length == 0) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)grps[0].getRootFolder(), (String)"classpath/source");
        path = path.trim();
        return cp.findResource(path);
    }

    public static int[] getIdentifierSpan(Document doc, int offset, Token[] token) {
        FileObject fo = ManifestHyperlinkProvider.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        if (prj == null) {
            return null;
        }
        NbModuleProvider module = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
        if (module == null) {
            return null;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence(Language.find((String)"text/x-manifest"));
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (!ts.moveNext()) {
            return null;
        }
        Token t = ts.token();
        if (ManifestHyperlinkProvider.findFile(fo, t.toString()) != null) {
            return new int[]{ts.offset(), ts.offset() + t.length()};
        }
        return null;
    }

    private static FileObject getFileObject(Document doc) {
        DataObject od = (DataObject)doc.getProperty("stream");
        return od != null ? od.getPrimaryFile() : null;
    }
}

