/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.xml.sax.SAXException;

public final class LayerHandle {
    private static final Map<Project, LayerHandle> layerHandleCache = new WeakHashMap<Project, LayerHandle>();
    private final Project project;
    private final FileObject layerXML;
    private FileSystem fs;
    private LayerUtils.SavableTreeEditorCookie cookie;
    private boolean autosave;

    public static LayerHandle forProject(Project project) {
        LayerHandle handle = layerHandleCache.get(project);
        if (handle == null) {
            handle = new LayerHandle(project, null);
            layerHandleCache.put(project, handle);
        }
        return handle;
    }

    public LayerHandle(Project project, FileObject layerXML) {
        this.project = project;
        this.layerXML = layerXML;
    }

    public FileSystem layer(boolean create) {
        return this.layer(create, null);
    }

    public synchronized FileSystem layer(boolean create, ClassPath cp) {
        if (this.fs == null) {
            FileObject xml = this.getLayerFile();
            if (xml == null) {
                if (!create) {
                    return new DualLayers(null);
                }
                try {
                    String layerSrcPath;
                    NbModuleProvider module = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
                    FileObject manifest = module.getManifestFile();
                    if (manifest != null && (layerSrcPath = ManifestManager.getInstance(Util.getManifest(manifest), false).getLayer()) == null) {
                        layerSrcPath = this.newLayerPath();
                        EditableManifest m = Util.loadManifest(manifest);
                        m.setAttribute("OpenIDE-Module-Layer", layerSrcPath, null);
                        Util.storeManifest(manifest, m);
                    }
                    xml = NbModuleProjectGenerator.createLayer(this.project.getProjectDirectory(), module.getResourceDirectoryPath(false) + '/' + this.newLayerPath());
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                    this.fs = FileUtil.createMemoryFileSystem();
                    return this.fs;
                }
            }
            try {
                this.cookie = LayerUtils.cookieForFile(xml);
                this.fs = new DualLayers((FileSystem)new WritableXMLFileSystem(xml.getURL(), this.cookie, cp));
            }
            catch (FileStateInvalidException e) {
                throw new AssertionError((Object)e);
            }
            this.cookie.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (LayerHandle.this.autosave && "dirty".equals(evt.getPropertyName())) {
                        try {
                            LayerHandle.this.save();
                        }
                        catch (IOException e) {
                            Util.err.notify(1, (Throwable)e);
                        }
                    }
                }
            });
        }
        return this.fs;
    }

    public void save() throws IOException {
        if (this.cookie == null) {
            throw new IOException("Cannot save a nonexistent layer");
        }
        this.cookie.save();
    }

    public FileObject getLayerFile() {
        if (this.layerXML != null) {
            return this.layerXML;
        }
        NbModuleProvider module = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
        if (module == null) {
            return null;
        }
        Manifest mf = Util.getManifest(module.getManifestFile());
        if (mf == null) {
            return null;
        }
        String path = ManifestManager.getInstance(mf, false).getLayer();
        if (path == null) {
            return null;
        }
        FileObject ret = Util.getResourceDirectory(this.project);
        return ret == null ? null : ret.getFileObject(path);
    }

    public void setAutosave(boolean autosave) {
        this.autosave = autosave;
        if (autosave && this.cookie != null) {
            try {
                this.cookie.save();
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
    }

    public boolean isAutosave() {
        return this.autosave;
    }

    private String newLayerPath() {
        String bundlePath;
        NbModuleProvider module = (NbModuleProvider)this.project.getLookup().lookup(NbModuleProvider.class);
        FileObject manifest = module.getManifestFile();
        if (manifest != null && (bundlePath = ManifestManager.getInstance(Util.getManifest(manifest), false).getLocalizingBundle()) != null) {
            return bundlePath.replaceFirst("/[^/]+$", "/layer.xml");
        }
        return module.getCodeNameBase().replace('.', '/') + "/layer.xml";
    }

    public String toString() {
        FileObject layer = this.getLayerFile();
        if (layer != null) {
            return FileUtil.getFileDisplayName((FileObject)layer);
        }
        return FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
    }

    private final class DualLayers
    extends MultiFileSystem
    implements FileChangeListener {
        private final FileSystem explicit;
        private final File generated;

        DualLayers(FileSystem explicit) {
            this.explicit = explicit;
            if (LayerHandle.this.project instanceof NbModuleProject) {
                this.generated = new File(((NbModuleProject)LayerHandle.this.project).getClassesDirectory(), "META-INF/generated-layer.xml");
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)this.generated);
            } else {
                this.generated = null;
            }
            this.configure();
            this.setPropagateMasks(true);
        }

        private void configure() {
            ArrayList<Object> layers = new ArrayList<Object>(2);
            if (this.explicit != null) {
                layers.add(this.explicit);
            }
            if (this.generated != null && this.generated.isFile()) {
                try {
                    layers.add(new XMLFileSystem(this.generated.toURI().toString()));
                }
                catch (SAXException x) {
                    Logger.getLogger(DualLayers.class.getName()).log(Level.INFO, "could not load " + this.generated, x);
                }
            }
            this.setDelegates(layers.toArray(new FileSystem[layers.size()]));
        }

        public void fileDataCreated(FileEvent fe) {
            this.configure();
        }

        public void fileChanged(FileEvent fe) {
            this.configure();
        }

        public void fileDeleted(FileEvent fe) {
            this.configure();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.configure();
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

