/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public final class CreatedModifiedFiles {
    private final SortedSet<String> createdPaths = new TreeSet<String>();
    private final SortedSet<String> modifiedPaths = new TreeSet<String>();
    private final SortedSet<String> invalidPaths = new TreeSet<String>();
    private final Project project;
    private final List<Operation> operations = new ArrayList<Operation>();
    private LayerHandle layerHandle;

    LayerHandle getLayerHandle() {
        if (this.layerHandle == null) {
            this.layerHandle = LayerHandle.forProject(this.project);
        }
        return this.layerHandle;
    }

    public CreatedModifiedFiles(Project project) {
        this.project = project;
    }

    public void add(Operation operation) {
        this.operations.add(operation);
        this.createdPaths.addAll(Arrays.asList(operation.getCreatedPaths()));
        this.modifiedPaths.addAll(Arrays.asList(operation.getModifiedPaths()));
        this.invalidPaths.addAll(Arrays.asList(operation.getInvalidPaths()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        boolean oldAutosave = false;
        if (this.layerHandle != null) {
            oldAutosave = this.layerHandle.isAutosave();
            this.layerHandle.setAutosave(false);
        }
        try {
            for (Operation op : this.operations) {
                op.run();
            }
            if (this.layerHandle != null) {
                this.layerHandle.save();
            }
        }
        finally {
            if (this.layerHandle != null) {
                this.layerHandle.setAutosave(oldAutosave);
            }
        }
    }

    public String[] getCreatedPaths() {
        if (this.createdPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.createdPaths.size()];
        return this.createdPaths.toArray(s);
    }

    public String[] getModifiedPaths() {
        if (this.modifiedPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.modifiedPaths.size()];
        return this.modifiedPaths.toArray(s);
    }

    public String[] getInvalidPaths() {
        if (this.invalidPaths == null) {
            return new String[0];
        }
        String[] s = new String[this.invalidPaths.size()];
        return this.invalidPaths.toArray(s);
    }

    public static FileObject getTemplate(String name) {
        FileObject f = FileUtil.getConfigFile((String)("Templates/NetBeansModuleDevelopment-files/" + name));
        assert (f != null) : name;
        return f;
    }

    public Operation createFile(String path, FileObject content) {
        return CreatedModifiedFilesFactory.createFile(this.project, path, content);
    }

    public Operation createFileWithSubstitutions(String path, FileObject content, Map<String, String> tokens) {
        if (tokens == null) {
            throw new NullPointerException();
        }
        return CreatedModifiedFilesFactory.createFileWithSubstitutions(this.project, path, content, tokens);
    }

    public Operation bundleKey(String bundlePath, String key, String value) {
        return CreatedModifiedFilesFactory.bundleKey(this.project, key, value, bundlePath);
    }

    public Operation bundleKeyDefaultBundle(String key, String value) {
        return CreatedModifiedFilesFactory.bundleKeyDefaultBundle(this.project, key, value);
    }

    public Operation addLoaderSection(String dataLoaderClass, String installBefore) {
        return CreatedModifiedFilesFactory.addLoaderSection(this.project, dataLoaderClass, installBefore);
    }

    public Operation addLookupRegistration(String interfaceClass, String implClass, boolean inTests) {
        return CreatedModifiedFilesFactory.addLookupRegistration(this.project, interfaceClass, implClass, inTests);
    }

    public Operation addModuleDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) {
        return CreatedModifiedFilesFactory.addModuleDependency(this.project, codeNameBase, releaseVersion, version, useInCompiler);
    }

    public Operation addModuleDependency(String codeNameBase) {
        return this.addModuleDependency(codeNameBase, null, null, true);
    }

    public Operation createLayerEntry(String layerPath, FileObject content, Map<String, String> substitutionTokens, String localizedDisplayName, Map<String, Object> fileAttributes) {
        return CreatedModifiedFilesFactory.createLayerEntry(this, this.project, layerPath, content, substitutionTokens, localizedDisplayName, fileAttributes);
    }

    public Operation manifestModification(String section, Map<String, String> attributes) {
        return CreatedModifiedFilesFactory.manifestModification(this.project, section, attributes);
    }

    public Operation addManifestToken(final String header, final String token) {
        return new CreatedModifiedFilesFactory.ModifyManifest(this.project){
            {
                super(x0);
                this.setAttribute(header, token, null);
            }

            @Override
            protected void performModification(EditableManifest em, String name, String value, String section) throws IllegalArgumentException {
                String originalValue = em.getAttribute(name, section);
                if (originalValue != null) {
                    if (!Arrays.asList(originalValue.split("[, ]+")).contains(value)) {
                        em.setAttribute(name, originalValue + ", " + value, section);
                    }
                } else {
                    super.performModification(em, name, value, section);
                }
            }
        };
    }

    public Operation propertiesModification(String propertyPath, Map<String, String> properties) {
        return CreatedModifiedFilesFactory.propertiesModification(this.project, propertyPath, properties);
    }

    public Operation createLayerAttribute(final String parentPath, final String attrName, final Object attrValue) {
        return this.layerModifications(new LayerOperation(){

            @Override
            public void run(FileSystem layer) throws IOException {
                FileObject f = layer.findResource(parentPath);
                if (f == null) {
                    throw new IOException(parentPath);
                }
                f.setAttribute(attrName, attrValue);
            }
        }, Collections.<String>emptySet());
    }

    public Operation orderLayerEntry(final String layerPath, final String precedingItemName, final String newItemName, final String followingItemName) {
        return this.layerModifications(new LayerOperation(){

            @Override
            public void run(FileSystem layer) throws IOException {
                FileObject f = layer.findResource(layerPath);
                if (f == null) {
                    throw new IOException("No such folder " + layerPath);
                }
                FileObject merged = LayerUtils.getEffectiveSystemFilesystem(CreatedModifiedFiles.this.project).findResource(layerPath);
                assert (merged != null) : layerPath;
                Integer beforePos = this.getPosition(merged, precedingItemName);
                Integer afterPos = this.getPosition(merged, followingItemName);
                if (beforePos != null && afterPos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)((beforePos + afterPos) / 2));
                } else if (beforePos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)(beforePos + 100));
                } else if (afterPos != null) {
                    f.getFileObject(newItemName).setAttribute("position", (Object)(afterPos - 100));
                } else {
                    if (precedingItemName != null) {
                        f.setAttribute(precedingItemName + '/' + newItemName, (Object)true);
                    }
                    if (followingItemName != null) {
                        f.setAttribute(newItemName + '/' + followingItemName, (Object)true);
                    }
                }
            }

            private Integer getPosition(FileObject folder, String name) {
                if (name == null) {
                    return null;
                }
                FileObject f = folder.getFileObject(name);
                if (f == null) {
                    return null;
                }
                Object pos = f.getAttribute("position");
                return pos instanceof Integer ? (Integer)pos : null;
            }
        }, Collections.<String>emptySet());
    }

    public Operation layerModifications(LayerOperation op, Set<String> externalFiles) {
        return CreatedModifiedFilesFactory.layerModifications(this.project, op, externalFiles, this);
    }

    public Operation packageInfo(String packageName, Map<String, Map<String, Object>> annotations) {
        return CreatedModifiedFilesFactory.packageInfo(this.project, packageName, annotations);
    }

    public static interface LayerOperation {
        public void run(FileSystem var1) throws IOException;
    }

    public static interface Operation {
        public void run() throws IOException;

        public String[] getModifiedPaths();

        public String[] getCreatedPaths();

        public String[] getInvalidPaths();
    }
}

