/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.util.LMListener;
import org.netbeans.modules.parsing.impl.indexing.lucene.IndexCacheFactory;
import org.netbeans.modules.parsing.impl.indexing.lucene.util.Evictable;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

class LuceneIndex
extends Index
implements Evictable {
    private static final boolean debugIndexMerging = Boolean.getBoolean("java.index.debugMerge");
    private static final boolean useMemoryCache = Boolean.getBoolean("java.index.useMemCache");
    private static final String REFERENCES = "refs";
    private static final Logger LOGGER = Logger.getLogger(LuceneIndex.class.getName());
    private static final String CACHE_LOCK_PREFIX = "nb-lock";
    private static final RequestProcessor RP = new RequestProcessor(LuceneIndex.class.getName(), 1);
    private final File refCacheRoot;
    private Directory directory;
    private Long rootTimeStamp;
    private IndexReader reader;
    private Set<String> rootPkgCache;
    private Analyzer analyzer;
    private volatile boolean closed;
    private volatile Boolean validCache;
    private Directory memCacheDir;

    static Index create(File cacheRoot) throws IOException {
        assert (cacheRoot != null && cacheRoot.exists() && cacheRoot.canRead() && cacheRoot.canWrite());
        return new LuceneIndex(LuceneIndex.getReferencesCacheFolder(cacheRoot));
    }

    private LuceneIndex(File refCacheRoot) throws IOException {
        assert (refCacheRoot != null);
        this.refCacheRoot = refCacheRoot;
        this.directory = LuceneIndex.createDirectory(this.refCacheRoot);
        PerFieldAnalyzerWrapper _analyzer = new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer());
        _analyzer.addAnalyzer(DocumentUtil.identTerm("").field(), (Analyzer)new WhitespaceAnalyzer());
        _analyzer.addAnalyzer(DocumentUtil.featureIdentTerm("").field(), (Analyzer)new WhitespaceAnalyzer());
        _analyzer.addAnalyzer(DocumentUtil.caseInsensitiveFeatureIdentTerm("").field(), (Analyzer)new DocumentUtil.LCWhitespaceAnalyzer());
        this.analyzer = _analyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getUsagesFQN(String resourceName, Set<ClassIndexImpl.UsageType> mask, Index.BooleanOperator operator) throws IOException, InterruptedException {
        this.checkPreconditions();
        AtomicBoolean cancel = (AtomicBoolean)LuceneIndex.cancel.get();
        assert (cancel != null);
        assert (resourceName != null);
        assert (mask != null);
        assert (operator != null);
        IndexReader in = this.getReader();
        if (in == null) {
            return null;
        }
        IndexSearcher searcher = new IndexSearcher(in);
        try {
            WildcardQuery query;
            LinkedList<String> result = new LinkedList<String>();
            switch (operator) {
                case AND: {
                    query = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, mask));
                    break;
                }
                case OR: {
                    BooleanQuery booleanQuery = new BooleanQuery();
                    for (ClassIndexImpl.UsageType ut : mask) {
                        WildcardQuery subQuery = new WildcardQuery(DocumentUtil.referencesTerm(resourceName, EnumSet.of(ut)));
                        booleanQuery.add((Query)subQuery, BooleanClause.Occur.SHOULD);
                    }
                    query = booleanQuery;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(operator.toString());
                }
            }
            if (cancel.get()) {
                throw new InterruptedException();
            }
            Hits hits = searcher.search((Query)query);
            Iterator it = hits.iterator();
            while (it.hasNext()) {
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                Hit hit = (Hit)it.next();
                Document doc = hit.getDocument();
                String user = DocumentUtil.getBinaryName(doc);
                result.add(user);
            }
            LinkedList<String> linkedList = result;
            return linkedList;
        }
        finally {
            searcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSourceName(String resourceName) throws IOException {
        this.checkPreconditions();
        IndexReader in = this.getReader();
        if (in == null) {
            return null;
        }
        IndexSearcher searcher = new IndexSearcher(in);
        try {
            Hits hits = searcher.search(DocumentUtil.binaryNameQuery(resourceName));
            if (hits.length() == 0) {
                String string = null;
                return string;
            }
            Hit hit = (Hit)hits.iterator().next();
            String string = DocumentUtil.getSourceName(hit.getDocument());
            return string;
        }
        finally {
            searcher.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void getDeclaredTypes(String name, ClassIndex.NameKind kind, ResultConvertor<T> convertor, Set<? super T> result) throws IOException, InterruptedException {
        this.checkPreconditions();
        IndexReader in = this.getReader();
        if (in == null) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        AtomicBoolean cancel = (AtomicBoolean)LuceneIndex.cancel.get();
        assert (cancel != null);
        assert (name != null);
        TreeSet<Term> toSearch = new TreeSet<Term>(new TermComparator());
        switch (kind) {
            case SIMPLE_NAME: {
                toSearch.add(DocumentUtil.simpleNameTerm(name));
                break;
            }
            case PREFIX: {
                if (name.length() == 0) {
                    this.emptyPrefixSearch(in, convertor, result, cancel);
                    return;
                }
                Term nameTerm = DocumentUtil.simpleNameTerm(name);
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                if (name.length() == 0) {
                    this.emptyPrefixSearch(in, convertor, result, cancel);
                    return;
                }
                Term nameTerm = DocumentUtil.caseInsensitiveNameTerm(name.toLowerCase());
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                break;
            }
            case CAMEL_CASE: {
                int index;
                if (name.length() == 0) {
                    throw new IllegalArgumentException();
                }
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = name.substring(lastIndex, (index = LuceneIndex.findNextUpper(name, lastIndex + 1)) == -1 ? name.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(prefix), in, toSearch, cancel, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                if (name.length() == 0) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(name, 2);
                if (Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.regExpSearch(pattern, DocumentUtil.caseInsensitiveNameTerm(name.toLowerCase()), in, toSearch, cancel, false);
                    break;
                }
                this.regExpSearch(pattern, DocumentUtil.caseInsensitiveNameTerm(""), in, toSearch, cancel, false);
                break;
            }
            case REGEXP: {
                if (name.length() == 0) {
                    throw new IllegalArgumentException();
                }
                Pattern pattern = Pattern.compile(name);
                if (Character.isJavaIdentifierStart(name.charAt(0))) {
                    this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(name), in, toSearch, cancel, true);
                    break;
                }
                this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(""), in, toSearch, cancel, true);
                break;
            }
            case CAMEL_CASE_INSENSITIVE: {
                int index;
                if (name.length() == 0) {
                    this.emptyPrefixSearch(in, convertor, result, cancel);
                    return;
                }
                Term nameTerm = DocumentUtil.caseInsensitiveNameTerm(name.toLowerCase());
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = name.substring(lastIndex, (index = LuceneIndex.findNextUpper(name, lastIndex + 1)) == -1 ? name.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                this.regExpSearch(pattern, DocumentUtil.simpleNameTerm(prefix), in, toSearch, cancel, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        LOGGER.fine(String.format("LuceneIndex.getDeclaredTypes[%s] returned %d elements\n", this.toString(), toSearch.size()));
        ElementKind[] kindHolder = new ElementKind[1];
        TreeSet<Integer> docNums = new TreeSet<Integer>();
        TermDocs tds = in.termDocs();
        try {
            int[] docs = new int[25];
            int[] freq = new int[25];
            for (Term t : toSearch) {
                int len;
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                tds.seek(t);
                while ((len = tds.read(docs, freq)) > 0) {
                    for (int i = 0; i < len; ++i) {
                        docNums.add(docs[i]);
                    }
                }
            }
        }
        finally {
            tds.close();
        }
        for (Integer docNum : docNums) {
            if (cancel.get()) {
                throw new InterruptedException();
            }
            Document doc = in.document(docNum.intValue(), DocumentUtil.declaredTypesFieldSelector());
            String binaryName = DocumentUtil.getBinaryName(doc, kindHolder);
            T value = convertor.convert(kindHolder[0], binaryName);
            if (value == null) continue;
            result.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void getDeclaredElements(String ident, ClassIndex.NameKind kind, ResultConvertor<T> convertor, Map<T, Set<String>> result) throws IOException, InterruptedException {
        this.checkPreconditions();
        IndexReader in = this.getReader();
        if (in == null) {
            LOGGER.fine(String.format("LuceneIndex[%s] is invalid!\n", this.toString()));
            return;
        }
        AtomicBoolean cancel = (AtomicBoolean)LuceneIndex.cancel.get();
        assert (cancel != null);
        Parameters.notNull((CharSequence)"ident", (Object)ident);
        Parameters.notEmpty((CharSequence)"ident", (CharSequence)ident);
        TreeSet<Term> toSearch = new TreeSet<Term>(new TermComparator());
        switch (kind) {
            case SIMPLE_NAME: {
                toSearch.add(DocumentUtil.featureIdentTerm(ident));
                break;
            }
            case PREFIX: {
                Term nameTerm = DocumentUtil.featureIdentTerm(ident);
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                Term nameTerm = DocumentUtil.caseInsensitiveFeatureIdentTerm(ident.toLowerCase());
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                break;
            }
            case REGEXP: {
                Pattern pattern = Pattern.compile(ident);
                if (Character.isJavaIdentifierStart(ident.charAt(0))) {
                    this.regExpSearch(pattern, DocumentUtil.featureIdentTerm(ident), in, toSearch, cancel, true);
                    break;
                }
                this.regExpSearch(pattern, DocumentUtil.featureIdentTerm(""), in, toSearch, cancel, true);
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                Pattern pattern = Pattern.compile(ident, 2);
                if (Character.isJavaIdentifierStart(ident.charAt(0))) {
                    this.regExpSearch(pattern, DocumentUtil.caseInsensitiveFeatureIdentTerm(ident.toLowerCase()), in, toSearch, cancel, false);
                    break;
                }
                this.regExpSearch(pattern, DocumentUtil.caseInsensitiveFeatureIdentTerm(""), in, toSearch, cancel, false);
                break;
            }
            case CAMEL_CASE: {
                int index;
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = ident.substring(lastIndex, (index = LuceneIndex.findNextUpper(ident, lastIndex + 1)) == -1 ? ident.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                this.regExpSearch(pattern, DocumentUtil.featureIdentTerm(prefix), in, toSearch, cancel, true);
                break;
            }
            case CAMEL_CASE_INSENSITIVE: {
                int index;
                Term nameTerm = DocumentUtil.caseInsensitiveFeatureIdentTerm(ident.toLowerCase());
                this.prefixSearh(nameTerm, in, toSearch, cancel);
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                int lastIndex = 0;
                do {
                    String token = ident.substring(lastIndex, (index = LuceneIndex.findNextUpper(ident, lastIndex + 1)) == -1 ? ident.length() : index);
                    if (lastIndex == 0) {
                        prefix = token;
                    }
                    sb.append(token);
                    sb.append(index != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                    lastIndex = index;
                } while (index != -1);
                Pattern pattern = Pattern.compile(sb.toString());
                this.regExpSearch(pattern, DocumentUtil.featureIdentTerm(prefix), in, toSearch, cancel, true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        LOGGER.fine(String.format("LuceneIndex.getDeclaredElements[%s] returned %d elements\n", this.toString(), toSearch.size()));
        ElementKind[] kindHolder = new ElementKind[1];
        HashMap<Integer, HashSet<String>> docNums = new HashMap<Integer, HashSet<String>>();
        TermDocs tds = in.termDocs();
        try {
            int[] docs = new int[25];
            int[] freq = new int[25];
            for (Term t : toSearch) {
                int len;
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                tds.seek(t);
                while ((len = tds.read(docs, freq)) > 0) {
                    for (int i = 0; i < len; ++i) {
                        HashSet<String> row = (HashSet<String>)docNums.get(docs[i]);
                        if (row == null) {
                            row = new HashSet<String>();
                            docNums.put(docs[i], row);
                        }
                        row.add(t.text());
                    }
                }
            }
        }
        finally {
            tds.close();
        }
        for (Map.Entry docNum : docNums.entrySet()) {
            if (cancel.get()) {
                throw new InterruptedException();
            }
            Document doc = in.document(((Integer)docNum.getKey()).intValue(), DocumentUtil.declaredTypesFieldSelector());
            String binaryName = DocumentUtil.getBinaryName(doc, kindHolder);
            T key = convertor.convert(kindHolder[0], binaryName);
            if (key == null) continue;
            result.put(key, (Set<String>)docNum.getValue());
        }
    }

    public void evicted() {
        if (!useMemoryCache) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                            @Override
                            public Void run() throws IOException, InterruptedException {
                                LuceneIndex.this.close(false);
                                LOGGER.fine("Evicted index: " + LuceneIndex.this.refCacheRoot.getAbsolutePath());
                                return null;
                            }
                        });
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (InterruptedException ie) {
                        Exceptions.printStackTrace((Throwable)ie);
                    }
                }
            });
        }
    }

    private void _hit() {
        if (!useMemoryCache) {
            try {
                URL url = this.refCacheRoot.toURI().toURL();
                IndexCacheFactory.getDefault().getCache().put((Object)url, (Evictable)this);
            }
            catch (MalformedURLException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private static int findNextUpper(String text, int offset) {
        for (int i = offset; i < text.length(); ++i) {
            if (!Character.isUpperCase(text.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void regExpSearch(Pattern pattern, Term startTerm, IndexReader in, Set<Term> toSearch, AtomicBoolean cancel, boolean caseSensitive) throws IOException, InterruptedException {
        String startPrefix;
        String startText = startTerm.text();
        if (startText.length() > 0) {
            char c;
            StringBuilder startBuilder = new StringBuilder();
            startBuilder.append(startText.charAt(0));
            for (int i = 1; i < startText.length() && Character.isJavaIdentifierPart(c = startText.charAt(i)); ++i) {
                startBuilder.append(c);
            }
            startPrefix = startBuilder.toString();
            startTerm = new Term(startTerm.field(), startPrefix);
        } else {
            startPrefix = startText;
        }
        String camelField = startTerm.field();
        TermEnum en = in.terms(startTerm);
        try {
            do {
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                Term term = en.term();
                if (term == null || camelField != term.field() || !term.text().startsWith(startPrefix)) return;
                Matcher m = pattern.matcher(term.text());
                if (!m.matches()) continue;
                toSearch.add(term);
            } while (en.next());
            return;
        }
        finally {
            en.close();
        }
    }

    private <T> void emptyPrefixSearch(IndexReader in, ResultConvertor<T> convertor, Set<? super T> result, AtomicBoolean cancel) throws IOException, InterruptedException {
        int bound = in.maxDoc();
        ElementKind[] kindHolder = new ElementKind[1];
        for (int i = 0; i < bound; ++i) {
            T value;
            String binaryName;
            Document doc;
            if (cancel.get()) {
                throw new InterruptedException();
            }
            if (in.isDeleted(i) || (doc = in.document(i, DocumentUtil.declaredTypesFieldSelector())) == null || (binaryName = DocumentUtil.getBinaryName(doc, kindHolder)) == null || (value = convertor.convert(kindHolder[0], binaryName)) == null) continue;
            result.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void prefixSearh(Term nameTerm, IndexReader in, Set<Term> toSearch, AtomicBoolean cancel) throws IOException, InterruptedException {
        String prefixField = nameTerm.field();
        String name = nameTerm.text();
        TermEnum en = in.terms(nameTerm);
        try {
            do {
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                Term term = en.term();
                if (term == null || prefixField != term.field() || !term.text().startsWith(name)) return;
                toSearch.add(term);
            } while (en.next());
            return;
        }
        finally {
            en.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void getPackageNames(String prefix, boolean directOnly, Set<String> result) throws IOException, InterruptedException {
        this.checkPreconditions();
        if (directOnly && this.rootPkgCache != null && prefix.length() == 0) {
            result.addAll(this.rootPkgCache);
            return;
        }
        IndexReader in = this.getReader();
        if (in == null) {
            return;
        }
        AtomicBoolean cancel = (AtomicBoolean)LuceneIndex.cancel.get();
        assert (cancel != null);
        Term pkgTerm = DocumentUtil.packageNameTerm(prefix);
        String prefixField = pkgTerm.field();
        if (prefix.length() == 0) {
            if (directOnly) {
                this.rootPkgCache = new HashSet<String>();
            }
            TermEnum terms = in.terms();
            try {
                do {
                    if (cancel.get()) {
                        throw new InterruptedException();
                    }
                    Term currentTerm = terms.term();
                    if (currentTerm == null || prefixField != currentTerm.field()) continue;
                    String pkgName = currentTerm.text();
                    if (directOnly) {
                        int index = pkgName.indexOf(46, prefix.length());
                        if (index > 0) {
                            pkgName = pkgName.substring(0, index);
                        }
                        this.rootPkgCache.add(pkgName);
                    }
                    result.add(pkgName);
                } while (terms.next());
                return;
            }
            finally {
                terms.close();
            }
        }
        TermEnum terms = in.terms(pkgTerm);
        try {
            do {
                int index;
                if (cancel.get()) {
                    throw new InterruptedException();
                }
                Term currentTerm = terms.term();
                if (currentTerm == null || prefixField != currentTerm.field() || !currentTerm.text().startsWith(prefix)) return;
                String pkgName = currentTerm.text();
                if (directOnly && (index = pkgName.indexOf(46, prefix.length())) > 0) {
                    pkgName = pkgName.substring(0, index);
                }
                result.add(pkgName);
            } while (terms.next());
            return;
        }
        finally {
            terms.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUpToDate(String resourceName, long timeStamp) throws IOException {
        this.checkPreconditions();
        IndexReader in = this.getReader();
        if (in == null) {
            return false;
        }
        try {
            IndexSearcher searcher = new IndexSearcher(in);
            try {
                Hits hits;
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        if (this.rootTimeStamp != null) {
                            boolean bl = this.rootTimeStamp >= timeStamp;
                            return bl;
                        }
                    }
                    hits = searcher.search((Query)new TermQuery(DocumentUtil.rootDocumentTerm()));
                } else {
                    hits = searcher.search(DocumentUtil.binaryNameQuery(resourceName));
                }
                if (hits.length() != 1) {
                    boolean bl = false;
                    return bl;
                }
                Hit hit = (Hit)hits.iterator().next();
                long cacheTime = DocumentUtil.getTimeStamp(hit.getDocument());
                if (resourceName == null) {
                    LuceneIndex luceneIndex = this;
                    synchronized (luceneIndex) {
                        this.rootTimeStamp = new Long(cacheTime);
                    }
                }
                boolean bl = cacheTime >= timeStamp;
                return bl;
            }
            finally {
                searcher.close();
            }
        }
        catch (IOException ioe) {
            this.clear();
            return false;
        }
    }

    @Override
    public void store(final Map<Pair<String, String>, Object[]> refs, final List<Pair<String, String>> topLevels) throws IOException {
        try {
            ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    LuceneIndex.this._store((Map<Pair<String, String>, Object[]>)refs, topLevels);
                    LuceneIndex.this.validCache = true;
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(Map<Pair<String, String>, Object[]> refs, List<Pair<String, String>> topLevels) throws IOException {
        this.checkPreconditions();
        assert (ClassIndexManager.getDefault().holdsWriteLock());
        this.rootPkgCache = null;
        boolean create = !this.exists();
        long timeStamp = System.currentTimeMillis();
        IndexWriter out = this.getWriter(create);
        try {
            if (!create) {
                for (Pair<String, String> topLevel : topLevels) {
                    out.deleteDocuments(DocumentUtil.binaryContentNameQuery(topLevel));
                }
                out.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            this.storeData(out, refs, timeStamp, false);
        }
        finally {
            try {
                out.close();
            }
            finally {
                this.refreshReader();
            }
        }
    }

    @Override
    public void store(final Map<Pair<String, String>, Object[]> refs, final Set<Pair<String, String>> toDelete) throws IOException {
        try {
            ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    LuceneIndex.this._store((Map<Pair<String, String>, Object[]>)refs, toDelete);
                    LuceneIndex.this.validCache = true;
                    return null;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException("Interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _store(Map<Pair<String, String>, Object[]> refs, Set<Pair<String, String>> toDelete) throws IOException {
        this.checkPreconditions();
        assert (ClassIndexManager.getDefault().holdsWriteLock());
        this.rootPkgCache = null;
        boolean create = !this.exists();
        long timeStamp = System.currentTimeMillis();
        IndexWriter out = this.getWriter(create);
        try {
            if (!create) {
                for (Pair<String, String> toDeleteItem : toDelete) {
                    out.deleteDocuments(DocumentUtil.binaryNameSourceNamePairQuery(toDeleteItem));
                }
                out.deleteDocuments(DocumentUtil.rootDocumentTerm());
            }
            this.storeData(out, refs, timeStamp, true);
        }
        finally {
            try {
                out.close();
            }
            finally {
                this.refreshReader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeData(IndexWriter out, Map<Pair<String, String>, Object[]> refs, long timeStamp, boolean optimize) throws IOException {
        LuceneIndexMBeanImpl indexSettings;
        if (debugIndexMerging) {
            out.setInfoStream(System.err);
        }
        if ((indexSettings = LuceneIndexMBeanImpl.getDefault()) != null) {
            out.setMergeFactor(indexSettings.getMergeFactor());
            out.setMaxMergeDocs(indexSettings.getMaxMergeDocs());
            out.setMaxBufferedDocs(indexSettings.getMaxBufferedDocs());
        }
        LMListener lmListener = new LMListener();
        RAMDirectory memDir = null;
        IndexWriter activeOut = null;
        if (lmListener.isLowMemory()) {
            activeOut = out;
        } else {
            memDir = new RAMDirectory();
            activeOut = new IndexWriter((Directory)memDir, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
        }
        activeOut.addDocument(DocumentUtil.createRootTimeStampDocument(timeStamp));
        Iterator<Map.Entry<Pair<String, String>, Object[]>> it = refs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Pair<String, String>, Object[]> refsEntry = it.next();
            it.remove();
            Pair<String, String> pair = refsEntry.getKey();
            String cn = (String)pair.first;
            String srcName = (String)pair.second;
            Object[] data = refsEntry.getValue();
            List cr = (List)data[0];
            String fids = (String)data[1];
            String ids = (String)data[2];
            Document newDoc = DocumentUtil.createDocument(cn, timeStamp, cr, fids, ids, srcName);
            activeOut.addDocument(newDoc);
            if (memDir == null || !lmListener.isLowMemory()) continue;
            activeOut.close();
            out.addIndexesNoOptimize(new Directory[]{memDir});
            memDir = new RAMDirectory();
            activeOut = new IndexWriter((Directory)memDir, this.analyzer, true, IndexWriter.MaxFieldLength.LIMITED);
        }
        if (memDir != null) {
            activeOut.close();
            out.addIndexesNoOptimize(new Directory[]{memDir});
            activeOut = null;
            memDir = null;
        }
        if (optimize) {
            out.optimize(false);
        }
        LuceneIndex luceneIndex = this;
        synchronized (luceneIndex) {
            this.rootTimeStamp = new Long(timeStamp);
        }
    }

    @Override
    public boolean isValid(boolean force) throws IOException {
        this.checkPreconditions();
        Boolean valid = this.validCache;
        if (force || valid == null) {
            Collection<? extends String> locks = this.getOrphanLock();
            boolean res = false;
            if (!locks.isEmpty()) {
                LOGGER.warning("Broken (locked) index folder: " + this.refCacheRoot.getAbsolutePath());
                for (String string : locks) {
                    this.directory.deleteFile(string);
                }
                if (force) {
                    this.clear();
                }
            } else {
                res = this.exists();
                if (res && force) {
                    try {
                        this.getReader();
                    }
                    catch (IOException e) {
                        res = false;
                        this.clear();
                    }
                    catch (RuntimeException e) {
                        res = false;
                        this.clear();
                    }
                }
            }
            this.validCache = valid = Boolean.valueOf(res);
        }
        return valid;
    }

    @Override
    public void clear() throws IOException {
        try {
            this.checkPreconditions();
            ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    LuceneIndex.this._clear();
                    return null;
                }
            });
        }
        catch (InterruptedException ex) {
            IOException newException = new IOException();
            newException.initCause(ex);
            throw newException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _clear() throws IOException {
        block11: {
            this.rootPkgCache = null;
            this.close(false);
            try {
                File cacheDir;
                File[] children;
                String[] content = this.directory.list();
                boolean dirty = false;
                if (content != null) {
                    for (String file : content) {
                        try {
                            this.directory.deleteFile(file);
                        }
                        catch (IOException e) {
                            if (!this.directory.fileExists(file)) continue;
                            dirty = true;
                        }
                    }
                }
                if (!dirty || (children = (cacheDir = ((FSDirectory)this.directory).getFile()).listFiles()) == null) break block11;
                for (File child : children) {
                    if (child.delete()) continue;
                    Class<?> c = this.directory.getClass();
                    int refCount = -1;
                    try {
                        Field field = c.getDeclaredField("refCount");
                        field.setAccessible(true);
                        refCount = field.getInt(this.directory);
                    }
                    catch (NoSuchFieldException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                    throw new IOException("Cannot delete: " + child.getAbsolutePath() + "(" + child.exists() + "," + child.canRead() + "," + child.canWrite() + "," + cacheDir.canRead() + "," + cacheDir.canWrite() + "," + refCount + ")");
                }
            }
            finally {
                this.close(true);
                this.directory = LuceneIndex.createDirectory(this.refCacheRoot);
                this.closed = false;
            }
        }
    }

    @Override
    public boolean exists() {
        try {
            return IndexReader.indexExists((Directory)this.directory);
        }
        catch (IOException e) {
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.INFO, "Broken index: " + this.refCacheRoot.getAbsolutePath(), e);
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean closeDir) throws IOException {
        try {
            try {
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
            }
            finally {
                if (this.memCacheDir != null) {
                    assert (useMemoryCache);
                    Directory tmpDir = this.memCacheDir;
                    this.memCacheDir = null;
                    tmpDir.close();
                }
            }
        }
        finally {
            if (closeDir) {
                this.closed = true;
                this.directory.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.refCacheRoot.getAbsolutePath() + "]";
    }

    private synchronized IndexReader getReader() throws IOException {
        this._hit();
        if (this.reader == null) {
            if (this.validCache == Boolean.FALSE) {
                return null;
            }
            try {
                Directory source = useMemoryCache ? (this.memCacheDir = new RAMDirectory(this.directory)) : this.directory;
                this.reader = new NoNormsReader(IndexReader.open((Directory)source));
            }
            catch (FileNotFoundException fnf) {
            }
            catch (IOException ioe) {
                throw this.annotateException(ioe);
            }
        }
        return this.reader;
    }

    private synchronized IndexWriter getWriter(boolean create) throws IOException {
        this._hit();
        try {
            IndexWriter writer = new IndexWriter(this.directory, this.analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
            return writer;
        }
        catch (IOException ioe) {
            throw this.annotateException(ioe);
        }
    }

    private synchronized void refreshReader() throws IOException {
        IndexReader newReader;
        if (useMemoryCache) {
            this.close(false);
        } else if (this.reader != null && (newReader = this.reader.reopen()) != this.reader) {
            this.reader.close();
            this.reader = newReader;
        }
    }

    private IOException annotateException(IOException ioe) {
        String message;
        File[] children = this.refCacheRoot.listFiles();
        if (children == null) {
            message = "Non existing index folder";
        } else {
            StringBuilder b = new StringBuilder();
            for (File c : children) {
                b.append(c.getName() + " f: " + c.isFile() + " r: " + c.canRead() + " w: " + c.canWrite() + "\n");
            }
            message = b.toString();
        }
        return (IOException)Exceptions.attachMessage((Throwable)ioe, (String)message);
    }

    private static File getReferencesCacheFolder(File cacheRoot) throws IOException {
        File refRoot = new File(cacheRoot, REFERENCES);
        if (!refRoot.exists()) {
            refRoot.mkdir();
        }
        return refRoot;
    }

    private void checkPreconditions() throws ClassIndexImpl.IndexAlreadyClosedException {
        if (this.closed) {
            throw new ClassIndexImpl.IndexAlreadyClosedException();
        }
    }

    private static Directory createDirectory(File indexFolder) throws IOException {
        assert (indexFolder != null);
        FSDirectory directory = FSDirectory.getDirectory((File)indexFolder);
        directory.getLockFactory().setLockPrefix(CACHE_LOCK_PREFIX);
        return directory;
    }

    private Collection<? extends String> getOrphanLock() {
        LinkedList<String> locks = new LinkedList<String>();
        String[] content = this.refCacheRoot.list();
        if (content != null) {
            for (String name : content) {
                if (!name.startsWith(CACHE_LOCK_PREFIX)) continue;
                locks.add(name);
            }
        }
        return locks;
    }

    private static class TermComparator
    implements Comparator<Term> {
        private TermComparator() {
        }

        @Override
        public int compare(Term t1, Term t2) {
            int ret = t1.field().compareTo(t2.field());
            if (ret == 0) {
                ret = t1.text().compareTo(t2.text());
            }
            return ret;
        }
    }

    private static class NoNormsReader
    extends FilterIndexReader {
        private byte[] norms;

        public NoNormsReader(IndexReader reader) {
            super(reader);
        }

        public byte[] norms(String field) throws IOException {
            byte[] norms = this.fakeNorms();
            return norms;
        }

        public void norms(String field, byte[] norm, int offset) throws IOException {
            byte[] norms = this.fakeNorms();
            System.arraycopy(norms, 0, norm, offset, norms.length);
        }

        public boolean hasNorms(String field) throws IOException {
            return false;
        }

        protected void doSetNorm(int doc, String field, byte norm) throws CorruptIndexException, IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doClose() throws IOException {
            NoNormsReader noNormsReader = this;
            synchronized (noNormsReader) {
                this.norms = null;
            }
            super.doClose();
        }

        public IndexReader reopen() throws IOException {
            IndexReader newIn = this.in.reopen();
            if (newIn == this.in) {
                return this;
            }
            return new NoNormsReader(newIn);
        }

        private synchronized byte[] fakeNorms() {
            if (this.norms == null) {
                this.norms = new byte[this.maxDoc()];
                Arrays.fill(this.norms, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            return this.norms;
        }
    }
}

