/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.SiblingProvider;
import org.netbeans.modules.java.source.util.Iterators;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class OutputFileManager
extends CachingFileManager {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static final String OUTPUT_ROOT = "output-root";
    private ClassPath scp;
    private ClassPath apt;
    private final Set<File> filteredFiles = new HashSet<File>();
    private boolean filtered;
    private String outputRoot;
    private final SiblingProvider siblings;

    public OutputFileManager(CachingArchiveProvider provider, @NonNull ClassPath outputClassPath, @NonNull ClassPath sourcePath, ClassPath aptPath, @NonNull SiblingProvider siblings) {
        super(provider, outputClassPath, false, true);
        assert (outputClassPath != null);
        assert (sourcePath != null);
        assert (siblings != null);
        this.scp = sourcePath;
        this.apt = aptPath == null ? EMPTY_PATH : aptPath;
        this.siblings = siblings;
    }

    public final boolean isFiltered() {
        return this.filtered;
    }

    public final synchronized void setFilteredFiles(Set<File> files) {
        assert (files != null);
        this.filteredFiles.clear();
        this.filteredFiles.addAll(files);
        this.filtered = true;
    }

    public final synchronized void clearFilteredFiles() {
        this.filteredFiles.clear();
        this.filtered = false;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location l, String packageName, Set<JavaFileObject.Kind> kinds, boolean recursive) {
        Iterable<JavaFileObject> sr = super.list(l, packageName, kinds, recursive);
        if (this.filteredFiles.isEmpty()) {
            return sr;
        }
        Iterable<JavaFileObject> res = Iterators.filter(sr, new Comparable<JavaFileObject>(){

            @Override
            public int compareTo(JavaFileObject o) {
                File f = ((FileObjects.FileBase)o).f;
                return OutputFileManager.this.filteredFiles.contains(f) ? 0 : -1;
            }
        });
        return res;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location l, String className, JavaFileObject.Kind kind, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        String baseName;
        if (kind != JavaFileObject.Kind.CLASS) {
            throw new IllegalArgumentException();
        }
        File activeRoot = null;
        if (this.outputRoot != null) {
            activeRoot = new File(this.outputRoot);
        } else {
            baseName = FileObjects.convertPackage2Folder(className);
            activeRoot = this.getRootForApt(sibling, baseName);
            if (activeRoot == null) {
                int index = this.getActiveRoot(sibling, baseName);
                if (index == -1) {
                    throw new InvalidSourcePath();
                }
                if (index < 0) {
                    Logger.getLogger(OutputFileManager.class.getName()).warning("No output for class: " + className + " sibling: " + sibling + " srcRoots: " + this.scp + " cacheRoots: " + this.cp);
                    throw new InvalidSourcePath();
                }
                assert (index < this.cp.entries().size()) : "index " + index + " class: " + className + " sibling: " + sibling + " srcRoots: " + this.scp + " cacheRoots: " + this.cp;
                activeRoot = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(index)).getURL().toExternalForm()));
            }
        }
        baseName = className.replace('.', File.separatorChar);
        String nameStr = baseName + '.' + "sig";
        int nameComponentIndex = nameStr.lastIndexOf(File.separatorChar);
        if (nameComponentIndex != -1) {
            String pathComponent = nameStr.substring(0, nameComponentIndex);
            new File(activeRoot, pathComponent).mkdirs();
        } else {
            activeRoot.mkdirs();
        }
        File f = FileUtil.normalizeFile((File)new File(activeRoot, nameStr));
        return FileObjects.fileFileObject(f, activeRoot, null, null);
    }

    @Override
    public javax.tools.FileObject getFileForOutput(JavaFileManager.Location l, String pkgName, String relativeName, javax.tools.FileObject sibling) throws IOException, UnsupportedOperationException, IllegalArgumentException {
        URL siblingURL;
        assert (pkgName != null);
        assert (relativeName != null);
        URL uRL = this.siblings.hasSibling() ? this.siblings.getSibling() : (siblingURL = sibling == null ? null : sibling.toUri().toURL());
        if (siblingURL == null) {
            throw new IllegalArgumentException("sibling == null");
        }
        int index = this.getActiveRootImpl(siblingURL);
        if (index == -1) {
            throw new InvalidSourcePath();
        }
        assert (index >= 0 && index < this.cp.entries().size());
        File activeRoot = new File(URI.create(((ClassPath.Entry)this.cp.entries().get(index)).getURL().toExternalForm()));
        if (File.separatorChar != '/') {
            relativeName = relativeName.replace('/', File.separatorChar);
        }
        StringBuilder path = new StringBuilder();
        if (pkgName.length() > 0) {
            path.append(FileObjects.convertPackage2Folder(pkgName, File.separatorChar));
            path.append(File.separatorChar);
        }
        path.append(relativeName);
        File file = FileUtil.normalizeFile((File)new File(activeRoot, path.toString()));
        return FileObjects.fileFileObject(file, activeRoot, null, null);
    }

    private int getActiveRoot(javax.tools.FileObject sibling, String baseName) throws IOException {
        return sibling == null ? this.getActiveRootImpl(baseName) : this.getActiveRootImpl(sibling.toUri().toURL());
    }

    private int getActiveRootImpl(URL sibling) throws IOException {
        List entries = this.scp.entries();
        int eSize = entries.size();
        if (eSize == 1) {
            return 0;
        }
        if (eSize == 0) {
            return -1;
        }
        Iterator it = entries.iterator();
        try {
            int i = 0;
            while (it.hasNext()) {
                URL rootUrl = ((ClassPath.Entry)it.next()).getURL();
                if (FileObjects.isParentOf(rootUrl, sibling)) {
                    return i;
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            String message = String.format("uri: %s", sibling.toString());
            throw (IllegalArgumentException)Exceptions.attachMessage((Throwable)e, (String)message);
        }
        return -2;
    }

    private int getActiveRootImpl(String baseName) {
        List entries = this.scp.entries();
        int eSize = entries.size();
        if (eSize == 1) {
            return 0;
        }
        if (eSize == 0) {
            return -1;
        }
        String[] parentName = this.splitParentName(baseName);
        Iterator it = entries.iterator();
        int i = 0;
        while (it.hasNext()) {
            FileObject parentFile;
            FileObject root = ((ClassPath.Entry)it.next()).getRoot();
            if (root != null && (parentFile = root.getFileObject(parentName[0])) != null && parentFile.getFileObject(parentName[1], "java") != null) {
                return i;
            }
            ++i;
        }
        return -2;
    }

    private File getRootForApt(javax.tools.FileObject sibling, String baseName) {
        return sibling == null ? this.getRootForAptImpl(baseName) : this.getRootForAptImpl(sibling);
    }

    private File getRootForAptImpl(javax.tools.FileObject sibling) {
        try {
            URL surl = sibling.toUri().toURL();
            for (ClassPath.Entry entry : this.apt.entries()) {
                URL classFolder;
                if (!FileObjects.isParentOf(entry.getURL(), surl) || (classFolder = AptCacheForSourceQuery.getClassFolder(entry.getURL())) == null) continue;
                try {
                    return new File(classFolder.toURI());
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)("sibling class=" + sibling.getClass() + ", uri=" + sibling.toUri().toASCIIString())));
        }
        return null;
    }

    private File getRootForAptImpl(String baseName) {
        String[] parentName = this.splitParentName(baseName);
        for (ClassPath.Entry entry : this.scp.entries()) {
            URL classFolder;
            FileObject parentFile;
            FileObject root = entry.getRoot();
            if (root == null || (parentFile = root.getFileObject(parentName[0])) == null || parentFile.getFileObject(parentName[1], "java") == null || (classFolder = AptCacheForSourceQuery.getClassFolder(entry.getURL())) == null) continue;
            try {
                return new File(classFolder.toURI());
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private String[] splitParentName(String baseName) {
        String name;
        String parent = null;
        int index = baseName.lastIndexOf(47);
        if (index < 0) {
            parent = "";
            name = baseName;
        } else {
            parent = baseName.substring(0, index);
            name = baseName.substring(index + 1);
        }
        index = name.indexOf(36);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return new String[]{parent, name};
    }

    @Override
    public boolean handleOption(String head, Iterator<String> tail) {
        if (OUTPUT_ROOT.equals(head)) {
            if (!tail.hasNext()) {
                throw new IllegalArgumentException();
            }
            this.outputRoot = tail.next();
            if (this.outputRoot.length() <= 0) {
                this.outputRoot = null;
            }
            return true;
        }
        return super.handleOption(head, tail);
    }

    public class InvalidSourcePath
    extends IllegalStateException {
    }
}

