/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import org.netbeans.modules.java.source.usages.ClassFileUtil;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class CheckSums {
    private static final String CHECK_SUMS_FILE = "checksums.properties";
    private static final String DEPRECATED = "DEPRECATED";
    private final Context context;
    private final Properties props = new Properties();
    private final MessageDigest md;

    public static CheckSums forContext(Context context) throws IOException, NoSuchAlgorithmException {
        return new CheckSums(context);
    }

    private CheckSums(Context context) throws IOException, NoSuchAlgorithmException {
        assert (context != null);
        this.context = context;
        this.md = MessageDigest.getInstance("MD5");
        this.load();
    }

    public boolean checkAndSet(URL file, Iterable<? extends TypeElement> topLevelElements, Elements elements) {
        String sum;
        String fileId = file.toExternalForm();
        String value = (String)this.props.setProperty(fileId, sum = this.computeCheckSum(topLevelElements, elements));
        return value == null || value.equals(sum);
    }

    public void remove(URL file) {
        String fileId = file.toExternalForm();
        this.props.remove(fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        FileObject indexDir = this.context.getIndexFolder();
        FileObject f = FileUtil.createData((FileObject)indexDir, (String)CHECK_SUMS_FILE);
        assert (f != null);
        OutputStream out = f.getOutputStream();
        try {
            this.props.store(out, "");
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        FileObject indexDir = this.context.getIndexFolder();
        FileObject f = indexDir.getFileObject(CHECK_SUMS_FILE);
        if (f != null) {
            InputStream in = f.getInputStream();
            try {
                this.props.load(in);
            }
            finally {
                in.close();
            }
        }
    }

    private String computeCheckSum(Iterable<? extends TypeElement> topLevelElements, Elements elements) {
        LinkedList<TypeElement> toHandle = new LinkedList<TypeElement>();
        for (TypeElement typeElement : topLevelElements) {
            toHandle.offer(typeElement);
        }
        ArrayList<String> sigs = new ArrayList<String>();
        while (!toHandle.isEmpty()) {
            TypeElement typeElement = (TypeElement)toHandle.poll();
            if (typeElement == null) continue;
            sigs.add(ClassFileUtil.encodeClassName(typeElement) + this.getExtendedModifiers(elements, typeElement));
            for (Element element : typeElement.getEnclosedElements()) {
                switch (element.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        toHandle.offer((TypeElement)element);
                        break;
                    }
                    case CONSTRUCTOR: 
                    case METHOD: {
                        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        sigs.add(Arrays.toString(ClassFileUtil.createExecutableDescriptor((ExecutableElement)element)) + this.getExtendedModifiers(elements, element));
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) break;
                        sigs.add(Arrays.toString(ClassFileUtil.createFieldDescriptor((VariableElement)element)) + this.getExtendedModifiers(elements, element));
                    }
                }
            }
        }
        Collections.sort(sigs);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : sigs) {
            stringBuilder.append(string);
        }
        byte[] bytes = this.md.digest(stringBuilder.toString().getBytes());
        return new String(bytes);
    }

    private String getExtendedModifiers(Elements elements, Element el) {
        Object v;
        StringBuilder sb = new StringBuilder();
        for (Modifier m : el.getModifiers()) {
            sb.append(m.name());
        }
        if (elements.isDeprecated(el)) {
            sb.append(DEPRECATED);
        }
        if (el.getKind() == ElementKind.FIELD && (v = ((VariableElement)el).getConstantValue()) != null) {
            sb.append(v.getClass().getName());
            sb.append(String.valueOf(v));
        }
        return sb.toString();
    }
}

