/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.LuceneIndexMBeanImpl;
import org.netbeans.modules.java.source.util.LowMemoryNotifierMBeanImpl;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;

public class JBrowseModule
extends ModuleInstall {
    private static final boolean ENABLE_MBEANS = Boolean.getBoolean("org.netbeans.modules.java.source.enableMBeans");
    private static final Logger log = Logger.getLogger(JBrowseModule.class.getName());

    public void restored() {
        super.restored();
        if (ENABLE_MBEANS) {
            JBrowseModule.registerMBeans();
        }
        System.setProperty("useJavaUtilZip", "true");
    }

    public void close() {
        super.close();
        try {
            ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    ClassIndexManager.getDefault().close();
                    return null;
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        if (ENABLE_MBEANS) {
            JBrowseModule.unregisterMBeans();
        }
    }

    private static void registerMBeans() {
        block8: {
            try {
                MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
                mgs.registerMBean(new LowMemoryNotifierMBeanImpl(), new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
                mgs.registerMBean(LuceneIndexMBeanImpl.getDefault(), new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
            }
            catch (NotCompliantMBeanException e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (MalformedObjectNameException e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (InstanceAlreadyExistsException e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (MBeanRegistrationException e) {
                if (!log.isLoggable(Level.SEVERE)) break block8;
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    private static void unregisterMBeans() {
        block6: {
            try {
                MBeanServer mgs = ManagementFactory.getPlatformMBeanServer();
                mgs.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LowMemoryNotifier"));
                mgs.unregisterMBean(new ObjectName("org.netbeans.modules.java.source:type=LuceneIndex"));
            }
            catch (MalformedObjectNameException e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (InstanceNotFoundException e) {
                if (log.isLoggable(Level.SEVERE)) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            catch (MBeanRegistrationException e) {
                if (!log.isLoggable(Level.SEVERE)) break block6;
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

