/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TranslateIdentifier;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.openide.util.Exceptions;

public final class TreeUtilities {
    private final CompilationInfo info;
    private final CommentHandlerService handler;
    static Set<Character> EXOTIC_ESCAPE = new HashSet<Character>(Arrays.asList(Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf(','), Character.valueOf('-'), Character.valueOf(':'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('@'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}')));
    private static final Map<Character, Character> ESCAPE_UNENCODE;
    private static final Map<Character, Character> ESCAPE_ENCODE;

    TreeUtilities(CompilationInfo info) {
        assert (info != null);
        this.info = info;
        this.handler = CommentHandlerService.instance(info.impl.getJavacTask().getContext());
    }

    public boolean isClass(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x6200L) == 0L;
    }

    public boolean isInterface(ClassTree tree) {
        long flags = ((JCTree.JCModifiers)tree.getModifiers()).flags;
        return (flags & 0x200L) != 0L && (flags & 0x2000L) == 0L;
    }

    public boolean isEnum(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isEnumConstant(VariableTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x4000L) != 0L;
    }

    public boolean isAnnotation(ClassTree tree) {
        return (((JCTree.JCModifiers)tree.getModifiers()).flags & 0x2000L) != 0L;
    }

    public boolean isSynthetic(TreePath path) throws NullPointerException {
        if (path == null) {
            throw new NullPointerException();
        }
        while (path != null) {
            if (this.isSynthetic(path.getCompilationUnit(), path.getLeaf())) {
                return true;
            }
            path = path.getParentPath();
        }
        return false;
    }

    private boolean isSynthetic(CompilationUnitTree cut, Tree leaf) throws NullPointerException {
        IdentifierTree it;
        MethodInvocationTree mit;
        ExpressionStatementTree est;
        JCTree tree = (JCTree)leaf;
        if (tree.pos == -1) {
            return true;
        }
        if (leaf.getKind() == Tree.Kind.METHOD) {
            return (((JCTree.JCMethodDecl)leaf).mods.flags & 0x1000000000L) != 0L;
        }
        if (leaf.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (est = (ExpressionStatementTree)leaf).getExpression().getKind() == Tree.Kind.METHOD_INVOCATION && (mit = (MethodInvocationTree)est.getExpression()).getMethodSelect().getKind() == Tree.Kind.IDENTIFIER && "super".equals((it = (IdentifierTree)mit.getMethodSelect()).getName().toString())) {
            SourcePositions sp = this.info.getTrees().getSourcePositions();
            return sp.getEndPosition(cut, leaf) == -1L;
        }
        return false;
    }

    public List<Comment> getComments(Tree tree, boolean preceding) {
        CommentSetImpl set = this.handler.getComments(tree);
        TreeUtilities.ensureCommentsMapped(this.info, tree, set);
        List<Comment> comments = preceding ? set.getPrecedingComments() : set.getTrailingComments();
        return Collections.unmodifiableList(comments);
    }

    static void ensureCommentsMapped(CompilationInfo info, Tree tree, CommentSetImpl set) {
        if (!set.areCommentsMapped()) {
            boolean assertsEnabled = false;
            boolean automap = true;
            if (!$assertionsDisabled) {
                assertsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertsEnabled) {
                TreePath tp;
                TreePath treePath = tp = info.getCompilationUnit() == tree ? new TreePath(info.getCompilationUnit()) : TreePath.getPath(info.getCompilationUnit(), tree);
                if (tp == null) {
                    Logger.getLogger(TreeUtilities.class.getName()).log(Level.WARNING, "Comment automap requested for Tree not from the root compilation info. Please, make sure to call GeneratorUtilities.importComments before Treeutilities.getComments. Tree: {0}", tree);
                    Logger.getLogger(TreeUtilities.class.getName()).log(Level.INFO, "Caller", new Exception());
                    automap = false;
                }
            }
            if (automap) {
                try {
                    TokenSequence seq = ((SourceFileObject)info.getCompilationUnit().getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
                    new TranslateIdentifier(info, true, false, (TokenSequence<JavaTokenId>)seq).translate(tree);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public TreePath pathFor(int pos) {
        return this.pathFor(new TreePath(this.info.getCompilationUnit()), pos);
    }

    public TreePath pathFor(TreePath path, int pos) {
        return this.pathFor(path, pos, this.info.getTrees().getSourcePositions());
    }

    public TreePath pathFor(TreePath path, int pos, SourcePositions sourcePositions) {
        class Result
        extends Error {
            TreePath path;

            Result(TreePath path) {
                this.path = path;
            }
        }
        if (this.info == null || path == null || sourcePositions == null) {
            throw new IllegalArgumentException();
        }
        try {
            class PathFinder
            extends TreePathScanner<Void, Void> {
                private int pos;
                private SourcePositions sourcePositions;

                PathFinder(int pos, SourcePositions sourcePositions) {
                    this.pos = pos;
                    this.sourcePositions = sourcePositions;
                }

                @Override
                public Void scan(Tree tree, Void p) {
                    if (tree != null && this.sourcePositions.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree) < (long)this.pos && this.sourcePositions.getEndPosition(this.getCurrentPath().getCompilationUnit(), tree) >= (long)this.pos) {
                        if (tree.getKind() == Tree.Kind.ERRONEOUS) {
                            tree.accept(this, p);
                            throw new Result(this.getCurrentPath());
                        }
                        super.scan(tree, p);
                        throw new Result(new TreePath(this.getCurrentPath(), tree));
                    }
                    return null;
                }

                @Override
                public Void visitVariable(VariableTree node, Void p) {
                    int[] span = TreeUtilities.this.findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitVariable(node, p);
                }

                @Override
                public Void visitMethod(MethodTree node, Void p) {
                    int[] span = TreeUtilities.this.findNameSpan(node);
                    if (span != null && span[0] <= this.pos && this.pos < span[1]) {
                        throw new Result(this.getCurrentPath());
                    }
                    return (Void)super.visitMethod(node, p);
                }
            }
            new PathFinder(pos, sourcePositions).scan(path, null);
        }
        catch (Result result) {
            path = result.path;
        }
        if (path.getLeaf() == path.getCompilationUnit()) {
            return path;
        }
        TokenSequence<JavaTokenId> tokenList = this.tokensFor(path.getLeaf(), sourcePositions);
        tokenList.moveEnd();
        if (tokenList.movePrevious() && tokenList.offset() < pos) {
            switch ((JavaTokenId)tokenList.token().id()) {
                case GTGTGT: 
                case GTGT: 
                case GT: {
                    if (path.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT || path.getLeaf().getKind() == Tree.Kind.CLASS || path.getLeaf().getKind() == Tree.Kind.GREATER_THAN) break;
                }
                case RPAREN: {
                    if (path.getLeaf().getKind() == Tree.Kind.ENHANCED_FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.FOR_LOOP || path.getLeaf().getKind() == Tree.Kind.IF || path.getLeaf().getKind() == Tree.Kind.WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.DO_WHILE_LOOP || path.getLeaf().getKind() == Tree.Kind.TYPE_CAST) break;
                }
                case SEMICOLON: {
                    if (path.getLeaf().getKind() == Tree.Kind.FOR_LOOP && (long)tokenList.offset() <= sourcePositions.getStartPosition(path.getCompilationUnit(), ((ForLoopTree)path.getLeaf()).getUpdate().get(0))) break;
                }
                case RBRACE: {
                    path = path.getParentPath();
                    switch (path.getLeaf().getKind()) {
                        case CATCH: {
                            path = path.getParentPath();
                        }
                        case METHOD: 
                        case FOR_LOOP: 
                        case ENHANCED_FOR_LOOP: 
                        case IF: 
                        case SYNCHRONIZED: 
                        case WHILE_LOOP: 
                        case TRY: {
                            path = path.getParentPath();
                        }
                    }
                }
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMirror parseType(String expr, TypeElement scope) {
        Enter enter = Enter.instance(this.info.impl.getJavacTask().getContext());
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            if (enter.getClassEnv((Symbol.TypeSymbol)((Object)scope)) == null && this.info.getTrees().getTree(scope) == null) {
                TypeMirror typeMirror = null;
                return typeMirror;
            }
            Type type = this.info.impl.getJavacTask().parseType(expr, scope);
            return type;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatementTree parseStatement(String stmt, SourcePositions[] sourcePositions) {
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            JCTree.JCStatement jCStatement = this.info.impl.getJavacTask().parseStatement(stmt, sourcePositions);
            return jCStatement;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionTree parseExpression(String expr, SourcePositions[] sourcePositions) {
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            JCTree.JCExpression jCExpression = this.info.impl.getJavacTask().parseExpression(expr, sourcePositions);
            return jCExpression;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionTree parseVariableInitializer(String init, SourcePositions[] sourcePositions) {
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            JCTree.JCExpression jCExpression = this.info.impl.getJavacTask().parseVariableInitializer(init, sourcePositions);
            return jCExpression;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockTree parseStaticBlock(String block, SourcePositions[] sourcePositions) {
        TreeMaker jcMaker = TreeMaker.instance(this.info.impl.getJavacTask().getContext());
        int oldPos = jcMaker.pos;
        try {
            JCTree.JCBlock jCBlock = this.info.impl.getJavacTask().parseStaticBlock(block, sourcePositions);
            return jCBlock;
        }
        finally {
            jcMaker.pos = oldPos;
        }
    }

    public Scope scopeFor(int pos) {
        List<? extends StatementTree> stmts = null;
        SourcePositions sourcePositions = this.info.getTrees().getSourcePositions();
        TreePath path = this.pathFor(pos);
        CompilationUnitTree root = path.getCompilationUnit();
        switch (path.getLeaf().getKind()) {
            case BLOCK: {
                stmts = ((BlockTree)path.getLeaf()).getStatements();
                break;
            }
            case FOR_LOOP: {
                stmts = ((ForLoopTree)path.getLeaf()).getInitializer();
                break;
            }
            case ENHANCED_FOR_LOOP: {
                stmts = Collections.singletonList(((EnhancedForLoopTree)path.getLeaf()).getStatement());
                break;
            }
            case METHOD: {
                stmts = ((MethodTree)path.getLeaf()).getParameters();
            }
        }
        if (stmts != null) {
            StatementTree tree = null;
            for (StatementTree statementTree : stmts) {
                if (sourcePositions.getStartPosition(root, statementTree) >= (long)pos) continue;
                tree = statementTree;
            }
            if (tree != null) {
                path = new TreePath(path, tree);
            }
        }
        Scope scope = this.info.getTrees().getScope(path);
        if (path.getLeaf().getKind() == Tree.Kind.CLASS) {
            TokenSequence ts = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            ts.move(pos);
            block11: while (ts.movePrevious()) {
                switch ((JavaTokenId)ts.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        continue block11;
                    }
                    case EXTENDS: 
                    case IMPLEMENTS: {
                        ((JavacScope)scope).getEnv().baseClause = true;
                    }
                }
                return scope;
            }
        }
        return scope;
    }

    public TypeMirror attributeTree(Tree tree, Scope scope) {
        return this.info.impl.getJavacTask().attributeTree((JCTree)tree, ((JavacScope)scope).getEnv());
    }

    public Scope attributeTreeTo(Tree tree, Scope scope, Tree to) {
        return this.info.impl.getJavacTask().attributeTreeTo((JCTree)tree, ((JavacScope)scope).getEnv(), (JCTree)to);
    }

    public TypeMirror reattributeTree(Tree tree, Scope scope) {
        Env<AttrContext> env = ((JavacScope)scope).getEnv();
        this.copyInnerClassIndexes(env.tree, tree);
        return this.info.impl.getJavacTask().attributeTree((JCTree)tree, env);
    }

    public Scope reattributeTreeTo(Tree tree, Scope scope, Tree to) {
        Env<AttrContext> env = ((JavacScope)scope).getEnv();
        this.copyInnerClassIndexes(env.tree, tree);
        return this.info.impl.getJavacTask().attributeTreeTo((JCTree)tree, env, (JCTree)to);
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree) {
        return this.tokensFor(tree, this.info.getTrees().getSourcePositions());
    }

    public TokenSequence<JavaTokenId> tokensFor(Tree tree, SourcePositions sourcePositions) {
        int start = (int)sourcePositions.getStartPosition(this.info.getCompilationUnit(), tree);
        int end = (int)sourcePositions.getEndPosition(this.info.getCompilationUnit(), tree);
        return this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language()).subSequence(start, end);
    }

    public boolean isAccessible(Scope scope, Element member, TypeMirror type) {
        if (scope instanceof JavacScope && member instanceof Symbol && type instanceof Type) {
            Resolve resolve = Resolve.instance(this.info.impl.getJavacTask().getContext());
            return resolve.isAccessible(((JavacScope)scope).getEnv(), (Type)type, (Symbol)member);
        }
        return false;
    }

    public boolean isStaticContext(Scope scope) {
        Resolve.instance(this.info.impl.getJavacTask().getContext());
        return Resolve.isStatic(((JavacScope)scope).getEnv());
    }

    public Set<TypeMirror> getUncaughtExceptions(TreePath path) {
        UnrelatedTypeMirrorSet set = new UnrelatedTypeMirrorSet(this.info.getTypes());
        new UncaughtExceptionsVisitor(this.info).scan(path, set);
        return set;
    }

    public int[] findNameSpan(ClassTree clazz) {
        return this.findNameSpan(clazz.getSimpleName().toString(), clazz, JavaTokenId.CLASS, JavaTokenId.INTERFACE, JavaTokenId.ENUM, JavaTokenId.AT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    public int[] findNameSpan(MethodTree method) {
        String name;
        if (this.isSynthetic(this.info.getCompilationUnit(), method)) {
            return null;
        }
        JCTree.JCMethodDecl jcm = (JCTree.JCMethodDecl)method;
        if (jcm.name == jcm.name.table.names.init) {
            Element clazz;
            TreePath path = this.info.getTrees().getPath(this.info.getCompilationUnit(), jcm);
            if (path == null) {
                return null;
            }
            Element em = this.info.getTrees().getElement(path);
            if (em == null || (clazz = em.getEnclosingElement()) == null || !clazz.getKind().isClass()) {
                return null;
            }
            name = clazz.getSimpleName().toString();
        } else {
            name = method.getName().toString();
        }
        return this.findNameSpan(name, method, new JavaTokenId[0]);
    }

    public int[] findNameSpan(VariableTree var) {
        return this.findNameSpan(var.getName().toString(), var, new JavaTokenId[0]);
    }

    public int[] findNameSpan(MemberSelectTree mst) {
        return this.findNameSpan(mst.getIdentifier().toString(), mst, JavaTokenId.DOT, JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.JAVADOC_COMMENT);
    }

    private int[] findNameSpan(String name, Tree t, JavaTokenId ... allowedTokens) {
        boolean wasNext;
        if (!SourceVersion.isIdentifier(name)) {
            return null;
        }
        JCTree jcTree = (JCTree)t;
        int pos = jcTree.pos;
        if (pos < 0) {
            return null;
        }
        EnumSet<JavaTokenId> allowedTokensSet = EnumSet.noneOf(JavaTokenId.class);
        allowedTokensSet.addAll(Arrays.asList(allowedTokens));
        TokenSequence tokenSequence = this.info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move(pos);
        while ((wasNext = tokenSequence.moveNext()) && allowedTokensSet.contains(tokenSequence.token().id())) {
        }
        if (wasNext && tokenSequence.token().id() == JavaTokenId.IDENTIFIER && name.contentEquals(tokenSequence.token().text())) {
            return new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()};
        }
        return null;
    }

    public StatementTree getBreakContinueTarget(TreePath breakOrContinue) throws IllegalArgumentException {
        if (this.info.getPhase().compareTo(JavaSource.Phase.RESOLVED) < 0) {
            throw new IllegalArgumentException("Not in correct Phase. Required: Phase.RESOLVED, got: Phase." + this.info.getPhase().toString());
        }
        Tree leaf = breakOrContinue.getLeaf();
        switch (leaf.getKind()) {
            case BREAK: {
                return (StatementTree)((Object)((JCTree.JCBreak)leaf).target);
            }
            case CONTINUE: {
                StatementTree target = (StatementTree)((Object)((JCTree.JCContinue)leaf).target);
                if (target == null) {
                    return null;
                }
                if (((JCTree.JCContinue)leaf).label == null) {
                    return target;
                }
                TreePath tp = breakOrContinue;
                while (tp.getLeaf() != target) {
                    tp = tp.getParentPath();
                }
                Tree parent = tp.getParentPath().getLeaf();
                if (parent.getKind() == Tree.Kind.LABELED_STATEMENT) {
                    return (StatementTree)parent;
                }
                return target;
            }
        }
        throw new IllegalArgumentException("Unsupported kind: " + (Object)((Object)leaf.getKind()));
    }

    @NonNull
    public CharSequence decodeIdentifier(@NonNull CharSequence text) {
        return TreeUtilities.decodeIdentifierInternal(text);
    }

    @NonNull
    public CharSequence encodeIdentifier(@NonNull CharSequence ident) {
        return TreeUtilities.encodeIdentifierInternal(ident);
    }

    @NonNull
    static CharSequence decodeIdentifierInternal(@NonNull CharSequence text) {
        if (text.charAt(0) != '#') {
            return text;
        }
        int count = text.charAt(text.length() - 1) == '\"' ? text.length() - 1 : text.length();
        StringBuilder sb = new StringBuilder(text.length());
        for (int c = 2; c < count; ++c) {
            if (text.charAt(c) == '\\' && ++c < count) {
                if (EXOTIC_ESCAPE.contains(Character.valueOf(text.charAt(c)))) {
                    sb.append('\\');
                    sb.append(text.charAt(c));
                    continue;
                }
                Character remaped = ESCAPE_UNENCODE.get(Character.valueOf(text.charAt(c)));
                if (remaped != null) {
                    sb.append(remaped);
                    continue;
                }
                sb.append(text.charAt(c));
                continue;
            }
            sb.append(text.charAt(c));
        }
        return sb.toString();
    }

    @NonNull
    static CharSequence encodeIdentifierInternal(@NonNull CharSequence ident) {
        if (ident.length() == 0) {
            return ident;
        }
        StringBuilder sb = new StringBuilder(ident.length());
        boolean needsExotic = Character.isJavaIdentifierStart(ident.charAt(0));
        for (int i = 0; i < ident.length(); ++i) {
            char c = ident.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            needsExotic = true;
            Character target = ESCAPE_ENCODE.get(Character.valueOf(c));
            if (target != null) {
                sb.append('\\');
                sb.append(target);
                continue;
            }
            sb.append(c);
        }
        if (needsExotic) {
            sb.append("\"");
            sb.insert(0, "#\"");
            return sb.toString();
        }
        return ident;
    }

    private void copyInnerClassIndexes(Tree from, Tree to) {
        final int[] fromIdx = new int[]{-2};
        TreeScanner scanner = new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void p) {
                if (fromIdx[0] < -1) {
                    super.scan(node, p);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                fromIdx[0] = ((JCTree.JCClassDecl)node).index;
                return null;
            }
        };
        scanner.scan(from, null);
        if (fromIdx[0] < -1) {
            return;
        }
        scanner = new TreeScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void p) {
                int n = fromIdx[0];
                fromIdx[0] = n + 1;
                ((JCTree.JCClassDecl)node).index = n;
                return null;
            }
        };
        scanner.scan(to, null);
    }

    static {
        HashMap<Character, Character> unencode = new HashMap<Character, Character>();
        unencode.put(Character.valueOf('n'), Character.valueOf('\n'));
        unencode.put(Character.valueOf('t'), Character.valueOf('\t'));
        unencode.put(Character.valueOf('b'), Character.valueOf('\b'));
        unencode.put(Character.valueOf('r'), Character.valueOf('\r'));
        ESCAPE_UNENCODE = Collections.unmodifiableMap(unencode);
        HashMap<Character, Character> encode = new HashMap<Character, Character>();
        encode.put(Character.valueOf('\n'), Character.valueOf('n'));
        encode.put(Character.valueOf('\t'), Character.valueOf('t'));
        encode.put(Character.valueOf('\b'), Character.valueOf('b'));
        encode.put(Character.valueOf('\r'), Character.valueOf('r'));
        ESCAPE_ENCODE = Collections.unmodifiableMap(encode);
    }

    private static class UnrelatedTypeMirrorSet
    extends AbstractSet<TypeMirror> {
        private Types types;
        private LinkedList<TypeMirror> list = new LinkedList();

        public UnrelatedTypeMirrorSet(Types types) {
            this.types = types;
        }

        @Override
        public boolean add(TypeMirror typeMirror) {
            ListIterator it = this.list.listIterator();
            while (it.hasNext()) {
                TypeMirror tm = (TypeMirror)it.next();
                if (this.types.isSubtype(typeMirror, tm)) {
                    return false;
                }
                if (!this.types.isSubtype(tm, typeMirror)) continue;
                it.remove();
            }
            return this.list.add(typeMirror);
        }

        @Override
        public Iterator<TypeMirror> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            return this.list.size();
        }
    }

    private static class UncaughtExceptionsVisitor
    extends TreePathScanner<Void, Set<TypeMirror>> {
        private final CompilationInfo info;

        private UncaughtExceptionsVisitor(CompilationInfo info) {
            this.info = info;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Set<TypeMirror> p) {
            super.visitMethodInvocation(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.METHOD) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitNewClass(NewClassTree node, Set<TypeMirror> p) {
            super.visitNewClass(node, p);
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getKind() == ElementKind.CONSTRUCTOR) {
                p.addAll(((ExecutableElement)el).getThrownTypes());
            }
            return null;
        }

        @Override
        public Void visitThrow(ThrowTree node, Set<TypeMirror> p) {
            super.visitThrow(node, p);
            TypeMirror tm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getExpression()));
            if (tm != null && tm.getKind() == TypeKind.DECLARED) {
                p.add(tm);
            }
            return null;
        }

        @Override
        public Void visitTry(TryTree node, Set<TypeMirror> p) {
            HashSet s = new HashSet();
            this.scan(node.getBlock(), s);
            for (CatchTree catchTree : node.getCatches()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                if (t.getKind() == TypeKind.ERROR) continue;
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)it.next(), t)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            this.scan(node.getCatches(), p);
            this.scan(node.getFinallyBlock(), p);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree node, Set<TypeMirror> p) {
            HashSet s = new HashSet();
            this.scan(node.getBody(), s);
            for (ExpressionTree expressionTree : node.getThrows()) {
                TypeMirror t = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), expressionTree));
                if (t.getKind() == TypeKind.ERROR) continue;
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    if (!this.info.getTypes().isSubtype((TypeMirror)it.next(), t)) continue;
                    it.remove();
                }
            }
            p.addAll(s);
            return null;
        }

        @Override
        public Void visitClass(ClassTree node, Set<TypeMirror> p) {
            return null;
        }
    }
}

