/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeTargetPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = -8864738441088422274L;
    private GridBagConstraints grid;
    Insets insets;
    private JTextField targetName;
    private JTextField dependsOn;
    private JTextField subdirectory;
    private JTextField makeFlags;
    private JTextArea commandDisplay;
    private boolean enableCommandSelection;
    private String tname;
    private String depends;
    private String subdir;
    private String mflags;
    private int row;
    private boolean initialized;
    private int key;

    MakeTargetPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = new String(this.getString("LBL_MakeTargetPanel"));
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        this.insets = new Insets(10, 0, 0, 0);
        this.grid = new GridBagConstraints();
        this.grid.anchor = 18;
        this.grid.insets = this.insets;
        this.tname = new String("");
        this.depends = new String("");
        this.subdir = new String("");
        this.mflags = new String("");
        this.row = 0;
        JPanel tpanel = this.createTextFields();
        this.insets.top = 0;
        this.insets.left = 0;
        this.grid.gridx = 0;
        this.grid.gridy = 0;
        this.grid.insets = this.insets;
        this.add((Component)tpanel, this.grid);
        Dimension tsize = tpanel.getPreferredSize();
        Dimension psize = this.getPreferredSize();
        Dimension csize = new Dimension(psize.width, psize.height - tsize.height);
        this.createCommandDisplay(csize, "LBL_CommandDisplay", "MNEM_CommandDisplay");
        this.setupListeners();
    }

    private JPanel createTextFields() {
        JPanel tpanel = new JPanel(new GridBagLayout());
        this.targetName = this.createTextField(tpanel, "LBL_TargetName", "MNEM_TargetName");
        this.dependsOn = this.createTextField(tpanel, "LBL_DependsOn", "MNEM_DependsOn");
        this.subdirectory = this.createTextField(tpanel, "LBL_Subdirectory", "MNEM_Subdirectory");
        this.makeFlags = this.createTextField(tpanel, "LBL_MakeFlags", "MNEM_MakeFlags");
        return tpanel;
    }

    private JTextField createTextField(JPanel tpanel, String label, String mnem) {
        JLabel nueLabel = new JLabel(this.getString(label));
        JTextField nueText = new JTextField();
        this.insets.left = 0;
        this.grid.gridx = 0;
        this.grid.gridy = this.row++;
        this.grid.gridwidth = 1;
        this.grid.weightx = 0.0;
        tpanel.add((Component)nueLabel, this.grid);
        this.insets.left = 5;
        this.grid.gridx = 1;
        this.grid.gridwidth = 0;
        this.grid.weightx = 1.0;
        this.grid.fill = 2;
        tpanel.add((Component)nueText, this.grid);
        nueLabel.setDisplayedMnemonic(this.getString(mnem).charAt(0));
        nueLabel.setLabelFor(nueText);
        return nueText;
    }

    private void createCommandDisplay(Dimension size, String label, String mnem) {
        JLabel nueLabel = new JLabel(this.getString(label));
        nueLabel.setDisplayedMnemonic(this.getString(mnem).charAt(0));
        this.insets.top = 16;
        this.grid.gridx = 0;
        this.grid.gridy = 1;
        this.grid.gridwidth = 1;
        this.add((Component)nueLabel, this.grid);
        size.setSize(size.getWidth(), size.getHeight() - (double)this.insets.top - nueLabel.getPreferredSize().getHeight());
        this.commandDisplay = new JTextArea();
        this.commandDisplay.setEditable(false);
        this.commandDisplay.setBackground(this.getBackground());
        this.commandDisplay.addFocusListener(this);
        JScrollPane s = new JScrollPane(this.commandDisplay);
        s.setHorizontalScrollBarPolicy(30);
        s.setVerticalScrollBarPolicy(20);
        size.height = size.height - this.insets.top - nueLabel.getPreferredSize().height;
        s.setPreferredSize(size);
        nueLabel.setLabelFor(this.commandDisplay);
        this.insets.top = 0;
        this.grid.gridy = 2;
        this.grid.gridwidth = 0;
        this.grid.gridheight = 0;
        this.add((Component)s, this.grid);
        this.enableCommandSelection = false;
    }

    @Override
    public void focusGained(FocusEvent evt) {
        if (this.enableCommandSelection) {
            this.commandDisplay.selectAll();
        }
        this.enableCommandSelection = true;
    }

    @Override
    public void focusLost(FocusEvent evt) {
        this.commandDisplay.setSelectionEnd(0);
    }

    private void setupListeners() {
        this.targetName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                MakeTargetPanel.this.tname = MakeTargetPanel.this.targetName.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.dependsOn.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                MakeTargetPanel.this.depends = MakeTargetPanel.this.dependsOn.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.subdirectory.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                MakeTargetPanel.this.subdir = MakeTargetPanel.this.subdirectory.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
        this.makeFlags.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void insertUpdate(DocumentEvent e) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }

            public void removeUpdate(DocumentEvent e) {
                MakeTargetPanel.this.mflags = MakeTargetPanel.this.makeFlags.getText();
                MakeTargetPanel.this.commandDisplay.setText(MakeTargetPanel.this.getCommandDisplay());
                MakeTargetPanel.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        MakefileWizard mw = MakefileWizard.getMakefileWizard();
        if (this.tname.length() > 0 || this.depends.length() > 0 || this.subdir.length() > 0 || this.mflags.length() > 0) {
            mw.getNextButton().setEnabled(true);
            if (mw.getMakefileData().isComplete(true)) {
                mw.getFinishButton().setEnabled(true);
            }
        } else {
            mw.getNextButton().setEnabled(false);
            mw.getFinishButton().setEnabled(false);
        }
    }

    @Override
    public boolean isPanelValid() {
        if (this.tname != null && this.depends != null && this.subdir != null && this.mflags != null) {
            return this.tname.length() > 0 || this.depends.length() > 0 || this.subdir.length() > 0 || this.mflags.length() > 0;
        }
        return false;
    }

    private String getCommandDisplay() {
        return this.getCommandDisplay(-1);
    }

    private String getCommandDisplay(int key) {
        StringBuilder buf = new StringBuilder(512);
        TargetData target = key < 0 ? this.getMakefileData().getCurrentTarget() : this.getMakefileData().getTarget(key);
        buf.append(target.getName());
        buf.append(": ");
        if (this.depends.length() > 0) {
            buf.append(this.depends);
        }
        String[] dirs = this.getSubDirList();
        for (int i = 0; i < dirs.length; ++i) {
            buf.append("\n\t");
            if (dirs[i].length() > 0) {
                buf.append("cd ").append(dirs[i]).append("; ");
            }
            buf.append("$(MAKE) ");
            if (this.mflags.length() > 0) {
                buf.append(this.mflags).append(' ');
            }
            if (this.tname.length() <= 0) continue;
            buf.append(this.tname);
        }
        return buf.toString();
    }

    private String[] getSubDirList() {
        String[] dirs;
        if (this.subdir.length() < 1 || this.subdir.equals(".")) {
            dirs = new String[]{new String("")};
        } else {
            StringTokenizer tok = new StringTokenizer(this.subdir, " ");
            int count = tok.countTokens();
            int i = 0;
            dirs = new String[count];
            while (tok.hasMoreTokens()) {
                dirs[i++] = tok.nextToken();
            }
        }
        return dirs;
    }

    @Override
    public void validateData(ArrayList<String> msgs, int key) {
        block5: {
            block3: {
                File sd;
                block4: {
                    String cwd = this.getMakefileData().getBaseDirectory(true);
                    sd = null;
                    if (this.subdir.length() > 0 && !this.subdir.equals(".") && (sd = this.subdir.startsWith(File.separator) ? new File(this.subdir) : new File(cwd, this.subdir)).getPath().equals(cwd)) {
                        sd = null;
                    }
                    if (sd == null) break block3;
                    if (sd.exists()) break block4;
                    this.warn(msgs, WARN_SUBDIR_DOES_NOT_EXIST, this.subdir, this.tname);
                    break block5;
                }
                if (sd.canWrite()) break block5;
                this.warn(msgs, WARN_SUBDIR_NOT_WRITABLE, this.subdir, this.tname);
                break block5;
            }
            List<TargetData> tlist = this.getMakefileData().getTargetList();
            for (int i = 0; i < tlist.size(); ++i) {
                if (!this.tname.equals(tlist.get(i).getName())) continue;
                this.warn(msgs, WARN_INFINITE_RECURSION, this.tname);
            }
        }
        if (!this.isValidMakeFlags()) {
            this.warn(msgs, WARN_INVALID_MAKEFLAGS);
        }
    }

    private boolean isValidMakeFlags() {
        int lastChar = 0;
        int squote = 0;
        int dquote = 0;
        for (int i = 0; i < this.mflags.length(); ++i) {
            char c = this.mflags.charAt(i);
            if (lastChar != 92) {
                if (c == '\'') {
                    ++squote;
                }
                if (c == '\"') {
                    ++dquote;
                }
            }
            lastChar = c;
        }
        return squote % 2 != 1 && dquote % 2 != 1;
    }

    @Override
    public void addNotify() {
        TargetData target = this.getMakefileData().getCurrentTarget();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        this.key = target.getKey();
        this.targetName.setText(this.tname);
        this.dependsOn.setText(this.depends);
        this.subdirectory.setText(this.subdir);
        this.makeFlags.setText(this.mflags);
        this.commandDisplay.setText(this.getCommandDisplay());
        this.updateButtons();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData target = this.getMakefileData().getTarget(this.key);
        target.setTargetName(this.tname);
        target.setDependsOn(this.depends);
        target.setSubdirectory(this.subdir);
        target.setMakeFlags(this.mflags);
    }
}

