/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.parser;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeListener;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.cnd.api.makefile.MakefileElement;
import org.netbeans.modules.cnd.api.makefile.MakefileInclude;
import org.netbeans.modules.cnd.api.makefile.MakefileMacro;
import org.netbeans.modules.cnd.api.makefile.MakefileRule;
import org.netbeans.modules.cnd.makefile.MakefileApiAccessor;
import org.netbeans.modules.cnd.makefile.lexer.MakefileTokenId;
import org.netbeans.modules.cnd.makefile.parser.MakefileParseResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakefileParser
extends Parser {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private MakefileParseResult result;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.result = null;
        this.cancelled.set(false);
        this.result = MakefileParser.parse(snapshot, this.cancelled);
    }

    public MakefileParseResult getResult(Task task) throws ParseException {
        return this.result;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private static MakefileParseResult parse(Snapshot snapshot, AtomicBoolean cancelled) {
        TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence(MakefileTokenId.language());
        if (tokenSequence == null) {
            return null;
        }
        FileObject fobj = snapshot.getSource().getFileObject();
        ArrayList<MakefileElement> makefileElements = new ArrayList<MakefileElement>(1);
        int startIndex = 0;
        while (tokenSequence.moveNext() && !cancelled.get()) {
            Token token = tokenSequence.token();
            switch ((MakefileTokenId)token.id()) {
                case EQUALS: 
                case COLON_EQUALS: {
                    tokenSequence.moveIndex(startIndex);
                    makefileElements.add(MakefileParser.createMacro(fobj, (TokenSequence<MakefileTokenId>)tokenSequence));
                    startIndex = tokenSequence.index() + 1;
                    break;
                }
                case COLON: {
                    tokenSequence.moveIndex(startIndex);
                    makefileElements.add(MakefileParser.createRule(fobj, (TokenSequence<MakefileTokenId>)tokenSequence));
                    startIndex = tokenSequence.index() + 1;
                    break;
                }
                case INCLUDE: {
                    makefileElements.add(MakefileParser.createInclude(fobj, (TokenSequence<MakefileTokenId>)tokenSequence));
                    startIndex = tokenSequence.index() + 1;
                    break;
                }
                case COMMENT: 
                case NEW_LINE: {
                    startIndex = tokenSequence.index() + 1;
                }
            }
        }
        return cancelled.get() ? null : new MakefileParseResult(snapshot, makefileElements);
    }

    private static MakefileMacro createMacro(FileObject fobj, TokenSequence<MakefileTokenId> tokenSequence) {
        StringBuilder nameBuilder = new StringBuilder();
        int startOffset = -1;
        block6: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (startOffset == -1) {
                startOffset = tokenSequence.offset();
            }
            switch ((MakefileTokenId)token.id()) {
                case EQUALS: 
                case COLON_EQUALS: {
                    break block6;
                }
                default: {
                    nameBuilder.append(token.text());
                    continue block6;
                }
            }
        }
        StringBuilder valueBuilder = new StringBuilder();
        block7: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            switch ((MakefileTokenId)token.id()) {
                case COMMENT: 
                case NEW_LINE: {
                    break block7;
                }
                default: {
                    valueBuilder.append(token.text());
                    continue block7;
                }
            }
        }
        int endOffset = tokenSequence.offset();
        return MakefileApiAccessor.getInstance().newMakefileMacro(fobj, startOffset, endOffset, nameBuilder.toString().trim(), valueBuilder.toString());
    }

    private static MakefileRule createRule(FileObject fobj, TokenSequence<MakefileTokenId> tokenSequence) {
        StringBuilder nameBuilder = new StringBuilder();
        int startOffset = -1;
        ArrayList<String> targets = new ArrayList<String>(1);
        block8: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (startOffset == -1) {
                startOffset = tokenSequence.offset();
            }
            switch ((MakefileTokenId)token.id()) {
                case COLON: {
                    if (0 >= nameBuilder.length()) break block8;
                    targets.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    break block8;
                }
                case WHITESPACE: 
                case ESCAPED_NEW_LINE: {
                    if (0 >= nameBuilder.length()) continue block8;
                    targets.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    continue block8;
                }
                default: {
                    nameBuilder.append(token.text());
                    continue block8;
                }
            }
        }
        ArrayList<String> prereqs = new ArrayList<String>(1);
        block9: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            switch ((MakefileTokenId)token.id()) {
                case WHITESPACE: 
                case ESCAPED_NEW_LINE: {
                    if (0 >= nameBuilder.length()) continue block9;
                    prereqs.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    continue block9;
                }
                case COMMENT: 
                case NEW_LINE: {
                    if (0 >= nameBuilder.length()) break block9;
                    prereqs.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    break block9;
                }
                default: {
                    nameBuilder.append(token.text());
                    continue block9;
                }
            }
        }
        int endOffset = tokenSequence.offset();
        return MakefileApiAccessor.getInstance().newMakefileRule(fobj, startOffset, endOffset, targets, prereqs);
    }

    private static MakefileInclude createInclude(FileObject fobj, TokenSequence<MakefileTokenId> tokenSequence) {
        StringBuilder nameBuilder = new StringBuilder();
        int startOffset = tokenSequence.offset();
        ArrayList<String> fileNames = new ArrayList<String>(1);
        block4: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            switch ((MakefileTokenId)token.id()) {
                case WHITESPACE: 
                case ESCAPED_NEW_LINE: {
                    if (0 >= nameBuilder.length()) continue block4;
                    fileNames.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    continue block4;
                }
                case COMMENT: 
                case NEW_LINE: {
                    if (0 >= nameBuilder.length()) break block4;
                    fileNames.add(nameBuilder.toString());
                    nameBuilder.setLength(0);
                    break block4;
                }
                default: {
                    nameBuilder.append(token.text());
                    continue block4;
                }
            }
        }
        return MakefileApiAccessor.getInstance().newMakefileInclude(fobj, startOffset, startOffset, fileNames);
    }
}

