/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.log.LogBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class RlogCommand
extends BasicCommand {
    private final List modules = new LinkedList();
    private boolean defaultBranch;
    private String dateFilter;
    private boolean headerOnly;
    private boolean suppressHeader;
    private boolean noTags;
    private String revisionFilter;
    private String stateFilter;
    private String userFilter;
    private boolean headerAndDescOnly;

    public RlogCommand() {
        this.resetCVSCommand();
    }

    public void setModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] modules) {
        this.clearModules();
        if (modules == null) {
            return;
        }
        for (int i = 0; i < modules.length; ++i) {
            String module = modules[i];
            this.modules.add(module);
        }
    }

    public String[] getModules() {
        String[] mods = new String[this.modules.size()];
        mods = this.modules.toArray(mods);
        return mods;
    }

    public boolean isDefaultBranch() {
        return this.defaultBranch;
    }

    public void setDefaultBranch(boolean defaultBranch) {
        this.defaultBranch = defaultBranch;
    }

    public String getDateFilter() {
        return this.dateFilter;
    }

    public void setDateFilter(String dateFilter) {
        this.dateFilter = dateFilter;
    }

    public boolean isHeaderOnly() {
        return this.headerOnly;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    public boolean isSuppressHeader() {
        return this.suppressHeader;
    }

    public void setSuppressHeader(boolean suppressHeader) {
        this.suppressHeader = suppressHeader;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    public void setNoTags(boolean noTags) {
        this.noTags = noTags;
    }

    public String getRevisionFilter() {
        return this.revisionFilter;
    }

    public void setRevisionFilter(String revisionFilter) {
        this.revisionFilter = revisionFilter;
    }

    public String getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
    }

    public boolean isHeaderAndDescOnly() {
        return this.headerAndDescOnly;
    }

    public void setHeaderAndDescOnly(boolean headerAndDescOnly) {
        this.headerAndDescOnly = headerAndDescOnly;
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        super.execute(client, em);
        if (!this.isRecursive()) {
            this.requests.add(new ArgumentRequest("-l"));
        }
        if (this.defaultBranch) {
            this.requests.add(new ArgumentRequest("-b"));
        }
        if (this.headerAndDescOnly) {
            this.requests.add(new ArgumentRequest("-t"));
        }
        if (this.headerOnly) {
            this.requests.add(new ArgumentRequest("-h"));
        }
        if (this.suppressHeader) {
            this.requests.add(new ArgumentRequest("-S"));
        }
        if (this.noTags) {
            this.requests.add(new ArgumentRequest("-N"));
        }
        if (this.userFilter != null) {
            this.requests.add(new ArgumentRequest("-w" + this.userFilter));
        }
        if (this.revisionFilter != null) {
            this.requests.add(new ArgumentRequest("-r" + this.revisionFilter));
        }
        if (this.stateFilter != null) {
            this.requests.add(new ArgumentRequest("-s" + this.stateFilter));
        }
        if (this.dateFilter != null) {
            this.requests.add(new ArgumentRequest("-d" + this.dateFilter));
        }
        Iterator it = this.modules.iterator();
        while (it.hasNext()) {
            String module = (String)it.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.requests.add(CommandRequest.RLOG);
        try {
            client.processRequests(this.requests);
            this.requests.clear();
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return false;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("rlog ");
        toReturn.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator it = this.modules.iterator();
            while (it.hasNext()) {
                String module = (String)it.next();
                toReturn.append(module);
                toReturn.append(' ');
            }
        } else {
            String localizedMsg = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        return toReturn.toString();
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isDefaultBranch()) {
            toReturn.append("-b ");
        }
        if (this.isHeaderAndDescOnly()) {
            toReturn.append("-t ");
        }
        if (this.isHeaderOnly()) {
            toReturn.append("-h ");
        }
        if (this.isSuppressHeader()) {
            toReturn.append("-S ");
        }
        if (this.isNoTags()) {
            toReturn.append("-N ");
        }
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.userFilter != null) {
            toReturn.append("-w");
            toReturn.append(this.userFilter);
            toReturn.append(' ');
        }
        if (this.revisionFilter != null) {
            toReturn.append("-r");
            toReturn.append(this.revisionFilter);
            toReturn.append(' ');
        }
        if (this.stateFilter != null) {
            toReturn.append("-s");
            toReturn.append(this.stateFilter);
            toReturn.append(' ');
        }
        if (this.dateFilter != null) {
            toReturn.append("-d");
            toReturn.append(this.dateFilter);
            toReturn.append(' ');
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'b') {
            this.setDefaultBranch(true);
        } else if (opt == 'h') {
            this.setHeaderOnly(true);
        } else if (opt == 't') {
            this.setHeaderAndDescOnly(true);
        } else if (opt == 'S') {
            this.setSuppressHeader(true);
        } else if (opt == 'N') {
            this.setNoTags(true);
        } else if (opt == 'd') {
            this.setDateFilter(optArg);
        } else if (opt == 'r') {
            this.setRevisionFilter(optArg == null ? "" : optArg);
        } else if (opt == 's') {
            this.setStateFilter(optArg);
        } else if (opt == 'w') {
            this.setUserFilter(optArg == null ? "" : optArg);
        } else {
            return false;
        }
        return true;
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setDefaultBranch(false);
        this.setHeaderOnly(false);
        this.setHeaderAndDescOnly(false);
        this.setSuppressHeader(false);
        this.setNoTags(false);
        this.setDateFilter(null);
        this.setRevisionFilter(null);
        this.setStateFilter(null);
        this.setUserFilter(null);
    }

    public String getOptString() {
        return "RlbhStNd:r:s:w:";
    }

    public Builder createBuilder(EventManager eventMan) {
        return new LogBuilder(eventMan, this);
    }
}

