/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ClassInstanceMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.SerializedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.mappings.MapKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingAccessor
extends MetadataAccessor {
    private static final String CONVERT_NONE = "none";
    private static final String CONVERT_SERIALIZED = "serialized";
    private static final String CONVERT_CLASS_INSTANCE = "class-instance";
    protected static final String KEY_DOT_NOTATION = "key.";
    protected static final String VALUE_DOT_NOTATION = "value.";
    private static final String DEFAULT_MAP_KEY_COLUMN_SUFFIX = "_KEY";
    private AccessMethodsMetadata m_accessMethods;
    private ClassAccessor m_classAccessor;
    private DatabaseMapping m_mapping;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();

    protected MappingAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
    }

    protected MappingAccessor(String xmlElement) {
        super(xmlElement);
    }

    public boolean derivesId() {
        return false;
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor aggregatesAccessor) {
        DatabaseMapping aggregatesMapping = aggregatesAccessor.getMapping();
        DatabaseField aggregatesMappingField = aggregatesMapping.getField();
        if (aggregatesAccessor.isId()) {
            this.updatePrimaryKeyField(aggregatesAccessor, overrideField);
        }
        if (overrideName.indexOf(".") > -1) {
            embeddableMapping.addNestedFieldNameTranslation(overrideName, overrideField.getQualifiedName(), aggregatesMappingField.getName());
        } else {
            embeddableMapping.addFieldNameTranslation(overrideField.getQualifiedName(), aggregatesMappingField.getName());
        }
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    protected Map<String, AssociationOverrideMetadata> getAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides) {
        String name;
        HashMap<String, AssociationOverrideMetadata> associationOverridesMap = new HashMap<String, AssociationOverrideMetadata>();
        for (AssociationOverrideMetadata associationOverride : associationOverrides) {
            name = associationOverride.getName();
            String dotNotationName = this.getAttributeName() + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAssociationOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_association_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                associationOverridesMap.put(name, this.getDescriptor().getAssociationOverrideFor(dotNotationName));
                continue;
            }
            associationOverridesMap.put(name, associationOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AssociationOverrideMetadata associationOverride : this.getDescriptor().getAssociationOverrides()) {
                String attributeName = name = associationOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || associationOverridesMap.containsKey(attributeName)) continue;
                associationOverridesMap.put(overrideName, associationOverride);
            }
        }
        return associationOverridesMap;
    }

    @Override
    public String getAttributeName() {
        if (this.m_accessMethods == null) {
            return this.getAccessibleObject().getAttributeName();
        }
        return this.getName();
    }

    protected AttributeOverrideMetadata getAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().getAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return this.getDescriptor().getAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName());
        }
        return this.getDescriptor().getAttributeOverrideFor(this.getAttributeName());
    }

    protected Map<String, AttributeOverrideMetadata> getAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides) {
        String name;
        HashMap<String, AttributeOverrideMetadata> attributeOverridesMap = new HashMap<String, AttributeOverrideMetadata>();
        for (AttributeOverrideMetadata attributeOverride : attributeOverrides) {
            name = attributeOverride.getName();
            String dotNotationName = this.getAttributeName() + "." + name;
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAttributeOverrideFor(dotNotationName)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_warning_ignore_attribute_override", name, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                attributeOverridesMap.put(name, this.getDescriptor().getAttributeOverrideFor(dotNotationName));
                continue;
            }
            attributeOverridesMap.put(name, attributeOverride);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AttributeOverrideMetadata attributeOverride : this.getDescriptor().getAttributeOverrides()) {
                String attributeName = name = attributeOverride.getName();
                String overrideName = name;
                int indexOfFirstDot = name.indexOf(".");
                if (indexOfFirstDot > -1) {
                    attributeName = name.substring(0, indexOfFirstDot);
                    overrideName = name.substring(indexOfFirstDot + 1);
                }
                if (!attributeName.equals(this.getAttributeName()) || attributeOverridesMap.containsKey(attributeName)) continue;
                attributeOverridesMap.put(overrideName, attributeOverride);
            }
        }
        return attributeOverridesMap;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        return new ColumnMetadata(this.getAccessibleObject());
    }

    protected DatabaseField getDatabaseField(DatabaseTable defaultTable, String loggingCtx) {
        ColumnMetadata column = this.hasAttributeOverride(loggingCtx) ? this.getAttributeOverride(loggingCtx).getColumn() : this.getColumn(loggingCtx);
        DatabaseField field = column.getDatabaseField();
        if (field.getTableName().equals("")) {
            field.setTable(defaultTable);
        }
        String defaultName = this.getDefaultAttributeName();
        if (loggingCtx.equals("metadata_default_key_column")) {
            defaultName = defaultName + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        }
        this.setFieldName(field, defaultName, loggingCtx);
        if (field.getTable() != null && this.useDelimitedIdentifier()) {
            field.getTable().setUseDelimiters(this.useDelimitedIdentifier());
        }
        return field;
    }

    protected String getDefaultFetchType() {
        return FetchType.EAGER.name();
    }

    protected DatabaseTable getDefaultTableForEntityMapKey() {
        return this.getReferenceDescriptor().getPrimaryTable();
    }

    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return null;
    }

    protected String getGetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getGetMethodName() != null) {
            return this.m_accessMethods.getGetMethodName();
        }
        return this.getAccessibleObjectName();
    }

    protected List<JoinColumnMetadata> getJoinColumns(List<JoinColumnMetadata> potentialJoinColumns, MetadataDescriptor descriptor) {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.getJoinColumnsAndValidate(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), descriptor);
        }
        return this.getJoinColumnsAndValidate(potentialJoinColumns, descriptor);
    }

    protected List<JoinColumnMetadata> getJoinColumnsAndValidate(List<JoinColumnMetadata> joinColumns, MetadataDescriptor descriptor) {
        if (joinColumns.isEmpty()) {
            if (descriptor.hasCompositePrimaryKey()) {
                for (String primaryKeyField : descriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField);
                    joinColumn.setName(primaryKeyField);
                    joinColumns.add(joinColumn);
                }
            } else {
                joinColumns.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumn : joinColumns) {
                joinColumn.setReferencedColumnName(descriptor.getPrimaryKeyJoinColumnAssociation(joinColumn.getReferencedColumnName()));
            }
        }
        if (descriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumn : joinColumns) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        }
        return joinColumns;
    }

    public LobMetadata getLob(boolean isForMapKey) {
        return null;
    }

    public DatabaseMapping getMapping() {
        return this.m_mapping;
    }

    protected int getMappingJoinFetchType(String joinFetchType) {
        if (joinFetchType == null) {
            return 0;
        }
        if (joinFetchType.equals(JoinFetchType.INNER.name())) {
            return 1;
        }
        return 2;
    }

    public MetadataDescriptor getOwningDescriptor() {
        return this.getClassAccessor().getOwningDescriptor();
    }

    public List<MetadataDescriptor> getOwningDescriptors() {
        return this.getClassAccessor().getOwningDescriptors();
    }

    public MapKeyMetadata getMapKey() {
        return null;
    }

    public MetadataClass getMapKeyReferenceClass() {
        if (this.isMapAccessor()) {
            MetadataClass referenceClass = this.getAccessibleObject().getMapKeyClass(this.getDescriptor());
            if (referenceClass == null) {
                throw ValidationException.unableToDetermineMapKeyClass(this.getAttributeName(), this.getJavaClass());
            }
            if (this.getClassAccessor().isMappedSuperclass()) {
                try {
                    MetadataHelper.getClassForName(referenceClass.getName(), this.getMetadataFactory().getLoader());
                }
                catch (ValidationException exception) {
                    return new MetadataClass(this.getMetadataFactory(), Void.class);
                }
            }
            return referenceClass;
        }
        return this.getMetadataFactory().getMetadataClass(Void.TYPE.getName());
    }

    public MetadataClass getRawClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Collection<MappingAccessor> getReferenceAccessors() {
        return this.getReferenceDescriptor().getAccessors();
    }

    public MetadataClass getReferenceClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public MetadataClass getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    protected DatabaseTable getReferenceDatabaseTable() {
        return this.getReferenceDescriptor().getPrimaryKeyTable();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        ClassAccessor accessor = this.getProject().getAccessor(this.getReferenceClassName());
        if (accessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit(this.getReferenceClassName());
        }
        return accessor.getDescriptor();
    }

    protected String getSetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getSetMethodName() != null) {
            return this.m_accessMethods.getSetMethodName();
        }
        return ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return null;
    }

    protected boolean hasAttributeOverride(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            return this.getDescriptor().hasAttributeOverrideFor(KEY_DOT_NOTATION + this.getAttributeName());
        }
        if (loggingCtx.equals("metadata_default_value_column") && this.getDescriptor().hasAttributeOverrideFor(VALUE_DOT_NOTATION + this.getAttributeName())) {
            return true;
        }
        return this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName());
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert(boolean isForMapKey) {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasEnumerated(boolean isForMapKey) {
        return false;
    }

    protected boolean hasLob(boolean isForMapKey) {
        return false;
    }

    public boolean hasMapKey() {
        return false;
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public boolean hasTemporal(boolean isForMapKey) {
        return false;
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.setEntityMappings(classAccessor.getEntityMappings());
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_accessMethods, accessibleObject);
    }

    public boolean isBasic() {
        return false;
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isBasicMap() {
        return false;
    }

    public boolean isDerivedIdClass() {
        return false;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public boolean isDirectEmbeddableCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    protected boolean isEnumerated(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasEnumerated(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_enumerated", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasEnumerated(isForMapKey) || EnumeratedMetadata.isValidEnumeratedType(referenceClass);
    }

    public boolean isId() {
        return false;
    }

    protected boolean isLob(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasLob(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_lob", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasLob(isForMapKey);
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isMapAccessor() {
        return this.getAccessibleObject().isSupportedMapClass(this.getDescriptor());
    }

    public boolean isMappedKeyMapAccessor() {
        return MappedKeyMapAccessor.class.isAssignableFrom(this.getClass()) && this.isMapAccessor() && !this.hasMapKey();
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    protected boolean isPrimitiveWrapperClass(MetadataClass cls) {
        return cls.extendsClass(Number.class) || cls.equals(Boolean.class) || cls.equals(Character.class) || cls.equals(String.class) || cls.extendsClass(BigInteger.class) || cls.extendsClass(BigDecimal.class) || cls.extendsClass(Date.class) || cls.extendsClass(Calendar.class);
    }

    @Override
    public boolean isProcessed() {
        return this.m_mapping != null;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isSerialized(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            this.getLogger().logConfigMessage("metadata_warning_ignore_serialized", this.getJavaClass(), (Object)this.getAnnotatedElement());
            return false;
        }
        return this.isValidSerializedType(referenceClass);
    }

    protected boolean isTemporal(MetadataClass referenceClass, boolean isForMapKey) {
        if (this.hasConvert(isForMapKey)) {
            if (this.hasTemporal(isForMapKey)) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_temporal", this.getJavaClass(), this.getAnnotatedElement());
            }
            return false;
        }
        return this.hasTemporal(isForMapKey) || TemporalMetadata.isValidTemporalType(referenceClass);
    }

    public boolean isTransient() {
        return false;
    }

    protected boolean isValidSerializedType(MetadataClass cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (this.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (LobMetadata.isValidLobType(cls)) {
            return false;
        }
        return !TemporalMetadata.isValidTemporalType(cls);
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        throw ValidationException.invalidEmbeddableAttributeForAssociationOverride(this.getJavaClass(), this.getAttributeName(), associationOverride.getName(), associationOverride.getLocation());
    }

    protected void processAssociationOverrides(List<AssociationOverrideMetadata> associationOverrides, EmbeddableMapping embeddableMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AssociationOverrideMetadata> mergedAssociationOverrides = this.getAssociationOverrides(associationOverrides);
        for (String attributeName : mergedAssociationOverrides.keySet()) {
            AssociationOverrideMetadata associationOverride = mergedAssociationOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getAccessorFor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAssociationOverrideNotFound(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            mappingAccessor.processAssociationOverride(associationOverride, embeddableMapping, this.getOwningDescriptor());
        }
    }

    protected void processAttributeOverrides(List<AttributeOverrideMetadata> attributeOverrides, AggregateObjectMapping aggregateObjectMapping, MetadataDescriptor embeddableDescriptor) {
        Map<String, AttributeOverrideMetadata> mergedAttributeOverrides = this.getAttributeOverrides(attributeOverrides);
        for (String attributeName : mergedAttributeOverrides.keySet()) {
            AttributeOverrideMetadata attributeOverride = mergedAttributeOverrides.get(attributeName);
            MappingAccessor mappingAccessor = embeddableDescriptor.getAccessorFor(attributeName);
            if (mappingAccessor == null) {
                throw ValidationException.embeddableAttributeOverrideNotFound(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            if (!mappingAccessor.isBasic()) {
                throw ValidationException.invalidEmbeddableAttributeForAttributeOverride(embeddableDescriptor.getJavaClass(), attributeName, this.getJavaClass(), this.getAttributeName());
            }
            this.addFieldNameTranslation(aggregateObjectMapping, attributeName, attributeOverride.getColumn().getDatabaseField(), mappingAccessor);
        }
    }

    protected void processContainerPolicyAndIndirection(CollectionMapping mapping) {
        if (this.isMappedKeyMapAccessor()) {
            this.processMapKeyClass(mapping, (MappedKeyMapAccessor)((Object)this));
        } else if (this.isMapAccessor()) {
            MapKeyMetadata mapKey = this.getMapKey();
            if (mapKey == null) {
                this.setIndirectionPolicy(mapping, new MapKeyMetadata().process(mapping, this), this.usesIndirection());
            } else {
                this.setIndirectionPolicy(mapping, mapKey.process(mapping, this), this.usesIndirection());
            }
        } else {
            this.setIndirectionPolicy(mapping, null, this.usesIndirection());
        }
    }

    protected void processConvert(DatabaseMapping mapping, String converterName, MetadataClass referenceClass, boolean isForMapKey) {
        if (!converterName.equals(CONVERT_NONE)) {
            if (converterName.equals(CONVERT_SERIALIZED)) {
                this.processSerialized(mapping, referenceClass, isForMapKey);
            } else if (converterName.equals(CONVERT_CLASS_INSTANCE)) {
                new ClassInstanceMetadata().process(mapping, this, referenceClass, isForMapKey);
            } else {
                AbstractConverterMetadata converter = this.getProject().getConverter(converterName);
                if (converter == null) {
                    throw ValidationException.converterNotFound(this.getJavaClass(), converterName, this.getAnnotatedElement());
                }
                converter.process(mapping, this, referenceClass, isForMapKey);
            }
        }
    }

    protected DirectToFieldMapping processDirectMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        DirectToFieldMapping keyMapping = new DirectToFieldMapping();
        DatabaseField mapKeyField = this.getDatabaseField(this.getReferenceDatabaseTable(), "metadata_default_key_column");
        keyMapping.setField(mapKeyField);
        keyMapping.setIsReadOnly(mapKeyField.isReadOnly());
        this.processMappingKeyConverter(keyMapping, mappedKeyMapAccessor.getMapKeyConvert(), mappedKeyMapAccessor.getMapKeyClass());
        keyMapping.setAttributeClassificationName(mappedKeyMapAccessor.getMapKeyClass().getName());
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        return keyMapping;
    }

    protected AggregateObjectMapping processEmbeddableMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        AggregateObjectMapping keyMapping = new AggregateObjectMapping();
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        keyMapping.setReferenceClassName(mapKeyClass.getName());
        EmbeddableAccessor mapKeyAccessor = this.getProject().getEmbeddableAccessor(mapKeyClass);
        mapKeyAccessor.getDescriptor().setIsEmbeddableCollection();
        this.processAttributeOverrides(mappedKeyMapAccessor.getMapKeyAttributeOverrides(), keyMapping, mapKeyAccessor.getDescriptor());
        this.processAssociationOverrides(mappedKeyMapAccessor.getMapKeyAssociationOverrides(), keyMapping, mapKeyAccessor.getDescriptor());
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        return keyMapping;
    }

    protected OneToOneMapping processEntityMapKeyClass(MappedKeyMapAccessor mappedKeyMapAccessor) {
        String mapKeyClassName = mappedKeyMapAccessor.getMapKeyClass().getName();
        OneToOneMapping keyMapping = new OneToOneMapping();
        keyMapping.setReferenceClassName(mapKeyClassName);
        keyMapping.dontUseIndirection();
        keyMapping.setDescriptor(this.getDescriptor().getClassDescriptor());
        EntityAccessor mapKeyAccessor = this.getProject().getEntityAccessor(mapKeyClassName);
        MetadataDescriptor mapKeyClassDescriptor = mapKeyAccessor.getDescriptor();
        String defaultPKFieldName = mapKeyClassDescriptor.getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getAttributeName() + DEFAULT_MAP_KEY_COLUMN_SUFFIX;
        this.processOneToOneForeignKeyRelationship(keyMapping, this.getJoinColumns(mappedKeyMapAccessor.getMapKeyJoinColumns(), mapKeyClassDescriptor), defaultPKFieldName, mapKeyClassDescriptor.getPrimaryTable(), defaultFKFieldName, this.getDefaultTableForEntityMapKey());
        return keyMapping;
    }

    protected void processEnumerated(EnumeratedMetadata enumerated, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (enumerated == null) {
            enumerated = new EnumeratedMetadata(this.getAccessibleObject());
        }
        enumerated.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processJPAConverters(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (this.isEnumerated(referenceClass, isForMapKey)) {
            this.processEnumerated(this.getEnumerated(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isLob(referenceClass, isForMapKey)) {
            this.processLob(this.getLob(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isTemporal(referenceClass, isForMapKey)) {
            this.processTemporal(this.getTemporal(isForMapKey), mapping, referenceClass, isForMapKey);
        } else if (this.isSerialized(referenceClass, isForMapKey)) {
            this.processSerialized(mapping, referenceClass, isForMapKey);
        }
    }

    protected void processLob(LobMetadata lob, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        lob.process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processMapKeyClass(CollectionMapping mapping, MappedKeyMapAccessor mappedKeyMapAccessor) {
        Class<Hashtable> containerClass;
        MetadataClass mapKeyClass = mappedKeyMapAccessor.getMapKeyClass();
        DatabaseMapping keyMapping = this.getProject().hasEntity(mapKeyClass) ? this.processEntityMapKeyClass(mappedKeyMapAccessor) : (this.getProject().hasEmbeddable(mapKeyClass) ? this.processEmbeddableMapKeyClass(mappedKeyMapAccessor) : this.processDirectMapKeyClass(mappedKeyMapAccessor));
        if (this.usesIndirection()) {
            containerClass = ClassConstants.IndirectMap_Class;
            mapping.setIndirectionPolicy(new TransparentIndirectionPolicy());
        } else {
            containerClass = Hashtable.class;
            mapping.dontUseIndirection();
        }
        MappedKeyMapContainerPolicy policy = new MappedKeyMapContainerPolicy(containerClass);
        policy.setKeyMapping((MapKeyMapping)((Object)keyMapping));
        policy.setValueMapping((MapComponentMapping)((Object)mapping));
        mapping.setContainerPolicy(policy);
    }

    protected void processMappingConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass, boolean isForMapKey) {
        if (convertValue != null && !convertValue.equals(CONVERT_NONE)) {
            this.processConvert(mapping, convertValue, referenceClass, isForMapKey);
        }
        this.processJPAConverters(mapping, referenceClass, isForMapKey);
    }

    protected void processMappingKeyConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass) {
        this.processMappingConverter(mapping, convertValue, referenceClass, true);
    }

    protected void processMappingValueConverter(DatabaseMapping mapping, String convertValue, MetadataClass referenceClass) {
        this.processMappingConverter(mapping, convertValue, referenceClass, false);
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping, List<JoinColumnMetadata> joinColumns, String defaultPKFieldName, DatabaseTable defaultPKTable, String defaultFKFieldName, DatabaseTable defaultFKTable) {
        boolean allReadOnly = true;
        for (JoinColumnMetadata joinColumn : joinColumns) {
            allReadOnly = allReadOnly && joinColumn.getForeignKeyField().isReadOnly();
        }
        for (JoinColumnMetadata joinColumn : joinColumns) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, defaultPKFieldName, "metadata_default_pk_column");
            pkField.setTable(defaultPKTable);
            DatabaseField fkField = joinColumn.getForeignKeyField();
            this.setFieldName(fkField, defaultFKFieldName, "metadata_default_fk_column");
            if (fkField.getTableName().equals("")) {
                fkField.setTable(defaultFKTable);
            }
            if (allReadOnly || !fkField.isReadOnly()) {
                mapping.addForeignKeyField(fkField, pkField);
                continue;
            }
            mapping.addTargetForeignKeyField(pkField, fkField);
        }
        if (allReadOnly) {
            mapping.setIsReadOnly(true);
        }
    }

    protected void processProperties(DatabaseMapping mapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata property : this.getProperties()) {
                this.processProperty(mapping, property);
            }
        } else {
            MetadataAnnotation property;
            MetadataAnnotation properties = this.getAnnotation(Properties.class);
            if (properties != null) {
                for (Object property2 : (Object[])properties.getAttribute("value")) {
                    this.processProperty(mapping, new PropertyMetadata((MetadataAnnotation)property2, this.getAccessibleObject()));
                }
            }
            if ((property = this.getAnnotation(Property.class)) != null) {
                this.processProperty(mapping, new PropertyMetadata(property, this.getAccessibleObject()));
            }
        }
    }

    protected void processProperty(DatabaseMapping mapping, PropertyMetadata property) {
        if (property.shouldOverride(this.m_properties.get(property.getName()))) {
            this.m_properties.put(property.getName(), property);
            mapping.getProperties().put(property.getName(), property.getConvertedValue());
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        new SerializedMetadata(this.getAccessibleObject()).process(mapping, this, referenceClass, isForMapKey);
    }

    protected void processSerialized(DatabaseMapping mapping, MetadataClass referenceClass, MetadataClass classification, boolean isForMapKey) {
        new SerializedMetadata(this.getAccessibleObject()).process(mapping, this, referenceClass, classification, isForMapKey);
    }

    protected void processTemporal(TemporalMetadata temporal, DatabaseMapping mapping, MetadataClass referenceClass, boolean isForMapKey) {
        if (temporal == null) {
            throw ValidationException.noTemporalTypeSpecified(this.getAttributeName(), this.getJavaClass());
        }
        temporal.process(mapping, this, referenceClass, isForMapKey);
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethods) {
        this.m_accessMethods = accessMethods;
    }

    protected void setAccessorMethods(DatabaseMapping mapping) {
        if (this.usesPropertyAccess(this.getDescriptor())) {
            mapping.setGetMethodName(this.getGetMethodName());
            mapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    protected void setIndirectionPolicy(CollectionMapping mapping, String mapKey, boolean usesIndirection) {
        MetadataClass rawClass = this.getRawClass();
        if (usesIndirection) {
            if (rawClass.equals(Map.class)) {
                if (mapping.isDirectMapMapping()) {
                    ((DirectMapMapping)mapping).useTransparentMap();
                } else {
                    mapping.useTransparentMap(mapKey);
                }
            } else if (rawClass.equals(List.class)) {
                mapping.useTransparentList();
            } else if (rawClass.equals(Collection.class)) {
                mapping.useTransparentCollection();
            } else if (rawClass.equals(Set.class)) {
                mapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), rawClass);
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass.equals(Map.class)) {
                if (mapping.isDirectMapMapping()) {
                    ((DirectMapMapping)mapping).useMapClass(Hashtable.class);
                } else {
                    mapping.useMapClass(Hashtable.class, mapKey);
                }
            } else if (rawClass.equals(Set.class)) {
                mapping.useCollectionClass(HashSet.class);
            } else if (rawClass.equals(List.class)) {
                mapping.useCollectionClass(Vector.class);
            } else if (rawClass.equals(Collection.class)) {
                mapping.setContainerPolicy(new CollectionContainerPolicy(Vector.class));
            } else if (mapKey == null || mapKey.equals("")) {
                mapping.useCollectionClassName(rawClass.getName());
            } else {
                mapping.useMapClassName(rawClass.getName(), mapKey);
            }
        }
    }

    protected void setMapping(DatabaseMapping mapping) {
        this.processProperties(mapping);
        this.getDescriptor().getClassDescriptor().addMapping(mapping);
        this.m_mapping = mapping;
    }

    public String toString() {
        return this.getAnnotatedElementName();
    }

    protected void updatePrimaryKeyField(MappingAccessor idAccessor, DatabaseField overrideField) {
        this.getOwningDescriptor().removePrimaryKeyField(idAccessor.getMapping().getField());
        this.getOwningDescriptor().addPrimaryKeyField(overrideField, idAccessor);
    }

    protected boolean usesIndirection() {
        return false;
    }

    public boolean usesPropertyAccess(MetadataDescriptor descriptor) {
        if (this.hasAccess()) {
            return this.hasPropertyAccess();
        }
        return this.m_accessMethods == null ? this.m_classAccessor.usesPropertyAccess() : true;
    }
}

