/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.swing.outline.NodeRowModel;
import org.netbeans.modules.websvc.manager.swing.outline.OutlineModel;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public class TypeCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    Component lastComponent;
    String type;
    private ClassLoader classLoader;

    public TypeCellEditor(ClassLoader classLoader) {
        super(new JTextField());
        this.setClickCountToStart(1);
        this.classLoader = classLoader;
    }

    @Override
    public void cancelCellEditing() {
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        if (null == this.type) {
            return ((JTextField)this.lastComponent).getText();
        }
        if (this.lastComponent instanceof JTextField) {
            String string = ((JTextField)this.lastComponent).getText();
            Object object = this.createValue(string);
            return object;
        }
        if (this.lastComponent instanceof JComboBox) {
            return ((JComboBox)this.lastComponent).getSelectedItem();
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        NodeRowModel nodeRowModel = ((OutlineModel)jTable.getModel()).getRowNodeModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)nodeRowModel.getNodeForRow(n);
        if (null == defaultMutableTreeNode.getUserObject()) {
            JTextField jTextField = new JTextField();
            jTextField.setText((String)object);
            this.lastComponent = jTextField;
        } else {
            TypeNodeData typeNodeData = (TypeNodeData)defaultMutableTreeNode.getUserObject();
            this.type = typeNodeData.getTypeClass();
            if (ReflectionHelper.isSimpleType(this.type, this.classLoader)) {
                if (this.type.equalsIgnoreCase(Boolean.TYPE.getName()) || this.type.equalsIgnoreCase(Boolean.class.getName())) {
                    JComboBox<Boolean> jComboBox;
                    this.lastComponent = jComboBox = new JComboBox<Boolean>();
                    jComboBox.addItem(new Boolean(true));
                    jComboBox.addItem(new Boolean(false));
                    Object object2 = typeNodeData.getTypeValue();
                    jComboBox.setSelectedItem(object2);
                    jComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TypeCellEditor.this.comboActionPerformed(actionEvent);
                        }
                    });
                } else {
                    JTextField jTextField = new JTextField();
                    if (null != object) {
                        jTextField.setText(object.toString());
                    }
                    this.lastComponent = jTextField;
                }
            } else if (ReflectionHelper.isEnumeration(this.type, this.classLoader)) {
                try {
                    JComboBox<Object> jComboBox = new JComboBox<Object>();
                    List<String> list = ReflectionHelper.getEnumerationValues(this.type, this.classLoader);
                    for (String string : list) {
                        Object object3 = ReflectionHelper.getEnumeration(this.type, string, this.classLoader);
                        jComboBox.addItem(object3);
                    }
                    this.lastComponent = jComboBox;
                    jComboBox.setSelectedItem(typeNodeData.getTypeValue());
                    jComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TypeCellEditor.this.comboActionPerformed(actionEvent);
                        }
                    });
                }
                catch (WebServiceReflectionException webServiceReflectionException) {
                    Throwable throwable = webServiceReflectionException.getCause();
                    ErrorManager.getDefault().notify(throwable);
                    ErrorManager.getDefault().log(this.getClass().getName() + ": Error retrieving Enum type on: " + "WebServiceReflectionException=" + throwable);
                }
            }
        }
        return this.lastComponent;
    }

    private void comboActionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        this.fireEditingStopped();
    }

    private Object createValue(String string) {
        Object object = null;
        String string2 = this.type;
        if (string2.equalsIgnoreCase("int") || string2.equalsIgnoreCase("java.lang.Integer")) {
            try {
                object = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Integer(0);
            }
        } else if (string2.equalsIgnoreCase("byte") || string2.equalsIgnoreCase("java.lang.Byte")) {
            try {
                object = new Byte(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Byte("0");
            }
        } else if (string2.equalsIgnoreCase("boolean") || string2.equalsIgnoreCase("java.lang.Boolean")) {
            try {
                object = new Boolean(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Boolean(false);
            }
        } else if (string2.equalsIgnoreCase("float") || string2.equalsIgnoreCase("java.lang.Float")) {
            try {
                object = new Float(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Float(0.0f);
            }
        } else if (string2.equalsIgnoreCase("double") || string2.equalsIgnoreCase("java.lang.Double")) {
            try {
                object = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Double(0.0);
            }
        } else if (string2.equalsIgnoreCase("long") || string2.equalsIgnoreCase("java.lang.Long")) {
            try {
                object = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Long(0L);
            }
        } else if (string2.equalsIgnoreCase("short") || string2.equalsIgnoreCase("java.lang.Short")) {
            try {
                object = new Short(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new Short(" ");
            }
        } else if (string2.equalsIgnoreCase("java.lang.String")) {
            object = string;
        } else if (string2.equalsIgnoreCase("java.math.BigDecimal")) {
            try {
                object = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new BigDecimal(0);
            }
        } else if (string2.equalsIgnoreCase("java.math.BigInteger")) {
            try {
                object = new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = new BigInteger("0");
            }
        } else if (string2.equalsIgnoreCase("java.net.URI")) {
            try {
                object = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    object = new URI("http://java.sun.com");
                }
                catch (URISyntaxException uRISyntaxException2) {}
            }
        } else if (string2.equalsIgnoreCase("java.util.Calendar")) {
            object = Calendar.getInstance();
        } else if (string2.equalsIgnoreCase("java.util.Date")) {
            try {
                object = DateFormat.getInstance().parse(string);
            }
            catch (ParseException parseException) {
                object = new Date();
            }
        }
        return object;
    }
}

