/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openide.ErrorManager;

public class SolarisRoutines {
    public static final int PATCH_INSTALLED = 0;
    public static final int PATCH_MISSING = 1;
    public static final int PATCH_UNKNOWN = 2;

    public static PkgInfo findPackage(String packageName) {
        int result = -1;
        StringBuffer cmdOutput = new StringBuffer();
        try {
            result = SolarisRoutines.executeRuntimeCommand("/bin/pkginfo -i -l " + packageName, cmdOutput);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
        if (result == 0) {
            return new PkgInfo(cmdOutput);
        }
        return null;
    }

    public static File createPatchScript() throws IOException {
        File showrev = new File("/bin/showrev");
        if (!showrev.exists()) {
            throw new FileNotFoundException("/bin/showrev is not found to check the installed patches");
        }
        File script = File.createTempFile("appserver-showrev", ".sh", new File("/tmp"));
        Process proc = Runtime.getRuntime().exec("chmod +x " + script);
        try {
            proc.waitFor();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        FileWriter out = new FileWriter(script);
        out.write("/bin/showrev -p | grep $1\n");
        out.close();
        return script;
    }

    public static String[] getUninstalledPatches(String[] patchList) throws IOException {
        File script = SolarisRoutines.createPatchScript();
        String filename = script.getAbsolutePath();
        ArrayList<String> uninstalledPatches = new ArrayList<String>(Arrays.asList(patchList));
        Iterator<String> iter = uninstalledPatches.iterator();
        while (iter.hasNext()) {
            String patch = iter.next();
            if (SolarisRoutines.checkPatch(patch, filename) != 0) continue;
            iter.remove();
        }
        script.delete();
        return uninstalledPatches.size() > 0 ? uninstalledPatches.toArray(new String[uninstalledPatches.size()]) : null;
    }

    public static int checkPatch(String patchId, String scriptAbsolutePath) {
        int result = -1;
        StringBuffer cmdOutput = new StringBuffer();
        String patchMajorVersion = patchId.substring(0, patchId.indexOf(45));
        try {
            result = SolarisRoutines.executeRuntimeCommand(scriptAbsolutePath + " " + patchMajorVersion, cmdOutput);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return 2;
        }
        if (result == 0) {
            if (SolarisRoutines.checkPatchInstalled(patchId, cmdOutput)) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    private static boolean checkPatchInstalled(String patchId, StringBuffer buffer) {
        String output = buffer.toString();
        String patchMajorVersion = patchId.substring(0, patchId.indexOf(45));
        String patchMinorVersion = patchId.substring(patchId.indexOf(45) + 1);
        int lineNum = 0;
        int patchCount = 0;
        int currentLine = 0;
        int startIndex = 0;
        lineNum = output.indexOf("Patch:", 0);
        while (lineNum != -1) {
            ++lineNum;
            ++patchCount;
            lineNum = output.indexOf("Patch:", lineNum);
        }
        lineNum = 0;
        while (currentLine < patchCount) {
            String infoString = (lineNum = output.indexOf("Patch:", lineNum + 1)) == -1 ? output.substring(startIndex) : output.substring(startIndex, lineNum);
            int beforePatchNum = infoString.indexOf(32);
            int afterPatchNum = infoString.indexOf(32, beforePatchNum + 1);
            String patch = infoString.substring(beforePatchNum, afterPatchNum).trim();
            String majorVersion = patch.substring(0, patch.indexOf(45));
            String minorVersion = patch.substring(patch.indexOf(45) + 1);
            if (majorVersion.equals(patchMajorVersion) && minorVersion.compareTo(patchMinorVersion) >= 0) {
                return true;
            }
            startIndex = lineNum;
            ++currentLine;
        }
        return false;
    }

    public static void killProcess(String processCmd) {
        block6: {
            String command = processCmd.trim();
            int index = command.indexOf(32);
            if (index != -1) {
                command = command.substring(0, index);
            }
            String pgrepCmd = "/bin/pgrep -f " + command;
            String ptreeCmd = "/bin/ptree ";
            String killCmd = "/bin/kill -9 ";
            try {
                int result = -1;
                StringBuffer cmdOutput = new StringBuffer();
                result = SolarisRoutines.executeRuntimeCommand(pgrepCmd, cmdOutput);
                if (result != 0 || cmdOutput.length() == 0) break block6;
                StringTokenizer stArr = new StringTokenizer(cmdOutput.toString());
                while (stArr.hasMoreTokens()) {
                    cmdOutput = new StringBuffer();
                    String token = stArr.nextToken().trim();
                    try {
                        Integer.valueOf(token);
                    }
                    catch (NumberFormatException ex) {
                        continue;
                    }
                    Thread.sleep(3000L);
                    result = SolarisRoutines.executeRuntimeCommand("/bin/ptree " + token, cmdOutput);
                    if (result != 0 || cmdOutput.length() == 0) continue;
                    String pidList = SolarisRoutines.parsePtreeInformation(cmdOutput, command);
                    result = SolarisRoutines.executeRuntimeCommand("/bin/kill -9 " + pidList, cmdOutput);
                }
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    private static String parsePtreeInformation(StringBuffer buffer, String command) {
        StringTokenizer stArr = new StringTokenizer(buffer.toString(), "\n");
        boolean isCmdFound = false;
        String pidList = "";
        while (stArr.hasMoreTokens()) {
            int index;
            String token = stArr.nextToken().trim();
            if (!isCmdFound) {
                index = token.indexOf(command);
                if (index == -1) continue;
                isCmdFound = true;
            }
            if ((index = token.indexOf(32)) == -1) continue;
            pidList = pidList + " " + token.substring(0, index);
        }
        return pidList;
    }

    public static int executeRuntimeCommand(String command, StringBuffer commandOutput) throws Exception {
        Process proc = Runtime.getRuntime().exec(command);
        try {
            proc.waitFor();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        InputStream pIn = proc.getInputStream();
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(pIn));
        if (inputReader.ready()) {
            int eof = 0;
            while (eof != -1) {
                char[] buffer = new char[250];
                eof = inputReader.read(buffer, 0, 250);
                commandOutput.append(buffer);
            }
        }
        inputReader.close();
        return proc.exitValue();
    }

    public static void main(String[] args) {
        try {
            File script = SolarisRoutines.createPatchScript();
            String filename = script.getAbsolutePath();
            System.out.println("Checking patch 108827-35 -> " + SolarisRoutines.checkPatch("108827-35", filename));
            System.out.println("Checking patch 109326-09 -> " + SolarisRoutines.checkPatch("109326-09", filename));
            System.out.println("Checking patch 110380-04 -> " + SolarisRoutines.checkPatch("110380-04", filename));
            System.out.println("Checking patch 110934-10 -> " + SolarisRoutines.checkPatch("110934-10", filename));
            System.out.println("Checking patch 109320-01 -> " + SolarisRoutines.checkPatch("109320-01", filename));
            System.out.println("Checking patch 108435-05 -> " + SolarisRoutines.checkPatch("108435-05", filename));
            System.out.println("Class -> " + SolarisRoutines.class.getName());
            System.out.println("os -> " + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
            script.delete();
            String[] patches = new String[]{"108827-35", "109326-09", "110380-04", "110934-10", "109320-01", "108435-05"};
            String[] results = SolarisRoutines.getUninstalledPatches(patches);
            String resultStr = results == null ? "all installed" : Arrays.asList(results).toString();
            System.out.println("All installed -> " + Arrays.asList(patches) + "\n" + resultStr);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static class PkgInfo {
        private String version = "";
        private String location = "";
        private double versionNumber = 0.0;
        private Date revision;
        private String pkgInst = "";

        private PkgInfo() {
        }

        public PkgInfo(StringBuffer info) {
            this.parsePackageInformation(info);
        }

        public String getPkgInst() {
            return this.pkgInst;
        }

        public String getVersion() {
            return this.version;
        }

        public String getLocation() {
            return this.location;
        }

        public double getVersionNumber() {
            return this.versionNumber;
        }

        public Date getRevision() {
            return this.revision;
        }

        public int compareTo(PkgInfo pkg) {
            if (this.versionNumber > pkg.getVersionNumber()) {
                return 1;
            }
            if (this.versionNumber < pkg.getVersionNumber()) {
                return -1;
            }
            if (this.revision != null && pkg.getRevision() != null) {
                return this.revision.compareTo(pkg.getRevision());
            }
            return 0;
        }

        private void parsePackageInformation(StringBuffer buffer) {
            StringTokenizer stArr = new StringTokenizer(buffer.toString());
            while (stArr.hasMoreTokens()) {
                String token = stArr.nextToken();
                if ("BASEDIR:".equals(token)) {
                    this.location = stArr.nextToken();
                    continue;
                }
                if ("PKGINST:".equals(token)) {
                    this.pkgInst = stArr.nextToken();
                    continue;
                }
                if (!"VERSION:".equals(token)) continue;
                this.version = stArr.nextToken();
                String key = ",REV=";
                int index = this.version.indexOf(",REV=");
                if (index == -1) continue;
                try {
                    this.versionNumber = Double.parseDouble(this.version.substring(0, index));
                    String rev = this.version.substring(index + ",REV=".length());
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd.hh.mm");
                    this.revision = formatter.parse(rev);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }
}

