/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;

public class ReferenceContextImpl
implements CsmReferenceContext {
    private final CsmReferenceContext parent;
    private final int parentSize;
    private final List stack;
    private int popCount;

    public ReferenceContextImpl() {
        this(null, false);
    }

    public ReferenceContextImpl(CsmReferenceContext parent) {
        this(parent, false);
    }

    public ReferenceContextImpl(CsmReferenceContext parent, boolean fullcopy) {
        if (fullcopy && parent != null) {
            this.parent = null;
            this.parentSize = 0;
            this.stack = new ArrayList();
            for (int i = 0; i < parent.size(); ++i) {
                this.stack.add(parent.getToken(i));
                this.stack.add(parent.getReference(i));
            }
        } else {
            this.parent = parent;
            this.parentSize = parent == null ? 0 : parent.size();
            this.stack = new ArrayList();
        }
    }

    public ReferenceContextImpl(ReferenceContextImpl c) {
        this.parentSize = c.parentSize;
        this.parent = c.parent != null ? new ReferenceContextImpl(c.parent) : null;
        this.stack = new ArrayList(c.stack);
        this.popCount = c.popCount;
    }

    public int size() {
        return this.parentSize - this.popCount + this.stack.size() / 2;
    }

    public CsmReference getReference() {
        return this.getReference(this.size() - 1);
    }

    public CsmReference getReference(int i) {
        if (0 <= i && i < this.parentSize - this.popCount) {
            return this.parent.getReference(i);
        }
        return (CsmReference)this.stack.get(2 * (i - this.parentSize + this.popCount) + 1);
    }

    public CppTokenId getToken() {
        return this.getToken(this.size() - 1);
    }

    public CppTokenId getToken(int i) {
        if (0 <= i && i < this.parentSize - this.popCount) {
            return this.parent.getToken(i);
        }
        return (CppTokenId)this.stack.get(2 * (i - this.parentSize + this.popCount));
    }

    void push(CppTokenId token, CsmReference ref) {
        this.stack.add(token);
        this.stack.add(ref);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pop() {
        if (this.stack.isEmpty()) {
            if (this.popCount >= this.parentSize) throw new IllegalStateException("Stack underflow");
            ++this.popCount;
            return;
        } else {
            this.stack.remove(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (0 < i) {
                buf.append(' ');
            }
            buf.append('(');
            buf.append(this.getToken(i));
            buf.append(',');
            CsmReference ref = this.getReference(i);
            buf.append(ref == null ? null : ref.getText());
            buf.append(')');
        }
        return buf.toString();
    }
}

