/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;

public class CsmCodeTemplateFilter
implements CodeTemplateFilter {
    private static boolean enabled = true;
    private int startOffset;
    private int endOffset;
    private CppTokenId id;

    static void enableAbbreviations(boolean enabled) {
        CsmCodeTemplateFilter.enabled = enabled;
    }

    private CsmCodeTemplateFilter(JTextComponent component, int offset) {
        this.startOffset = offset;
        this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : this.startOffset;
        this.id = this.getID(component, offset);
    }

    public synchronized boolean accept(CodeTemplate template) {
        return enabled && this.startOffset == this.endOffset && this.isTemplateContext(template);
    }

    private CppTokenId getID(JTextComponent component, int offset) {
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((JTextComponent)component, (int)offset, (boolean)true, (boolean)false);
        if (ts != null) {
            if (ts.offset() <= offset && !ts.movePrevious()) {
                return CppTokenId.ERROR;
            }
            return (CppTokenId)ts.token().id();
        }
        return CppTokenId.ERROR;
    }

    private boolean isTemplateContext(CodeTemplate template) {
        boolean res = true;
        switch (this.id) {
            case DOT: 
            case DOTMBR: 
            case SCOPE: 
            case ARROW: 
            case ARROWMBR: {
                res = false;
            }
        }
        return res;
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new CsmCodeTemplateFilter(component, offset);
        }
    }
}

