/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.deviceanywhere;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPI;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIDeviceWrapper;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIGetLockedDevicesReturn;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIService;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIStartDownloadScriptReturn;
import org.netbeans.modules.deployment.deviceanywhere.service.ApplicationAPIUploadApplicationReturn;

public class DeviceAnywhereUploadTask
extends Task {
    private ResourceBundle bundle;
    private String user;
    private String password;
    private int deviceId;
    private File jadFile;
    private File jarFile;
    private String career;

    public void execute() throws BuildException {
        this.bundle = ResourceBundle.getBundle("org/netbeans/modules/deployment/deviceanywhere/messages");
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DeviceAnywhereUploadTask.class.getClassLoader());
        System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.stream.ZephyrParserFactory");
        System.setProperty("javax.xml.stream.XMLOutputFactory", "com.sun.xml.stream.ZephyrWriterFactory");
        try {
            ApplicationAPIService serviceApi = new ApplicationAPIService();
            ApplicationAPI port = serviceApi.getApplicationAPI();
            boolean deviceLockedOK = false;
            try {
                ApplicationAPIGetLockedDevicesReturn lockedDevices = port.getLockedDevices(this.user, this.password);
                this.handleReturnCode(lockedDevices.getReturnCode());
                List result = lockedDevices.getDeviceWrappers().getDeviceWrappers();
                this.log("Found following devices:", 3);
                for (ApplicationAPIDeviceWrapper elem : result) {
                    this.log("Device: " + String.valueOf(elem.getId()), 3);
                    if (this.deviceId != elem.getId()) continue;
                    deviceLockedOK = true;
                    this.log("Device " + this.deviceId + " found", 3);
                }
            }
            catch (Exception ex) {
                if (ex instanceof ClassNotFoundException) {
                    throw new BuildException((Throwable)ex);
                }
                throw new BuildException(this.bundle.getString("can_not_connect"));
            }
            if (!deviceLockedOK) {
                throw new BuildException(this.bundle.getString("device_not_locked"));
            }
            byte[] jadData = null;
            byte[] jarData = null;
            FilterInputStream jad = null;
            FilterInputStream jar = null;
            try {
                String line;
                jad = new DataInputStream(new BufferedInputStream(new FileInputStream(this.jadFile)));
                jadData = new byte[jad.available()];
                ((DataInputStream)jad).read(jadData);
                StringBuffer filtered = new StringBuffer();
                BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(jadData)));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("MicroEdition-")) continue;
                    filtered.append(line).append("\r\n");
                }
                jadData = filtered.toString().getBytes();
                this.log("JAD file read", 3);
            }
            catch (Exception ex) {
                throw new BuildException(this.bundle.getString("error_reading_jad"));
            }
            finally {
                if (jad != null) {
                    try {
                        jad.close();
                    }
                    catch (IOException ex) {}
                }
            }
            try {
                jar = new DataInputStream(new BufferedInputStream(new FileInputStream(this.jarFile)));
                jarData = new byte[jar.available()];
                ((DataInputStream)jar).read(jarData);
                this.log("JAR file read", 3);
            }
            catch (Exception ex) {
                throw new BuildException(this.bundle.getString("error_reading_jar"));
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException ex) {}
                }
            }
            String name = this.jadFile.getName();
            int index = name.indexOf(46);
            name = name.substring(0, index != -1 ? index : name.length() - 1);
            int applicationId = -1;
            try {
                this.log("Starting upload", 3);
                ApplicationAPIUploadApplicationReturn uploadReturn = port.uploadApplication(this.user, this.password, name, jarData, jadData);
                this.handleReturnCode(uploadReturn.getReturnCode());
                applicationId = uploadReturn.getApplicationId();
                this.log("Application id: " + applicationId, 3);
            }
            catch (Exception e) {
                throw new BuildException(this.bundle.getString("error_uploading_data"));
            }
            try {
                this.log("Starting script", 3);
                ApplicationAPIStartDownloadScriptReturn scriptReturn = port.startDownloadScript(this.user, this.password, this.deviceId, applicationId);
                this.handleReturnCode(scriptReturn.getReturnCode());
                this.log("Script executed", 3);
            }
            catch (Exception e) {
                throw new BuildException(this.bundle.getString("error_running_remote_script"));
            }
        }
        catch (IOException ioEx) {
            throw new BuildException((Throwable)ioEx);
        }
        finally {
            System.setProperty("javax.xml.stream.XMLInputFactory", "");
            System.setProperty("javax.xml.stream.XMLOutputFactory", "");
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.log("Done!", 3);
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDeviceId(int deviceId) {
        this.deviceId = deviceId;
    }

    public void setJadFile(File jadFile) {
        this.jadFile = jadFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public String getCareer() {
        return this.career;
    }

    public void setCareer(String career) {
        this.career = career;
    }

    private void handleReturnCode(int returnCode) {
        if (returnCode == 1) {
            throw new BuildException(this.bundle.getString("intenal_error"));
        }
        if (returnCode == 2) {
            throw new BuildException(this.bundle.getString("wrong_login"));
        }
        if (returnCode == 3) {
            throw new BuildException(this.bundle.getString("invalid_application_name"));
        }
        if (returnCode == 4) {
            throw new BuildException(this.bundle.getString("jad_file_cant_parse"));
        }
        if (returnCode == 5) {
            throw new BuildException(this.bundle.getString("device_not_found"));
        }
        if (returnCode == 6) {
            throw new BuildException(this.bundle.getString("application_not_found"));
        }
    }
}

