/*
 * Decompiled with CFR 0.152.
 */
package persistence.antlr;

import java.io.IOException;
import java.util.Enumeration;
import persistence.antlr.ActionElement;
import persistence.antlr.ActionTransInfo;
import persistence.antlr.Alternative;
import persistence.antlr.AlternativeBlock;
import persistence.antlr.AlternativeElement;
import persistence.antlr.BlockEndElement;
import persistence.antlr.CharLiteralElement;
import persistence.antlr.CharRangeElement;
import persistence.antlr.CodeGenerator;
import persistence.antlr.Grammar;
import persistence.antlr.GrammarAtom;
import persistence.antlr.GrammarSymbol;
import persistence.antlr.JavaCharFormatter;
import persistence.antlr.LexerGrammar;
import persistence.antlr.Lookahead;
import persistence.antlr.MakeGrammar;
import persistence.antlr.OneOrMoreBlock;
import persistence.antlr.ParserGrammar;
import persistence.antlr.RuleBlock;
import persistence.antlr.RuleRefElement;
import persistence.antlr.RuleSymbol;
import persistence.antlr.StringLiteralElement;
import persistence.antlr.SynPredBlock;
import persistence.antlr.TokenManager;
import persistence.antlr.TokenRangeElement;
import persistence.antlr.TokenRefElement;
import persistence.antlr.Tool;
import persistence.antlr.TreeElement;
import persistence.antlr.TreeWalkerGrammar;
import persistence.antlr.WildcardElement;
import persistence.antlr.ZeroOrMoreBlock;
import persistence.antlr.collections.impl.Vector;

public class DocBookCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public DocBookCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    static String HTMLEncode(String s) {
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '&') {
                buf.append("&amp;");
                continue;
            }
            if (c == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (c == '\'') {
                buf.append("&#039;");
                continue;
            }
            if (c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (c == '>') {
                buf.append("&gt;");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    static String QuoteForId(String s) {
        StringBuffer buf = new StringBuffer();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                buf.append(".");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void gen() {
        try {
            Enumeration grammarIter = this.behavior.grammars.elements();
            while (grammarIter.hasMoreElements()) {
                Grammar g = (Grammar)grammarIter.nextElement();
                g.setCodeGenerator(this);
                g.generate();
                if (!this.antlrTool.hasError()) continue;
                this.antlrTool.fatalError("Exiting due to errors.");
            }
        }
        catch (IOException e) {
            this.antlrTool.reportException(e, null);
        }
    }

    public void gen(ActionElement action) {
    }

    public void gen(AlternativeBlock blk) {
        this.genGenericBlock(blk, "");
    }

    public void gen(BlockEndElement end) {
    }

    public void gen(CharLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(DocBookCodeGenerator.HTMLEncode(atom.atomText) + " ");
    }

    public void gen(CharRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    public void gen(LexerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + TokenTypesFileExt);
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of lexer " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        this.genNextToken();
        Enumeration ids = this.grammar.rules.elements();
        while (ids.hasMoreElements()) {
            RuleSymbol rs = (RuleSymbol)ids.nextElement();
            if (rs.id.equals("mnextToken")) continue;
            this.genRule(rs);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock blk) {
        this.genGenericBlock(blk, "+");
    }

    public void gen(ParserGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".sgml");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".sgml");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement rr) {
        RuleSymbol rs = (RuleSymbol)this.grammar.getSymbol(rr.targetRule);
        this._print("<link linkend=\"" + DocBookCodeGenerator.QuoteForId(rr.targetRule) + "\">");
        this._print(rr.targetRule);
        this._print("</link>");
        this._print(" ");
    }

    public void gen(StringLiteralElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(DocBookCodeGenerator.HTMLEncode(atom.atomText));
        this._print(" ");
    }

    public void gen(TokenRangeElement r) {
        this.print(r.beginText + ".." + r.endText + " ");
    }

    public void gen(TokenRefElement atom) {
        if (atom.not) {
            this._print("~");
        }
        this._print(atom.atomText);
        this._print(" ");
    }

    public void gen(TreeElement t) {
        this.print(t + " ");
    }

    public void gen(TreeWalkerGrammar g) throws IOException {
        this.setGrammar(g);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".sgml");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".sgml");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(DocBookCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("<para>Definition of tree parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".</para>");
        this.println("");
        ++this.tabs;
        Enumeration rules = this.grammar.rules.elements();
        while (rules.hasMoreElements()) {
            this.println("");
            GrammarSymbol sym = (GrammarSymbol)rules.nextElement();
            if (!(sym instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)sym);
        }
        --this.tabs;
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wc) {
        this._print(". ");
    }

    public void gen(ZeroOrMoreBlock blk) {
        this.genGenericBlock(blk, "*");
    }

    protected void genAlt(Alternative alt) {
        if (alt.getTreeSpecifier() != null) {
            this._print(alt.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement elem = alt.head;
        while (!(elem instanceof BlockEndElement)) {
            elem.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = elem;
            elem = elem.next;
        }
    }

    public void genCommonBlock(AlternativeBlock blk) {
        if (blk.alternatives.size() > 1) {
            this.println("<itemizedlist mark=\"none\">");
        }
        for (int i = 0; i < blk.alternatives.size(); ++i) {
            Alternative alt = blk.getAlternativeAt(i);
            AlternativeElement elem = alt.head;
            if (blk.alternatives.size() > 1) {
                this.print("<listitem><para>");
            }
            if (i > 0 && blk.alternatives.size() > 1) {
                this._print("| ");
            }
            boolean save = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            this.genAlt(alt);
            --this.tabs;
            this.firstElementInAlt = save;
            if (blk.alternatives.size() <= 1) continue;
            this._println("</para></listitem>");
        }
        if (blk.alternatives.size() > 1) {
            this.println("</itemizedlist>");
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock blk) {
        Lookahead follow = this.grammar.theLLkAnalyzer.FOLLOW(1, blk.endNode);
        this.printSet(this.grammar.maxk, 1, follow);
    }

    protected void genGenericBlock(AlternativeBlock blk, String blkOp) {
        if (blk.alternatives.size() > 1) {
            this._println("");
            if (!this.firstElementInAlt) {
                this._println("(");
            } else {
                this._print("(");
            }
        } else {
            this._print("( ");
        }
        this.genCommonBlock(blk);
        if (blk.alternatives.size() > 1) {
            this._println("");
            this.print(")" + blkOp + " ");
            if (!(blk.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + blkOp + " ");
        }
    }

    protected void genHeader() {
        this.println("<?xml version=\"1.0\" standalone=\"no\"?>");
        this.println("<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook V3.1//EN\">");
        this.println("<book lang=\"en\">");
        this.println("<bookinfo>");
        this.println("<title>Grammar " + this.grammar.getClassName() + "</title>");
        this.println("  <author>");
        this.println("    <firstname></firstname>");
        this.println("    <othername></othername>");
        this.println("    <surname></surname>");
        this.println("    <affiliation>");
        this.println("     <address>");
        this.println("     <email></email>");
        this.println("     </address>");
        this.println("    </affiliation>");
        this.println("  </author>");
        this.println("  <othercredit>");
        this.println("    <contrib>");
        this.println("    Generated by <ulink url=\"http://www.ANTLR.org/\">ANTLR</ulink>" + Tool.version);
        this.println("    from " + this.antlrTool.grammarFile);
        this.println("    </contrib>");
        this.println("  </othercredit>");
        this.println("  <pubdate></pubdate>");
        this.println("  <abstract>");
        this.println("  <para>");
        this.println("  </para>");
        this.println("  </abstract>");
        this.println("</bookinfo>");
        this.println("<chapter>");
        this.println("<title></title>");
    }

    protected void genLookaheadSetForAlt(Alternative alt) {
        if (this.doingLexRules && alt.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int depth = alt.lookaheadDepth;
        if (depth == Integer.MAX_VALUE) {
            depth = this.grammar.maxk;
        }
        for (int i = 1; i <= depth; ++i) {
            Lookahead lookahead = alt.cache[i];
            this.printSet(depth, i, lookahead);
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock blk) {
        int i;
        int depth = 0;
        for (i = 0; i < blk.alternatives.size(); ++i) {
            Alternative alt = blk.getAlternativeAt(i);
            if (alt.lookaheadDepth == Integer.MAX_VALUE) {
                depth = this.grammar.maxk;
                break;
            }
            if (depth >= alt.lookaheadDepth) continue;
            depth = alt.lookaheadDepth;
        }
        for (i = 1; i <= depth; ++i) {
            Lookahead lookahead = this.grammar.theLLkAnalyzer.look(i, blk);
            this.printSet(depth, i, lookahead);
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock blk = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol nextTokenRs = new RuleSymbol("mnextToken");
        nextTokenRs.setDefined();
        nextTokenRs.setBlock(blk);
        nextTokenRs.access = "private";
        this.grammar.define(nextTokenRs);
        this.genCommonBlock(blk);
    }

    public void genRule(RuleSymbol s) {
        if (s == null || !s.isDefined()) {
            return;
        }
        this.println("");
        if (s.access.length() != 0 && !s.access.equals("public")) {
            this._print("<para>" + s.access + " </para>");
        }
        this.println("<section id=\"" + DocBookCodeGenerator.QuoteForId(s.getId()) + "\">");
        this.println("<title>" + s.getId() + "</title>");
        if (s.comment != null) {
            this._println("<para>" + DocBookCodeGenerator.HTMLEncode(s.comment) + "</para>");
        }
        this.println("<para>");
        RuleBlock rblk = s.getBlock();
        this._println("");
        this.print(s.getId() + ":\t");
        ++this.tabs;
        this.genCommonBlock(rblk);
        this._println("");
        --this.tabs;
        this._println("</para>");
        this._println("</section><!-- section \"" + s.getId() + "\" -->");
    }

    protected void genSynPred(SynPredBlock blk) {
    }

    public void genTail() {
        this.println("</chapter>");
        this.println("</book>");
    }

    protected void genTokenTypes(TokenManager tm) throws IOException {
        this.antlrTool.reportProgress("Generating " + tm.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(tm.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector v = tm.getVocabulary();
        for (int i = 4; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            if (s == null) continue;
            this.println(s + " = " + i);
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    protected String processActionForSpecialSymbols(String actionStr, int line, RuleBlock currentRule, ActionTransInfo tInfo) {
        return actionStr;
    }

    public String getASTCreateString(Vector v) {
        return null;
    }

    public String getASTCreateString(GrammarAtom atom, String str) {
        return null;
    }

    public String mapTreeId(String id, ActionTransInfo tInfo) {
        return id;
    }

    public void printSet(int depth, int k, Lookahead lookahead) {
        int numCols = 5;
        int[] elems = lookahead.fset.toArray();
        if (depth != 1) {
            this.print("k==" + k + ": {");
        } else {
            this.print("{ ");
        }
        if (elems.length > numCols) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int column = 0;
        for (int i = 0; i < elems.length; ++i) {
            if (++column > numCols) {
                this._println("");
                this.print("");
                column = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(elems[i]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(elems[i]));
            }
            if (i == elems.length - 1) continue;
            this._print(", ");
        }
        if (elems.length > numCols) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

