/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sequencing;

import java.io.StringWriter;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.queryframework.DataModifyQuery;
import oracle.toplink.essentials.queryframework.ValueReadQuery;
import oracle.toplink.essentials.sequencing.QuerySequence;

public class TableSequence
extends QuerySequence {
    protected static final String defaultTableName = "SEQUENCE";
    protected DatabaseTable table;
    protected String counterFieldName = "SEQ_COUNT";
    protected String nameFieldName = "SEQ_NAME";
    protected String qualifier = "";

    public TableSequence() {
        super(false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String name) {
        super(name, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String name, int size) {
        super(name, size, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String name, int size, int initialValue) {
        super(name, size, initialValue, false, true);
        this.setTableName(defaultTableName);
    }

    public TableSequence(String name, String tableName) {
        this(name);
        this.setTableName(tableName);
    }

    public TableSequence(String name, String tableName, String nameFieldName, String counterFieldName) {
        this(name);
        this.setTableName(tableName);
        this.setNameFieldName(nameFieldName);
        this.setCounterFieldName(counterFieldName);
    }

    public TableSequence(String name, int size, String tableName) {
        this(name, size);
        this.setTableName(tableName);
    }

    public TableSequence(String name, int size, String tableName, String nameFieldName, String counterFieldName) {
        this(name, size);
        this.setTableName(tableName);
        this.setNameFieldName(nameFieldName);
        this.setCounterFieldName(counterFieldName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TableSequence) {
            TableSequence other = (TableSequence)obj;
            if (TableSequence.equalNameAndSize(this, other)) {
                return this.getTableName().equals(other.getTableName()) && this.getCounterFieldName().equals(other.getCounterFieldName()) && this.getNameFieldName().equals(other.getNameFieldName());
            }
            return false;
        }
        return false;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void setCounterFieldName(String name) {
        this.counterFieldName = name;
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String name) {
        this.nameFieldName = name;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    public String getTableName() {
        return this.getTable().getQualifiedName();
    }

    public String getQualifiedTableName() {
        if (this.qualifier.equals("")) {
            return this.getTableName();
        }
        return this.qualifier + "." + this.getTableName();
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    public void setTableName(String name) {
        this.table = new DatabaseTable(name);
    }

    protected ValueReadQuery buildSelectQuery() {
        ValueReadQuery query = new ValueReadQuery();
        query.addArgument(this.getNameFieldName());
        StringWriter writer = new StringWriter();
        writer.write("SELECT " + this.getCounterFieldName());
        writer.write(" FROM " + this.getQualifiedTableName());
        writer.write(" WHERE " + this.getNameFieldName());
        writer.write(" = #" + this.getNameFieldName());
        query.setSQLString(writer.toString());
        return query;
    }

    protected DataModifyQuery buildUpdateQuery() {
        DataModifyQuery query = new DataModifyQuery();
        query.addArgument(this.getNameFieldName());
        query.addArgument("PREALLOC_SIZE");
        StringWriter writer = new StringWriter();
        writer.write("UPDATE " + this.getQualifiedTableName());
        writer.write(" SET " + this.getCounterFieldName());
        writer.write(" = " + this.getCounterFieldName());
        writer.write(" + #PREALLOC_SIZE");
        writer.write(" WHERE " + this.getNameFieldName() + " = #" + this.getNameFieldName());
        query.setSQLString(writer.toString());
        return query;
    }

    public void onConnect() {
        super.onConnect();
        this.qualifier = this.getDatasourcePlatform().getTableQualifier();
    }

    public void onDisconnect() {
        this.qualifier = "";
        super.onDisconnect();
    }
}

